/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.CJKsupport;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.logging.Level;

public class DicomBytesBuilder {
    public static final int BUFFER_SIZE = 512;
    public static final byte NULL = 0;
    public static final byte SPC = 32;
    private byte[] buffer;
    private int count;

    public DicomBytesBuilder() {
        this(512);
    }

    public DicomBytesBuilder(int capacity) {
        this.buffer = new byte[capacity];
    }

    public byte[] array() {
        this.trimToSize();
        return this.buffer;
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.buffer.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.buffer.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        this.buffer = DicomBytesBuilder.copyOf(this.buffer, newCapacity);
    }

    public void trimToSize() {
        if (this.count < this.buffer.length) {
            this.buffer = DicomBytesBuilder.copyOf(this.buffer, this.count);
        }
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new IndexOutOfBoundsException("New length out of range: " + newLength);
        }
        if (newLength > this.buffer.length) {
            this.expandCapacity(newLength);
        }
        if (this.count < newLength) {
            while (this.count < newLength) {
                this.buffer[this.count] = 0;
                ++this.count;
            }
        } else {
            this.count = newLength;
        }
    }

    public DicomBytesBuilder append(byte[] bytes) {
        if (bytes != null && 0 < bytes.length) {
            int len = bytes.length;
            int newCount = this.count + len;
            this.ensureCapacity(newCount);
            System.arraycopy(bytes, 0, this.buffer, this.count, len);
            this.count = newCount;
        }
        return this;
    }

    public DicomBytesBuilder append(String str, DicomCharSet dicomCharset, boolean escapeSequence) {
        String strToEncode = str;
        if (null == str) {
            strToEncode = "";
        }
        byte[] strBytes = DicomBytesBuilder.getDicomBytes(strToEncode, dicomCharset, escapeSequence);
        int len = strBytes.length;
        int newCount = this.count + len;
        this.ensureCapacity(newCount);
        System.arraycopy(strBytes, 0, this.buffer, this.count, len);
        this.count = newCount;
        return this;
    }

    public DicomBytesBuilder append(String str, DicomCharSet currentCharset, DicomCharSet defaultCharset, DicomCharSet activeCharset) {
        if (currentCharset == defaultCharset) {
            if (0 < this.count) {
                byte[] escapeSequence = DicomBytesBuilder.getEscapeSequence(activeCharset, defaultCharset);
                this.append(escapeSequence);
            }
            return this.append(str, currentCharset, false);
        }
        return this.append(str, currentCharset, true);
    }

    public DicomBytesBuilder append(String str, DicomCharSet[] dicomCharsets) {
        return this.append(str, dicomCharsets, (byte)32);
    }

    public DicomBytesBuilder appendWithNullPad(String str, DicomCharSet[] dicomCharsets) {
        return this.append(str, dicomCharsets, (byte)0);
    }

    public DicomBytesBuilder append(String str, DicomCharSet[] dicomCharsets, byte padChar) {
        if (null != str && 0 < str.length()) {
            int endIndex;
            int unicodeCodePoint;
            DicomCharSet defaultCharset;
            DicomCharSet currentCharset;
            DicomCharSet previousCharset = currentCharset = (defaultCharset = dicomCharsets[0]);
            CharsetEncoder[] encoder = new CharsetEncoder[dicomCharsets.length];
            for (int i2 = 0; i2 < encoder.length; ++i2) {
                encoder[i2] = dicomCharsets[i2].getJavaCharset().newEncoder();
            }
            int beginIndex = 0;
            for (endIndex = 0; endIndex < str.length(); endIndex += Character.charCount(unicodeCodePoint)) {
                int charsetIndex;
                for (charsetIndex = 0; charsetIndex < dicomCharsets.length && !encoder[charsetIndex].canEncode(str.charAt(endIndex)); ++charsetIndex) {
                }
                if (charsetIndex < dicomCharsets.length) {
                    if (currentCharset != dicomCharsets[charsetIndex]) {
                        if (0 < endIndex) {
                            String substr = str.substring(beginIndex, endIndex);
                            this.append(substr, currentCharset, defaultCharset, previousCharset);
                            beginIndex = endIndex;
                            previousCharset = currentCharset;
                        }
                        currentCharset = dicomCharsets[charsetIndex];
                    }
                } else {
                    throw new IllegalArgumentException("Unable to encode \"" + str + "\" with [" + DicomCharSet.getTag85(dicomCharsets) + "]");
                }
                unicodeCodePoint = Character.codePointAt(str, endIndex);
            }
            String substr = str.substring(beginIndex, endIndex);
            this.append(substr, currentCharset, defaultCharset, previousCharset);
            if (DicomBytesBuilder.isSwitchToDefault(currentCharset)) {
                byte[] escapeSequence = DicomBytesBuilder.getEscapeSequence(currentCharset, defaultCharset);
                this.append(escapeSequence);
            }
            if ((this.length() & 1) != 0) {
                this.append(new byte[]{padChar});
            }
        }
        return this;
    }

    public static byte[] getDicomBytes(String str, DicomCharSet dicomCharset, boolean escapeSequence) {
        byte[] buf = null;
        try {
            byte[] strBuf = str.getBytes(dicomCharset.getJavaCharsetName());
            if (escapeSequence) {
                byte[] escapeBuf = dicomCharset.getEscapeSequenceG1();
                if (null == escapeBuf) {
                    throw new IllegalStateException("Specified character repertoire " + (Object)((Object)dicomCharset) + " has no G1 escape sequence defined: " + dicomCharset.getDefinedTerm());
                }
                buf = new byte[1 + escapeBuf.length + strBuf.length];
                buf[0] = 27;
                System.arraycopy(escapeBuf, 0, buf, 1, escapeBuf.length);
                System.arraycopy(strBuf, 0, buf, escapeBuf.length + 1, strBuf.length);
            } else {
                buf = strBuf;
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.SEVERE, "Encoding \"" + str + "\" using specified character repertoire " + dicomCharset.getDefinedTerm() + " failed: " + ex);
        }
        return buf;
    }

    public static byte[] getDicomBytes(String str, DicomCharSet[] dicomCharsets) {
        DicomBytesBuilder dbb = new DicomBytesBuilder();
        dbb.append(str, dicomCharsets);
        return dbb.array();
    }

    public static byte[] getDicomBytesWithNullPad(String str, DicomCharSet[] dicomCharsets) {
        DicomBytesBuilder dbb = new DicomBytesBuilder();
        dbb.append(str, dicomCharsets, (byte)0);
        return dbb.array();
    }

    public static boolean canEncode(String str, DicomCharSet[] dicomCharsets) {
        boolean valid = true;
        if (null != str && 0 < str.length()) {
            int unicodeCodePoint;
            CharsetEncoder[] encoder = new CharsetEncoder[dicomCharsets.length];
            for (int i2 = 0; i2 < encoder.length; ++i2) {
                encoder[i2] = dicomCharsets[i2].getJavaCharset().newEncoder();
            }
            for (int index = 0; valid && index < str.length(); index += Character.charCount(unicodeCodePoint)) {
                int charsetIndex = 0;
                while (!(valid = encoder[charsetIndex].canEncode(str.charAt(index))) && ++charsetIndex < encoder.length) {
                }
                unicodeCodePoint = Character.codePointAt(str, index);
            }
        }
        return valid;
    }

    public static boolean hasEscapeSequence(byte[] bytes) {
        for (byte val : bytes) {
            if (27 != val) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEscapeSequence(String str, DicomCharSet[] dicomCharsets) {
        if (null != str && 0 < str.length() && 0 < dicomCharsets.length) {
            int unicodeCodePoint;
            CharsetEncoder defaultEnc = dicomCharsets[0].getJavaCharset().newEncoder();
            for (int index = 0; index < str.length(); index += Character.charCount(unicodeCodePoint)) {
                if (!defaultEnc.canEncode(str.charAt(index))) {
                    return true;
                }
                unicodeCodePoint = Character.codePointAt(str, index);
            }
        }
        return false;
    }

    public static byte[] getEscapeSequence(DicomCharSet activeCharset, DicomCharSet defaultCharset) {
        byte[] buf = null;
        if (DicomCharSet.ISO_2022_IR_149 != activeCharset) {
            byte[] escapeBuf = defaultCharset.getEscapeSequenceG0();
            if (null == escapeBuf) {
                throw new IllegalStateException("No escape G0 sequence defined in charset to be used for encoding default characters. Specified active charset must be of IS0 2022 range.");
            }
            buf = new byte[1 + escapeBuf.length];
            buf[0] = 27;
            System.arraycopy(escapeBuf, 0, buf, 1, escapeBuf.length);
        }
        return buf;
    }

    public static boolean isSwitchToDefault(DicomCharSet dicomCharset) {
        return DicomCharSet.ISO_2022_IR_87 == dicomCharset || DicomCharSet.ISO_2022_IR_159 == dicomCharset;
    }

    public static String dicomBytesToString(byte[] buffer, int start, int length, String indent) {
        int size = indent.length() + 4 * length;
        StringBuffer sb1 = new StringBuffer(2 * size);
        sb1.append(indent);
        int[] index = new int[size];
        Arrays.fill(index, -1);
        for (int i2 = start; i2 < length; ++i2) {
            index[sb1.length() + 1] = i2 - start;
            sb1.append(' ');
            if (buffer[i2] == 27) {
                sb1.append("ESC");
                continue;
            }
            sb1.append(Integer.toHexString(buffer[i2] & 0xFF));
        }
        StringBuffer sb2 = new StringBuffer();
        int end = length - start - 1;
        for (int i3 = 0; i3 < index.length; ++i3) {
            if (index[i3] < 0) {
                sb2.append(' ');
                continue;
            }
            sb2.append(index[i3]);
            if (index[i3] == end) break;
            i3 = sb2.length() - 1;
        }
        sb1.append(SimpleUtilities.getLineSeparator());
        sb1.append(sb2);
        return sb1.toString();
    }

    public String toString(DicomCharSet[] dicomCharsets) {
        return CJKsupport.getUnicode(this.buffer, 0, this.buffer.length, dicomCharsets);
    }

    public String toString() {
        String prefix = "length=" + this.count + " capacity=" + this.buffer.length + " :";
        return DicomBytesBuilder.dicomBytesToString(this.buffer, 0, this.buffer.length, prefix);
    }
}

