/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.util.dicom.dicomInfoTableModel;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class Diff
extends JPanel
implements Printable {
    private InputStream streamA;
    private InputStream streamB;
    private HashMap map = new HashMap();
    private JTable table = new JTable();
    private BorderLayout borderLayout1 = new BorderLayout();
    private dicomInfoTableModel model = new dicomInfoTableModel();
    private JScrollPane scroll = new JScrollPane();
    private Vector allData = new Vector();
    private boolean areDiff = true;
    private String[] headers = new String[]{"DIFF", "Tag", "Name", "Value", "Value2"};

    public Diff() {
        this.model.setColumnNames(this.headers);
        try {
            this.buildTagNames();
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setFiles(String a2, String b2) {
        try {
            this.setFiles(new FileInputStream(a2), new FileInputStream(b2));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setFiles(InputStream a2, InputStream b2) {
        this.streamA = a2;
        this.streamB = b2;
        this.parse();
        this.model.setData(this.allData);
    }

    public boolean areFilesDifferent() {
        return this.areDiff;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.scroll.setHorizontalScrollBarPolicy(30);
        this.scroll.setVerticalScrollBarPolicy(20);
        this.table.setModel(this.model);
        this.scroll.getViewport().add(this.table);
        this.add((Component)this.scroll, "Center");
    }

    private void buildTagNames() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("dicomDict.txt")));
            while (in.ready()) {
                String str = in.readLine();
                StringTokenizer tok = new StringTokenizer(str, ";");
                String group = tok.nextToken().toLowerCase();
                String element = tok.nextToken().toLowerCase();
                String tagName = tok.nextToken();
                this.map.put("(" + group + "," + element + ")", tagName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parse() {
        try {
            this.areDiff = false;
            DiffLine[] delta = Diff.diff(this.streamA, this.streamB);
            this.allData.clear();
            Vector[] vect = new Vector[this.headers.length];
            for (int i2 = 0; i2 < vect.length; ++i2) {
                vect[i2] = new Vector();
                this.allData.add(vect[i2]);
            }
            for (int k2 = 0; k2 < delta.length; ++k2) {
                tagValue tv = delta[k2].tva != null ? delta[k2].tva : delta[k2].tvb;
                String tag2 = tagValue.atToString(tv.group, tv.element);
                if (delta[k2].state == 3) {
                    this.areDiff = true;
                    vect[0].add(delta[k2].stateString());
                    vect[4].add(delta[k2].tvb.value);
                } else {
                    vect[0].add(delta[k2].stateString());
                    vect[4].add("");
                }
                vect[1].add(tag2);
                vect[2].add(this.looseQuotes((String)this.map.get(tag2)));
                if (tv.value != null && tv.value.getClass() == Object[].class) {
                    vect[3].add("Sequence");
                } else if (tv.value instanceof Object[]) {
                    Object[] o2 = (Object[])tv.value;
                    String str = "[" + o2.length + "]";
                    for (int i3 = 0; i3 < 2; ++i3) {
                        str = str + o2[i3].toString() + ",";
                    }
                    str = str + "...";
                    vect[3].add(str);
                } else {
                    vect[3].add(tv.value);
                }
                if (tv.value == null || tv.value.getClass() != Object[].class) continue;
                if (delta[k2].tva == null) {
                    this.appendSeq(vect, (Object[])delta[k2].tvb.value, "");
                    continue;
                }
                if (delta[k2].tvb == null) {
                    this.appendSeq(vect, (Object[])delta[k2].tva.value, "");
                    continue;
                }
                this.appendSeq(vect, (Object[])delta[k2].tva.value, (Object[])delta[k2].tvb.value, "");
            }
        }
        catch (Exception e2) {
            this.areDiff = true;
            e2.printStackTrace();
        }
    }

    private void appendSeq(Vector[] vect, Object[] seq, String indent) {
        indent = indent + ">";
        for (int i2 = 0; i2 < seq.length; ++i2) {
            Object[] item = (Object[])seq[i2];
            vect[0].add("");
            vect[1].add(indent + "ITEM");
            vect[2].add("");
            vect[3].add("");
            vect[4].add("");
            for (int j2 = 0; j2 < item.length; ++j2) {
                tagValue elem = (tagValue)item[j2];
                String tag2 = tagValue.atToString(elem.group, elem.element);
                vect[0].add("");
                vect[1].add(indent + tag2);
                vect[2].add(this.looseQuotes((String)this.map.get(tag2)));
                if (elem.value instanceof Object[]) {
                    vect[3].add("Sequence");
                } else {
                    vect[3].add(elem.value);
                }
                vect[4].add("");
                if (elem.value == null || elem.value.getClass() != Object[].class) continue;
                this.appendSeq(vect, (Object[])elem.value, indent);
            }
        }
        vect[0].add("");
        vect[1].add(indent + "ITEM END");
        vect[2].add("");
        vect[3].add("");
        vect[4].add("");
    }

    private void appendSeq(Vector[] vect, Object[] seq_a, Object[] seq_b, String indent) {
        indent = indent + ">";
        for (int i2 = 0; i2 < seq_a.length; ++i2) {
            Object[] item = (Object[])seq_a[i2];
            tagValue[] itemb = i2 < seq_b.length ? (Object[])seq_b[i2] : new tagValue[20];
            vect[0].add("");
            vect[1].add(indent + "ITEM");
            vect[2].add("");
            vect[3].add("");
            vect[4].add("");
            for (int j2 = 0; j2 < item.length; ++j2) {
                tagValue elem = (tagValue)item[j2];
                tagValue elemb = itemb[j2];
                String tag2 = tagValue.atToString(elem.group, elem.element);
                if (Diff.isSameObject(elem, elemb)) {
                    vect[0].add("SAME");
                } else {
                    vect[0].add("DIFF");
                }
                vect[1].add(indent + tag2);
                vect[2].add(this.looseQuotes((String)this.map.get(tag2)));
                if (elem.value instanceof Object[]) {
                    vect[3].add("Sequence");
                } else {
                    vect[3].add(elem.value);
                }
                vect[4].add("");
                if (elem.value.getClass() != Object[].class) continue;
                if (elemb != null) {
                    this.appendSeq(vect, (Object[])elem.value, (Object[])elemb.value, indent);
                    continue;
                }
                this.appendSeq(vect, (Object[])elem.value, indent);
            }
        }
        vect[0].add("");
        vect[1].add(indent + "ITEM END");
        vect[2].add("");
        vect[3].add("");
        vect[4].add("");
    }

    private String looseQuotes(String str) {
        if (str == null || str.trim().equals("")) {
            return null;
        }
        if (str.charAt(0) == '\"') {
            str = str.substring(1);
        }
        if (str.charAt(str.length() - 1) == '\"') {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public int print(Graphics g2, PageFormat format, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g2;
        g2d.translate(format.getImageableX(), format.getImageableY());
        double sx = format.getImageableWidth() / (double)this.getWidth();
        double sy = format.getImageableHeight() / (double)this.getHeight();
        if (sx > sy) {
            sx = sy;
        } else {
            sy = sx;
        }
        g2d.scale(sx, sy);
        this.printAll(g2d);
        return 0;
    }

    @Override
    public void print(Graphics g2) {
        Color c2 = this.getBackground();
        this.setBackground(Color.white);
        this.paint(g2);
        this.setBackground(c2);
    }

    public static void main(String[] args) {
        final Diff diff1 = new Diff();
        JFrame f2 = new JFrame();
        f2.setDefaultCloseOperation(3);
        JPanel p2 = new JPanel();
        f2.getContentPane().add((Component)p2, "North");
        final JTextField t1 = new JTextField("E:\\dev\\images\\ves\\s7\\i39.SCDC.1");
        JButton b2 = new JButton("Diff");
        final JTextField t2 = new JTextField("E:\\dev\\images\\ves\\s7\\i40.SCDC.2");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                diff1.setFiles(t1.getText(), t2.getText());
                System.out.println("[" + t1.getText() + "] and [" + t2.getText() + "] are " + (diff1.areFilesDifferent() ? "different" : "the same"));
            }
        });
        p2.add(new JLabel("A:"));
        p2.add(t1);
        p2.add(b2);
        p2.add(new JLabel("B:"));
        p2.add(t2);
        f2.getContentPane().add(diff1);
        f2.pack();
        f2.setVisible(true);
    }

    private static boolean isSameObject(tagValue tva, tagValue tvb) {
        if (tva == null && tvb == null) {
            return true;
        }
        if (tva == null && tvb != null) {
            return false;
        }
        if (tva != null && tvb == null) {
            return false;
        }
        if (tva.value == null && tvb.value == null) {
            return true;
        }
        if (tva.value == null || tvb.value == null) {
            return false;
        }
        if (tva.value != null && tva.value.equals(tvb.value)) {
            return true;
        }
        if (tva.value.getClass() == Object[].class) {
            if (tvb.value.getClass() == Object[].class) {
                return Diff.sameSequence((Object[])tva.value, (Object[])tvb.value);
            }
            return false;
        }
        if (tva.value instanceof Object[] && tvb.value instanceof Object[]) {
            for (int i2 = 0; i2 < ((Object[])tva.value).length; ++i2) {
                if (((Object[])tva.value)[i2].equals(((Object[])tvb.value)[i2])) continue;
                return false;
            }
            return true;
        }
        if (tva.vrep == 20290 && tvb.vrep == 20290) {
            byte[] a2 = (byte[])tva.value;
            byte[] b2 = (byte[])tvb.value;
            for (int i3 = 0; i3 < a2.length; ++i3) {
                if (a2[i3] == b2[i3]) continue;
                return false;
            }
            return true;
        }
        if (tva.vrep == 20311 && tvb.vrep == 20311) {
            short[] a3 = (short[])tva.value;
            short[] b3 = (short[])tvb.value;
            for (int i4 = 0; i4 < a3.length; ++i4) {
                if (a3[i4] == b3[i4]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean sameSequence(Object[] a2, Object[] b2) {
        if (a2.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            Object[] ia = (Object[])a2[i2];
            Object[] ib = (Object[])b2[i2];
            if (ia.length != ib.length) {
                return false;
            }
            for (int j2 = 0; j2 < ia.length; ++j2) {
                tagValue tva = (tagValue)ia[j2];
                tagValue tvb = (tagValue)ia[j2];
                boolean objsame = Diff.isSameObject(tva, tvb);
                if (objsame) continue;
                return false;
            }
        }
        return true;
    }

    private static DiffLine[] diff(InputStream streamA, InputStream streamB) throws FileNotFoundException {
        dicomParser pa = new dicomParser();
        pa.setFile(streamA);
        dicomParser pb = new dicomParser();
        pb.setFile(streamB);
        Vector<DiffLine> v2 = new Vector<DiffLine>(100);
        boolean dida = true;
        boolean didb = true;
        tagValue tva = null;
        tagValue tvb = null;
        while (pa.hasMoreTags() || pb.hasMoreTags()) {
            if (!pa.hasMoreTags()) {
                tva = null;
            }
            if (!pb.hasMoreTags()) {
                tvb = null;
            }
            if (dida && pa.hasMoreTags()) {
                tva = pa.readNext();
            }
            if (didb && pb.hasMoreTags()) {
                tvb = pb.readNext();
            }
            int diff = 0;
            if (tva == null) {
                diff = 1000;
                if (tvb == null) {
                    break;
                }
            } else if (tvb == null) {
                diff = -1000;
            }
            if (diff == 0) {
                diff = tva.group - tvb.group;
            }
            if (diff == 0) {
                diff = tva.element - tvb.element;
            }
            dida = true;
            didb = true;
            if (diff == 0) {
                v2.add(new DiffLine(tva, tvb));
                dida = true;
                didb = true;
            }
            if (diff > 0) {
                v2.add(new DiffLine(null, tvb));
                dida = false;
            }
            if (diff >= 0) continue;
            v2.add(new DiffLine(tva, null));
            didb = false;
        }
        pa.clearFile();
        pb.clearFile();
        DiffLine[] result = new DiffLine[v2.size()];
        Iterator iter = v2.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            result[i2++] = (DiffLine)iter.next();
        }
        return result;
    }

    private static class DiffLine {
        int group;
        int element;
        int state;
        public static final int SAME = 0;
        public static final int IN_A = 1;
        public static final int IN_B = 2;
        public static final int DIFF = 3;
        tagValue tva;
        tagValue tvb;

        public String stateString() {
            switch (this.state) {
                case 0: {
                    return "SAME";
                }
                case 1: {
                    return "IN_A";
                }
                case 2: {
                    return "IN_B";
                }
                case 3: {
                    return "DIFF";
                }
            }
            return "????";
        }

        public String toString() {
            String str = "(" + Integer.toHexString(this.group) + "," + Integer.toHexString(this.element) + ")";
            switch (this.state) {
                case 0: {
                    return str + "[SAME]" + this.tva;
                }
                case 1: {
                    return str + "[IN_A]" + this.tva;
                }
                case 2: {
                    return str + "[IN_B]" + this.tvb;
                }
                case 3: {
                    return str + "[DIFF]" + this.tva + " VS " + this.tvb;
                }
            }
            return str;
        }

        public DiffLine(tagValue a2, tagValue b2) {
            this.tva = a2;
            this.tvb = b2;
            if (a2 == null) {
                this.group = b2.group;
                this.element = b2.element;
                this.state = 2;
                return;
            }
            if (b2 == null) {
                this.group = a2.group;
                this.element = a2.element;
                this.state = 1;
                return;
            }
            this.group = a2.group;
            this.element = a2.element;
            this.state = 3;
            if (Diff.isSameObject(a2, b2)) {
                this.state = 0;
            }
        }
    }
}

