/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ImageCreator {
    private SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
    private String seed = null;
    DicomComposite comp = new DicomComposite();

    public ImageCreator() throws Exception {
        this(null);
    }

    public ImageCreator(String seed) throws Exception {
        this.seed = seed;
        if (seed == null) {
            this.comp.read(this.getClass().getResourceAsStream("mrseed.dcm"));
        } else {
            FileInputStream in = new FileInputStream(seed);
            this.comp.read(in);
            in.close();
        }
    }

    public void install(int patients, int studies, int series, int images, DMSession dest) throws Exception {
        for (int p2 = 0; p2 < patients; ++p2) {
            this.comp.setValue(16, 16, "Patient" + (p2 + 1));
            this.comp.setValue(16, 32, "" + (p2 + 1));
            this.comp.setValue(16, 48, this.fmt.format(Calendar.getInstance().getTime()));
            for (int e2 = 0; e2 < studies; ++e2) {
                this.comp.setValue(32, 16, "" + (e2 + 1));
                this.comp.setValue(32, 13, UidGenerator.newInstanceUID());
                for (int s2 = 0; s2 < series; ++s2) {
                    this.comp.setValue(32, 14, UidGenerator.newInstanceUID());
                    this.comp.setValue(32, 17, "" + (s2 + 1));
                    long start = System.currentTimeMillis();
                    for (int i2 = 0; i2 < images; ++i2) {
                        this.comp.setValue(8, 24, UidGenerator.newInstanceUID());
                        this.comp.setValue(32, 19, "" + (i2 + 1));
                        dest.send(DMUtils.MSG_RESERVE_SPACE + "=" + "8000");
                        dest.install(this.comp.getInputStream());
                        dest.send(DMUtils.MSG_RELEASE_SPACE);
                    }
                    System.out.println("Series installed in " + (System.currentTimeMillis() - start) + " ms");
                }
            }
        }
    }

    public static void usage() {
        System.out.println("java com.ge.med.terra.tap.util.dicom.ImageCreator");
        System.out.println("\t[-seed /path/to/seed/file]");
        System.out.println("\t[-dir /paths/to/dicom/files]");
        System.out.print("\t[-p numPatients");
        System.out.print(" -e numExams");
        System.out.print(" -s numSeries");
        System.out.println(" -i numImages]");
        System.out.println("\t-ses <session args>");
        System.exit(1);
    }

    public static void main(String[] args) {
        int i2;
        if (args.length == 0) {
            ImageCreator.usage();
        }
        String seed = null;
        String dir = null;
        int p2 = 1;
        int e2 = 1;
        int s2 = 4;
        int im = 10;
        String[] sesArgs = new String[]{"pesi", "C:/dev/images/test"};
        for (i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals("-seed")) {
                seed = args[++i2];
                continue;
            }
            if (args[i2].equals("-dir")) {
                dir = args[++i2];
                continue;
            }
            if (args[i2].equals("-p")) {
                p2 = Integer.parseInt(args[++i2]);
                e2 = Integer.parseInt(args[i2 += 2]);
                s2 = Integer.parseInt(args[i2 += 2]);
                im = Integer.parseInt(args[i2 += 2]);
                continue;
            }
            if (!args[i2].equals("-ses")) continue;
            sesArgs = new String[args.length - i2 - 1];
            System.arraycopy(args, i2 + 1, sesArgs, 0, sesArgs.length);
        }
        System.out.print("Session args= ");
        for (i2 = 0; i2 < sesArgs.length; ++i2) {
            System.out.print("\"" + sesArgs[i2] + "\" ");
        }
        System.out.println("");
        DMSession ses = new DMSession(sesArgs);
        try {
            long elapsed;
            if (dir == null) {
                ImageCreator ic = new ImageCreator(seed);
                System.out.println("Installing: P=" + p2 + ", E=" + e2 + ", S=" + s2 + ", I= " + im);
                System.out.println("Seed File= " + (seed == null ? "default" : seed));
                long start = System.currentTimeMillis();
                ic.install(p2, e2, s2, im, ses);
                elapsed = System.currentTimeMillis() - start;
            } else {
                System.out.println("Installing all files under " + dir);
                File[] f2 = SimpleUtilities.getFilesRecursively(new File(dir));
                System.out.println("" + f2.length + " files found");
                long start = System.currentTimeMillis();
                ses.installFiles(f2, true);
                elapsed = System.currentTimeMillis() - start;
            }
            System.out.println("Time Taken= " + elapsed + " ms");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

