/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class KeyObjectSelectionComposite
extends DicomComposite {
    private static int instanceUID = 23;
    private final Date creationDate = Calendar.getInstance().getTime();
    private final XjTagValue[] tagsToFill = new XjTagValue[]{new XjTagValue(8, 5), new XjTagValue(16, 16), new XjTagValue(16, 32), new XjTagValue(16, 48), new XjTagValue(16, 64), new XjTagValue(16, 50), new XjTagValue(16, 4096), new XjTagValue(16, 4097), new XjTagValue(16, 8544), new XjTagValue(16, 16384), new XjTagValue(18, 16), new XjTagValue(18, 32), new XjTagValue(18, 33), new XjTagValue(18, 48), new XjTagValue(18, 49), new XjTagValue(18, 64), new XjTagValue(18, 66), new XjTagValue(32, 13), new XjTagValue(8, 32), new XjTagValue(8, 48), new XjTagValue(8, 144), new XjTagValue(32, 16), new XjTagValue(8, 80), new XjTagValue(8, 4224), new XjTagValue(18, 80), new XjTagValue(18, 81), new XjTagValue(18, 96), new XjTagValue(8, 112), new XjTagValue(8, 128), new XjTagValue(8, 129), new XjTagValue(8, 4112), new XjTagValue(8, 4160), new XjTagValue(8, 4240), new XjTagValue(24, 4096), new XjTagValue(24, 4128), new XjTagValue(24, 4176), new XjTagValue(24, 4608), new XjTagValue(24, 4609), new XjTagValue(8, 33), new XjTagValue(8, 49), new XjTagValue(8, 4158), new XjTagValue(8, 4159), new XjTagValue(8, 17)};

    public KeyObjectSelectionComposite() {
        this.setValue(2, 1, new byte[]{0, 1});
        this.setValue(2, 18, "1.2.840.113619.6.311");
        Arrays.sort(this.tagsToFill);
        this.setValue(8, 22, "1.2.840.10008.5.1.4.1.1.88.59");
        this.setValue(8, 24, UidGenerator.newInstanceUID());
        this.setValue(8, 5, DicomCharSet.ISO_IR_100.getDefinedTerm());
        this.setDateValue(8, 18, this.creationDate);
        this.setTimeValue(8, 19, this.creationDate);
        this.setValue(8, 96, "KO");
        this.setValue(32, 14, UidGenerator.newInstanceUID());
        this.setValue(8, 4158, "Key Object Selection");
        this.setValue(32, 19, "" + instanceUID);
        ++instanceUID;
        this.setDateValue(8, 35, this.creationDate);
        this.setTimeValue(8, 51, this.creationDate);
    }

    public void fill(XjDicomObject obj) {
        obj.getValues(this.tagsToFill);
        this.setValues(this.tagsToFill);
        this.setValue(32, 17, KeyObjectSelectionComposite.getSeriesNo(obj));
    }

    public void fill(DMObject obj) {
        KOSDicomObject ref = new KOSDicomObject(obj);
        this.fill(ref);
    }

    private void setValues(XjTagValue[] tvs) {
        for (XjTagValue tv : tvs) {
            this.setValue(tv);
        }
    }

    private void setValue(XjTagValue tv) {
        if (null == tv.value) {
            this.removeTag(tv.group, tv.element);
        } else {
            this.setValue(tv.group, tv.element, tv.value);
        }
    }

    public static String getSeriesNo(DMObject refImage) {
        return (String)refImage.getValue(32, 17);
    }

    public static String getSeriesNo(XjDicomObject refImage) {
        return (String)refImage.getValue(32, 17);
    }

    public static void main(String[] args) {
        try {
            String[] stringArray;
            KeyObjectSelectionComposite kin = new KeyObjectSelectionComposite();
            System.out.println("\nBasic KIN Template\n");
            kin.printDebugInfo(System.out);
            if (args.length == 0) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "file";
                stringArray = stringArray2;
                stringArray2[1] = "D:/data/test/i18n/Japanese2";
            } else {
                stringArray = args;
            }
            DMSession ses = new DMSession(stringArray);
            kin.fill(ses.getChildren()[0]);
            System.out.println("\nAfter fill()\n");
            kin.printDebugInfo(System.out);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static class KOSDicomObject
    implements XjDicomObject {
        private DMObject ref;

        public KOSDicomObject(DMObject src) {
            this.ref = src;
        }

        @Override
        public Object getValue(int group, int element) {
            return this.ref.getValue(group, element);
        }

        @Override
        public int getValues(XjTagValue[] tvs) {
            int counter = 0;
            for (int i2 = 0; i2 < tvs.length; ++i2) {
                tvs[i2].value = this.getValue(tvs[i2].group, tvs[i2].element);
                if (null == tvs[i2].value) continue;
                ++counter;
            }
            return counter;
        }
    }
}

