/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.dicomInfoTableModel;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class dicomInfo
extends JPanel
implements Printable {
    String file;
    HashMap map = new HashMap();
    JTable table = new JTable();
    BorderLayout borderLayout1 = new BorderLayout();
    dicomInfoTableModel model = new dicomInfoTableModel();
    JScrollPane scroll = new JScrollPane();
    public String[] headers = new String[]{"Tag", "Name", "VR", "Len", "Value"};
    Vector allData = new Vector();
    JPanel jPanel1 = new JPanel();
    JComboBox ieLevel = new JComboBox();
    JCheckBox showUnknown = new JCheckBox();
    JLabel jLabel1 = new JLabel();
    String lastDir = SimpleUtilities.getTempDir();
    InputStream is = null;

    public dicomInfo() {
        this.model.setColumnNames(this.headers);
        try {
            this.buildTagNames();
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public dicomInfo(String file) {
        this();
        this.setFile(file);
    }

    public void setFile(String file) {
        this.file = file;
        this.parse();
        this.model.setData(this.allData);
    }

    public void setFile(InputStream is) {
        this.file = null;
        this.is = is;
        this.parse();
        this.model.setData(this.allData);
    }

    public String getFile() {
        return this.file;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.scroll.setHorizontalScrollBarPolicy(30);
        this.scroll.setVerticalScrollBarPolicy(20);
        this.showUnknown.setSelected(true);
        this.showUnknown.setText("Show Unknown");
        this.showUnknown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                dicomInfo.this.showUnknown_actionPerformed(e2);
            }
        });
        this.table.setModel(this.model);
        this.jLabel1.setText("Show");
        this.scroll.getViewport().add(this.table);
        this.add((Component)this.scroll, "Center");
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.ieLevel, null);
        this.jPanel1.add((Component)this.showUnknown, null);
        this.ieLevel.addItem("All Levels");
        this.ieLevel.addItem("Patient Level");
        this.ieLevel.addItem("Exam Level");
        this.ieLevel.addItem("Series Level");
        this.ieLevel.addItem("Image Level");
    }

    private void buildTagNames() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("dicomDict.txt")));
            while (in.ready()) {
                String str = in.readLine();
                StringTokenizer tok = new StringTokenizer(str, ";");
                String group = tok.nextToken().toLowerCase();
                String element = tok.nextToken().toLowerCase();
                String tagName = tok.nextToken();
                this.map.put("(" + group + "," + element + ")", tagName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parse() {
        try {
            dicomParser p2;
            if (this.file != null) {
                p2 = new dicomParser(this.file);
            } else {
                p2 = new dicomParser();
                p2.setFile(this.is);
            }
            this.allData.clear();
            Vector[] vect = new Vector[this.headers.length];
            for (int i2 = 0; i2 < vect.length; ++i2) {
                vect[i2] = new Vector();
                this.allData.add(vect[i2]);
            }
            while (p2.hasMoreTags()) {
                tagValue tv = p2.readNext();
                String tag2 = tagValue.atToString(tv.group, tv.element);
                vect[0].add(tag2);
                vect[1].add(this.looseQuotes((String)this.map.get(tag2)));
                vect[2].add(tv.vrString());
                vect[3].add("" + tv.len);
                if (tv.value != null && tv.value.getClass() == Object[].class) {
                    vect[4].add("Sequence");
                } else if (tv.value instanceof Object[]) {
                    Object[] o2 = (Object[])tv.value;
                    String str = "[" + o2.length + "]";
                    for (int i3 = 0; i3 < o2.length && i3 < 2; ++i3) {
                        str = str + o2[i3].toString() + ",";
                    }
                    str = str + "...";
                    vect[4].add(str);
                } else {
                    vect[4].add(tv.value);
                }
                if (tv.value == null || tv.value.getClass() != Object[].class) continue;
                this.appendSeq(vect, (Object[])tv.value, "");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void appendSeq(Vector[] vect, Object[] seq, String prefix) {
        String indent = prefix + ">";
        for (int i2 = 0; i2 < seq.length; ++i2) {
            Object[] item = (Object[])seq[i2];
            vect[0].add(indent + "ITEM");
            vect[1].add("");
            vect[2].add("");
            vect[3].add("");
            vect[4].add("");
            for (int j2 = 0; j2 < item.length; ++j2) {
                tagValue elem = (tagValue)item[j2];
                String tag2 = tagValue.atToString(elem.group, elem.element);
                vect[0].add(indent + tag2);
                vect[1].add(this.looseQuotes((String)this.map.get(tag2)));
                vect[2].add(elem.vrString());
                vect[3].add("" + elem.len);
                if (elem.value instanceof Object[]) {
                    vect[4].add("Sequence");
                } else {
                    vect[4].add(elem.value);
                }
                if (elem.value == null || elem.value.getClass() != Object[].class) continue;
                this.appendSeq(vect, (Object[])elem.value, indent);
            }
        }
        vect[0].add(indent + "ITEM END");
        vect[1].add("");
        vect[2].add("");
        vect[3].add("");
        vect[4].add("");
    }

    private String looseQuotes(String tagName) {
        String str = tagName;
        if (str == null || str.trim().equals("")) {
            return null;
        }
        if (str.charAt(0) == '\"') {
            str = str.substring(1);
        }
        if (str.charAt(str.length() - 1) == '\"') {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    void showUnknown_actionPerformed(ActionEvent e2) {
        this.model.setShowUnknown(this.showUnknown.isSelected());
    }

    @Override
    public int print(Graphics g2, PageFormat format, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g2;
        g2d.translate(format.getImageableX(), format.getImageableY());
        double sx = format.getImageableWidth() / (double)this.getWidth();
        double sy = format.getImageableHeight() / (double)this.getHeight();
        if (sx > sy) {
            sx = sy;
        } else {
            sy = sx;
        }
        g2d.scale(sx, sy);
        this.printAll(g2d);
        return 0;
    }

    @Override
    public void print(Graphics g2) {
        Color c2 = this.getBackground();
        this.setBackground(Color.white);
        this.paint(g2);
        this.setBackground(c2);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            dicomInfo.simpleDicomInfo(null);
        } else {
            dicomInfo.simpleDicomInfo(args[0]);
        }
    }

    public static JFrame simpleDicomInfo(String arg) {
        final dicomInfo dicomInfo1 = new dicomInfo();
        JFrame f2 = new JFrame();
        f2.setDefaultCloseOperation(3);
        JMenuBar menu = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem fileOpen = new JMenuItem("Open...");
        JMenuItem filePrint = new JMenuItem("Print...");
        JMenuItem fileExit = new JMenuItem("Exit");
        file.add(fileOpen);
        file.add(filePrint);
        file.add(fileExit);
        fileOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JFileChooser fc = new JFileChooser(dicomInfo1.lastDir);
                fc.setFileSelectionMode(0);
                fc.showOpenDialog((Component)e2.getSource());
                File fs = fc.getSelectedFile();
                if (fs != null) {
                    dicomInfo1.lastDir = fs.getParent();
                    System.out.println("setting = " + fs.getAbsolutePath());
                    dicomInfo1.setFile(fs.getAbsolutePath());
                }
            }
        });
        fileExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                System.exit(0);
            }
        });
        filePrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                Book book = new Book();
                book.append(dicomInfo1, new PageFormat());
                printerJob.setPageable(book);
                boolean doPrint = printerJob.printDialog();
                if (doPrint) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException exception) {
                        System.err.println("Printing error: " + exception);
                    }
                }
            }
        });
        if (arg != null) {
            dicomInfo1.setFile(arg);
        }
        menu.add(file);
        f2.setJMenuBar(menu);
        f2.getContentPane().add(dicomInfo1);
        f2.pack();
        f2.setVisible(true);
        return f2;
    }

    public String getLastDir() {
        return this.lastDir;
    }

    public void setLastDir(String lastDir) {
        this.lastDir = lastDir;
    }
}

