/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.Position;

public abstract class AbstractSearchAction
extends AbstractAction
implements DocumentListener,
KeyListener {
    private static final int DEF_SEARCH_FIELD_WIDTH = 256;
    private static final Color MATCH_TEXT_COLOR = Color.BLACK;
    private static final Color NO_MATCH_TEXT_COLOR = Color.RED;
    private static final Color MATCH_COUNT_COLOR = Color.GRAY;
    private static final Color NO_MATCH_COUNT_COLOR = Color.BLACK;
    private static final Color NO_MATCH_COUNT_BG_COLOR = new Color(255, 100, 100);
    private static final ImageIcon SEARCH_ICON = new ImageIcon(AbstractSearchAction.class.getResource("../dicom/images/search16x16.png"));
    private static final ImageIcon CROSS_ICON = new ImageIcon(AbstractSearchAction.class.getResource("../dicom/images/cross16x16.png"));
    private static final ImageIcon CROSS_ROLLOVER_ICON = new ImageIcon(AbstractSearchAction.class.getResource("../dicom/images/cross_white16x16.png"));
    private static final ImageIcon CROSS_PRESSED_ICON = new ImageIcon(AbstractSearchAction.class.getResource("../dicom/images/cross_white16x16.png"));
    protected JTextField searchTextField;
    protected boolean ignoreCase;
    protected boolean exactMatch;
    protected JComponent comp;
    private JPanel searchPanel;
    private JLabel matchesLabel;
    private int matches;
    protected boolean shiftDown = false;
    protected boolean controlDown = false;
    private static final MouseListener BUTTON_MOUSE_LISTENER = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent event) {
            Component component = event.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            Component component = event.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    protected AbstractSearchAction(boolean ignoreCase) {
        super("incremantal-search-case-" + (ignoreCase ? "in" : "") + "sensitive");
        this.ignoreCase = ignoreCase;
        this.exactMatch = true;
        this.comp = null;
        int modifiers = 2;
        if (!ignoreCase) {
            modifiers |= 1;
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, modifiers));
        this.createSearchPanel();
    }

    private void createSearchPanel() {
        this.searchPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.searchPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JLabel searchLabel = new JLabel(SEARCH_ICON);
        this.searchTextField = new JTextField();
        int height = this.searchTextField.getPreferredSize().height;
        this.searchTextField.setPreferredSize(new Dimension(256, height));
        JButton closeButton = new JButton(CROSS_ICON);
        closeButton.setPreferredSize(new Dimension(CROSS_ICON.getIconWidth() + 1, CROSS_ICON.getIconHeight() + 1));
        closeButton.setToolTipText("Close search");
        closeButton.setUI(new BasicButtonUI());
        closeButton.setContentAreaFilled(false);
        closeButton.setFocusable(false);
        closeButton.setBorder(BorderFactory.createEtchedBorder());
        closeButton.setBorderPainted(false);
        closeButton.addMouseListener(BUTTON_MOUSE_LISTENER);
        closeButton.setRolloverIcon(CROSS_ROLLOVER_ICON);
        closeButton.setPressedIcon(CROSS_PRESSED_ICON);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractSearchAction.this.searchPanel.setVisible(false);
            }
        });
        this.matchesLabel = new JLabel();
        this.matchesLabel.setOpaque(true);
        Border outsideBorder = BorderFactory.createEtchedBorder();
        Border insideBorder = BorderFactory.createEmptyBorder(0, 3, 0, 3);
        CompoundBorder border = BorderFactory.createCompoundBorder(outsideBorder, insideBorder);
        this.matchesLabel.setBorder(border);
        JCheckBox exactMatchCheckBox = new JCheckBox("Exact Match");
        exactMatchCheckBox.setSelected(this.exactMatch);
        exactMatchCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JCheckBox checkBox = (JCheckBox)event.getSource();
                AbstractSearchAction.this.exactMatch = checkBox.isSelected();
                AbstractSearchAction.this.changed();
            }
        });
        this.searchPanel.add(searchLabel);
        this.searchPanel.add(this.searchTextField);
        this.searchPanel.add(closeButton);
        this.searchPanel.add(exactMatchCheckBox);
        this.searchPanel.add(this.matchesLabel);
        this.searchPanel.setVisible(false);
        this.searchTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractSearchAction.this.searchPanel.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        this.searchTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent event) {
                AbstractSearchAction.this.changed();
            }

            @Override
            public void focusLost(FocusEvent event) {
                AbstractSearchAction.this.matchesLabel.setVisible(false);
            }
        });
    }

    public JPanel getSearchPanel() {
        return this.searchPanel;
    }

    @Override
    public void actionPerformed(ActionEvent ae2) {
        if (ae2.getSource() == this.searchTextField) {
            this.changed();
        } else if (!this.searchPanel.isVisible()) {
            this.comp = (JComponent)ae2.getSource();
            this.searchTextField.getDocument().removeDocumentListener(this);
            this.searchTextField.removeKeyListener(this);
            this.searchTextField.removeActionListener(this);
            this.initSearch(ae2);
            this.searchTextField.getDocument().addDocumentListener(this);
            this.searchTextField.addKeyListener(this);
            this.searchTextField.addActionListener(this);
            this.searchPanel.setVisible(true);
            this.searchTextField.requestFocus();
            this.searchTextField.selectAll();
        }
    }

    protected void initSearch(ActionEvent ae2) {
        this.changed();
    }

    private void changed() {
        this.matches = this.changed(this.comp, this.searchTextField.getText());
        this.searchTextField.requestFocus();
        if (this.matches > 0) {
            this.searchTextField.setForeground(MATCH_TEXT_COLOR);
            this.matchesLabel.setText(Integer.toString(this.matches));
            this.matchesLabel.setBackground(this.searchTextField.getBackground());
            this.matchesLabel.setForeground(MATCH_COUNT_COLOR);
            this.matchesLabel.setVisible(true);
        } else {
            this.searchTextField.setForeground(NO_MATCH_TEXT_COLOR);
            if (this.searchTextField.getText().length() > 0) {
                this.matchesLabel.setText(Integer.toString(this.matches));
                this.matchesLabel.setBackground(NO_MATCH_COUNT_BG_COLOR);
                this.matchesLabel.setForeground(NO_MATCH_COUNT_COLOR);
                this.matchesLabel.setVisible(true);
            } else {
                this.matchesLabel.setText("");
                this.matchesLabel.setVisible(false);
            }
        }
    }

    private void changed(Position.Bias bias) {
        this.searchTextField.requestFocus();
        int match = this.changed(this.comp, this.searchTextField.getText(), bias);
        if (match <= 0) {
            this.searchTextField.setForeground(NO_MATCH_TEXT_COLOR);
            this.matchesLabel.setText("0 of " + this.matches);
        } else {
            this.searchTextField.setForeground(MATCH_TEXT_COLOR);
            this.matchesLabel.setText(match + " of " + this.matches);
        }
    }

    protected abstract int changed(JComponent var1, String var2);

    protected abstract int changed(JComponent var1, String var2, Position.Bias var3);

    @Override
    public void insertUpdate(DocumentEvent e2) {
        this.changed();
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        this.changed();
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
        this.changed();
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        this.shiftDown = ke.isShiftDown();
        this.controlDown = ke.isControlDown();
        switch (ke.getKeyCode()) {
            case 38: {
                this.changed(Position.Bias.Backward);
                break;
            }
            case 40: {
                this.changed(Position.Bias.Forward);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }
}

