/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.search;

public class LCS {
    private static final int ONE_HUNDRED_PERCENT = 100;
    private final int[][] lengths;

    public LCS(String a2, String b2) {
        int M = a2.length();
        int N = b2.length();
        this.lengths = new int[M + 1][N + 1];
        for (int i2 = M - 1; i2 >= 0; --i2) {
            for (int j2 = N - 1; j2 >= 0; --j2) {
                this.lengths[i2][j2] = a2.charAt(i2) == b2.charAt(j2) ? this.lengths[i2 + 1][j2 + 1] + 1 : Math.max(this.lengths[i2 + 1][j2], this.lengths[i2][j2 + 1]);
            }
        }
    }

    public static int getLCSLength(String a2, String b2) {
        int[][] lengths = new LCS((String)a2, (String)b2).lengths;
        return lengths[0][0];
    }

    public static String getLCS(String a2, String b2) {
        int[][] lengths = new LCS((String)a2, (String)b2).lengths;
        int pos = 0;
        char[] ans = new char[lengths[0][0]];
        int i2 = 0;
        int j2 = 0;
        int M = a2.length();
        int N = b2.length();
        while (i2 < M && j2 < N) {
            if (a2.charAt(i2) == b2.charAt(j2)) {
                ans[pos++] = a2.charAt(i2);
                ++i2;
                ++j2;
                continue;
            }
            if (lengths[i2 + 1][j2] >= lengths[i2][j2 + 1]) {
                ++i2;
                continue;
            }
            ++j2;
        }
        return new String(ans);
    }

    public static boolean match(String a2, String b2, boolean ignoreCase, boolean exactMatch) {
        String text;
        String searchString = ignoreCase ? a2.toLowerCase() : a2;
        String string = text = ignoreCase ? b2.toLowerCase() : b2;
        if (exactMatch || searchString.length() <= 3) {
            return text.contains(searchString);
        }
        String[] ans = text.split("\\s");
        int min = searchString.length() * 7 / 10;
        for (int i2 = 0; i2 < ans.length; ++i2) {
            if (ans[i2].length() <= min || LCS.getLCSLength(searchString, ans[i2]) <= min) continue;
            return true;
        }
        return false;
    }

    public static int percentMatch(String a2, String b2) {
        if (null == a2 || null == b2) {
            return 0;
        }
        if (0 == a2.length() || 0 == b2.length()) {
            return 0;
        }
        int lcsLength = LCS.getLCSLength(a2, b2);
        return lcsLength * 100 / a2.length();
    }
}

