/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.search;

import com.ge.med.terra.tap.util.search.AbstractSearchAction;
import com.ge.med.terra.tap.util.search.LCS;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.text.Position;

public class TableSearchAction
extends AbstractSearchAction {
    private List<Integer> matchedRows = new ArrayList<Integer>();
    private List<Point> selectionIntervals = new ArrayList<Point>();

    public TableSearchAction(boolean ignoreCase) {
        super(ignoreCase);
    }

    @Override
    protected int changed(JComponent comp, String text) {
        int row;
        JTable table = (JTable)comp;
        String searchString = text.trim();
        table.getSelectionModel().clearSelection();
        this.matchedRows.clear();
        this.selectionIntervals.clear();
        if (searchString.length() == 0) {
            return 0;
        }
        int rows = table.getRowCount();
        int cols = table.getColumnCount();
        Point interval = null;
        block0: for (int row2 = 0; row2 < rows; ++row2) {
            for (int column = 0; column < cols; ++column) {
                Object value = table.getValueAt(row2, column);
                if (null == value || !LCS.match(searchString, value.toString(), this.ignoreCase, this.exactMatch)) continue;
                if (null != interval && row2 == interval.y + 1) {
                    interval.y = row2;
                } else {
                    interval = new Point();
                    interval.x = row2;
                    interval.y = row2;
                    this.selectionIntervals.add(interval);
                }
                this.matchedRows.add(row2);
                continue block0;
            }
        }
        for (Point selection : this.selectionIntervals) {
            table.getSelectionModel().addSelectionInterval(selection.x, selection.y);
        }
        if (table.getSelectionModel().getSelectionMode() != 2 && this.matchedRows.size() > 1) {
            row = this.matchedRows.get(0);
            table.getSelectionModel().addSelectionInterval(row, row);
        } else {
            row = table.getSelectedRow();
        }
        if (row >= 0) {
            table.scrollRectToVisible(table.getCellRect(row, 0, true));
        }
        return this.matchedRows.size();
    }

    @Override
    protected int changed(JComponent comp, String text, Position.Bias bias) {
        String searchString;
        int row;
        int startingRow;
        JTable table = (JTable)comp;
        boolean startingFromSelection = true;
        int max = table.getRowCount();
        int increment = 0;
        if (bias != null) {
            int n2 = increment = bias == Position.Bias.Forward ? 1 : -1;
        }
        if ((startingRow = (table.getSelectionModel().getLeadSelectionIndex() + increment + max) % max) < 0 || startingRow >= table.getRowCount()) {
            startingFromSelection = false;
            startingRow = 0;
        }
        if ((row = this.getNextMatch(table, searchString = text.trim(), startingRow, bias)) != -1) {
            this.changeSelection(table, row);
        } else if (startingFromSelection && (row = this.getNextMatch(table, searchString, 0, bias)) != -1) {
            this.changeSelection(table, row);
        }
        return this.matchedRows.indexOf(row) + 1;
    }

    private int getNextMatch(JTable table, String searchString, int startingRow, Position.Bias bias) {
        int rows = table.getRowCount();
        int cols = table.getColumnCount();
        int increment = bias == null || bias == Position.Bias.Forward ? 1 : -1;
        int row = startingRow;
        do {
            for (int column = 0; column < cols; ++column) {
                Object value = table.getValueAt(row, column);
                if (null == value || !LCS.match(searchString, value.toString(), this.ignoreCase, this.exactMatch)) continue;
                return row;
            }
        } while ((row = (row + increment + rows) % rows) != startingRow);
        return -1;
    }

    private void changeSelection(JTable table, int row) {
        if (this.controlDown) {
            table.addRowSelectionInterval(row, row);
        } else {
            table.setRowSelectionInterval(row, row);
        }
        table.scrollRectToVisible(table.getCellRect(row, 0, true));
    }
}

