/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.socket;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class SocketListener {
    private boolean dBug = false;
    private boolean done = false;

    void udpSocket(String port) throws SocketException {
        DatagramSocket ds = new DatagramSocket(Integer.parseInt(port.trim()));
        System.out.println("UDP Listener UP on port " + Integer.parseInt(port.trim()) + "...");
        byte[] buf = new byte[1020];
        DatagramPacket rp = new DatagramPacket(buf, buf.length);
        while (true) {
            try {
                while (true) {
                    ds.receive(rp);
                    System.out.println("Connected!");
                    byte[] data = rp.getData();
                    String str = new String(rp.getData(), rp.getOffset(), rp.getLength());
                    System.out.println("datagram: " + str);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    void tcpipSocket(String port) throws IOException {
        ServerSocket server = new ServerSocket(Integer.parseInt(port.trim()));
        Socket socket = null;
        while (!this.done) {
            try {
                System.out.println("TCPIP Listener UP on port " + Integer.parseInt(port.trim()) + "...");
                socket = server.accept();
                System.out.println("Connected!");
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                String s2 = in.readLine();
                out.write(s2);
                out.newLine();
                out.flush();
                System.out.println("Read - " + s2);
                System.out.println("Wrote- " + s2);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    void tcpipObjectSocket(String port) throws IOException {
        ServerSocket server = new ServerSocket(Integer.parseInt(port.trim()));
        Socket socket = null;
        while (true) {
            try {
                while (true) {
                    System.out.println("TCPIP Listener UP on port " + Integer.parseInt(port.trim()) + "...");
                    socket = server.accept();
                    System.out.println("Connected!");
                    ObjectInputStream in = new ObjectInputStream(socket.getInputStream());
                    ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
                    String s2 = (String)in.readObject();
                    out.writeObject(s2);
                    out.flush();
                    System.out.println("Read - " + s2);
                    System.out.println("Wrote- " + s2);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
                continue;
            }
            break;
        }
    }

    void tcpipByteSocket(String port) throws IOException {
        ServerSocket server = new ServerSocket(Integer.parseInt(port.trim()));
        Socket socket = null;
        System.out.println("TCPIP Listener UP on port " + Integer.parseInt(port.trim()) + "...");
        byte[] buff1 = new byte[5];
        while (!this.done) {
            try {
                socket = server.accept();
                InputStream in = socket.getInputStream();
                OutputStream out = socket.getOutputStream();
                in.read(buff1, 0, 5);
                int len = 0;
                for (int x2 = 4; x2 >= 1; --x2) {
                    len <<= 8;
                    len |= 0xFF & buff1[x2];
                }
                byte[] buff2 = new byte[len];
                for (int read = 0; read < len; read += in.read(buff2, read, len - read)) {
                }
                out.write(buff1);
                out.write(buff2);
                out.flush();
                if (!this.dBug) continue;
                System.out.println("Listener Read Type- " + buff1[0]);
                System.out.println("Listener Read Len - " + len);
                System.out.println("Listener Read Msg - " + new String(buff2, 0, buff2.length));
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public void setDebugOn(boolean b2) {
        this.dBug = b2;
    }

    public boolean isDebugOn() {
        return this.dBug;
    }

    public void kill() {
        this.done = true;
        System.exit(1);
    }

    public void usage() {
        System.out.println("Usage: SocketListener [tcp|udp] PORT");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        SocketListener s2 = new SocketListener();
        if (args.length < 2) {
            s2.usage();
        }
        if (args[0].equals("tcp")) {
            s2.tcpipByteSocket(args[1]);
        } else if (args[0].equals("udp")) {
            s2.udpSocket(args[1]);
        } else {
            s2.usage();
        }
    }
}

