/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.socket;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.bind.DatatypeConverter;

public class SocketUtil {
    private static final String TLS_CONFIG_FILE_PATH = "TLS_CONFIG_FILE_PATH";
    private static final String TLS_KEY_FILE_PATH = "TLS_KEY_FILE_PATH";
    private static final String KEY_PROPERTIES = ".key.properties";
    private static final String TLS_CONFIG_PROPERTIES = "tls_config.properties";
    private static final String ENCRYPTION_OFF = "off";
    private static final String ENCRYPTION_FALSE = "false";
    private static final int DEFAULT_TIMEOUT = 0;
    private static final Logger logger = Logger.getLogger(SocketUtil.class.getName());
    private static final String TLS_KEYSTORE = "tls.keystore";
    private static final String TLS_TRUSTSTORE = "tls.truststore";
    private static final String TLS_SERVER_CIPHERSUITES = "tls.server.ciphersuites";
    private static final String TLS_CLIENT_CIPHERSUITES = "tls.client.ciphersuites";
    private static final String TLS_KEYSTORE_PASSWORD = "tls.keystore.password";
    private static final String JAVAX_NET_SSL_KEY_STORE = "javax.net.ssl.keyStore";
    private static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String JAVAX_NET_SSL_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String USR_SHARE_GEHC_SECURITY = "/usr/share/gehc_security";
    private static final String TLS_PASSWORD_ENCRYPTION = "tls.password.encryption";
    private static final String TLS_KEY_VALUE = "key";
    private static final String TLS_CLIENT_VERSION = "tls.client.versions";
    private static Properties tlsConfigProps = new Properties();
    private SSLServerSocketFactory sslServerSocketFactory;
    private String[] configuredServerCipherSuites;
    private SSLSocketFactory sslClientSocketFactory;
    private String[] configuredClientCipherSuites;
    private String[] filteredServerCipherSuites;
    private String[] filteredClientCipherSuites;
    private String[] clientSSLVersions;

    private static void loadTLSConfigurations() {
        String tlsConfigPath = System.getProperty(TLS_CONFIG_FILE_PATH, SocketUtil.getTLSDefaultFilePath(TLS_CONFIG_FILE_PATH));
        logger.info("TLS Config path is : " + tlsConfigPath);
        tlsConfigProps = SocketUtil.loadProp(tlsConfigPath);
        if (!tlsConfigProps.isEmpty()) {
            SocketUtil.setKeyAndTrustStoresAsSystemProperties(tlsConfigProps);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("keyStore : " + System.getProperty(JAVAX_NET_SSL_KEY_STORE));
                logger.finest("TrustStore : " + System.getProperty(JAVAX_NET_SSL_TRUST_STORE));
            }
            logger.log(Level.INFO, "Finished loading TLS Configurations");
        }
    }

    private static String getTLSDefaultFilePath(String tlsFilepath) {
        String defaultfilePath = System.getenv("SEC_HOME");
        if (defaultfilePath == null) {
            defaultfilePath = USR_SHARE_GEHC_SECURITY;
        }
        defaultfilePath = defaultfilePath + File.separator + "certs" + File.separator;
        if (TLS_CONFIG_FILE_PATH.equalsIgnoreCase(tlsFilepath)) {
            defaultfilePath = defaultfilePath + TLS_CONFIG_PROPERTIES;
        } else if (tlsFilepath.equalsIgnoreCase(TLS_KEY_FILE_PATH)) {
            defaultfilePath = defaultfilePath + KEY_PROPERTIES;
        } else {
            logger.log(Level.INFO, "Invalid file mentioned");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "TLS Config File Path is : " + defaultfilePath);
        }
        return defaultfilePath;
    }

    private static Properties loadProp(String configPath) {
        Properties prop = new Properties();
        File filePath = new File(configPath.trim());
        if (filePath.exists() && filePath.isFile()) {
            try {
                FileInputStream fin = new FileInputStream(configPath);
                prop.load(fin);
            }
            catch (FileNotFoundException e2) {
                logger.log(Level.SEVERE, "Can't load [" + filePath.getAbsolutePath() + "] + properties file, FileNotFoundException", e2);
            }
            catch (IOException e3) {
                logger.log(Level.SEVERE, "Can't load [" + filePath.getAbsolutePath() + "] + properties file, IOException", e3);
            }
        } else {
            logger.log(Level.WARNING, "TLS properties Path [" + filePath.getAbsolutePath() + "] not found.");
        }
        return prop;
    }

    private static void setKeyAndTrustStoresAsSystemProperties(Properties tlsProps) {
        String trustStore = tlsProps.getProperty(TLS_TRUSTSTORE);
        String keyStore = tlsProps.getProperty(TLS_KEYSTORE);
        String keyStorePassword = tlsProps.getProperty(TLS_KEYSTORE_PASSWORD);
        String passwordEncrytion = tlsProps.getProperty(TLS_PASSWORD_ENCRYPTION);
        SocketUtil.setSSLTrustStore(trustStore);
        SocketUtil.setSSLKeyStore(keyStore, keyStorePassword, passwordEncrytion);
    }

    private static void setSSLTrustStore(String trustStore) {
        if (trustStore != null && !trustStore.isEmpty()) {
            File filePath = new File(trustStore.trim());
            if (filePath.exists() && filePath.isFile()) {
                System.setProperty(JAVAX_NET_SSL_TRUST_STORE, trustStore);
            } else {
                logger.log(Level.SEVERE, "Trust store defined " + trustStore + " does not exists");
            }
        } else {
            logger.log(Level.SEVERE, "Trust store is not defined.");
        }
    }

    private static void setSSLKeyStore(String keyStore, String keyStorePassword, String passwordEncrytion) {
        if (keyStore != null && !keyStore.isEmpty()) {
            File filePath = new File(keyStore.trim());
            if (filePath.exists() && filePath.isFile()) {
                System.setProperty(JAVAX_NET_SSL_KEY_STORE, keyStore);
            } else {
                logger.log(Level.SEVERE, "Keystore defined " + keyStore + " does not exists");
            }
            if (keyStorePassword != null && !keyStorePassword.isEmpty()) {
                if (SocketUtil.isPasswordEncryptionOn(passwordEncrytion)) {
                    SocketUtil.decryptKeystorePassword(keyStorePassword);
                } else {
                    System.setProperty(JAVAX_NET_SSL_KEY_STORE_PASSWORD, keyStorePassword);
                }
            } else {
                logger.log(Level.SEVERE, "Keystore password is not defined.");
            }
        } else {
            logger.log(Level.SEVERE, "Key store is not defined.");
        }
    }

    private static boolean isPasswordEncryptionOn(String passwordEncrytion) {
        return !ENCRYPTION_OFF.equalsIgnoreCase(passwordEncrytion) && !ENCRYPTION_FALSE.equalsIgnoreCase(passwordEncrytion);
    }

    private static void decryptKeystorePassword(String keyStorePassword) {
        Properties keyProps = SocketUtil.loadTLSKeyFilePath();
        if (!keyProps.isEmpty()) {
            byte[] cipherKey = SocketUtil.decryptKey(keyProps.getProperty(TLS_KEY_VALUE));
            String decryptedKeystorePassword = SocketUtil.decryptPassword(keyStorePassword, cipherKey);
            if (decryptedKeystorePassword != null) {
                System.setProperty(JAVAX_NET_SSL_KEY_STORE_PASSWORD, decryptedKeystorePassword.trim());
            } else {
                logger.log(Level.SEVERE, "unable to decrypt Key store password or key.properties ");
            }
        }
    }

    private static Properties loadTLSKeyFilePath() {
        String tlsKeyPath = System.getProperty(TLS_KEY_FILE_PATH, SocketUtil.getTLSDefaultFilePath(TLS_KEY_FILE_PATH));
        logger.info("TLS Key path is : " + tlsKeyPath);
        return SocketUtil.loadProp(tlsKeyPath);
    }

    private static byte[] decryptKey(String bytesEncoded) {
        byte[] decoded = DatatypeConverter.parseBase64Binary((String)bytesEncoded);
        try {
            return DatatypeConverter.parseHexBinary((String)new String(decoded, "UTF-8"));
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, "Hexadecimal key provided cannot be parsed.");
        }
        catch (UnsupportedEncodingException e2) {
            logger.log(Level.SEVERE, " new String(decoded,\"UTF-8\") charset is not supported ");
        }
        return decoded;
    }

    private static String decryptPassword(String encryptedPassword, byte[] cipherKey) {
        if (cipherKey != null && cipherKey.length > 0) {
            try {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                SecretKeySpec secretKey = new SecretKeySpec(cipherKey, "AES");
                cipher.init(2, secretKey);
                byte[] decryptedStringBytes = DatatypeConverter.parseBase64Binary((String)encryptedPassword);
                return new String(cipher.doFinal(decryptedStringBytes));
            }
            catch (Exception e2) {
                logger.severe("Unable to decrypt password " + e2.getMessage());
            }
        }
        return null;
    }

    public SocketUtil() {
        this.initializeWithDefaultConfig();
    }

    public SocketUtil(SSLServerSocketFactory sslServerFactory, SSLSocketFactory sslClientFactory) {
        this.sslServerSocketFactory = sslServerFactory != null ? sslServerFactory : (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        this.sslClientSocketFactory = sslClientFactory != null ? sslClientFactory : (SSLSocketFactory)SSLSocketFactory.getDefault();
        this.initializeCipherSuites();
        this.initializeSSLVersions();
    }

    private void initializeWithDefaultConfig() {
        this.sslServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        this.sslClientSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        this.initializeCipherSuites();
        this.initializeSSLVersions();
    }

    private void initializeCipherSuites() {
        this.configuredServerCipherSuites = this.readCipherSuitesFromConfig(tlsConfigProps.getProperty(TLS_SERVER_CIPHERSUITES));
        this.configuredClientCipherSuites = this.readCipherSuitesFromConfig(tlsConfigProps.getProperty(TLS_CLIENT_CIPHERSUITES));
        this.filteredServerCipherSuites = this.getFilteredServerSocketCipherSuites();
        this.filteredClientCipherSuites = this.getFilteredClientSocketCipherSuites();
    }

    private void initializeSSLVersions() {
        String sslClientVersionsConfigured = tlsConfigProps.getProperty(TLS_CLIENT_VERSION, null);
        logger.log(Level.INFO, "Configured tls client versions are " + sslClientVersionsConfigured);
        if (sslClientVersionsConfigured != null) {
            this.clientSSLVersions = sslClientVersionsConfigured.split(",");
        } else {
            logger.warning("No TLS client versions are configured in TLS Properties, Hence jdk takes default versions");
        }
    }

    private String[] readCipherSuitesFromConfig(String cipherSuitesStr) {
        String[] cipherSuitesArray = null;
        if (cipherSuitesStr != null && !cipherSuitesStr.isEmpty()) {
            cipherSuitesArray = cipherSuitesStr.split(",");
        } else {
            logger.warning("No Cipher Suites are configured in TLS Properties.");
        }
        return cipherSuitesArray;
    }

    private String[] getFilteredServerSocketCipherSuites() {
        return this.filterCipherSuites(this.sslServerSocketFactory.getDefaultCipherSuites(), this.configuredServerCipherSuites != null ? this.configuredServerCipherSuites : this.sslServerSocketFactory.getDefaultCipherSuites());
    }

    private String[] getFilteredClientSocketCipherSuites() {
        return this.filterCipherSuites(this.sslClientSocketFactory.getDefaultCipherSuites(), this.configuredClientCipherSuites != null ? this.configuredClientCipherSuites : this.sslClientSocketFactory.getDefaultCipherSuites());
    }

    private String[] filterCipherSuites(String[] defaultCipherSuites, String[] cipherSuites) {
        ArrayList<String> filteredCipherSuites = new ArrayList<String>();
        List<String> defaultCipherSuitesList = Arrays.asList(defaultCipherSuites);
        for (String cipher : cipherSuites) {
            if (defaultCipherSuitesList.contains(cipher)) {
                filteredCipherSuites.add(cipher);
                continue;
            }
            logger.warning("Configured Cipher : " + cipher + " not supported");
        }
        return filteredCipherSuites.toArray(new String[filteredCipherSuites.size()]);
    }

    private void setFilteredCipherSuites(SSLServerSocket sslServerSocket) {
        if (this.filteredServerCipherSuites.length == 0) {
            logger.log(Level.WARNING, "Secure Connection may fail as none of the configured Cipher suite is supported.");
        }
        sslServerSocket.setEnabledCipherSuites(this.filteredServerCipherSuites);
    }

    private void setFilteredCipherSuites(SSLSocket sslClientSocket) {
        if (this.filteredClientCipherSuites.length == 0) {
            logger.log(Level.WARNING, "Secure Connection may fail as configured Cipher suites are not supported.");
        }
        sslClientSocket.setEnabledCipherSuites(this.filteredClientCipherSuites);
    }

    private void setClientProtocols(SSLSocket sslClientSocket) throws IOException {
        ArrayList<String> filterVersionList = new ArrayList<String>();
        List<String> supportedVersionList = Arrays.asList(sslClientSocket.getSupportedProtocols());
        if (this.clientSSLVersions != null && this.clientSSLVersions.length > 0) {
            for (String versionsConfigured : this.clientSSLVersions) {
                if (supportedVersionList.contains(versionsConfigured.trim())) {
                    filterVersionList.add(versionsConfigured.trim());
                    continue;
                }
                logger.log(Level.WARNING, "Configured TLS client version " + versionsConfigured + " is invalid");
            }
            if (filterVersionList.isEmpty()) {
                logger.log(Level.WARNING, "None of the Configured TLS client versions are supported by jdk");
                throw new IOException("Unable to set Configured TLS versions in SSL client socket");
            }
            sslClientSocket.setEnabledProtocols(filterVersionList.toArray(new String[filterVersionList.size()]));
        }
    }

    public void setSSLClientCipherSuites(String[] clientCipherSuites) {
        this.configuredClientCipherSuites = clientCipherSuites;
        this.filteredClientCipherSuites = this.getFilteredClientSocketCipherSuites();
    }

    public void setSSLServerCipherSuites(String[] serverCipherSuites) {
        this.configuredServerCipherSuites = serverCipherSuites;
        this.filteredServerCipherSuites = this.getFilteredServerSocketCipherSuites();
    }

    public SSLServerSocket getSSLServerSocket(int port) throws IOException {
        SSLServerSocket sslServerSocket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port);
        this.setFilteredCipherSuites(sslServerSocket);
        return sslServerSocket;
    }

    public ServerSocket getServerSocket(int port) throws IOException {
        return new ServerSocket(port);
    }

    public SSLSocket getSSLSocket(String remoteHostName, int port) throws IOException {
        return this.getSSLSocket(remoteHostName, port, 0);
    }

    public SSLSocket getSSLSocket(String remoteHostName, int port, int timeout) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.sslClientSocketFactory.createSocket();
        this.setFilteredCipherSuites(sslSocket);
        this.setClientProtocols(sslSocket);
        sslSocket.connect(new InetSocketAddress(remoteHostName, port), timeout);
        return sslSocket;
    }

    public Socket getSocket() throws IOException {
        return new Socket();
    }

    public Socket getSocket(String remoteHostName, int port) throws IOException {
        return this.getSocket(remoteHostName, port, 0);
    }

    public Socket getSocket(String remoteHostName, int port, int timeout) throws IOException {
        Socket sock = new Socket();
        sock.connect(new InetSocketAddress(remoteHostName, port), timeout);
        return sock;
    }

    static {
        SocketUtil.loadTLSConfigurations();
    }
}

