/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.testTools;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class testTools {
    int steps = 10;
    int stepSleep = 10;
    Robot r;

    public testTools() {
        try {
            this.r = new Robot();
        }
        catch (AWTException ex) {
            ex.printStackTrace();
        }
    }

    public void pressButton(Component c2) {
        this.pressButton(c2, 0);
    }

    public void pressButton(Component c2, int button) {
        button = this.getButton(button);
        this.moveMouseOver(c2);
        this.r.mousePress(button);
    }

    public BufferedImage picture(Component c2) {
        return this.r.createScreenCapture(new Rectangle(c2.getLocationOnScreen(), c2.getSize()));
    }

    public void moveMouseOver(Component c2) {
        Point p2 = c2.getLocationOnScreen();
        int y2 = c2.getHeight() / 2 + p2.y;
        int x2 = c2.getWidth() / 2 + p2.y;
        this.r.mouseMove(x2, y2);
    }

    private void wrtiePPM(BufferedImage img, String file) throws FileNotFoundException, IOException {
        int[] pixels = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
        BufferedOutputStream b2 = new BufferedOutputStream(new FileOutputStream(file));
        b2.write("P6\n".getBytes());
        String str = "" + img.getWidth() + " " + img.getHeight() + "\n";
        b2.write(str.getBytes(), 0, str.length());
        b2.write("255\n".getBytes());
        byte[] bpix = new byte[pixels.length * 3];
        for (int i2 = 0; i2 < pixels.length; ++i2) {
            int k2 = i2 * 3;
            int n2 = k2++;
            bpix[n2] = (byte)(bpix[n2] | pixels[i2] & 0xFF);
            int n3 = k2++;
            bpix[n3] = (byte)(bpix[n3] | pixels[i2] >> 8 & 0xFF);
            int n4 = k2;
            bpix[n4] = (byte)(bpix[n4] | pixels[i2] >> 16 & 0xFF);
        }
        b2.write(bpix);
    }

    private int getButton(int button) {
        switch (button) {
            case 0: {
                return 16;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 4;
            }
        }
        return 16;
    }

    public Component findComponent(Container cont, Class cl) {
        Component[] comp = cont.getComponents();
        for (int i2 = 0; i2 < comp.length; ++i2) {
            Component ret;
            if (comp[i2].getClass() == cl) {
                return comp[i2];
            }
            if (!(comp[i2] instanceof Container) || (ret = this.findComponent((Container)comp[i2], cl)) == null) continue;
            return ret;
        }
        return null;
    }

    public void mousDrag(Component c2, int x1, int y1, int x2, int y2, int button) {
        Point p2 = c2.getLocationOnScreen();
        button = this.getButton(button);
        x2 += p2.x;
        y2 += p2.y;
        this.r.mouseMove(x1 += p2.x, y1 += p2.y);
        this.r.mousePress(button);
        for (int t2 = 0; t2 <= this.steps; ++t2) {
            int x3 = (x1 * (this.steps - t2) + x2 * t2) / this.steps;
            int y3 = (y1 * (this.steps - t2) + y2 * t2) / this.steps;
            this.r.waitForIdle();
            testTools.sleep(this.stepSleep);
            this.r.mouseMove(x3, y3);
        }
        this.r.mouseRelease(button);
    }

    public static void sleep(long millis) {
        try {
            Thread.currentThread();
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

