/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tport;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.util.tport.AppletDataList_back_actionAdapter;
import com.ge.med.terra.tap.util.tport.AppletDataList_load_actionAdapter;
import com.ge.med.terra.tap.util.tport.BufferedImageEx;
import com.ge.med.terra.tap.util.tport.HttpImageServer2;
import com.ge.med.terra.tap.util.tport.ListTag;
import com.ge.med.terra.tap.util.tport.MyCellRenderer;
import com.ge.med.terra.tap.util.tport.TPort;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class AppletDataList
extends JPanel {
    DMTag[] stags = null;
    DMTag[] itags = null;
    DMObject[] series = new DMObject[0];
    DMObject[] images = new DMObject[0];
    int selectedSeries = -1;
    BufferedImage[][] isets = new BufferedImage[0][];
    JScrollPane scroll = new JScrollPane();
    JList imageList = new JList();
    JPanel listPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JPanel bottomPanel = new JPanel();
    JPanel statusPanel = new JPanel();
    DefaultComboBoxModel seriesModel = new DefaultComboBoxModel();
    BorderLayout borderLayout1 = new BorderLayout();
    JTextField status = new JTextField();
    private TPort tport;
    BufferedImage[] bi;
    String url;
    JButton load = new JButton();
    JButton back = new JButton();
    Stack stack = new Stack();
    Border border1;

    public AppletDataList() {
        try {
            this.jbInit();
            this.fetch("");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.setLayout(new BorderLayout());
        this.scroll.setHorizontalScrollBarPolicy(30);
        this.scroll.setVerticalScrollBarPolicy(20);
        this.imageList.setBorder(null);
        this.imageList.setSelectionBackground(Color.lightGray);
        this.imageList.setSelectionForeground(Color.red);
        this.imageList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                AppletDataList.this.imageList_mouseClicked(e2);
            }
        });
        this.listPanel.setOpaque(false);
        this.listPanel.setLayout(this.borderLayout1);
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        this.buttonPanel.setOpaque(false);
        this.statusPanel.setLayout(this.borderLayout1);
        this.status.setBackground(Color.lightGray);
        this.status.setBorder(this.border1);
        this.status.setEditable(false);
        this.statusPanel.add((Component)this.status, "Center");
        this.load.setEnabled(false);
        this.load.setText("Load");
        this.load.addActionListener(new AppletDataList_load_actionAdapter(this));
        this.back.setEnabled(false);
        this.back.setText("Back");
        this.back.addActionListener(new AppletDataList_back_actionAdapter(this));
        this.bottomPanel.add(this.buttonPanel);
        this.bottomPanel.add(this.statusPanel);
        this.add((Component)this.scroll, "Center");
        this.add((Component)this.listPanel, "North");
        this.add((Component)this.bottomPanel, "South");
        this.buttonPanel.add((Component)this.back, null);
        this.buttonPanel.add((Component)this.load, null);
        this.scroll.getViewport().add((Component)this.imageList, null);
        this.imageList.setCellRenderer(new MyCellRenderer());
    }

    void loadListSelect() {
        int[] index = this.imageList.getSelectedIndices();
        if (index.length <= 0) {
            return;
        }
        BufferedImage[] imageList = new BufferedImage[100];
        int count = 0;
        for (int i2 = 0; i2 < index.length; ++i2) {
            BufferedImage[] iset = this.images[index[i2]].getPixelData();
            for (int j2 = 0; j2 < iset.length; ++j2) {
                if (count >= imageList.length) {
                    BufferedImage[] newList = new BufferedImage[imageList.length * 2];
                    System.arraycopy(imageList, 0, newList, 0, imageList.length);
                    imageList = newList;
                }
                imageList[count] = iset[j2];
                ++count;
            }
            BufferedImage[] newList = new BufferedImage[count];
            System.arraycopy(imageList, 0, newList, 0, newList.length);
        }
    }

    public void selectionChanged(int oldPort, int newPort) {
        this.imageList.clearSelection();
    }

    public static void main(String[] argv) {
        for (int i2 = 0; i2 < argv.length; ++i2) {
            if (!argv[i2].equals("-version") && !argv[i2].equals("-v")) continue;
            System.out.println("@(#)@BUILD_INFO@");
            System.exit(0);
        }
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        AppletDataList content = new AppletDataList();
        frame.getContentPane().add(content);
        frame.pack();
        frame.setVisible(true);
    }

    void fetch(String selection) {
        this.url = "http://localhost:4100";
        this.url = this.url + "/" + selection;
        this.stack.push(selection);
        if (!this.stack.empty() && !selection.equals("")) {
            this.back.setEnabled(true);
        } else {
            this.back.setEnabled(false);
        }
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AppletDataList.this.pull(AppletDataList.this.url);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        th.start();
    }

    private void pull(String url_str) {
        try {
            this.status("Contacting server ..." + url_str);
            ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
            URL url = new URL(url_str);
            InputStream in = url.openStream();
            ObjectInputStream oi = new ObjectInputStream(in);
            try {
                while (true) {
                    Integer obj_type;
                    if ((obj_type = (Integer)oi.readObject()) == HttpImageServer2.OBJ_TYPE_IMAGE) {
                        this.status("Pulling images ...");
                        BufferedImageEx i2 = (BufferedImageEx)oi.readObject();
                        list.add(i2.getBufferedImage());
                        continue;
                    }
                    if (obj_type == HttpImageServer2.OBJ_TYPE_LIST) {
                        this.status("Getting listing ...");
                        String[] str = (String[])oi.readObject();
                        obj_type = (Integer)oi.readObject();
                        this.status("Getting icons ...");
                        Icon[] icons = (Icon[])oi.readObject();
                        ListTag[] lt = new ListTag[str.length];
                        for (int i3 = 0; i3 < lt.length; ++i3) {
                            lt[i3] = new ListTag(str[i3], icons[i3]);
                        }
                        this.imageList.setListData(lt);
                        if (this.bi != null && this.bi.length > 0 && this.tport != null) {
                            this.tport.removeAll();
                            this.tport.repaint();
                        }
                        oi.close();
                        in.close();
                        this.status("Done");
                        return;
                    }
                    if (obj_type != HttpImageServer2.OBJ_TYPE_TNAIL) continue;
                }
            }
            catch (Exception e2) {
                if (e2 instanceof EOFException) {
                    this.status("No more images to read");
                    oi.close();
                    in.close();
                } else {
                    e2.printStackTrace();
                }
                this.bi = new BufferedImage[list.size()];
                for (int i4 = 0; i4 < this.bi.length; ++i4) {
                    this.bi[i4] = (BufferedImage)list.get(i4);
                }
                this.status("Will add " + this.bi.length + " images to TPort here");
                if (this.bi != null && this.bi.length > 0 && this.tport != null) {
                    this.tport.setImages(this.bi);
                    this.tport.repaint();
                }
                this.status("Done");
            }
        }
        catch (Exception e3) {
            this.status("Failed: " + e3.getMessage());
            e3.printStackTrace();
        }
    }

    void imageList_mouseClicked(MouseEvent e2) {
        if (e2.getClickCount() == 2) {
            try {
                int i2 = this.imageList.locationToIndex(e2.getPoint());
                String s2 = ((ListTag)this.imageList.getSelectedValue()).getName();
                this.imageList.setSelectedIndex(i2);
                StringTokenizer tok = new StringTokenizer(s2, "@@XD@@");
                String current = tok.nextToken();
                String key = tok.nextToken();
                if (current.startsWith("Exam")) {
                    this.fetch("Series=" + key);
                } else if (current.startsWith("Series")) {
                    this.fetch("Image=" + key);
                } else if (current.startsWith("Series")) {
                    this.fetch("Image=" + key);
                } else if (current.startsWith("Image")) {
                    this.fetch("Image=" + key);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void status(String msg) {
        this.status.setText(msg);
    }

    void back_actionPerformed(ActionEvent e2) {
        if (!this.stack.isEmpty()) {
            this.stack.pop();
        }
        if (!this.stack.isEmpty()) {
            this.fetch((String)this.stack.pop());
        }
        if (this.stack.isEmpty()) {
            this.back.setEnabled(false);
        }
    }

    void load_actionPerformed(ActionEvent e2) {
    }

    public void setTport(TPort tport) {
        this.tport = tport;
    }

    public TPort getTport() {
        return this.tport;
    }
}

