/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tport;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;

class CheckImage {
    BufferedImage img;
    int img_cnt = 0;
    BufferedImage[] imageArray = new BufferedImage[20];

    public BufferedImage[] getImageArray() {
        BufferedImage[] ia = new BufferedImage[this.img_cnt];
        for (int i2 = 0; i2 < this.img_cnt; ++i2) {
            ia[i2] = this.imageArray[i2];
        }
        return ia;
    }

    public CheckImage() {
        this.img = new BufferedImage(256, 256, 11);
        Graphics2D g2 = (Graphics2D)this.img.getGraphics();
        for (int y2 = 0; y2 < 256; ++y2) {
            for (int x2 = 0; x2 < 256; ++x2) {
                this.img.setRGB(x2, y2, x2 + y2);
            }
        }
        g2.setColor(new Color(200));
        g2.fillOval(128, 128, 50, 80);
        for (int i2 = 0; i2 < 20; ++i2) {
            g2.setColor(new Color(i2 * 100));
            g2.drawString("(" + i2 + ")", i2 / 10 * 20, i2 % 10 * 20);
        }
        this.imageArray[0] = this.img;
    }

    public CheckImage(int dimx, int dimy, byte[] array) {
        this.loadImage(dimx, dimy, array);
    }

    public void loadImage(int dimx, int dimy, byte[] array) {
        this.img = new BufferedImage(dimx, dimy, 11);
        Graphics2D g2 = (Graphics2D)this.img.getGraphics();
        int k2 = 0;
        short[] shortArray = new short[dimx * dimy];
        int min = 0;
        int max = 0;
        for (int y2 = 0; y2 < 256; ++y2) {
            for (int x2 = 0; x2 < 256; ++x2) {
                int val1 = array[k2 * 2] & 0xFF;
                int val2 = array[k2 * 2 + 1] & 0xFF;
                int tempx = val1 << 8 | val2;
                if (y2 == 0 && x2 == 0) {
                    min = max = tempx;
                }
                if (min > tempx) {
                    min = tempx;
                }
                if (max < tempx) {
                    max = tempx;
                }
                shortArray[k2] = (short)tempx;
                ++k2;
            }
        }
        System.out.println("(min,max)= " + min + "," + max);
        DataBufferUShort dbs = new DataBufferUShort(shortArray, k2);
        int[] bandOffsets = new int[]{0};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx, 1, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[]{16};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 1);
        this.img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
        this.imageArray[this.img_cnt++] = this.img;
    }

    public CheckImage(String file) {
        this.addFile(file);
    }

    public void addFile(String file) {
        try {
            File f2 = new File(file);
            if (f2.isDirectory()) {
                return;
            }
            long len = f2.length();
            FileInputStream fr = new FileInputStream(file);
            fr.skip(len - 131072L);
            byte[] buff = new byte[131072];
            fr.read(buff);
            this.loadImage(256, 256, buff);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CheckImage(String[] files) {
        this.imageArray = new BufferedImage[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            this.addFile(files[i2]);
        }
    }
}

