/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tport;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.util.tport.SDpram;
import com.ge.med.terra.tap.util.tport.TPort;
import com.ge.med.terra.tap.util.tport.TPortAnnot;
import com.ge.med.terra.tap.util.tport.TPortScene;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class PrismTPort
extends JPanel {
    GridLayout gridLayout1 = new GridLayout();
    SDpram p = new SDpram();
    SDpram op = new SDpram();
    TPort[] ports = new TPort[0];
    int[] index = null;
    TPortScene[] scenes = new TPortScene[0];
    BufferedImage[] imgSet;
    int offset = 0;
    boolean oneScene = false;
    private int changeMode = 2;
    private TPortAnnot annot = TPortAnnot.getDefault();
    boolean cineEnabled = false;
    boolean rotateEnabled = false;
    MouseAdapter ma = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e2) {
            PrismTPort.this.mouseClick(e2);
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            PrismTPort.this.mouseDown(e2);
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            PrismTPort.this.mouseUp(e2);
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }
    };
    long when;
    final long minTime = 180L;
    int lastScene = 0;
    private int skip = 0;
    int wlDir = 0;

    public int[] getSelection() {
        int count = 0;
        for (int i2 = 0; i2 < this.scenes.length; ++i2) {
            if (this.scenes[i2].selection <= 0) continue;
            ++count;
        }
        int[] sel = new int[count];
        count = 0;
        for (int i3 = 0; i3 < this.scenes.length; ++i3) {
            if (this.scenes[i3].selection <= 0) continue;
            sel[count++] = i3;
        }
        return sel;
    }

    public void setSelection(int[] sel) {
        for (int i2 = 0; i2 < sel.length; ++i2) {
            if (this.scenes.length < sel[i2] || 0 > sel[i2]) continue;
            this.scenes[sel[i2]].selection = 1;
        }
    }

    public void setWLmode(int mode) {
        this.changeMode = mode;
    }

    public int getWLmode() {
        return this.changeMode;
    }

    public TPort getTport(int i2) {
        return this.ports[i2];
    }

    public TPortAnnot getAnnot() {
        return this.annot;
    }

    public void setAnnot(TPortAnnot annot) {
        this.annot = annot;
        for (int i2 = 0; i2 < this.ports.length; ++i2) {
            this.ports[i2].setAnnot(annot);
        }
        this.repaint();
    }

    protected void mouseDown(MouseEvent e2) {
        this.when = e2.getWhen();
    }

    protected void mouseClick(MouseEvent e2) {
        TPort p2 = (TPort)e2.getSource();
        if (p2 == null) {
            return;
        }
        int mouse = e2.getModifiers();
        TPortScene gs = p2.getScene();
        int cc = e2.getClickCount();
        switch (cc) {
            case 1: {
                int k2;
                int sel;
                int i2;
                boolean shift = (mouse & 1) > 0;
                boolean ctl = (mouse & 2) > 0;
                boolean left = (mouse & 0x10) > 0;
                boolean middle = (mouse & 8) > 0;
                boolean right = (mouse & 4) > 0;
                int clickPort = 0;
                int clickScene = 0;
                for (i2 = 0; i2 < this.ports.length; ++i2) {
                    if (p2 != this.ports[i2]) continue;
                    clickPort = i2;
                }
                for (i2 = 0; i2 < this.scenes.length; ++i2) {
                    if (gs != this.scenes[i2]) continue;
                    clickScene = i2;
                }
                if (left && !shift && !ctl) {
                    this.lastScene = clickScene;
                    for (i2 = 0; i2 < this.scenes.length; ++i2) {
                        int n2 = sel = clickScene == i2 ? 1 : 0;
                        if (sel == this.scenes[i2].selection) continue;
                        this.scenes[i2].selection = sel;
                        for (k2 = 0; k2 < this.ports.length; ++k2) {
                            if (this.scenes[i2] != this.ports[k2].getScene()) continue;
                            this.ports[k2].paintSelection();
                        }
                    }
                }
                if (left && !shift && ctl) {
                    this.lastScene = clickScene;
                    gs.selection = (gs.selection + 1) % 2;
                    p2.paintSelection();
                }
                if (left && shift && !ctl) {
                    for (i2 = 0; i2 < this.scenes.length; ++i2) {
                        int n3 = sel = (this.lastScene - i2) * (clickScene - i2) <= 0 ? 1 : 0;
                        if (sel == this.scenes[i2].selection) continue;
                        this.scenes[i2].selection = sel;
                        for (k2 = 0; k2 < this.ports.length; ++k2) {
                            if (this.scenes[i2] != this.ports[k2].getScene()) continue;
                            this.ports[k2].paintSelection();
                        }
                    }
                }
                return;
            }
            case 2: {
                boolean clickPort = false;
                boolean clickScene = false;
                Object ser = this.imgSet[p2.getFrame()].getProperty("32,17");
                if (ser == null) {
                    return;
                }
                for (int i3 = 0; i3 < this.imgSet.length; ++i3) {
                    this.scenes[i3].selection = ser.equals(this.imgSet[i3].getProperty("32,17")) ? 1 : 0;
                }
                for (int k3 = 0; k3 < this.ports.length; ++k3) {
                    this.ports[k3].paintSelection();
                }
                return;
            }
            case 3: {
                for (int i4 = 0; i4 < this.imgSet.length; ++i4) {
                    this.scenes[i4].selection = 1;
                }
                for (int k4 = 0; k4 < this.ports.length; ++k4) {
                    this.ports[k4].paintSelection();
                }
                return;
            }
        }
    }

    protected void mouseUp(MouseEvent e2) {
        int range;
        int delta;
        int i2;
        TPort p2 = (TPort)e2.getSource();
        if (p2 == null) {
            return;
        }
        int mouse = e2.getModifiers();
        TPortScene gs = p2.getScene();
        if (e2.getWhen() - this.when < 180L) {
            return;
        }
        if (0 == this.changeMode) {
            return;
        }
        if (0 != (mouse & 0x10)) {
            for (i2 = 0; i2 < this.scenes.length; ++i2) {
                if (this.scenes[i2].selection <= 0 && this.changeMode != 2) continue;
                delta = (this.skip & 1) == 1 ? (this.skip + 1) / 2 : this.skip / 2;
                for (range = -delta; range <= delta; ++range) {
                    if (i2 + delta < 0 || i2 + delta >= this.scenes.length) continue;
                    this.scenes[i2 + delta].pan_x = gs.pan_x;
                    this.scenes[i2 + delta].pan_y = gs.pan_y;
                }
            }
        }
        if (0 != (mouse & 8)) {
            for (i2 = 0; i2 < this.scenes.length; ++i2) {
                if (this.scenes[i2].selection <= 0 && this.changeMode != 2) continue;
                delta = (this.skip & 1) == 1 ? (this.skip + 1) / 2 : this.skip / 2;
                for (range = -delta; range <= delta; ++range) {
                    if (i2 + delta < 0 || i2 + delta >= this.scenes.length) continue;
                    this.scenes[i2].window_max = gs.window_max;
                    this.scenes[i2].window_min = gs.window_min;
                }
            }
        }
        if (0 != (mouse & 4)) {
            for (i2 = 0; i2 < this.scenes.length; ++i2) {
                if (this.scenes[i2].selection <= 0 && this.changeMode != 2) continue;
                delta = (this.skip & 1) == 1 ? (this.skip + 1) / 2 : this.skip / 2;
                for (range = -delta; range <= delta; ++range) {
                    if (i2 + delta < 0 || i2 + delta >= this.scenes.length) continue;
                    this.scenes[i2].zoom = gs.zoom;
                }
            }
        }
        this.repaint();
    }

    void update() {
        boolean update_layout = false;
        if (this.p.cols != this.op.cols) {
            update_layout = true;
        }
        if (this.p.rows != this.op.rows) {
            update_layout = true;
        }
        if (update_layout) {
            int i2;
            this.op.rows = this.p.rows;
            this.op.cols = this.p.cols;
            int size = this.op.cols * this.op.rows;
            TPort[] nports = new TPort[size];
            this.removeAll();
            for (i2 = 0; i2 < size; ++i2) {
                nports[i2] = new TPort();
                nports[i2].setWLdir(this.wlDir);
                nports[i2].setLock(true);
                nports[i2].addMouseListener(this.ma);
                nports[i2].setAnnot(this.annot);
                nports[i2].setCineEnabled(this.cineEnabled);
                nports[i2].setRotateEnabled(this.rotateEnabled);
            }
            this.gridLayout1 = new GridLayout(this.op.rows, this.op.cols);
            this.setLayout(this.gridLayout1);
            for (i2 = 0; i2 < size; ++i2) {
                this.add(nports[i2]);
            }
            this.ports = nports;
            this.setImages();
            this.validate();
            for (i2 = 0; i2 < size; ++i2) {
                nports[i2].setLock(false);
            }
            this.repaint();
        }
    }

    public void lockPorts(boolean lock) {
        for (int i2 = 0; i2 < this.ports.length; ++i2) {
            this.ports[i2].setLock(lock);
        }
    }

    public int[] getIndex() {
        return this.index;
    }

    public PrismTPort() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static DMTag[] neededTags() {
        DMTag[] neededTags = new DMTag[]{new DMTag(8, 22), new DMTag(8, 24), new DMTag(32, 14), new DMTag(32, 17), new DMTag(32, 19)};
        return neededTags;
    }

    public static Comparator SrImSorter() {
        Comparator compareImgNo = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)((BufferedImage)o1).getProperty("32,17");
                String s2 = (String)((BufferedImage)o2).getProperty("32,17");
                int val = Integer.parseInt(s1) - Integer.parseInt(s2);
                if (val != 0) {
                    return val;
                }
                s1 = (String)((BufferedImage)o1).getProperty("32,19");
                s2 = (String)((BufferedImage)o2).getProperty("32,19");
                return Integer.parseInt(s1) - Integer.parseInt(s2);
            }
        };
        return compareImgNo;
    }

    public TPort[] getPorts() {
        return this.ports;
    }

    public static void main(String[] args) {
        final PrismTPort p2 = new PrismTPort();
        JFrame frame = new JFrame("prismPort");
        JPanel pan = new JPanel();
        JPanel pan2 = new JPanel();
        JButton[] b2 = new JButton[]{new JButton("2x1"), new JButton("4x2"), new JButton("8x4"), new JButton("all"), new JButton("one"), new JButton("4")};
        p2.setCineEnabled(true);
        ActionListener al2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JButton b2 = (JButton)e2.getSource();
                if (b2.getText().equals("2x1")) {
                    p2.setRowCol(1, 2);
                }
                if (b2.getText().equals("4x2")) {
                    p2.setRowCol(2, 4);
                }
                if (b2.getText().equals("8x4")) {
                    p2.setRowCol(4, 8);
                }
                if (b2.getText().equals("all")) {
                    p2.setIndex(null);
                }
                if (b2.getText().equals("one")) {
                    p2.setIndex(new int[]{0, -1, -1, -1, -1});
                }
                if (b2.getText().equals("4")) {
                    p2.setIndex(new int[]{0, 1, 2, 3, -1});
                }
            }
        };
        for (int i2 = 0; i2 < b2.length; ++i2) {
            pan2.add(b2[i2]);
            b2[i2].addActionListener(al2);
        }
        final JScrollBar sbar = new JScrollBar(1, 0, 1, 0, 14);
        pan.setLayout(new BorderLayout());
        pan.add(sbar);
        sbar.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                p2.setOffset(sbar.getValue());
            }

            @Override
            public void mouseMoved(MouseEvent e2) {
            }
        });
        sbar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
            }

            @Override
            public void mousePressed(MouseEvent e2) {
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                p2.setOffset(sbar.getValue());
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
            }

            @Override
            public void mouseExited(MouseEvent e2) {
            }
        });
        p2.setRowCol(2, 1);
        DMSession ses = new DMSession("file", "D:/dev/ves_exams/ct/e65/s180", null);
        DMObject patient2 = ses.getChildren()[0];
        BufferedImage[] iset = patient2.getPixelData(PrismTPort.neededTags());
        Arrays.sort(iset, PrismTPort.SrImSorter());
        p2.setImages(iset);
        frame.getContentPane().add(p2);
        frame.getContentPane().add((Component)pan, "East");
        frame.getContentPane().add((Component)pan2, "North");
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 500);
        frame.validate();
        frame.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.black);
        this.setDoubleBuffered(false);
        this.setLayout(this.gridLayout1);
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.layoutImages();
    }

    public void setImages(BufferedImage[] imgSet, int frame) {
        this.imgSet = imgSet;
        if (imgSet != null && !this.oneScene) {
            this.scenes = new TPortScene[imgSet.length];
        }
        for (int i2 = 0; i2 < this.scenes.length; ++i2) {
            this.scenes[i2] = new TPortScene(imgSet[i2]);
        }
        this.offset = frame;
        this.setImages();
    }

    public void setImages(BufferedImage[] imgSet) {
        this.imgSet = imgSet;
        if (imgSet != null && !this.oneScene) {
            this.scenes = new TPortScene[imgSet.length];
        }
        for (int i2 = 0; i2 < this.scenes.length; ++i2) {
            this.scenes[i2] = new TPortScene(imgSet[i2]);
        }
        this.setImages();
    }

    public BufferedImage[] getImages() {
        return this.imgSet;
    }

    private void setImages() {
        if (this.imgSet == null) {
            return;
        }
        this.lockPorts(true);
        for (int i2 = 0; i2 < this.ports.length; ++i2) {
            this.ports[i2].setImages(this.imgSet);
        }
        this.layoutImages();
        this.lockPorts(false);
    }

    private void layoutImages() {
        if (this.imgSet == null) {
            return;
        }
        for (int i2 = 0; i2 < this.ports.length; ++i2) {
            int f2 = this.calcFrame(i2 + this.offset);
            this.ports[i2].setFrame(f2);
            if (this.oneScene || f2 == -1) continue;
            this.ports[i2].setScene(this.scenes[f2]);
        }
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setIndex(int[] index) {
        this.index = index;
        this.lockPorts(true);
        this.layoutImages();
        this.lockPorts(false);
    }

    private int calcFrame(int i2) {
        if (this.imgSet == null) {
            return -1;
        }
        if (this.index == null) {
            int slice = i2 * (this.skip + 1);
            return slice < this.imgSet.length ? slice : -1;
        }
        if (i2 >= this.index.length) {
            return -1;
        }
        if (this.index[i2] > this.imgSet.length) {
            return -1;
        }
        return this.index[i2];
    }

    public void setRowCol(int row, int col) {
        this.p.cols = col;
        this.p.rows = row;
        this.update();
    }

    public void setRows(int newRows) {
        this.p.rows = newRows;
        this.update();
    }

    public int getRows() {
        return this.p.rows;
    }

    public void setCols(int newCols) {
        this.p.cols = newCols;
        this.update();
    }

    public int getCols() {
        return this.p.cols;
    }

    public void setCineEnabled(boolean cineon) {
        for (int i2 = 0; i2 < this.ports.length; ++i2) {
            this.ports[i2].setCineEnabled(cineon);
        }
        this.cineEnabled = cineon;
    }

    public boolean isCineEnabled() {
        return this.cineEnabled;
    }

    public void setRotateEnabled(boolean rotateon) {
        for (int i2 = 0; i2 < this.ports.length; ++i2) {
            this.ports[i2].setRotateEnabled(rotateon);
        }
        this.rotateEnabled = rotateon;
    }

    public boolean isRotateEnabled() {
        return this.rotateEnabled;
    }

    public void clearSelection() {
        for (int i2 = 0; i2 < this.scenes.length; ++i2) {
            this.scenes[i2].selection = 0;
        }
    }

    public void setWLdir(int wlDir) {
        this.wlDir = wlDir;
        for (int i2 = 0; i2 < this.ports.length; ++i2) {
            this.ports[i2].setWLdir(wlDir);
        }
    }

    public int getWLdir() {
        return this.wlDir;
    }

    public void setScene(int i2, TPortScene s2) {
        this.scenes[i2].copyScene(s2);
    }

    public TPortScene getScene(int i2) {
        return this.scenes[i2];
    }

    @Override
    public void paint(Graphics g2) {
        if (this.imgSet != null) {
            super.paint(g2);
        } else {
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

