/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.xlib;

import com.ge.med.terra.tap.util.xlib.JXDisplay;
import com.ge.med.terra.tap.util.xlib.JXScreen;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;

public class JXVisual {
    private int ID;
    private int classNumber;
    private int bitsPerRGB;
    private int colormapEntries;
    private int rMask;
    private int gMask;
    private int bMask;
    private JXScreen screen;
    private int depth;
    private int bpp;
    private int bitPad;
    public static final int StaticGray = 0;
    public static final int GrayScale = 1;
    public static final int StaticColor = 2;
    public static final int PseudoColor = 3;
    public static final int TrueColor = 4;
    public static final int DirectColor = 5;
    static final String[] class_name = new String[]{"StaticGray", "GrayScale", "StaticColor", "PseudoColor", "TrueColor", "DirectColor"};

    public JXScreen getScreen() {
        return this.screen;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getBpp() {
        return this.bpp;
    }

    public int getBitPad() {
        return this.bitPad;
    }

    public int getWidthBytes(int width) {
        return width * this.bpp >> 3;
    }

    public int getBitPad(int width) {
        return 0;
    }

    public int getRedMask() {
        return this.rMask;
    }

    public int getGreenMask() {
        return this.gMask;
    }

    public int getBlueMask() {
        return this.bMask;
    }

    public int getBitsPerRGB() {
        return this.bitsPerRGB;
    }

    public int getColormapEntries() {
        return this.colormapEntries;
    }

    public int getBytePad(int width) {
        int bits = width * this.bpp;
        bits = -bits & this.bitPad - 1;
        return bits >> 3;
    }

    public int getClassNumber() {
        return this.classNumber;
    }

    public String getClassName() {
        return class_name[this.classNumber];
    }

    private JXVisual() {
    }

    public static JXVisual createVisualFromStream(JXScreen screen, JXDisplay display, int depth, int bpp, int bitPad) throws IOException {
        JXVisual v2 = new JXVisual();
        v2.screen = screen;
        v2.depth = depth;
        v2.bpp = bpp;
        v2.bitPad = bitPad;
        DataInputStream in = display.in;
        v2.ID = in.readInt();
        v2.classNumber = in.readByte();
        v2.bitsPerRGB = in.readByte();
        v2.colormapEntries = in.readShort();
        v2.rMask = in.readInt();
        v2.gMask = in.readInt();
        v2.bMask = in.readInt();
        in.readInt();
        return v2;
    }

    public String toString() {
        return super.toString() + "(" + this.getClassName() + ", " + this.bitsPerRGB + " bitsPerRGB, " + this.colormapEntries + " entries)";
    }

    void print(PrintStream out) {
        out.println("    VISUAL #" + this.ID + ":");
        out.println("      class = " + this.getClassName());
        out.println("      bitsPerRGB = " + this.bitsPerRGB);
        out.println("      colormapEntries = " + this.colormapEntries);
        out.println("      rMask = " + Integer.toHexString(this.rMask));
        out.println("      gMask = " + Integer.toHexString(this.gMask));
        out.println("      bask = " + Integer.toHexString(this.bMask));
    }
}

