/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMultiImageViewport;
import com.ge.med.terra.jami.XpSeriesDisplayer;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSystem;
import com.ge.med.terra.tap.print.ColFormat;
import com.ge.med.terra.tap.print.PrintablePort;
import com.ge.med.terra.tap.print.RowFormat;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.AutoControlResources;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.util.DicomPrintablePort;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JButton;
import javax.swing.JComponent;

public class XPwFilmPage
extends JButton
implements CapableListener {
    static ResourceBundle res = AutoControlResources.STRING_RESOURCES;
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = new AutoControlPanelSeek(this);
    Properties prop;

    public XPwFilmPage() {
        this.addAncestorListener(this.panelSeek);
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setData(DMObject[] objs) {
    }

    private void jbInit() throws Exception {
        this.setToolTipText(res.getString("Film_Selected_Viewport_"));
        this.setText(res.getString("PAGE"));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                XPwFilmPage.this.this_actionPerformed(e2);
            }
        });
    }

    @Override
    public void setProperties(Properties properties) {
        this.prop = properties;
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    void this_actionPerformed(ActionEvent e2) {
        String printAble;
        XPutil.getLogger().log(Level.FINEST, "Start <XPwFilmPage>  " + Tid.newTid());
        try {
            Class.forName("com.ge.med.terra.xpv.print.JavaPrintService");
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        DocPrintJob job = null;
        DMSystem dmSystem = (DMSystem)this.screen.getClientProperty("dmSystem");
        if (dmSystem != null && (printAble = dmSystem.getDMSystemProperties().getProperty("printServiceCapable")) != null && printAble.equalsIgnoreCase("true")) {
            job = dmSystem.getPrintService().createPrintJob();
        }
        if (job == null) {
            String docFlavor = this.prop.getProperty("DOC_FLAVOR");
            if (docFlavor == null) {
                return;
            }
            DocFlavor flavor = new DocFlavor("application/x-java-" + docFlavor + "-printable-print-service", "java.awt.print.Printable");
            PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, null);
            if (services.length == 0) {
                XPutil.getLogger().log(Level.FINEST, "End <XPwFilmPage>");
                Tid.popTID();
                return;
            }
            job = services[0].createPrintJob();
        }
        if (job == null) {
            XPutil.getLogger().log(Level.FINEST, "End <XPwFilmPage>");
            Tid.popTID();
            return;
        }
        JComponent port = this.screen.getSelectedPort();
        SimpleDoc doc = null;
        HashPrintRequestAttributeSet aset = null;
        if (port instanceof XpMultiImageViewport || port instanceof XpSeriesDisplayer) {
            DicomPrintablePort savedScreen = new DicomPrintablePort();
            XpMedicalImage[] mImgs = ((XpCompositePort)port).getImages();
            int sIndex = ((FramePositioningCapable)((Object)port)).getFrameIndex();
            int rows = ((RowColCapable)((Object)port)).getRows();
            int cols = ((RowColCapable)((Object)port)).getCols();
            int numImages = cols * rows;
            ArrayList<XpMedicalImage> vec = new ArrayList<XpMedicalImage>();
            for (int i2 = 0; i2 < numImages && sIndex + i2 <= mImgs.length - 1; ++i2) {
                vec.add(mImgs[sIndex + i2]);
            }
            XpMedicalImage[] imageSet = vec.toArray(new XpMedicalImage[vec.size()]);
            savedScreen.setImages(imageSet);
            savedScreen.setRowCol(1, 1);
            for (int i3 = 0; i3 < imageSet.length; ++i3) {
                savedScreen.getScene(i3).setImageRenderAttributes(((XpCompositePort)port).getScene(sIndex + i3).getImageRenderAttributes());
            }
            savedScreen.setRowCol(1, 1);
            aset = new HashPrintRequestAttributeSet();
            aset.add((Attribute)new RowFormat(rows));
            aset.add((Attribute)new ColFormat(cols));
            savedScreen.setPrimaryBorder(null);
            savedScreen.setAnnotationVisible(Boolean.getBoolean("XPwFilm.showAnnotation"));
            doc = new SimpleDoc(savedScreen, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        } else {
            doc = new SimpleDoc(new PrintablePort(port), DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        }
        try {
            job.print(doc, aset);
        }
        catch (PrintException pe) {
            pe.printStackTrace();
            XPutil.getLogger().log(Level.WARNING, "Print Page Failed");
            Tid.popTID();
        }
        XPutil.getLogger().log(Level.FINEST, "End <XPwFilmPage>");
        Tid.popTID();
    }
}

