/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.AutoControlResources;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.util.XPutil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XPwZoomSlider
extends JSlider
implements CapableListener {
    static ResourceBundle res = AutoControlResources.STRING_RESOURCES;
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = null;
    StateChangeListener listener = null;
    private boolean vplistner = true;
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "zoom") {
                XPwZoomSlider.this.updateZoomSetting();
            } else if (evt.getPropertyName() == "data_changed") {
                XPwZoomSlider.this.updateZoomSetting();
            }
        }
    };

    public XPwZoomSlider() {
        this.init();
    }

    public XPwZoomSlider(boolean vpListenr) {
        this.vplistner = vpListenr;
        this.init();
    }

    private void init() {
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.setBackground(null);
        this.setValue(1);
        this.setMaximum(60);
        this.setMinimum(-60);
        this.setMinorTickSpacing(20);
        this.setPaintTicks(false);
    }

    public void setData(DMObject[] objs) {
    }

    public void removeChangeListener() {
        this.removeChangeListener(this.listener);
    }

    private void jbInit() throws Exception {
        this.setToolTipText(res.getString("Zoom_Slider_"));
        this.listener = new StateChangeListener();
        this.addChangeListener(this.listener);
    }

    public Double getZoom() {
        PanZoomCapable pz = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pz == null) {
            return null;
        }
        return new Double(pz.getZoom());
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        PanZoomCapable pz;
        if (this.vplistner && (pz = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable")) != null) {
            this.updateZoomSetting();
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
        if (this.vplistner) {
            screen.addPropertyChangeListener(this.viewPortListener);
        }
    }

    public void removePropertyChangeListener() {
        if (this.screen != null) {
            this.screen.removePropertyChangeListener(this.viewPortListener);
        }
    }

    private void updateZoomSetting() {
        PanZoomCapable pz = this.panelSeek.getPZPort();
        if (pz != null && XPutil.compareCallBack(Math.pow(2.0, (double)this.getValue() / 20.0), pz.getZoom())) {
            this.setValue((int)(Math.log(pz.getZoom()) / Math.log(2.0) * 20.0));
        }
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    @Override
    public void setProperties(Properties properties) {
    }

    class StateChangeListener
    implements ChangeListener {
        StateChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            XPutil.getLogger().log(Level.FINEST, "Start <XPwZoomSlider> " + Tid.newTid());
            PanZoomCapable pz = (PanZoomCapable)XPwZoomSlider.this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
            if (pz != null) {
                pz.setZoom(Math.pow(2.0, (double)XPwZoomSlider.this.getValue() / 20.0));
                System.out.println("XPwZoomSlider.this_stateChanged() " + Math.pow(2.0, (double)XPwZoomSlider.this.getValue() / 20.0));
            }
            XPutil.getLogger().log(Level.FINEST, "Stop <XPwZoomSlider> ");
            Tid.popTID();
        }
    }
}

