/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.AutoControlResources;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class XPwZoomText
extends JTextField
implements CapableListener {
    static ResourceBundle res = AutoControlResources.STRING_RESOURCES;
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = null;
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "zoom") {
                XPwZoomText.this.updateZoomSetting();
            } else if (evt.getPropertyName() == "data_changed") {
                XPwZoomText.this.updateZoomSetting();
            }
        }
    };
    DecimalFormat zoomFormat = new DecimalFormat("#.000");

    public XPwZoomText() {
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.setText("1.000");
    }

    public void setData(DMObject[] objs) {
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        PanZoomCapable pz = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pz != null) {
            this.updateZoomSetting();
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
        screen.addPropertyChangeListener(this.viewPortListener);
    }

    private void updateZoomSetting() {
        PanZoomCapable pz = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pz != null && XPutil.compareCallBack(Double.parseDouble(this.getText()), pz.getZoom())) {
            this.setText(this.zoomFormat.format(pz.getZoom()));
        }
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    private void jbInit() throws Exception {
        this.setMaximumSize(new Dimension(33, 25));
        this.setMinimumSize(new Dimension(33, 25));
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(33, 25));
        this.setToolTipText(res.getString("Zoom_Indicatior_"));
        this.setSelectionStart(5);
        this.setText("1.000");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                XPwZoomText.this.this_actionPerformed(e2);
            }
        });
    }

    void this_actionPerformed(ActionEvent e2) {
        XPutil.getLogger().log(Level.FINEST, "Start <XPwZoomText> " + Tid.newTid());
        PanZoomCapable pz = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pz != null) {
            double zoom = 1.0;
            try {
                zoom = Double.parseDouble(this.getText());
                pz.setZoom(zoom);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        XPutil.getLogger().log(Level.FINEST, "Stop <XPwZoomText> ");
        Tid.popTID();
    }

    public Double getZoom() {
        PanZoomCapable pz = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pz == null) {
            return null;
        }
        return new Double(pz.getZoom());
    }
}

