/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.base;

import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.idc.DelayedPrintCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.idc.Selectable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.ImageOpCapable;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.xpv.base.ViewportContext;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import com.ge.med.terra.xpv.onport.XPopPanel;
import com.ge.med.terra.xpv.ui.FadeAwayOverLay;
import com.ge.med.terra.xpv.util.XPutil;
import com.ge.med.terra.xpv.util.XpColorConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class XPscreen
extends JPanel
implements Printable,
AnnotCapable,
ColorMapCapable,
PanZoomCapable,
RowColCapable,
CineCapable,
WindowLevelCapable,
FramePositioningCapable,
ROICapable,
DelayedPrintCapable,
ImageOpCapable,
SelectionCapable {
    public static Border selectedBorder = BorderFactory.createLineBorder(Color.white, 2);
    public static Border unselectedBorder = BorderFactory.createLineBorder(Color.black, 2);
    JComponent[] pport = new JComponent[0];
    XPscreenLayout layout = XPscreenLayout.layout2x2();
    private int selectedPortNumber = 0;
    public static final String PARENT_PORT_CHANGE = "parent_port_changed";
    public static final String DATA_CHANGE = "data_changed";
    public static final String LAYOUT_CHANGE = "layout_changed";
    Properties prop;
    Color selectedPortBorderColor = Color.lightGray;
    Class[] onPort = null;
    String[] location = null;
    PropertyChangeListener vpContextListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ViewportContext context = (ViewportContext)((JComponent)evt.getSource()).getClientProperty("ViewportContext");
            XPscreen.this.firePropertyChange("ViewportContext", null, context);
        }
    };
    Class[] capables = new Class[]{PanZoomCapable.class, CineCapable.class, RowColCapable.class, WindowLevelCapable.class, FramePositioningCapable.class};
    private PropertyChangeListener portPropertyChange = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XPscreen.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    };

    public void reset() {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            this.pport[i2] = new EmptyPort();
            this.addPort(this.pport[i2], i2);
        }
        this.setSelectedPortNumber(0);
    }

    public void setLayout(XPscreenLayout layout) {
        super.setLayout(layout);
        int selNo = this.getSelectedPortNumber();
        int len = layout.getNoOfPorts();
        if (len > this.pport.length) {
            JComponent[] tmp = new JComponent[len];
            System.arraycopy(this.pport, 0, tmp, 0, this.pport.length);
            for (int i2 = this.pport.length; i2 < len; ++i2) {
                tmp[i2] = new EmptyPort();
                this.addPort(tmp[i2], i2);
            }
            this.pport = tmp;
            this.setSelectedPortNumber(selNo);
        }
        if (this.getSelectedPortNumber() >= layout.getNoOfPorts()) {
            this.setSelectedPortNumber(0);
        }
        for (int i3 = 0; i3 < len; ++i3) {
            this.pport[i3].setVisible(true);
        }
        this.layout = layout;
        this.firePropertyChange(LAYOUT_CHANGE, null, layout);
    }

    public XPscreenLayout getScreenLayout() {
        return this.layout;
    }

    public void clearScreen() {
        this.removeAll();
        this.pport = new JComponent[0];
    }

    @Override
    public Capable getCapable(String capableIFName) {
        String[] cap = new String[]{"Printable", "AnnotCapable", "ColorMapCapable", "PanZoomCapable", "RowColCapable", "CineCapable", "WindowLevelCapable", "FramePositioningCapable", "ROICapable", "DelayedPrintCapable", "ImageOpCapable"};
        for (int i2 = 0; i2 < cap.length; ++i2) {
            if (capableIFName.indexOf(cap[i2]) < 0) continue;
            return this;
        }
        return null;
    }

    @Override
    public boolean isAutoRepaint() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof Capable) {
            return ((Capable)((Object)c2)).isAutoRepaint();
        }
        return false;
    }

    @Override
    public void setAutoRepaint(boolean stat) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof Capable)) continue;
            ((Capable)((Object)this.pport[i2])).setAutoRepaint(stat);
        }
    }

    public int getNumPorts() {
        return this.pport.length;
    }

    @Override
    public int getNumComponents() {
        return this.getNumPorts();
    }

    public XPscreen() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            XPutil.getLogger().log(Level.SEVERE, "XPscreen creation failed", ex);
        }
        XPutil.getLogger().log(Level.FINEST, "XPscreen is created", new Exception());
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layout);
        this.setOpaque(false);
        this.setBackground(Color.black);
        this.setSelectedPortNumber(0);
    }

    @Override
    public void paintComponent(Graphics g2) {
        Insets insets = this.getInsets();
        g2.setColor(this.getBackground());
        g2.fillRect(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
    }

    public JComponent getPort(int n2) {
        if (n2 < 0 || n2 >= this.pport.length) {
            return null;
        }
        return this.pport[n2];
    }

    @Override
    public JComponent getViewportComponent(int selection) {
        return this.getPort(selection);
    }

    public void setProperties(Properties properties) {
        String uport_porder;
        this.prop = properties;
        String portCtls = properties.getProperty("PortControls");
        String borderColor = properties.getProperty("PORT_SELECTION_BORDER_COLOR");
        if (borderColor != null) {
            this.selectedPortBorderColor = XpColorConverter.getColor(borderColor);
            if (this.selectedPortBorderColor == null) {
                this.selectedPortBorderColor = Color.lightGray;
            }
            selectedBorder = BorderFactory.createLineBorder(this.selectedPortBorderColor, 2);
        }
        if ((uport_porder = properties.getProperty("UNSLECT_PORT_NO_BORDER")) != null) {
            unselectedBorder = null;
        }
        if (portCtls == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(portCtls, ",");
        this.onPort = new Class[st.countTokens()];
        this.location = new String[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            String thisport = st.nextToken();
            int index = thisport.lastIndexOf(64);
            String className = thisport.substring(0, index);
            String gloc = thisport.substring(index + 1, thisport.length());
            try {
                Class<?> c2;
                this.onPort[count] = c2 = Class.forName(className);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.location[count] = gloc;
            ++count;
        }
    }

    public void dataChanged() {
        this.firePropertyChange(DATA_CHANGE, this.selectedPortNumber, -1);
    }

    public void addPort(JComponent comp, int index) {
        if (this.pport.length <= index) {
            JComponent[] port = new JComponent[index + 1];
            System.arraycopy(this.pport, 0, port, 0, this.pport.length);
            for (int i2 = this.pport.length; i2 <= index; ++i2) {
                port[i2] = new EmptyPort();
                this.add(port[i2]);
            }
            this.pport = port;
        }
        this.pport[index].setVisible(false);
        this.remove(index);
        this.pport[index] = comp;
        if (comp instanceof Capable) {
            FadeAwayOverLay f2 = (FadeAwayOverLay)comp.getClientProperty("FadeAwayOverLay");
            if (f2 == null) {
                f2 = new FadeAwayOverLay();
                f2.addBase(comp);
                comp.putClientProperty("FadeAwayOverLay", f2);
                XPopPanel op = null;
                try {
                    if (this.onPort != null) {
                        for (int cIndex = 0; cIndex < this.onPort.length; ++cIndex) {
                            op = (XPopPanel)this.onPort[cIndex].newInstance();
                            if (!op.isSupported((Capable)((Object)comp))) continue;
                            if (this.location[cIndex].compareToIgnoreCase("west") == 0) {
                                f2.addOnPortCtl(op, "West");
                            } else if (this.location[cIndex].compareToIgnoreCase("east") == 0) {
                                f2.addOnPortCtl(op, "East");
                            } else if (this.location[cIndex].compareToIgnoreCase("north") == 0) {
                                f2.addOnPortCtl(op, "North");
                            } else if (this.location[cIndex].compareToIgnoreCase("south") == 0) {
                                f2.addOnPortCtl(op, "South");
                            }
                            op.setPort(comp);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    XPutil.getLogger().log(Level.INFO, "XPscreen.addPort()", ex);
                }
            }
            super.add((Component)f2, index);
        } else {
            super.add((Component)comp, index);
        }
        comp.setVisible(true);
        if (comp instanceof Capable) {
            SelectionCapable sc = (SelectionCapable)((Capable)((Object)comp)).getCapable("com.ge.med.idc.SelectionCapable");
            Selectable selectable = (Selectable)((Object)((Capable)((Object)comp)).getCapable("com.ge.med.idc.Selectable"));
            if (sc != null) {
                sc.addPropertyChangeListener("ComponentSelection", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e2) {
                        if (!e2.getPropertyName().equals("ComponentSelection")) {
                            return;
                        }
                        if ((Integer)e2.getNewValue() == -1) {
                            return;
                        }
                        XPscreen.this.selectionChangeOnChild(e2.getSource());
                    }
                });
            } else if (selectable != null) {
                selectable.addPropertyChangeListener("COMPONENT_SELECTED", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e2) {
                        XPscreen.this.selectionChangeOnChild(e2.getSource());
                    }
                });
            } else {
                comp.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e2) {
                        XPscreen.this.selectionChangeOnChild(e2.getSource());
                    }
                });
            }
        } else {
            comp.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e2) {
                    XPscreen.this.selectionChangeOnChild(e2.getSource());
                }
            });
        }
        this.selectionChangeOnChild(comp);
        comp.removePropertyChangeListener(this.vpContextListener);
        comp.addPropertyChangeListener("ViewportContext", this.vpContextListener);
        if (comp instanceof Capable) {
            ((Capable)((Object)comp)).setAutoRepaint(true);
        }
        this.revalidate();
    }

    protected void selectionChangeOnChild(Object source) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (this.pport[i2] == source || source instanceof Component && this.pport[i2].isAncestorOf((Component)source)) {
                this.setSelectedPortNumber(i2);
                this.pport[i2].setBorder(selectedBorder);
                continue;
            }
            if (this.pport[i2] instanceof SelectionCapable) {
                ((SelectionCapable)((Object)this.pport[i2])).setComponentSelection(-1);
            }
            this.pport[i2].setBorder(unselectedBorder);
        }
    }

    public void updateSelection() {
        int sel = this.getSelectedPortNumber();
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (sel == i2) {
                this.pport[i2].setBorder(selectedBorder);
                continue;
            }
            if (this.pport[i2] instanceof SelectionCapable) {
                ((SelectionCapable)((Object)this.pport[i2])).setComponentSelection(-1);
            }
            this.pport[i2].setBorder(unselectedBorder);
        }
    }

    public JComponent[] getAllPorts() {
        return this.pport;
    }

    public void switchPort(int n1, int n2) {
        JComponent sPort;
        JComponent fPort = this.getPort(n1);
        this.pport[n1] = sPort = this.getPort(n2);
        this.pport[n2] = fPort;
        this.removeAll();
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            FadeAwayOverLay f2 = (FadeAwayOverLay)this.pport[i2].getClientProperty("FadeAwayOverLay");
            if (f2 != null) {
                this.add((Component)f2, i2);
                continue;
            }
            this.add((Component)this.pport[i2], i2);
        }
        if (this.getSelectedPortNumber() != n2) {
            this.setSelectedPortNumber(n2);
        } else {
            this.setSelectedPortNumber(n1);
        }
        this.revalidate();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    public void setSelectedPortNumber(int selectedPort) {
        int oldSelectedPortNumber = this.selectedPortNumber;
        this.selectedPortNumber = selectedPort;
        JComponent port = this.getPort(oldSelectedPortNumber);
        JComponent newport = this.getPort(selectedPort);
        for (int i2 = 0; i2 < this.capables.length; ++i2) {
            if (this.capables[i2].isInstance(port)) {
                ((Capable)((Object)port)).removePropertyChangeListener(this.portPropertyChange);
            }
            if (!this.capables[i2].isInstance(newport)) continue;
            ((Capable)((Object)newport)).addPropertyChangeListener(this.portPropertyChange);
            break;
        }
        this.firePropertyChange(PARENT_PORT_CHANGE, oldSelectedPortNumber, selectedPort);
        this.firePropertyChange("ComponentSelection", oldSelectedPortNumber, selectedPort);
        this.repaint();
    }

    @Override
    public void setComponentSelection(int selection) {
        this.setSelectedPortNumber(selection);
    }

    public int getSelectedPortNumber() {
        return this.selectedPortNumber;
    }

    @Override
    public int getComponentSelection() {
        return this.getSelectedPortNumber();
    }

    public JComponent getSelectedPort() {
        if (this.selectedPortNumber < 0 || this.selectedPortNumber >= this.pport.length) {
            return null;
        }
        return this.pport[this.selectedPortNumber];
    }

    @Override
    public int print(Graphics g2, PageFormat format, int pageIndex) {
        Graphics2D g2d = (Graphics2D)g2;
        g2d.translate(format.getImageableX(), format.getImageableY());
        double sx = format.getImageableWidth() / (double)this.getWidth();
        double sy = format.getImageableHeight() / (double)this.getHeight();
        if (sx > sy) {
            sx = sy;
        } else {
            sy = sx;
        }
        g2d.scale(sx, sy);
        this.printAll(g2d);
        return 0;
    }

    @Override
    public String[] getAnnotationGroups() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof AnnotCapable) {
            return ((AnnotCapable)((Object)c2)).getAnnotationGroups();
        }
        return null;
    }

    @Override
    public String[] getAnnotationItems() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof AnnotCapable) {
            return ((AnnotCapable)((Object)c2)).getAnnotationItems();
        }
        return null;
    }

    @Override
    public String[] getAnnotationItems(String groupName) {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof AnnotCapable) {
            return ((AnnotCapable)((Object)c2)).getAnnotationItems(groupName);
        }
        return null;
    }

    @Override
    public int[] getColorMap() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof ColorMapCapable) {
            return ((ColorMapCapable)((Object)c2)).getColorMap();
        }
        return null;
    }

    @Override
    public void setColorMap(int[] cmap) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof ColorMapCapable)) continue;
            ((ColorMapCapable)((Object)this.pport[i2])).setColorMap(cmap);
        }
    }

    @Override
    public void setZoom(double zoom) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i2])).setZoom(zoom);
        }
    }

    @Override
    public void resetPanZoom() {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i2])).resetPanZoom();
        }
    }

    @Override
    public double getZoom() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof PanZoomCapable) {
            return ((PanZoomCapable)((Object)c2)).getZoom();
        }
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof PanZoomCapable)) continue;
            return ((PanZoomCapable)((Object)this.pport[i2])).getZoom();
        }
        return 1.0;
    }

    @Override
    public void setRotate(double rotate) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i2])).setRotate(rotate);
        }
    }

    @Override
    public double getRotate() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof PanZoomCapable) {
            return ((PanZoomCapable)((Object)c2)).getRotate();
        }
        return 0.0;
    }

    @Override
    public void setPanY(double pan_y) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i2])).setPanY(pan_y);
        }
    }

    @Override
    public double getPanY() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof PanZoomCapable) {
            return ((PanZoomCapable)((Object)c2)).getPanY();
        }
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof PanZoomCapable)) continue;
            return ((PanZoomCapable)((Object)this.pport[i2])).getPanY();
        }
        return 0.0;
    }

    @Override
    public void setPanX(double pan_x) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i2])).setPanX(pan_x);
        }
    }

    @Override
    public double getPanX() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof PanZoomCapable) {
            return ((PanZoomCapable)((Object)c2)).getPanX();
        }
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof PanZoomCapable)) continue;
            return ((PanZoomCapable)((Object)this.pport[i2])).getPanX();
        }
        return 0.0;
    }

    @Override
    public void setPan(double x2, double y2) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i2])).setPan(x2, y2);
        }
    }

    @Override
    public void flipHorizontal() {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i2])).flipHorizontal();
        }
    }

    @Override
    public void flipVertical() {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i2])).flipVertical();
        }
    }

    @Override
    public void setRowCol(int row, int col) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof RowColCapable)) continue;
            ((RowColCapable)((Object)this.pport[i2])).setRowCol(row, col);
        }
    }

    @Override
    public void setRows(int newRows) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof RowColCapable)) continue;
            ((RowColCapable)((Object)this.pport[i2])).setRows(newRows);
        }
    }

    @Override
    public int getRows() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof RowColCapable) {
            return ((RowColCapable)((Object)c2)).getRows();
        }
        return 1;
    }

    @Override
    public void setCols(int newCols) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof RowColCapable)) continue;
            ((RowColCapable)((Object)this.pport[i2])).setCols(newCols);
        }
    }

    @Override
    public int getCols() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof RowColCapable) {
            return ((RowColCapable)((Object)c2)).getCols();
        }
        return 1;
    }

    @Override
    public double[] getRange() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)c2)).getRange();
        }
        return new double[]{0.0, 100.0};
    }

    @Override
    public void resetWindowing() {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i2])).resetWindowing();
        }
    }

    @Override
    public void setWinUpperLimit(double um) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i2])).setWinUpperLimit(um);
        }
    }

    @Override
    public double getWinUpperLimit() {
        if (this.getSelectedPort() instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)this.getSelectedPort())).getWinUpperLimit();
        }
        return 0.0;
    }

    @Override
    public void setWinLowerLimit(double um) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i2])).setWinLowerLimit(um);
        }
    }

    @Override
    public double getWinLowerLimit() {
        if (this.getSelectedPort() instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)this.getSelectedPort())).getWinLowerLimit();
        }
        return 0.0;
    }

    @Override
    public void setWinMinMax(double parm1, double parm2) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i2])).setWinMinMax(parm1, parm2);
        }
    }

    @Override
    public double getWinMin() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)c2)).getWinMin();
        }
        return 0.0;
    }

    @Override
    public void setWinMin(double parm1) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i2])).setWinMin(parm1);
        }
    }

    @Override
    public double getWinMax() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)c2)).getWinMax();
        }
        return 100.0;
    }

    @Override
    public void setWinMax(double parm1) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i2])).setWinMax(parm1);
        }
    }

    @Override
    public void setVideoInverted(boolean parm1) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i2])).setVideoInverted(parm1);
        }
    }

    @Override
    public boolean isVideoInverted() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)c2)).isVideoInverted();
        }
        return false;
    }

    @Override
    public void setCine(boolean parm1) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof CineCapable)) continue;
            ((CineCapable)((Object)this.pport[i2])).setCine(parm1);
        }
    }

    @Override
    public boolean getCine() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof CineCapable) {
            return ((CineCapable)((Object)c2)).getCine();
        }
        return false;
    }

    @Override
    public int getCineMode() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof CineCapable) {
            return ((CineCapable)((Object)c2)).getCineMode();
        }
        return 0;
    }

    @Override
    public void setCineMode(int cineMode) {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof CineCapable) {
            ((CineCapable)((Object)c2)).setCineMode(cineMode);
        }
    }

    @Override
    public void setCineRate(int parm1) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof CineCapable)) continue;
            ((CineCapable)((Object)this.pport[i2])).setCineRate(parm1);
        }
    }

    @Override
    public int getCineRate() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof CineCapable) {
            return ((CineCapable)((Object)c2)).getCineRate();
        }
        return 1;
    }

    @Override
    public void setOffset(int parm1) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof CineCapable)) continue;
            ((CineCapable)((Object)this.pport[i2])).setOffset(parm1);
        }
    }

    @Override
    public int getOffset() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof CineCapable) {
            return ((CineCapable)((Object)c2)).getOffset();
        }
        return 0;
    }

    @Override
    public void setStartOffset(int parm1) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof CineCapable)) continue;
            ((CineCapable)((Object)this.pport[i2])).setStartOffset(parm1);
        }
    }

    @Override
    public int getStartOffset() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof CineCapable) {
            return ((CineCapable)((Object)c2)).getStartOffset();
        }
        return 0;
    }

    @Override
    public void setEndOffset(int parm1) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof CineCapable)) continue;
            ((CineCapable)((Object)this.pport[i2])).setEndOffset(parm1);
        }
    }

    @Override
    public int getEndOffset() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof CineCapable) {
            return ((CineCapable)((Object)c2)).getEndOffset();
        }
        return 0;
    }

    @Override
    public int getMaxFrame() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof CineCapable) {
            return ((CineCapable)((Object)c2)).getMaxFrame();
        }
        return 0;
    }

    @Override
    public int getNumberShown() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof CineCapable) {
            return ((CineCapable)((Object)c2)).getNumberShown();
        }
        return 0;
    }

    @Override
    public int getCineSkip() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof CineCapable) {
            return ((CineCapable)((Object)c2)).getCineSkip();
        }
        return 0;
    }

    @Override
    public void setCineSkip(int parm1) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof CineCapable)) continue;
            ((CineCapable)((Object)this.pport[i2])).setCineSkip(parm1);
        }
    }

    @Override
    public void setAnnotationGenerator(Class agClass, Properties props) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof AnnotCapable)) continue;
            ((AnnotCapable)((Object)this.pport[i2])).setAnnotationGenerator(agClass, props);
        }
    }

    @Override
    public boolean isAnnotationVisible() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof AnnotCapable) {
            return ((AnnotCapable)((Object)c2)).isAnnotationVisible();
        }
        return false;
    }

    @Override
    public void setAnnotationGroup(String group, boolean status) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof AnnotCapable)) continue;
            ((AnnotCapable)((Object)this.pport[i2])).setAnnotationGroup(group, status);
        }
    }

    @Override
    public void setAnnotationItems(String[] items, boolean status) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof AnnotCapable)) continue;
            ((AnnotCapable)((Object)this.pport[i2])).setAnnotationItems(items, status);
        }
    }

    @Override
    public void setAnnotationVisible(boolean bool) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof AnnotCapable)) continue;
            ((AnnotCapable)((Object)this.pport[i2])).setAnnotationVisible(bool);
        }
    }

    @Override
    public XpAnnotationGenerator getAnnotationGenerator() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof AnnotCapable) {
            AnnotCapable ac2 = (AnnotCapable)((Object)c2);
            return ac2.getAnnotationGenerator();
        }
        return null;
    }

    @Override
    public int getNumFrames() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof PanZoomCapable) {
            FramePositioningCapable ac2 = (FramePositioningCapable)((Object)c2);
            return ac2.getNumFrames();
        }
        return 0;
    }

    @Override
    public void setFrameIndex(int parm1) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof FramePositioningCapable)) continue;
            ((FramePositioningCapable)((Object)this.pport[i2])).setFrameIndex(parm1);
        }
    }

    @Override
    public int getFrameIndex() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof FramePositioningCapable) {
            FramePositioningCapable ac2 = (FramePositioningCapable)((Object)c2);
            return ac2.getFrameIndex();
        }
        return 0;
    }

    @Override
    public Color getAnnotationColor() {
        return Color.white;
    }

    @Override
    public void setAnnotationColor(Color col) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof AnnotCapable)) continue;
            ((AnnotCapable)((Object)this.pport[i2])).setAnnotationColor(col);
        }
    }

    @Override
    public void queryAnnotationItems(String[] items, boolean[] status) {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof AnnotCapable) {
            ((AnnotCapable)((Object)c2)).queryAnnotationItems(items, status);
        }
    }

    @Override
    public boolean queryAnnotationItem(String item) {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof AnnotCapable) {
            return ((AnnotCapable)((Object)c2)).queryAnnotationItem(item);
        }
        return false;
    }

    @Override
    public void add(RoiActor ra) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof ROICapable)) continue;
            ((ROICapable)((Object)this.pport[i2])).add(ra);
        }
    }

    @Override
    public List getRois() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof ROICapable) {
            return ((ROICapable)((Object)c2)).getRois();
        }
        return null;
    }

    @Override
    public boolean remove(RoiActor ra) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof ROICapable)) continue;
            ((ROICapable)((Object)this.pport[i2])).remove(ra);
        }
        return true;
    }

    @Override
    public RoiActor getRoi() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof ROICapable) {
            return ((ROICapable)((Object)c2)).getRoi();
        }
        return null;
    }

    @Override
    public void setComponentCreator(ComponentCreator rc) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof ROICapable)) continue;
            ((ROICapable)((Object)this.pport[i2])).setComponentCreator(rc);
        }
    }

    @Override
    public ComponentCreator getComponentCreator() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof ROICapable) {
            return ((ROICapable)((Object)c2)).getComponentCreator();
        }
        return null;
    }

    @Override
    public Printable getPrintable() {
        Printable pt = new Printable(){

            @Override
            public int print(Graphics graphics, PageFormat pf, int pageIndex) throws PrinterException {
                if (pageIndex > 0) {
                    return 1;
                }
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.translate(pf.getImageableX(), pf.getImageableY());
                Rectangle bound = XPscreen.this.getBounds();
                double sx = pf.getImageableWidth() / bound.getWidth();
                double sy = pf.getImageableHeight() / bound.getHeight();
                if (sx > sy) {
                    sx = sy;
                } else {
                    sy = sx;
                }
                g2d.scale(sx, sy);
                Graphics sg = graphics.create();
                Rectangle clipBound = sg.getClipBounds();
                for (int i2 = 0; i2 < XPscreen.this.getComponentCount(); ++i2) {
                    Component c2 = XPscreen.this.getComponent(i2);
                    if (!c2.isVisible()) continue;
                    Rectangle cr = c2.getBounds();
                    SwingUtilities.computeIntersection(clipBound.x, clipBound.y, clipBound.width, clipBound.height, cr);
                    Graphics cg = sg.create(cr.x, cr.y, cr.width, cr.height);
                    new ImagePrintComponent(c2).print(cg, pf, pageIndex);
                }
                return 0;
            }
        };
        return pt;
    }

    @Override
    public void addImageOp(XpImageOp imageOp) {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof ImageOpCapable)) continue;
            ((ImageOpCapable)((Object)this.pport[i2])).addImageOp(imageOp);
        }
    }

    @Override
    public List getImageOps() {
        JComponent c2 = this.getSelectedPort();
        if (c2 instanceof ImageOpCapable) {
            return ((ImageOpCapable)((Object)c2)).getImageOps();
        }
        return null;
    }

    @Override
    public void clearImageOps() {
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            if (!(this.pport[i2] instanceof ImageOpCapable)) continue;
            ((ImageOpCapable)((Object)this.pport[i2])).clearImageOps();
        }
    }

    class ImagePrintComponent {
        BufferedImage buff;
        Rectangle bounds;

        public ImagePrintComponent(BufferedImage img) {
            this.bounds = new Rectangle(img.getWidth(), img.getHeight());
            this.buff = img;
        }

        public ImagePrintComponent(Component c2) {
            this.bounds = c2.getBounds();
            this.buff = new BufferedImage(this.bounds.width, this.bounds.height, 1);
            Graphics g2 = this.buff.getGraphics();
            g2.clearRect(0, 0, this.bounds.width, this.bounds.height);
            c2.print(g2);
        }

        public int print(Graphics g2, PageFormat format, int pageIndex) {
            g2.clearRect(0, 0, this.bounds.width, this.bounds.height);
            g2.drawImage(this.buff, 0, 0, this.bounds.width, this.bounds.height, null);
            return 0;
        }
    }

    public static class EmptyPort
    extends JPanel {
        public EmptyPort() {
            this.setBackground(Color.black);
        }
    }
}

