/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.UIManager;

public class XPscreenLayout
implements Icon,
LayoutManager {
    private int noOfPorts;
    private Rectangle[] portDim;
    private String layout;
    public static final String _1X1LAYOUT = "[0,0,10000,10000]";
    public static final String _2X2LAYOUT = "[0,0,5000,5000][5000,0,5000,5000][0,5000,5000,5000][5000,5000,5000,5000]";
    public static final String _13LAYOUT = "[0,0,6666,9999][6667,0,3333,3333][6667,3334,3333,3333][6667,6667,3333,3333]";
    public static final String _31LAYOUT = "[3334,0,6666,9999][0,0,3333,3333][0,3334,3333,3333][0,6667,3333,3333]";
    public static final String _1X2LAYOUT = "[0,0,10000,5000][0,5000,10000,5000]";
    public static final String _1X3LAYOUT = "[0,0,10000,3333][0,3333,10000,3333][0,6666,10000,3333]";
    public static final String _2X1LAYOUT = "[0,0,5000,10000][5000,0,5000,10000]";
    public static final String _2X3LAYOUT = "[0,0,5000,3333][0,3333,5000,3333][0,6666,5000,3333][5000,0,5000,3333][5000,3333,5000,3333][5000,6666,5000,3333]";
    public static final String _3X1LAYOUT = "[0,0,3333,10000][3333,0,3333,10000][6666,0,3333,10000]";
    public static final String _3X2LAYOUT = "[0,0,3333,5000][3333,0,3333,5000][6666,0,3333,5000][0,5000,3333,5000][3333,5000,3333,5000][6666,5000,3333,5000]";
    public static final String _3X3LAYOUT = "[0,0,3333,3333][3333,0,3333,3333][6666,0,3333,3333][0,3333,3333,3333][3333,3333,3333,3333][6666,3333,3333,3333][0,6666,3333,3333][3333,6666,3333,3333][6666,6666,3333,3333]";
    public static final int SCALE = 10000;
    private int hgap_ = 0;
    private int vgap_ = 0;
    final int iconSize = 16;
    private String layoutString_;
    public static final String SPLIT_HORIZONTAL = "split_horizontal";
    public static final String SPLIT_VERTICAL = "split_vertical";
    public static final String MERGE_UP = "merge_up";
    public static final String MERGE_DOWN = "merge_down";
    public static final String MERGE_LEFT = "merge_left";
    public static final String MERGE_RIGHT = "merge_right";
    String layoutName_ = this.layoutString_;

    protected XPscreenLayout() {
        this(0, 0);
    }

    protected XPscreenLayout(int hgap, int vgap) {
        this(hgap, vgap, _1X1LAYOUT);
    }

    protected XPscreenLayout(int hgap, int vgap, String layoutString) {
        this.hgap_ = hgap;
        this.vgap_ = vgap;
        StringTokenizer st = new StringTokenizer(layoutString, ",][");
        this.portDim = new Rectangle[st.countTokens() / 4];
        int i2 = 0;
        while (st.hasMoreElements()) {
            int x2 = Integer.parseInt(st.nextToken());
            int y2 = Integer.parseInt(st.nextToken());
            int w2 = Integer.parseInt(st.nextToken());
            int h2 = Integer.parseInt(st.nextToken());
            this.portDim[i2] = new Rectangle(x2, y2, w2, h2);
            ++i2;
        }
        this.noOfPorts = i2;
        this.layoutString_ = layoutString;
        this.setLayoutName(layoutString);
    }

    public XPscreenLayout(String str) {
        this(0, 0, str);
    }

    public static final XPscreenLayout layout1x1() {
        return new XPscreenLayout(_1X1LAYOUT);
    }

    public static final XPscreenLayout layout2x2() {
        return new XPscreenLayout(_2X2LAYOUT);
    }

    public static final XPscreenLayout layout1x2() {
        return new XPscreenLayout(_1X2LAYOUT);
    }

    public static final XPscreenLayout layout1x3() {
        return new XPscreenLayout(_1X3LAYOUT);
    }

    public static final XPscreenLayout layout13() {
        return new XPscreenLayout(_13LAYOUT);
    }

    public static final XPscreenLayout layout31() {
        return new XPscreenLayout(_31LAYOUT);
    }

    public static final XPscreenLayout layout2x1() {
        return new XPscreenLayout(_2X1LAYOUT);
    }

    public static final XPscreenLayout layout2x3() {
        return new XPscreenLayout(_2X3LAYOUT);
    }

    public static final XPscreenLayout layout3x1() {
        return new XPscreenLayout(_3X1LAYOUT);
    }

    public static final XPscreenLayout layout3x2() {
        return new XPscreenLayout(_3X2LAYOUT);
    }

    public static final XPscreenLayout layout3x3() {
        return new XPscreenLayout(_3X3LAYOUT);
    }

    public int getNoOfPorts() {
        return this.noOfPorts;
    }

    public void paintIcon(int w2, int h2, Graphics g2, int offx, int offy) {
        g2.setColor(Color.black);
        g2.fillRect(offx, offy, w2, h2);
        g2.setColor(Color.white);
        for (int i2 = 0; i2 < this.portDim.length; ++i2) {
            g2.drawRect(offx + this.portDim[i2].x * w2 / 10000, offy + this.portDim[i2].y * h2 / 10000, this.portDim[i2].width * w2 / 10000, this.portDim[i2].height * h2 / 10000);
        }
    }

    public void paintIcon(int w2, int h2, Graphics g2, int offx, int offy, int num) {
        g2.setColor(Color.black);
        g2.fillRect(offx, offy, w2, h2);
        for (int i2 = 0; i2 < this.portDim.length; ++i2) {
            if (i2 == num) {
                g2.setColor(UIManager.getColor("P9"));
                g2.fillRect(offx + this.portDim[i2].x * w2 / 10000, offy + this.portDim[i2].y * h2 / 10000, this.portDim[i2].width * w2 / 10000, this.portDim[i2].height * h2 / 10000);
                continue;
            }
            g2.setColor(Color.white);
            g2.drawRect(offx + this.portDim[i2].x * w2 / 10000, offy + this.portDim[i2].y * h2 / 10000, this.portDim[i2].width * w2 / 10000, this.portDim[i2].height * h2 / 10000);
        }
    }

    @Override
    public int getIconWidth() {
        return 16;
    }

    @Override
    public int getIconHeight() {
        return 16;
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        this.paintIcon(16, 16, g2, x2, y2);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(1024, 1024);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension size = parent.getSize();
            Insets insets = parent.getInsets();
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            Component[] children = null;
            children = parent.getComponents();
            for (int i2 = 0; i2 < children.length; ++i2) {
                children[i2].setVisible(i2 < this.portDim.length);
                if (i2 >= this.portDim.length) continue;
                int qx = this.portDim[i2].x * size.width;
                int qy = this.portDim[i2].y * size.height;
                int qw = this.portDim[i2].width * size.width;
                int qh = this.portDim[i2].height * size.height;
                qw = (qw + qx) / 10000;
                qh = (qh + qy) / 10000;
                children[i2].setBounds(new Rectangle(qx += insets.left, qy += insets.top, qw -= (qx /= 10000), qh -= (qy /= 10000)));
            }
        }
    }

    public String toString() {
        return XPscreenLayout.getLayoutName(this.layoutString_);
    }

    public String getLayout() {
        return this.getLayoutString();
    }

    public static String getLayoutName(String layoutString) {
        if (_1X1LAYOUT.equals(layoutString)) {
            return "1x1";
        }
        if (_1X2LAYOUT.equals(layoutString)) {
            return "1x2";
        }
        if (_2X1LAYOUT.equals(layoutString)) {
            return "2x1";
        }
        if (_2X2LAYOUT.equals(layoutString)) {
            return "2x2";
        }
        if (_13LAYOUT.equals(layoutString)) {
            return "1-3";
        }
        if (_31LAYOUT.equals(layoutString)) {
            return "3-1";
        }
        return "Custom";
    }

    public String getLayoutString() {
        return this.layoutString_;
    }

    public XPscreenLayout derive(String type, int portNo) {
        Vector neighbors = this.deriveNeighbor(type, portNo);
        if (neighbors.size() == 0) {
            return null;
        }
        if (SPLIT_HORIZONTAL.equals(type) || SPLIT_VERTICAL.equals(type)) {
            StringBuffer buf = new StringBuffer();
            for (int i2 = 0; i2 < this.noOfPorts; ++i2) {
                if (portNo != i2) {
                    buf.append("[" + this.portDim[i2].x + "," + this.portDim[i2].y + "," + this.portDim[i2].width + "," + this.portDim[i2].height + "]");
                    continue;
                }
                if (SPLIT_HORIZONTAL.equals(type)) {
                    buf.append("[" + this.portDim[i2].x + "," + this.portDim[i2].y + "," + this.portDim[i2].width / 2 + "," + this.portDim[i2].height + "]" + "[" + (this.portDim[i2].x + this.portDim[i2].width / 2) + "," + this.portDim[i2].y + "," + (this.portDim[i2].width - this.portDim[i2].width / 2) + "," + this.portDim[i2].height + "]");
                    continue;
                }
                if (!SPLIT_VERTICAL.equals(type)) continue;
                buf.append("[" + this.portDim[i2].x + "," + this.portDim[i2].y + "," + this.portDim[i2].width + "," + this.portDim[i2].height / 2 + "]" + "[" + this.portDim[i2].x + "," + (this.portDim[i2].y + this.portDim[i2].height / 2) + "," + this.portDim[i2].width + "," + (this.portDim[i2].height - this.portDim[i2].height / 2) + "]");
            }
            return new XPscreenLayout(this.hgap_, this.vgap_, buf.toString());
        }
        StringBuffer buf = new StringBuffer();
        int first = (Integer)neighbors.get(0);
        for (int i3 = 0; i3 < this.noOfPorts; ++i3) {
            if (i3 == first) {
                if (SPLIT_HORIZONTAL.equals(type)) {
                    buf.append("[" + this.portDim[i3].x + "," + this.portDim[i3].y + "," + this.portDim[i3].width / 2 + "," + this.portDim[i3].height + "]" + "[" + (this.portDim[i3].x + this.portDim[i3].width / 2) + "," + this.portDim[i3].y + "," + (this.portDim[i3].width - this.portDim[i3].width / 2) + "," + this.portDim[i3].height + "]");
                    continue;
                }
                if (SPLIT_VERTICAL.equals(type)) {
                    buf.append("[" + this.portDim[i3].x + "," + this.portDim[i3].y + "," + this.portDim[i3].width + "," + this.portDim[i3].height / 2 + "]" + "[" + this.portDim[i3].x + "," + (this.portDim[i3].y + this.portDim[i3].height / 2) + "," + this.portDim[i3].width + "," + (this.portDim[i3].height - this.portDim[i3].height / 2) + "]");
                    continue;
                }
                if (MERGE_LEFT.equals(type)) {
                    buf.append("[" + this.portDim[i3].x + "," + this.portDim[i3].y + "," + (this.portDim[portNo].x - this.portDim[i3].x + this.portDim[portNo].width) + "," + this.portDim[portNo].height + "]");
                    continue;
                }
                if (MERGE_RIGHT.equals(type)) {
                    buf.append("[" + this.portDim[portNo].x + "," + this.portDim[portNo].y + "," + (this.portDim[i3].width + this.portDim[i3].x - this.portDim[portNo].x) + "," + this.portDim[portNo].height + "]");
                    continue;
                }
                if (MERGE_UP.equals(type)) {
                    buf.append("[" + this.portDim[i3].x + "," + this.portDim[i3].y + "," + this.portDim[portNo].width + "," + (this.portDim[i3].height + this.portDim[portNo].height) + "]");
                    continue;
                }
                if (!MERGE_DOWN.equals(type)) continue;
                buf.append("[" + this.portDim[portNo].x + "," + this.portDim[portNo].y + "," + this.portDim[portNo].width + "," + (this.portDim[i3].height + this.portDim[portNo].height) + "]");
                continue;
            }
            if (i3 == portNo || neighbors.contains(new Integer(i3))) continue;
            buf.append("[" + this.portDim[i3].x + "," + this.portDim[i3].y + "," + this.portDim[i3].width + "," + this.portDim[i3].height + "]");
        }
        return new XPscreenLayout(this.hgap_, this.vgap_, buf.toString());
    }

    public final Vector deriveNeighbor(String type, int portNo) {
        int h2;
        if (portNo < 0 || portNo >= this.noOfPorts) {
            throw new IllegalArgumentException("portNo must be between 0 and " + (this.noOfPorts - 1) + ": " + portNo);
        }
        Vector<Integer> v2 = new Vector<Integer>();
        if (SPLIT_HORIZONTAL.equals(type) || SPLIT_VERTICAL.equals(type)) {
            v2.add(new Integer(portNo));
            return v2;
        }
        System.out.println("XPscreenLayout.deriveNeighbor()" + this.portDim[portNo]);
        if (this.portDim[portNo].y == 0 && MERGE_UP.equals(type)) {
            System.err.println("nothing on top to merge");
            return v2;
        }
        if (this.portDim[portNo].x == 0 && MERGE_LEFT.equals(type)) {
            System.err.println("nothing at left to merge");
            return v2;
        }
        if (this.portDim[portNo].y + this.portDim[portNo].height >= 9999 && MERGE_DOWN.equals(type)) {
            System.err.println("nothing below to merge");
            return v2;
        }
        if (this.portDim[portNo].x + this.portDim[portNo].width >= 9999 && MERGE_RIGHT.equals(type)) {
            System.err.println("nothing at right to merge");
            return v2;
        }
        for (int i2 = 0; i2 < this.noOfPorts; ++i2) {
            if (portNo == i2) continue;
            if (MERGE_LEFT.equals(type)) {
                System.err.println("iiiii = " + i2 + ":" + this.portDim[i2]);
                System.err.println("portno = " + portNo + ":" + this.portDim[portNo]);
            }
            if (MERGE_LEFT.equals(type) && this.portDim[i2].y >= this.portDim[portNo].y && this.portDim[i2].y + this.portDim[i2].height <= this.portDim[portNo].y + this.portDim[portNo].height && this.portDim[i2].x + this.portDim[i2].width == this.portDim[portNo].x || this.portDim[i2].x + this.portDim[i2].width + 1 == this.portDim[portNo].x) {
                v2.add(new Integer(i2));
                continue;
            }
            if (MERGE_RIGHT.equals(type) && this.portDim[i2].y >= this.portDim[portNo].y && this.portDim[i2].y + this.portDim[i2].height <= this.portDim[portNo].y + this.portDim[portNo].height && (this.portDim[portNo].x + this.portDim[portNo].width == this.portDim[i2].x || this.portDim[portNo].x + this.portDim[portNo].width + 1 == this.portDim[i2].x)) {
                v2.add(new Integer(i2));
                continue;
            }
            if (MERGE_UP.equals(type) && this.portDim[i2].x >= this.portDim[portNo].x && this.portDim[i2].x + this.portDim[i2].width <= this.portDim[portNo].x + this.portDim[portNo].width && (this.portDim[i2].y + this.portDim[i2].height == this.portDim[portNo].y || this.portDim[i2].y + this.portDim[i2].height + 1 == this.portDim[portNo].y)) {
                v2.add(new Integer(i2));
                continue;
            }
            if (!MERGE_DOWN.equals(type) || this.portDim[i2].x < this.portDim[portNo].x || this.portDim[i2].x + this.portDim[i2].width > this.portDim[portNo].x + this.portDim[portNo].width || this.portDim[portNo].y + this.portDim[portNo].height != this.portDim[i2].y && this.portDim[portNo].y + this.portDim[portNo].height + 1 != this.portDim[i2].y) continue;
            v2.add(new Integer(i2));
        }
        if (v2.size() == 0) {
            System.err.println("nothing found for " + type);
            return v2;
        }
        if (MERGE_LEFT.equals(type) || MERGE_RIGHT.equals(type)) {
            h2 = this.portDim[((Integer)v2.get((int)0)).intValue()].height;
            int w2 = this.portDim[((Integer)v2.get((int)0)).intValue()].width;
            for (int i3 = 1; i3 < v2.size(); ++i3) {
                if (w2 != this.portDim[((Integer)v2.get((int)i3)).intValue()].width) {
                    v2.clear();
                    break;
                }
                h2 += this.portDim[((Integer)v2.get((int)i3)).intValue()].height;
            }
            if (v2.size() > 0 && h2 != this.portDim[portNo].height) {
                v2.clear();
            }
        } else if (MERGE_UP.equals(type) || MERGE_DOWN.equals(type)) {
            h2 = this.portDim[((Integer)v2.get((int)0)).intValue()].height;
            int w3 = this.portDim[((Integer)v2.get((int)0)).intValue()].width;
            for (int i4 = 1; i4 < v2.size(); ++i4) {
                if (h2 != this.portDim[((Integer)v2.get((int)i4)).intValue()].height) {
                    v2.clear();
                    break;
                }
                w3 += this.portDim[((Integer)v2.get((int)i4)).intValue()].width;
            }
            if (v2.size() > 0 && w3 != this.portDim[portNo].width) {
                v2.clear();
            }
        }
        return v2;
    }

    public final String getLayoutName() {
        return this.layoutName_;
    }

    public final void setLayoutName(String name) {
        this.layoutName_ = name;
    }
}

