/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.cuiPanels;

import com.ge.med.idc.PanZoomCapable;
import com.ge.med.ptk.PtkBorderFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.autoControls.XPwFlipHorizontal;
import com.ge.med.terra.xpv.autoControls.XPwFlipHorizontalVertical;
import com.ge.med.terra.xpv.autoControls.XPwFlipVertical;
import com.ge.med.terra.xpv.autoControls.XPwRotateControl;
import com.ge.med.terra.xpv.autoControls.XPwRotateLeft;
import com.ge.med.terra.xpv.autoControls.XPwRotateRight;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelResources;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelUtils;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import com.ge.med.terra.xpv.ui.SubTitlePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FlipRotatePanel
extends XPcaAutoControlPanel
implements ActionListener,
ChangeListener {
    static ResourceBundle res = CuiPanelResources.STRING_RESOURCES;
    XPwRotateControl rotXPV = new XPwRotateControl();
    SubTitlePanel titlePanel = new SubTitlePanel();
    XPwRotateLeft btRotateLeft = new XPwRotateLeft();
    XPwFlipVertical btFlipVert = new XPwFlipVertical();
    XPwFlipHorizontalVertical btFlipHozVert = new XPwFlipHorizontalVertical();
    XPwFlipHorizontal btFlipHoz = new XPwFlipHorizontal();
    XPwRotateRight btRotateRight = new XPwRotateRight();
    JLabel rotAngLabel = new JLabel();
    JTextField rotAngleF = new JTextField();
    JSeparator sep = new JSeparator();
    JSlider rotAngle = new JSlider(0, 0, 180, 30);
    JButton btRotLeftRandom = new JButton();
    JButton btRotRightRandom = new JButton();
    JButton btReset = new JButton();
    boolean valueChanged = false;
    private static final String ROTATE_L_RANDOM_CMD = "ROTATE_L_RANDOM_CMD";
    private static final String ROTATE_R_RANDOM_CMD = "ROTATE_R_RANDOM_CMD";
    private static final String RESET = "RESET";
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public FlipRotatePanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setBackground(null);
    }

    private void jbInit() throws Exception {
        this.setIcon(CuiPanelUtils.getIcon("FLIP_ROT_ICO"));
        this.setLayout(new BorderLayout());
        this.titlePanel.setTitle(res.getString("FlipRotatePanel.title"));
        super.setTitle(res.getString("FlipRotatePanel.title"));
        this.add((Component)this.titlePanel, "Center");
        this.btRotateLeft.setFocusable(false);
        this.btFlipVert.setFocusable(false);
        this.btFlipHozVert.setFocusable(false);
        this.btFlipHoz.setFocusable(false);
        this.btRotateRight.setFocusable(false);
        this.btReset.setFocusable(false);
        this.btRotLeftRandom.setFocusable(false);
        this.btRotRightRandom.setFocusable(false);
        this.btRotateLeft.setIcon(CuiPanelUtils.getIcon("ROT_LEFT_ICO"));
        this.btRotateLeft.setToolTipText(res.getString("FlipRotatePanel.rotLeft90toolTip"));
        this.btRotateLeft.setBorder(PtkBorderFactory.createButtonBorder(true, true, true, false));
        this.btRotateRight.setIcon(CuiPanelUtils.getIcon("ROT_RIGHT_ICO"));
        this.btRotateRight.setToolTipText(res.getString("FlipRotatePanel.rotRight90toolTip"));
        this.btRotateRight.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, false));
        this.btFlipVert.setIcon(CuiPanelUtils.getIcon("VERT_FLIP_ICO"));
        this.btFlipVert.setToolTipText(res.getString("FlipRotatePanel.FLIP_IMG_TB_TOOLTIP"));
        this.btFlipVert.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, false));
        this.btFlipHoz.setIcon(CuiPanelUtils.getIcon("HORZ_FLIP_ICO"));
        this.btFlipHoz.setToolTipText(res.getString("FlipRotatePanel.FLIP_IMG_LR_TOOLTIP"));
        this.btFlipHoz.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, false));
        this.btFlipHozVert.setIcon(CuiPanelUtils.getIcon("HORZ_VERT_FLIP_ICO"));
        this.btFlipHozVert.setToolTipText(res.getString("FlipRotatePanel.FLIP_IMG_TB_LR_TOOLTIP"));
        this.btFlipHozVert.setBorder(PtkBorderFactory.createButtonBorder(true, false, true, true));
        this.rotAngLabel.setText(res.getString("FlipRotatePanel.ANGLE_TEXT"));
        this.rotAngleF.setPreferredSize(new Dimension(50, 20));
        this.rotAngleF.setText(res.getString("FlipRotatePanel.SET_ANGLE_TEXT"));
        this.rotAngleF.setHorizontalAlignment(4);
        this.rotAngleF.addKeyListener(new RotAngKeyListener());
        this.rotAngleF.addFocusListener(new RotAngleFocusListener());
        this.rotAngle.setMajorTickSpacing(30);
        this.rotAngle.setMinorTickSpacing(5);
        this.rotAngle.setPaintTicks(true);
        this.rotAngle.setPaintLabels(true);
        this.rotAngle.addChangeListener(this);
        this.rotAngle.setInputMap(0, new InputMap());
        this.btRotLeftRandom.setPreferredSize(new Dimension(60, 50));
        this.btRotLeftRandom.setIcon(CuiPanelUtils.getIcon("ROT_LEFT_RANDOM_ICO"));
        this.btRotLeftRandom.setActionCommand(ROTATE_L_RANDOM_CMD);
        this.btRotLeftRandom.addActionListener(this);
        this.btRotLeftRandom.setToolTipText(res.getString("FlipRotatePanel.ROT_LEFT_TOOLTIP"));
        this.btRotRightRandom.setPreferredSize(new Dimension(60, 50));
        this.btRotRightRandom.setIcon(CuiPanelUtils.getIcon("ROT_RIGHT_RANDOM_ICO"));
        this.btRotRightRandom.setActionCommand(ROTATE_R_RANDOM_CMD);
        this.btRotRightRandom.addActionListener(this);
        this.btRotRightRandom.setToolTipText(res.getString("FlipRotatePanel.ROT_RIGHT_TOOLTIP"));
        this.btReset.setPreferredSize(new Dimension(60, 50));
        this.btReset.setIcon(CuiPanelUtils.getIcon("RESET_FLIP_ICO"));
        this.btReset.setActionCommand(RESET);
        this.btReset.addActionListener(this);
        this.btReset.setToolTipText(res.getString("FlipRotatePanel.RESET_TOOLTIP"));
        String val = System.getProperty("wf.dev_env", "false");
        boolean adv = "true".equalsIgnoreCase(val);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
        buttonPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        buttonPanel.add(this.btRotateLeft);
        buttonPanel.add(this.btRotateRight);
        buttonPanel.add(this.btFlipHoz);
        buttonPanel.add(this.btFlipVert);
        buttonPanel.add(this.btFlipHozVert);
        JPanel content = new JPanel(new BorderLayout(0, 20));
        content.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.titlePanel.add(content);
        content.add((Component)buttonPanel, "North");
        JPanel content1 = new JPanel(new BorderLayout());
        content1.add((Component)this.sep, "North");
        content.add(content1);
        JPanel anglePanel = new JPanel(new FlowLayout(0));
        anglePanel.add(this.rotAngLabel);
        anglePanel.add(this.rotAngleF);
        JPanel content2 = new JPanel(new BorderLayout());
        content2.setBorder(new EmptyBorder(10, 0, 0, 0));
        content1.add(content2);
        if (adv) {
            content2.add((Component)anglePanel, "North");
        }
        JPanel content3 = new JPanel(new BorderLayout(0, 30));
        content2.add(content3);
        if (adv) {
            content3.add((Component)this.rotAngle, "North");
        }
        JPanel randomButtonPanel = new JPanel();
        if (adv) {
            randomButtonPanel.add(this.btRotLeftRandom);
            randomButtonPanel.add(this.btRotRightRandom);
        }
        randomButtonPanel.add(this.btReset);
        content3.add(randomButtonPanel);
    }

    @Override
    public void actionPerformed(ActionEvent ae2) {
        String cmd = ae2.getActionCommand();
        TransactionLogName tln = new TransactionLogName("TID=SD_flipRotate");
        PanZoomCapable pzPort = (PanZoomCapable)this.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pzPort == null) {
            this.logger.log(Level.SEVERE, "{0} SEV5 Not PanZoomCapable", tln);
            return;
        }
        int angle = Integer.parseInt(this.rotAngleF.getText());
        if (cmd.equals(ROTATE_L_RANDOM_CMD)) {
            pzPort.setRotate(pzPort.getRotate() - (double)angle);
            this.logger.log(Level.FINEST, "{0} Rotate Left by " + angle, tln);
        } else if (cmd.equals(ROTATE_R_RANDOM_CMD)) {
            pzPort.setRotate(pzPort.getRotate() + (double)angle);
            this.logger.log(Level.FINEST, "{0} Rotate Right by " + angle, tln);
        } else if (cmd.equals(RESET)) {
            if (pzPort instanceof XpImageRenderAttributesOwner) {
                XpImageRenderAttributes ira = ((XpImageRenderAttributesOwner)((Object)pzPort)).getImageRenderAttributes();
                ira.getImageOrientation().reset();
                ((XpImageRenderAttributesOwner)((Object)pzPort)).setImageRenderAttributes(ira);
            }
            this.logger.log(Level.FINEST, "{0} Reset Image by 0 degress", tln);
        }
        pzPort.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (!this.valueChanged) {
            this.rotAngleF.setText("" + this.rotAngle.getValue());
        }
        this.valueChanged = false;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(new CuiLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e2) {
            e2.printStackTrace();
        }
        JFrame f2 = new JFrame();
        f2.setContentPane(new FlipRotatePanel());
        f2.setSize(256, 400);
        f2.setDefaultCloseOperation(3);
        f2.setVisible(true);
    }

    class RotAngleFocusListener
    implements FocusListener {
        RotAngleFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e2) {
        }

        @Override
        public void focusLost(FocusEvent e2) {
            if (!e2.isTemporary() && FlipRotatePanel.this.rotAngleF.getText().length() < 1) {
                int txtVal = FlipRotatePanel.this.rotAngle.getValue();
                FlipRotatePanel.this.rotAngleF.setText("" + txtVal);
            }
        }
    }

    class RotAngKeyListener
    implements KeyListener {
        RotAngKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e2) {
            char c2 = e2.getKeyChar();
            if (!Character.isDigit(c2) && c2 != '\b') {
                e2.consume();
            }
            JTextField txt = (JTextField)e2.getSource();
            String selTxt = txt.getSelectedText();
            String text = txt.getText();
            int caretPos = txt.getCaretPosition();
            String value = selTxt != null ? text.substring(0, txt.getSelectionStart()) + text.substring(txt.getSelectionEnd(), text.length()) : text;
            caretPos = text.length() - txt.getSelectionEnd();
            String txtVal = caretPos >= value.length() ? c2 + value.substring(0, value.length()) : value.substring(0, value.length() - caretPos) + c2 + value.substring(value.length() - caretPos, value.length());
            int val = 0;
            try {
                val = Integer.parseInt(txtVal);
            }
            catch (Exception ex) {
                val = 0;
            }
            if (val > 180 || val < 0) {
                e2.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent e2) {
        }

        @Override
        public void keyReleased(KeyEvent e2) {
            int val = 30;
            try {
                val = Integer.parseInt(FlipRotatePanel.this.rotAngleF.getText());
            }
            catch (Exception ex) {
                val = FlipRotatePanel.this.rotAngle.getValue();
            }
            int sliderVal = val;
            FlipRotatePanel.this.valueChanged = true;
            FlipRotatePanel.this.rotAngle.setValue(sliderVal);
        }
    }
}

