/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.jfc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class FilmPage {
    int row;
    int col;
    String[][] images;

    FilmPage(int row, int col) {
        this.row = row;
        this.col = col;
        this.initialize();
    }

    FilmPage() {
        this.row = 2;
        this.col = 2;
        this.initialize();
    }

    private void initialize() {
        this.images = new String[this.row][this.col];
        for (int i2 = 0; i2 < this.row; ++i2) {
            for (int j2 = 0; j2 < this.col; ++j2) {
                this.images[i2][j2] = null;
            }
        }
    }

    private Vector getImageVec() {
        Vector<String> vt = new Vector<String>();
        for (int i2 = 0; i2 < this.row; ++i2) {
            for (int j2 = 0; j2 < this.col; ++j2) {
                if (this.images[i2][j2] == null) {
                    vt.add("null");
                    continue;
                }
                vt.add(this.images[i2][j2]);
            }
        }
        return vt;
    }

    public String getImage(int row, int col) {
        return this.images[row][col];
    }

    public String[][] getImages() {
        return this.images;
    }

    public boolean addImage(String imageName, int row, int col) {
        if (this.images[row][col] == null) {
            this.images[row][col] = imageName;
            return true;
        }
        return false;
    }

    public boolean addImage(String imageName) {
        for (int i2 = 0; i2 < this.row; ++i2) {
            for (int j2 = 0; j2 < this.col; ++j2) {
                if (this.images[i2][j2] != null) continue;
                this.images[i2][j2] = imageName;
                return true;
            }
        }
        return false;
    }

    public void remove(int row, int col) {
        this.images[row][col] = null;
    }

    public boolean isEmpty() {
        for (int i2 = 0; i2 < this.images.length; ++i2) {
            for (int j2 = 0; j2 < this.images[i2].length; ++j2) {
                if (this.images[i2][j2] == null) continue;
                return false;
            }
        }
        return true;
    }

    public Vector setRowCol(int row, int col) {
        Vector vt = this.getImageVec();
        this.row = row;
        this.col = col;
        this.initialize();
        int count = 0;
        int vecSize = vt.size();
        for (int i2 = 0; i2 < row; ++i2) {
            for (int j2 = 0; j2 < col && count < vecSize; ++count, ++j2) {
                String name = (String)vt.get(count);
                if (name.equals("null")) continue;
                this.images[i2][j2] = name;
            }
            if (count >= vecSize) break;
        }
        if (count < vecSize) {
            Vector<String> left = new Vector<String>();
            for (int i3 = count; i3 < vecSize; ++i3) {
                if (((String)vt.get(i3)).equals("null")) continue;
                left.add((String)vt.get(i3));
            }
            if (left.size() > 0) {
                return left;
            }
        }
        return null;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public void clear() {
        this.row = 2;
        this.col = 2;
        this.initialize();
    }

    public boolean isFull() {
        for (int i2 = 0; i2 < this.row; ++i2) {
            for (int j2 = 0; j2 < this.col; ++j2) {
                if (this.images[i2][j2] != null) continue;
                return false;
            }
        }
        return true;
    }

    public void print() {
        for (int i2 = 0; i2 < this.row; ++i2) {
            for (int j2 = 0; j2 < this.col; ++j2) {
                if (this.images[i2][j2] == null) {
                    System.err.println("images[" + i2 + "][" + j2 + "]==null");
                    continue;
                }
                System.err.println("images[" + i2 + "][" + j2 + "]==" + this.images[i2][j2]);
            }
        }
    }

    public void writeThis(PrintStream pw) {
        pw.println(Integer.toString(this.row) + "|" + Integer.toString(this.col));
        for (int i2 = 0; i2 < this.row; ++i2) {
            for (int j2 = 0; j2 < this.col; ++j2) {
                if (this.images[i2][j2] == null) {
                    pw.println("null");
                    continue;
                }
                pw.println(this.images[i2][j2]);
            }
        }
    }

    public int getCapacity() {
        return this.row * this.col;
    }

    public void readThis(BufferedReader br) {
        try {
            String header = br.readLine();
            StringTokenizer st = new StringTokenizer(header, "|");
            this.row = Integer.parseInt(st.nextToken());
            this.col = Integer.parseInt(st.nextToken());
            this.initialize();
            for (int i2 = 0; i2 < this.row; ++i2) {
                for (int j2 = 0; j2 < this.col; ++j2) {
                    String line = br.readLine();
                    if (line.equals("null")) continue;
                    this.images[i2][j2] = line;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

