/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.onport;

import com.ge.med.terra.xpv.onport.XPopPanel;
import com.ge.med.terra.xpv.util.XPutil;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class XPopControlFactory {
    private Class[] controlClasses = new Class[0];
    private String[] controlLocations = new String[0];
    static XPopControlFactory factory = new XPopControlFactory();

    private XPopControlFactory() {
    }

    public static XPopControlFactory getFactory() {
        return factory;
    }

    public void setProperties(Properties prop) {
        String controlNames = prop.getProperty("PortControls");
        if (controlNames == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(controlNames, ", ");
        int numOfControls = st.countTokens();
        this.controlClasses = new Class[numOfControls];
        this.controlLocations = new String[numOfControls];
        for (int i2 = 0; i2 < numOfControls; ++i2) {
            try {
                String control = st.nextToken();
                StringTokenizer stCont = new StringTokenizer(control, "@");
                this.controlClasses[i2] = Class.forName(stCont.nextToken());
                String loc = stCont.nextToken();
                if (loc.equalsIgnoreCase("SOUTH")) {
                    this.controlLocations[i2] = "South";
                    continue;
                }
                if (loc.equalsIgnoreCase("NORTH")) {
                    this.controlLocations[i2] = "North";
                    continue;
                }
                if (loc.equalsIgnoreCase("WEST")) {
                    this.controlLocations[i2] = "West";
                    continue;
                }
                this.controlLocations[i2] = "East";
                continue;
            }
            catch (Exception ex) {
                XPutil.getLogger().log(Level.INFO, "fail to read port controls", ex);
            }
        }
    }

    public int getNumOfControls() {
        return this.controlClasses.length;
    }

    public String getControlLocation(int contNum) {
        if (contNum < 0 || contNum >= this.controlLocations.length) {
            throw new IllegalArgumentException("control " + contNum + " does not exist.");
        }
        return this.controlLocations[contNum];
    }

    public XPopPanel createControl(int contNum) {
        if (contNum < 0 || contNum >= this.controlLocations.length) {
            throw new IllegalArgumentException("control " + contNum + " does not exist.");
        }
        XPopPanel cont = null;
        try {
            cont = (XPopPanel)this.controlClasses[contNum].newInstance();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return cont;
    }

    public static void main(String[] args) {
        Properties prop = new Properties();
        XPopControlFactory contFactory = XPopControlFactory.getFactory();
        try {
            prop.load(contFactory.getClass().getResourceAsStream("xpv.properties"));
            String config = System.getProperties().getProperty("XPVCONFIG");
            if (config != null) {
                prop.load(new FileInputStream(config));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        contFactory.setProperties(prop);
    }
}

