/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.remote;

import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmService;
import com.ge.med.terra.tap.util.clientServer.XmServiceAdapter;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import com.ge.med.terra.xpv.remote.RemoteImage;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.swing.JFrame;

public class ClientViewport
extends XpImageViewport
implements XmService {
    private XmSession session_;
    static final byte LOAD_DATA_REQ = 1;
    static final byte WIN_MIN_MAX_REQ = 2;
    static final byte SIZE_CHANGE_REQ = 3;
    static final byte IMAGE_UPDATE_REP = 4;
    static final byte FRAME_INDEX_REQ = 5;
    BufferedImage clientImage_;
    final Iterator readers = ImageIO.getImageReadersByFormatName("jpeg");
    final ImageReader jpegReader = (ImageReader)this.readers.next();
    short id_;
    ByteArrayOutputStream bos;
    boolean isServer;
    XpImageViewport serverPort;
    JFrame f;
    BufferedImage buf;

    public ClientViewport() {
        this.moreInit();
    }

    protected void processData(byte[] data, int off) {
        byte messageID = data[off];
        switch (messageID) {
            case 1: {
                String path = new String(data, off + 1, data.length - off - 1);
                System.out.println("ClientViewport.readMessage()" + path);
                DMSession s2 = new DMSession(new String[]{"file", path});
                DMObject[] dmo = s2.getRelated("series");
                this.serverPort.setImages(dmo[0].getImages(null));
                break;
            }
            case 2: {
                double min = Utils.getDouble(data, ++off);
                double max = Utils.getDouble(data, off += 8);
                this.serverPort.setWinMinMax(min, max);
                break;
            }
            case 3: {
                int w2 = Utils.getInt(data, ++off);
                int h2 = Utils.getInt(data, off += 4);
                if (this.f == null) break;
                System.err.println("set port size to " + w2 + "x" + h2);
                this.serverPort.setPreferredSize(new Dimension(w2, h2));
                this.f.pack();
                break;
            }
            case 4: {
                ByteArrayInputStream is = new ByteArrayInputStream(data, ++off, data.length - off);
                try {
                    this.jpegReader.setInput(ImageIO.createImageInputStream(is), true);
                    ImageReadParam param = this.jpegReader.getDefaultReadParam();
                    param.setDestination(null);
                    this.clientImage_ = this.jpegReader.read(0, param);
                    XpImage frame = this.getFrame();
                    if (frame == null) break;
                    System.err.println("updating image");
                    System.err.println("image = " + this.clientImage_);
                    ((RemoteImage)frame).setPixelData(this.clientImage_);
                    this.refreshContents();
                    break;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    private void moreInit() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                if (!ClientViewport.this.isServer) {
                    final Dimension sz = ClientViewport.this.getSize();
                    if (sz.equals(new Dimension(0, 0))) {
                        return;
                    }
                    if (ClientViewport.this.session_ != null) {
                        ClientViewport.this.session_.writeMessage(new XmServiceAdapter(){

                            @Override
                            public short getID() {
                                return ClientViewport.this.id_;
                            }

                            @Override
                            public int writeMessage(OutputStream os, short mid) throws IOException {
                                System.err.println("changing size to " + sz);
                                byte[] intb = new byte[4];
                                Utils.putInt(intb, 0, 9);
                                os.write(intb);
                                os.write(3);
                                Utils.putInt(intb, 0, sz.width);
                                os.write(intb);
                                Utils.putInt(intb, 0, sz.height);
                                os.write(intb);
                                return 13;
                            }
                        });
                    }
                }
            }
        });
    }

    public ClientViewport(String rendererType) {
        super(rendererType);
        this.moreInit();
    }

    @Override
    public void setWinMinMax(final double min, final double max) {
        System.err.println("ClientViewport.setWinMinMax()");
        super.setWinMinMax(min, max);
        this.session_.writeMessage(new XmServiceAdapter(){

            @Override
            public short getID() {
                return ClientViewport.this.id_;
            }

            @Override
            public int writeMessage(OutputStream os, short mid) throws IOException {
                byte[] head = new byte[4];
                Utils.putInt(head, 0, 17);
                os.write(head);
                os.write(2);
                byte[] dbl = new byte[8];
                Utils.putDouble(dbl, 0, min);
                os.write(dbl);
                Utils.putDouble(dbl, 0, max);
                os.write(dbl);
                System.out.println(".writeMessage()client done");
                return head.length + 1 + 8 + 8;
            }
        });
    }

    public void setDataSet(XmSession session, final DMObject selection) {
        this.session_ = session;
        session.installHandle(this);
        session.writeMessage(new XmServiceAdapter(){

            @Override
            public short getID() {
                return ClientViewport.this.id_;
            }

            @Override
            public int writeMessage(OutputStream os, short mid) throws IOException {
                String s2 = selection.getID();
                byte[] b2 = s2.getBytes();
                byte[] head = new byte[4];
                Utils.putInt(head, 0, b2.length + 1);
                os.write(head);
                os.write(1);
                os.write(b2);
                System.out.println(".writeMessage()client done");
                return head.length + b2.length;
            }
        });
    }

    @Override
    public void connectionLost() {
    }

    @Override
    public short getID() {
        return this.id_;
    }

    @Override
    public int readMessage(InputStream is) throws IOException {
        byte[] lenBuf = new byte[4];
        int len = Utils.readInt(is, lenBuf);
        byte[] buf = new byte[len];
        Utils.readFully(is, buf);
        this.processData(buf, 0);
        return 4 + len;
    }

    @Override
    public void setID(short id) {
        this.id_ = id;
    }

    @Override
    public void setParent(final XmSession parent) {
        boolean bl = this.isServer = !parent.isClient();
        if (this.isServer && this.serverPort == null) {
            this.serverPort = new XpImageViewport(){

                @Override
                public void paintComponent(Graphics g2) {
                    if (ClientViewport.this.buf == null || ClientViewport.this.buf.getWidth() != this.getWidth() || ClientViewport.this.buf.getHeight() != this.getHeight()) {
                        ClientViewport.this.buf = new BufferedImage(this.getWidth(), this.getHeight(), 10);
                    }
                    Graphics2D g22 = ClientViewport.this.buf.createGraphics();
                    this.getMedicalImageVc().getImageVc().paint(g22);
                    g22.dispose();
                    g2.drawImage(ClientViewport.this.buf, 0, 0, null);
                    if (ClientViewport.this.bos == null) {
                        ClientViewport.this.bos = new ByteArrayOutputStream(0x400000);
                    }
                    ClientViewport.this.bos.reset();
                    try {
                        System.err.println("buf=" + ClientViewport.this.buf);
                        ImageIO.write((RenderedImage)ClientViewport.this.buf, "jpeg", ClientViewport.this.bos);
                        ImageIO.write((RenderedImage)ClientViewport.this.buf, "jpeg", new File("/abc.jpg"));
                        final byte[] buf0 = ClientViewport.this.bos.toByteArray();
                        parent.writeMessage(new XmServiceAdapter(){

                            @Override
                            public short getID() {
                                return ClientViewport.this.id_;
                            }

                            @Override
                            public int writeMessage(OutputStream os, short mid) throws IOException {
                                byte[] head = new byte[4];
                                Utils.putInt(head, 0, 1 + buf0.length);
                                os.write(head);
                                os.write(4);
                                os.write(buf0);
                                System.err.println("writing image " + ClientViewport.this.buf);
                                System.err.println("compression len " + buf0.length);
                                return 5 + buf0.length;
                            }
                        });
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            };
            this.serverPort.setAnnotationVisible(false);
            this.f = new JFrame();
            this.f.setContentPane(this.serverPort);
            this.serverPort.setPreferredSize(new Dimension(512, 512));
            this.f.pack();
            this.f.setVisible(true);
        }
    }

    @Override
    public int writeMessage(OutputStream os, short mid) throws IOException {
        return 0;
    }

    @Override
    public XmServiceStatus getStatus() {
        return null;
    }
}

