/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.template;

import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMultiImageViewport;
import com.ge.med.terra.jami.annotation.XpAnnotationManager;
import com.ge.med.terra.jami.annotation.XpApdAnnotationGenerator;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.base.ScreenHeader;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPdisplayArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import com.ge.med.terra.xpv.template.Template;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.RenderingHints;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JComponent;

public class BasicTemplate
implements Template {
    Properties prop;
    DMQuery query = null;
    int uGroup;
    int uElem;
    boolean[] dataUsed = null;
    DMTag[] tagList;

    @Override
    public void setConfigProp(Properties prop) {
        String unique;
        this.prop = prop;
        String filter = prop.getProperty("filter");
        if (filter != null) {
            this.query = new DMQuery(filter);
        }
        if ((unique = prop.getProperty("uniqueTag")) != null) {
            StringTokenizer st = new StringTokenizer(unique, "() ,");
            this.uGroup = Integer.decode(st.nextToken());
            this.uElem = Integer.decode(st.nextToken());
        }
    }

    @Override
    public String getSeriesName() {
        return null;
    }

    @Override
    public String getName() {
        return this.prop.getProperty("name", "BasicTemplate");
    }

    @Override
    public String[] getScans(DMObject[] dmo) {
        HashSet<Object> hs = new HashSet<Object>();
        for (int i2 = 0; i2 < dmo.length; ++i2) {
            DMObject[] ser = dmo[i2].getRelated("series", this.query);
            for (int j2 = 0; j2 < ser.length; ++j2) {
                Object o2 = ser[j2].getValue(this.uGroup, this.uElem);
                if (o2 == null) continue;
                hs.add(o2);
            }
        }
        return hs.toArray(new String[0]);
    }

    @Override
    public void run(DMObject[] series, XPscreen screen, XPcontrolArea ctlArea, String name) {
        this.fillPort(series, screen, name);
    }

    DMObject[] filterData(DMObject[] data, String level, DMQuery q2) {
        DMObject[][] dmo = new DMObject[data.length][];
        int count = 0;
        for (int i2 = 0; i2 < data.length; ++i2) {
            dmo[i2] = data[i2].getRelated(level, q2);
            count += dmo[i2].length;
        }
        DMObject[] ret = new DMObject[count];
        count = 0;
        for (int i3 = 0; i3 < data.length; ++i3) {
            System.arraycopy(dmo[i3], 0, ret, count, dmo[i3].length);
            count += dmo[i3].length;
        }
        return ret;
    }

    private DMImage[] filterFrames(DMImage[] iset, int en, int det) {
        DMImage[] dmi = new DMImage[iset.length];
        int count = 0;
        for (int i2 = 0; i2 < iset.length; ++i2) {
            Object energy = iset[i2].getValue(84, 16);
            Object detect = iset[i2].getValue(84, 32);
            if (en >= 0 && BasicTemplate.getIndexValue(energy, i2) != en || det >= 0 && BasicTemplate.getIndexValue(detect, i2) != det) continue;
            dmi[count] = iset[i2];
            ++count;
        }
        DMImage[] ret = new DMImage[count];
        System.arraycopy(dmi, 0, ret, 0, count);
        return ret;
    }

    public static int getIndexValue(Object vector, int index) {
        if (vector instanceof Integer[]) {
            Integer[] shorts = (Integer[])vector;
            return shorts[index];
        }
        if (vector instanceof short[]) {
            short[] shorts = (short[])vector;
            return shorts[index];
        }
        if (vector instanceof Short) {
            return ((Short)vector).intValue();
        }
        if (vector instanceof Integer) {
            return (Integer)vector;
        }
        if (vector instanceof int[]) {
            int[] shorts = (int[])vector;
            return shorts[index];
        }
        if (vector instanceof Short[]) {
            Short[] shorts = (Short[])vector;
            return shorts[index].intValue();
        }
        if (vector instanceof String) {
            return Integer.parseInt((String)vector);
        }
        return -1;
    }

    private int getTailInt(String name, String sval) {
        try {
            if (sval == null) {
                return -1;
            }
            int pos = sval.indexOf(name);
            if (pos == -1) {
                return -1;
            }
            String sub = sval.substring(pos += name.length(), pos + 1);
            int val = Integer.parseInt(sub);
            return val;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected void fillPort(DMObject[] data, XPscreen screen, String name) {
        String filter;
        String layout = this.prop.getProperty("layout");
        int nop = 1;
        DMObject[] sdata = this.filterData(data, "series", new DMQuery("(" + this.uGroup + "," + this.uElem + ") = " + name));
        if (layout != null) {
            XPscreenLayout lay = new XPscreenLayout(layout);
            nop = lay.getNoOfPorts();
            screen.setLayout(lay);
        }
        String tagStr = this.prop.getProperty("TAGS_TO_LOAD");
        DMTag[] tagsNM = XPutil.parseTags(tagStr);
        DMTag[] tags = this.getNeededTags();
        if (tagsNM != null) {
            int i2;
            int len = tagsNM.length + tags.length;
            DMTag[] compTag = new DMTag[len];
            for (i2 = 0; i2 < tagsNM.length; ++i2) {
                compTag[i2] = tagsNM[i2];
            }
            for (i2 = 0; i2 < tags.length; ++i2) {
                compTag[tagsNM.length + i2] = tags[i2];
            }
            tags = compTag;
        }
        DMQuery genFilter = (filter = this.prop.getProperty("filter")) == null ? null : new DMQuery(filter);
        for (int p2 = 0; p2 < nop; ++p2) {
            JComponent c2 = screen.getPort(p2);
            String sFilter = this.prop.getProperty("port" + (p2 + 1) + ".seriesFilter");
            String iFilter = this.prop.getProperty("port" + (p2 + 1) + ".imageFilter");
            String fFilter = this.prop.getProperty("port" + (p2 + 1) + ".frameFilter");
            int en = this.getTailInt("energy", fFilter);
            int det = this.getTailInt("detector", fFilter);
            DMQuery sQuery = sFilter == null ? null : new DMQuery(sFilter);
            DMQuery iQuery = iFilter == null ? null : new DMQuery(iFilter);
            for (int i3 = 0; i3 < sdata.length; ++i3) {
                if (sQuery != null && !sQuery.valid(sdata[i3])) continue;
                DMObject[] idata = sdata[i3].getRelated("image");
                DMImage[] iset = new DMImage[]{};
                for (int j2 = 0; j2 < idata.length; ++j2) {
                    DMImage[] fdata;
                    if (iQuery != null && !iQuery.valid(idata[j2])) continue;
                    DMImage[] img = fdata = this.filterFrames(idata[j2].getImages(tags), en, det);
                    DMImage[] tmp = new DMImage[iset.length + img.length];
                    System.arraycopy(iset, 0, tmp, 0, iset.length);
                    System.arraycopy(img, 0, tmp, iset.length, img.length);
                    iset = tmp;
                }
                String header = this.prop.getProperty("port" + (p2 + 1) + ".header");
                if (header != null) {
                    try {
                        Class<?> hdrClass = Class.forName(header);
                        ScreenHeader hdr = (ScreenHeader)hdrClass.newInstance();
                        screen.addPort(hdr, p2);
                        hdr.setProperties(this.prop);
                        if (idata == null) continue;
                        hdr.setData(idata);
                    }
                    catch (Exception ex) {}
                    continue;
                }
                if (iset.length != 0) {
                    XpMultiImageViewport port = new XpMultiImageViewport();
                    XpMedicalImage[] mi = new XpMedicalImage[iset.length];
                    port.setPrimaryBorder(null);
                    for (int ii = 0; ii < iset.length; ++ii) {
                        XpMedicalDmImage dmi = new XpMedicalDmImage(iset[ii]);
                        mi[ii] = dmi;
                    }
                    port.setImages(mi);
                    port.setAnnotationGenerator(XpApdAnnotationGenerator.class, this.prop);
                    port.setCineQuality(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    port.setRowCol(iset.length > 1 ? 2 : 1, iset.length > 2 ? 2 : 1);
                    String dimString = this.prop.getProperty("port" + (p2 + 1) + ".frameorg");
                    if (dimString != null) {
                        String str = dimString.substring(0, 1);
                        int col = Integer.parseInt(str);
                        str = dimString.substring(2, 3);
                        int row = Integer.parseInt(str);
                        port.setRowCol(row, col);
                    }
                    screen.addPort(port, p2);
                    continue;
                }
                screen.addPort(new XPscreen.EmptyPort(), p2);
            }
        }
        if (screen.getParent() instanceof XPdisplayArea) {
            XPdisplayArea xps = (XPdisplayArea)screen.getParent();
            xps.setProperties(this.prop);
            xps.setDataSet(data[0]);
        } else {
            System.err.println("no xpscreen!");
        }
    }

    protected void loadTags() {
        String tagStr = (String)this.prop.get("TAGS_TO_LOAD");
        this.tagList = BasicTemplate.getNeededTags();
    }

    public static DMTag[] getNeededTags() {
        String[] tags;
        DMTag[] dmTags = null;
        if (dmTags == null && (tags = XpAnnotationManager.getNeededTags("CT", "")) != null) {
            int len = tags.length;
            dmTags = new DMTag[len];
            for (int i2 = 0; i2 < len; ++i2) {
                StringTokenizer st = new StringTokenizer(tags[i2], ",");
                String groupStr = st.nextToken();
                String elemStr = st.nextToken();
                int group = Integer.parseInt(groupStr);
                int element = Integer.parseInt(elemStr);
                dmTags[i2] = new DMTag(group, element);
            }
        }
        return dmTags;
    }

    protected void loadLayout(XPscreen screen) {
        String layout = this.prop.getProperty("layout");
        if (layout == null) {
            return;
        }
        screen.setLayout(new XPscreenLayout(layout));
    }
}

