/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.template;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.xpv.template.BasicTemplate;
import com.ge.med.terra.xpv.template.Template;
import com.ge.med.terra.xpv.template.TemplateFactory;
import com.ge.med.terra.xpv.util.XPutil;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.swing.Icon;

public class BasicTemplateFactory
implements TemplateFactory {
    Template[] xpTemplate;
    String[] templateNames;
    HashMap map;
    String[] names;

    @Override
    public void setProperties(Properties prop) {
        String templateDir = prop.getProperty("TemplateDir");
        File fd = new File(templateDir);
        if (!fd.exists()) {
            return;
        }
        File[] files = fd.listFiles();
        this.templateNames = new String[files.length];
        this.xpTemplate = new Template[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            try {
                Properties tmpProp = new Properties(prop);
                tmpProp.load(new FileInputStream(files[i2]));
                this.xpTemplate[i2] = (Template)XPutil.getClassFor(tmpProp, "Template", Template.class);
                if (this.xpTemplate[i2] == null) {
                    this.xpTemplate[i2] = new BasicTemplate();
                }
                this.xpTemplate[i2].setConfigProp(tmpProp);
                continue;
            }
            catch (Exception ex) {
                System.err.println("Could not load file" + files[i2].getAbsolutePath());
                ex.printStackTrace();
            }
        }
    }

    @Override
    public String[] getNames(DMObject[] dmo) {
        this.map = new HashMap();
        boolean off = false;
        for (int i2 = 0; i2 < this.xpTemplate.length; ++i2) {
            String[] tmp = this.xpTemplate[i2].getScans(dmo);
            for (int k2 = 0; k2 < tmp.length; ++k2) {
                this.map.put(tmp[k2], this.xpTemplate[i2]);
            }
        }
        Set s2 = this.map.keySet();
        this.names = s2.toArray(new String[1]);
        return this.names;
    }

    @Override
    public Icon getTemplateIcons() {
        return null;
    }

    @Override
    public Template getTemplate(int n2) {
        return this.xpTemplate[n2];
    }
}

