/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import com.ge.med.ptk.PtkBorderFactory;
import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.shape.EdgeProfileBeveled;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.terra.xpv.ui.CuiInternalBorder;
import com.ge.med.terra.xpv.ui.XPui;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DualSlider
extends JComponent {
    private int wMin = 0;
    private int wMax = 255;
    private int wMaxRange = 384;
    private int wMinRange = -128;
    BorderLayout borderLayout1 = new BorderLayout();
    JButton buttonTopDown = new JButton();
    JButton buttonBottomUP = new JButton();
    boolean pressed = false;
    Rectangle scrollregion;
    Rectangle scrollBar;
    int barMode = 0;
    int barDown = 0;
    int oldMax = 0;
    int oldMin = 0;
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JTextField maxLabel = new JTextField();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JTextField minLabel = new JTextField();
    Border borderINT = new CuiInternalBorder();
    JPanel bar = new JPanel(){

        @Override
        public boolean contains(int x2, int y2) {
            return false;
        }

        @Override
        public void paintComponent(Graphics g2) {
            DualSlider.this.paintBar(g2);
        }
    };
    Color interiorColor = !this.isEnabled() ? UIManager.getColor("P4") : (!this.pressed ? this.getForeground() : this.getBackground());
    Color exteriorColor = new Color(0, true);
    JPanel jPanel1 = new JPanel(){

        @Override
        public void paintComponent(Graphics g2) {
            int w2 = DualSlider.this.jPanel1.getWidth();
            int h2 = DualSlider.this.jPanel1.getHeight();
            for (int i2 = 0; i2 < h2; ++i2) {
                int c2 = 1000 * (h2 - i2 - 1) / h2;
                g2.setColor(new Color(DualSlider.this.cmap[DualSlider.this.cmap.length * c2 / 1000]));
                g2.fillRect(0, i2, w2, 1);
            }
        }
    };
    boolean moveBoth = true;
    int[] cmap = new int[256];
    private transient Vector changeListeners;
    private transient Vector changeListenersTemp;
    JPanel jPanel4 = new JPanel();
    JButton buttonTopUp = new JButton();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel5 = new JPanel();
    JButton buttonBottomDown = new JButton();
    GridLayout gridLayout2 = new GridLayout();
    private int hardRangeMax = 12000;
    private int hardRangeMin = -12000;
    boolean enable;

    public void reCalc() {
        this.calcLayout();
        this.minLabel.setText(Integer.toString(this.wMin));
        this.maxLabel.setText(Integer.toString(this.wMax));
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintChildren(g2);
        this.paintBar(g2);
    }

    public DualSlider() {
        for (int i2 = 0; i2 < this.cmap.length; ++i2) {
            this.cmap[i2] = i2 * 65793;
        }
        this.enable = true;
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        Color col = UIManager.getColor("P2");
        if (col != null) {
            this.maxLabel.setBackground(col);
            this.minLabel.setBackground(col);
        }
        this.setBorder(PtkBorderFactory.createLoweredBorder());
        this.bar.setBorder(PtkBorderFactory.createRaisedBorder());
        this.bar.setOpaque(false);
        this.buttonBottomUP.setIcon(new ArrowIcon(16, 16, 1));
        this.buttonTopDown.setIcon(new ArrowIcon(16, 16, 0));
        this.buttonBottomDown.setIcon(new ArrowIcon(16, 16, 0));
        this.buttonTopUp.setIcon(new ArrowIcon(16, 16, 1));
        this.maxLabel.setBackground(XPui.p8());
        this.maxLabel.setBackground(XPui.p8());
    }

    public void setProperties(Properties properties) {
        String winControl = properties.getProperty("windowLevelMoveBoth");
        if (winControl != null) {
            this.moveBoth = winControl.equalsIgnoreCase("true");
        }
        String winUpperLimit = properties.getProperty("WinUpperLimit");
        String winLowerLimit = properties.getProperty("WinLowerLimit");
        try {
            Double winUpper = Double.valueOf(winUpperLimit);
            this.hardRangeMax = (int)winUpper.doubleValue();
            Double winLower = Double.valueOf(winLowerLimit);
            this.hardRangeMin = (int)winLower.doubleValue();
        }
        catch (Exception ex1) {
            this.hardRangeMax = Short.MAX_VALUE;
            this.hardRangeMin = Short.MIN_VALUE;
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(new CuiLookAndFeel());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DualSlider.testFrame(args);
    }

    public static JFrame testFrame(String[] args) {
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout(30, 30));
        DualSlider d2 = new DualSlider();
        d2.setPreferredSize(new Dimension(100, 400));
        p2.add((Component)d2, "Center");
        p2.add((Component)new JPanel(), "South");
        p2.add((Component)new JPanel(), "North");
        p2.add((Component)new JPanel(), "East");
        p2.add((Component)new JPanel(), "West");
        JFrame f2 = new JFrame("test");
        f2.setContentPane(p2);
        f2.setBounds(100, 100, 200, 500);
        f2.setDefaultCloseOperation(3);
        f2.setVisible(true);
        return f2;
    }

    public void paintBar(Graphics g2) {
        this.calcLayout();
        super.paintComponent(g2);
        int h2 = this.scrollBar.width;
        if (h2 > this.scrollBar.height / 2) {
            h2 = this.scrollBar.height / 2;
        }
        this.paintVerticalTexture(g2, 1, 1, this.scrollBar.width, h2);
        this.paintVerticalTexture(g2, 1, 1 + this.scrollBar.height - h2, this.scrollBar.width, h2);
    }

    public void clacBarSize() {
        Insets ins = this.getBorder().getBorderInsets(this);
        int x2 = ins.left;
        int w2 = this.jPanel1.getWidth() - ins.right - 1;
        int y2 = ins.top + this.buttonTopUp.getHeight();
        int h2 = this.jPanel1.getHeight() - (y2 + ins.bottom + this.buttonBottomUP.getHeight()) - 2;
        this.scrollregion = new Rectangle(x2, y2, w2, h2);
        int sby = y2 + (this.wMaxRange - this.wMax) * h2 / (this.wMaxRange - this.wMinRange);
        int sbh = (this.wMax - this.wMin) * h2 / (this.wMaxRange - this.wMinRange);
        int sbx = x2;
        int sbw = w2;
        this.scrollBar = new Rectangle(sbx, sby, sbw, sbh);
    }

    public void calcLayout() {
        if (this.wMaxRange < this.wMax) {
            this.wMaxRange = this.wMax;
        }
        if (this.wMinRange > this.wMin) {
            this.wMinRange = this.wMin;
        }
        if (this.wMaxRange - this.wMinRange == 0) {
            ++this.wMaxRange;
            --this.wMinRange;
        }
        this.clacBarSize();
        if (this.scrollBar.height <= 4 && this.scrollregion.height > 20) {
            this.wMaxRange = this.wMax + (this.wMax - this.wMin) / 3 + 2;
            this.wMinRange = this.wMin - (this.wMax - this.wMin) / 3 - 2;
            this.clacBarSize();
        }
        this.bar.setBounds(this.scrollBar);
    }

    public void updateColors() {
        this.interiorColor = !this.isEnabled() ? UIManager.getColor("P4") : (!this.pressed ? this.getForeground() : this.getBackground());
    }

    private void paintVerticalTexture(Graphics g2, int x2, int y2, int width, int height) {
        int stepSize = 5;
        int cw = 2;
        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(width - 2, stepSize), new Rectangle2D.Double(0.5, 0.5, width - 2, stepSize - 1), new EdgeProfileBeveled(1, 0, -0.01), this.interiorColor, this.interiorColor, null);
        for (int i2 = 0; i2 < height / stepSize; ++i2) {
            g2.drawImage(renderedShape, x2 + 1, y2 + 1 + stepSize * i2, width - 2, stepSize, null);
        }
    }

    private void paintBars(Graphics g2) {
        this.paintVerticalTexture(g2, 10, 10, 20, 20);
    }

    private void jbInit() throws Exception {
        this.buttonTopUp.setBorder(this.borderINT);
        this.buttonTopUp.setMargin(new Insets(0, 0, 0, 0));
        this.buttonTopUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DualSlider.this.buttonTop_actionPerformed(e2);
            }
        });
        this.setLayout(this.borderLayout1);
        this.buttonBottomUP.setBorder(this.borderINT);
        this.buttonBottomUP.setMargin(new Insets(0, 0, 0, 0));
        this.buttonBottomUP.setText("");
        this.buttonBottomUP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DualSlider.this.buttonBottom_actionPerformed(e2);
            }
        });
        this.setMinimumSize(new Dimension(40, 10));
        this.setPreferredSize(new Dimension(20, 100));
        this.jPanel1.setLayout(null);
        this.bar.setBounds(new Rectangle(6, 33, 382, 184));
        this.jPanel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                DualSlider.this.bar_mouseReleased(e2);
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                DualSlider.this.bar_mousePressed(e2);
            }
        });
        this.jPanel1.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                DualSlider.this.bar_mouseDragged(e2);
            }
        });
        this.jPanel2.setLayout(this.borderLayout2);
        this.maxLabel.setBorder(null);
        this.maxLabel.setText("255");
        this.maxLabel.setHorizontalAlignment(0);
        this.maxLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DualSlider.this.maxLabel_actionPerformed(e2);
            }
        });
        this.jPanel3.setLayout(this.borderLayout3);
        this.minLabel.setBorder(null);
        this.minLabel.setText("0");
        this.minLabel.setHorizontalAlignment(0);
        this.minLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DualSlider.this.minLabel_actionPerformed(e2);
            }
        });
        this.buttonTopUp.setBorder(this.borderINT);
        this.buttonTopUp.setMargin(new Insets(0, 0, 0, 0));
        this.buttonTopUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DualSlider.this.buttonTop_actionPerformed(e2);
            }
        });
        this.jPanel4.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.buttonBottomUP.setBorder(this.borderINT);
        this.buttonBottomUP.setMargin(new Insets(0, 0, 0, 0));
        this.buttonBottomUP.setText("");
        this.buttonBottomUP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DualSlider.this.buttonBottom_actionPerformed(e2);
            }
        });
        this.jPanel5.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(2);
        this.buttonBottomDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DualSlider.this.buttonBottomDown_actionPerformed(e2);
            }
        });
        this.buttonTopDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DualSlider.this.buttonTopDown_actionPerformed(e2);
            }
        });
        this.buttonBottomDown.setBorder(this.borderINT);
        this.buttonBottomDown.setMargin(new Insets(0, 0, 0, 0));
        this.buttonTopDown.setBorder(this.borderINT);
        this.buttonTopDown.setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.bar, null);
        this.add((Component)this.jPanel2, "North");
        this.jPanel2.add((Component)this.maxLabel, "North");
        this.jPanel2.add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.buttonTopUp, null);
        this.jPanel4.add((Component)this.buttonTopDown, null);
        this.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.minLabel, "South");
        this.jPanel3.add((Component)this.jPanel5, "North");
        this.jPanel5.add((Component)this.buttonBottomUP, null);
        this.jPanel5.add((Component)this.buttonBottomDown, null);
    }

    public int getWmin() {
        return this.wMin;
    }

    public void setWmin(int Wmin) {
        this.wMin = Wmin;
        this.clamp();
        this.reCalc();
    }

    public int getWmax() {
        return this.wMax;
    }

    public void setWmax(int Wmax) {
        this.wMax = Wmax;
        this.clamp();
        this.reCalc();
    }

    public int getWmaxRange() {
        return this.wMaxRange;
    }

    public void setWmaxRange(int wmaxRange) {
        this.wMaxRange = wmaxRange;
        this.reCalc();
    }

    public int getWminRange() {
        return this.wMinRange;
    }

    public void setWminRange(int wminRange) {
        this.wMinRange = wminRange;
        this.reCalc();
    }

    public void setMinMaxAndRange(int min, int max, int rmin, int rmax) {
        this.wMin = min;
        this.wMax = max;
        this.wMaxRange = rmax;
        this.wMinRange = rmin;
        this.reCalc();
    }

    public void setMinMax(int min, int max) {
        if (max < min) {
            max = 1 + (min + max) / 2;
            max = -1 + (min + max) / 2;
        }
        this.wMin = min;
        this.wMax = max;
        if (this.wMaxRange < this.wMax) {
            this.wMaxRange = this.wMax;
        }
        if (this.wMinRange > this.wMin) {
            this.wMinRange = this.wMin;
        }
        this.reCalc();
    }

    public void resetRange() {
        this.wMaxRange = this.wMax + (this.wMax - this.wMin) / 4;
        this.wMinRange = this.wMin - (this.wMax - this.wMin) / 4;
        this.reCalc();
    }

    public void setColorMap(int[] cmap) {
        if (cmap.length != 256) {
            int[] nc = new int[256];
            for (int i2 = 0; i2 < nc.length; ++i2) {
                double p2 = (double)i2 / 255.001 * (double)(cmap.length - 1);
                double rat = p2 - Math.floor(p2);
                int c1 = cmap[(int)p2];
                int c2 = cmap[1 + (int)p2];
                int r2 = (int)((double)(c1 & 0xFF) * (1.0 - rat) + (double)(c2 & 0xFF) * rat);
                int g2 = (int)((double)(c1 >> 8 & 0xFF) * (1.0 - rat) + (double)(c2 >> 8 & 0xFF) * rat);
                int b2 = (int)((double)(c1 >> 16 & 0xFF) * (1.0 - rat) + (double)(c2 >> 16 & 0xFF) * rat);
                nc[i2] = r2 | g2 << 8 | b2 << 16;
            }
            this.cmap = nc;
        } else {
            this.cmap = cmap;
        }
        this.repaint();
    }

    void bar_mousePressed(MouseEvent e2) {
        if (!this.enable) {
            return;
        }
        this.barMode = (e2.getY() - this.bar.getY()) / (this.bar.getHeight() / 3);
        this.barDown = e2.getY();
        this.oldMax = this.getWmax();
        this.oldMin = this.getWmin();
    }

    void bar_mouseReleased(MouseEvent e2) {
        if (!this.enable) {
            return;
        }
        this.fireStateChanged(new ChangeEvent(e2));
    }

    public void clamp() {
        if (this.wMax > this.hardRangeMax) {
            this.wMax = this.hardRangeMax;
        }
        if (this.wMin < this.hardRangeMin) {
            this.wMin = this.hardRangeMin;
        }
        if (this.wMax - this.wMin < 100) {
            this.wMin = this.wMax - 100;
        }
    }

    void bar_mouseDragged(MouseEvent e2) {
        if (!this.enable) {
            return;
        }
        switch (this.barMode) {
            case 0: {
                this.wMax = this.oldMax + (this.barDown - e2.getY()) * (this.wMaxRange - this.wMinRange) / this.jPanel1.getHeight();
                if (this.moveBoth) {
                    this.wMin = this.oldMin - (this.barDown - e2.getY()) * (this.wMaxRange - this.wMinRange) / this.jPanel1.getHeight();
                }
                this.clamp();
                if (this.wMin <= this.wMax) break;
                this.wMin = this.wMax - 10;
                break;
            }
            case 1: {
                this.wMax = this.oldMax + (this.barDown - e2.getY()) * (this.wMaxRange - this.wMinRange) / this.jPanel1.getHeight();
                this.wMin = this.oldMin + (this.barDown - e2.getY()) * (this.wMaxRange - this.wMinRange) / this.jPanel1.getHeight();
                this.clamp();
                break;
            }
            case 2: {
                this.wMin = this.oldMin + (this.barDown - e2.getY()) * (this.wMaxRange - this.wMinRange) / this.jPanel1.getHeight();
                if (this.moveBoth) {
                    this.wMax = this.oldMax - (this.barDown - e2.getY()) * (this.wMaxRange - this.wMinRange) / this.jPanel1.getHeight();
                }
                this.clamp();
                if (this.wMin <= this.wMax) break;
                this.wMax = this.wMin + 10;
            }
        }
        if (this.wMin < this.wMinRange) {
            this.wMinRange = this.wMin;
        }
        if (this.wMax > this.wMaxRange) {
            this.wMaxRange = this.wMax;
        }
        this.reCalc();
        this.fireStateChanged(new ChangeEvent(this));
    }

    public void setEnable(boolean flag) {
        if (flag) {
            this.bar.setEnabled(true);
            this.maxLabel.setEnabled(true);
            this.minLabel.setEnabled(true);
            this.buttonTopUp.setEnabled(true);
            this.buttonTopDown.setEnabled(true);
            this.buttonBottomUP.setEnabled(true);
            this.buttonBottomDown.setEnabled(true);
            this.enable = true;
        } else {
            this.bar.setEnabled(false);
            this.maxLabel.setEnabled(false);
            this.minLabel.setEnabled(false);
            this.buttonTopUp.setEnabled(false);
            this.buttonTopDown.setEnabled(false);
            this.buttonBottomUP.setEnabled(false);
            this.buttonBottomDown.setEnabled(false);
            this.enable = false;
        }
    }

    public synchronized void removeChangeListener(ChangeListener l2) {
        if (this.changeListeners != null && this.changeListeners.contains(l2)) {
            Vector v2 = (Vector)this.changeListeners.clone();
            v2.removeElement(l2);
            this.changeListeners = v2;
        }
    }

    public synchronized void addChangeListener(ChangeListener l2) {
        Vector v2;
        Vector vector = v2 = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.changeListeners = v2;
        }
    }

    protected void fireStateChanged(ChangeEvent e2) {
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((ChangeListener)listeners.elementAt(i2)).stateChanged(e2);
            }
        }
    }

    public void minLabel_actionPerformed(ActionEvent e2) {
        System.err.println("minLabel actionPerformed");
        try {
            this.setWmin(Integer.parseInt(this.minLabel.getText()));
            this.fireStateChanged(new ChangeEvent(this));
        }
        catch (NumberFormatException ex) {
            this.minLabel.setText(Integer.toString(this.wMin));
            this.fireStateChanged(new ChangeEvent(this));
        }
    }

    public void maxLabel_actionPerformed(ActionEvent e2) {
        try {
            this.setWmax(Integer.parseInt(this.maxLabel.getText()));
            this.fireStateChanged(new ChangeEvent(this));
        }
        catch (NumberFormatException ex) {
            this.maxLabel.setText(Integer.toString(this.wMax));
            this.fireStateChanged(new ChangeEvent(this));
        }
    }

    void buttonBottomDown_actionPerformed(ActionEvent e2) {
        this.wMin -= (this.wMaxRange - this.wMinRange) / 100;
        this.reCalc();
        this.fireStateChanged(new ChangeEvent(this));
    }

    void buttonTopDown_actionPerformed(ActionEvent e2) {
        this.wMax -= (this.wMaxRange - this.wMinRange) / 100;
        this.reCalc();
        this.fireStateChanged(new ChangeEvent(this));
    }

    void buttonTop_actionPerformed(ActionEvent e2) {
        this.wMax += (this.wMaxRange - this.wMinRange) / 100;
        this.reCalc();
        this.fireStateChanged(new ChangeEvent(this));
    }

    void buttonBottom_actionPerformed(ActionEvent e2) {
        this.wMin += (this.wMaxRange - this.wMinRange) / 100;
        this.reCalc();
        this.fireStateChanged(new ChangeEvent(this));
    }

    public int getHardRangeMax() {
        return this.hardRangeMax;
    }

    public void setHardRangeMax(int hardRangeMax) {
        this.hardRangeMax = hardRangeMax;
    }

    public int getHardRangeMin() {
        return this.hardRangeMin;
    }

    public void setHardRangeMin(int hardRangeMin) {
        this.hardRangeMin = hardRangeMin;
    }

    private class ArrowIcon
    implements Icon {
        int width = 10;
        int height = 10;
        int dir = 0;

        public ArrowIcon(int w2, int h2, int direction) {
            this.width = w2;
            this.height = h2;
            this.dir = direction;
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            this.drawIcon(g2, x2, y2, this.width, this.height);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        private void drawIcon(Graphics g2, int x2, int y2, int width, int height) {
            boolean enabled = true;
            boolean pressed = false;
            int in = (int)Math.ceil((double)Math.min(width, height) / 9.0);
            int w2 = width - 2 * in;
            int h2 = height - 2 * in;
            Dimension size = new Dimension(w2, h2);
            if (size.width <= 0 || size.height <= 0) {
                return;
            }
            float[][] p2 = new float[][]{{0.0f, (float)h2 / 4.0f, w2, (float)h2 / 4.0f, (float)w2 / 2.0f, (float)(h2 * 3) / 4.0f}, {0.0f, (float)(h2 * 3) / 4.0f, w2, (float)(h2 * 3) / 4.0f, (float)w2 / 2.0f, (float)h2 / 4.0f}, {(float)w2 / 4.0f, 0.0f, (float)w2 / 4.0f, h2, (float)(w2 * 3) / 4.0f, (float)h2 / 2.0f}, {(float)(w2 * 3) / 4.0f, 0.0f, (float)(w2 * 3) / 4.0f, h2, (float)w2 / 4.0f, (float)h2 / 2.0f}};
            int i2 = this.dir;
            GeneralPath path = new GeneralPath();
            path.moveTo(p2[i2][0], p2[i2][1]);
            path.lineTo(p2[i2][2], p2[i2][3]);
            path.lineTo(p2[i2][4], p2[i2][5]);
            path.closePath();
            GeneralPath shape = path;
            EdgeProfileRounded profile = new EdgeProfileRounded(0.0, 0.0);
            Color interiorColor = !enabled ? UIManager.getColor("P4") : (!pressed ? DualSlider.this.getForeground() : DualSlider.this.getBackground());
            Color exteriorColor = new Color(0, true);
            Rectangle cutout = null;
            BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, cutout);
            g2.drawImage(renderedShape, in + x2, in + y2, null);
        }
    }
}

