/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class RowColButton
extends JPanel {
    private int row = 6;
    private int col = 6;
    JToggleButton[][] buttons;
    actListen callback = new actListen();
    private transient Vector actionListeners;
    GridLayout gridLayout1 = new GridLayout();
    private Dimension value = new Dimension(0, 0);

    public RowColButton() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void updateButtons() {
        this.removeAll();
        this.gridLayout1.setRows(this.row);
        this.gridLayout1.setColumns(this.col);
        this.buttons = new JToggleButton[this.row][this.col];
        for (int y2 = 0; y2 < this.row; ++y2) {
            for (int x2 = 0; x2 < this.col; ++x2) {
                JToggleButton t2 = new JToggleButton();
                t2.putClientProperty("PTK_ICON_SHAPE", "NONE");
                t2.putClientProperty("PTK_ICON_SIZE", new Dimension(12, 12));
                t2.addActionListener(this.callback);
                this.buttons[y2][x2] = t2;
                this.add(t2);
            }
        }
    }

    public void updateButtons(ActionEvent e2) {
        JToggleButton pressed = (JToggleButton)e2.getSource();
        int maxx = 0;
        int maxy = 0;
        for (int y2 = 0; y2 < this.row; ++y2) {
            for (int x2 = 0; x2 < this.col; ++x2) {
                if (this.buttons[y2][x2] != pressed) continue;
                maxx = x2;
                maxy = y2;
            }
        }
        this.value.setSize(maxx, maxy);
        this.updateSelection();
        this.fireActionPerformed(e2);
    }

    private void updateSelection() {
        int maxx = this.value.width;
        int maxy = this.value.height;
        for (int y2 = 0; y2 < this.row; ++y2) {
            for (int x2 = 0; x2 < this.col; ++x2) {
                this.buttons[y2][x2].setSelected(x2 <= maxx & y2 <= maxy);
            }
        }
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
        this.updateButtons();
    }

    public void setCol(int col) {
        this.col = col;
        this.updateButtons();
    }

    public int getCol() {
        return this.col;
    }

    public synchronized void removeActionListener(ActionListener l2) {
        if (this.actionListeners != null && this.actionListeners.contains(l2)) {
            Vector v2 = (Vector)this.actionListeners.clone();
            v2.removeElement(l2);
            this.actionListeners = v2;
        }
    }

    public synchronized void addActionListener(ActionListener l2) {
        Vector v2;
        Vector vector = v2 = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.actionListeners = v2;
        }
    }

    protected void fireActionPerformed(ActionEvent e2) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((ActionListener)listeners.elementAt(i2)).actionPerformed(e2);
            }
        }
    }

    private void jbInit() throws Exception {
        this.gridLayout1.setHgap(-5);
        this.gridLayout1.setVgap(-5);
        this.setLayout(this.gridLayout1);
    }

    public void setValue(Dimension value) {
        this.value = value;
        this.updateSelection();
    }

    public Dimension getValue() {
        return this.value;
    }

    class actListen
    implements ActionListener {
        actListen() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            RowColButton.this.updateButtons(e2);
        }
    }
}

