/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMultiImageViewport;
import com.ge.med.terra.jami.image.XjMedicalImage;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.print.DicomPrintable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DicomPrintablePort
extends XpMultiImageViewport
implements DicomPrintable,
Pageable {
    private final JFrame jf = new JFrame("Offscreen");
    private final JPanel jp = new JPanel();

    public String getESIString() {
        Boolean forceLineBreak = Boolean.getBoolean("IOS.ESI.forceLineBreak");
        XpMedicalImage[] images = this.getImages();
        int currentIndex = this.getFrameIndex();
        if (images == null || currentIndex >= images.length) {
            return null;
        }
        XpMedicalImage image = images[currentIndex];
        String esi = "Ex: ";
        XpMedicalImage dicomImage = images[0];
        XpDicomElement exNum = new XpDicomElement(32, 16);
        XpDicomElement seNum = new XpDicomElement(32, 17);
        XpDicomElement imNum = new XpDicomElement(32, 19);
        dicomImage.getValue(exNum);
        dicomImage.getValue(seNum);
        dicomImage.getValue(imNum);
        if (forceLineBreak.booleanValue()) {
            int i2;
            int LINE_LIMIT = 10;
            StringBuffer buf = new StringBuffer(30);
            buf.append("Ex: " + (exNum.value != null ? (String)exNum.value : "0"));
            int ws = 10 - buf.length();
            for (i2 = 0; i2 < ws; ++i2) {
                buf.append(" ");
            }
            buf.append("Se: " + (seNum.value != null ? (String)seNum.value : "0"));
            ws = 10 - (buf.length() - 10);
            for (i2 = 0; i2 < ws; ++i2) {
                buf.append(" ");
            }
            buf.append("Im: " + (imNum.value != null ? (String)imNum.value : "0"));
            ws = 30 - buf.length();
            for (i2 = 0; i2 < ws; ++i2) {
                buf.append(" ");
            }
            return buf.toString();
        }
        esi = exNum.value != null ? esi + (String)exNum.value : esi + "0";
        esi = seNum.value != null ? esi + "\t" + "Se: " + (String)seNum.value : esi + "\tSe: 0";
        esi = imNum.value != null ? esi + "\t" + "Im: " + (String)imNum.value : esi + "\tIm: 0";
        return esi;
    }

    public String getOriginalImagePath() {
        XpMedicalImage[] images = this.getImages();
        int currentIndex = this.getFrameIndex();
        if (images == null || currentIndex >= images.length) {
            return null;
        }
        XpMedicalImage image = images[currentIndex];
        if (image instanceof XpMedicalDmImage) {
            return ((XpMedicalDmImage)image).getDMImage().getComposite().getFilePath();
        }
        if (image instanceof XjMedicalImage) {
            return ((XjMedicalImage)image).getFilePath();
        }
        return null;
    }

    public void print(Graphics graphics, int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.jf.setContentPane(this);
        this.jf.pack();
        Graphics2D g2d = (Graphics2D)graphics;
        this.paint(g2d);
        this.jf.setContentPane(this.jp);
    }

    public int print(Graphics graphics, PageFormat format, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        this.setPreferredSize(new Dimension((int)format.getWidth(), (int)format.getHeight()));
        this.jf.setContentPane(this);
        this.jf.pack();
        Graphics2D g2d = (Graphics2D)graphics;
        this.paint(g2d);
        this.jf.setContentPane(this.jp);
        return 0;
    }

    @Override
    public int getNumberOfPages() {
        return this.getPages();
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < this.getPages()) {
            return new PageFormat();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < this.getPages()) {
            this.setFrameIndex(pageIndex);
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    private int getPages() {
        int numImages = this.getImages().length;
        int cols = this.getCols();
        int rows = this.getRows();
        int numPages = numImages / (cols * rows);
        int remainder = numImages % (cols * rows);
        if (remainder > 0) {
            ++numPages;
        }
        return numPages;
    }
}

