/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.util.tport.color.ColorTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class XPutil {
    static boolean firstRequest = true;
    public static Logger xpvLogger = Logger.getLogger("com.ge.med.terra.xpv");
    static long lasttime;

    public static ResourceBundle getLocalResourceBundle(String prefix) {
        try {
            ResourceBundle res = ResourceBundle.getBundle(prefix, Locale.getDefault());
            if (res == null) {
                res = ResourceBundle.getBundle(prefix, new Locale("en"));
            }
            return res;
        }
        catch (Exception ex) {
            if (firstRequest) {
                ex.printStackTrace();
                firstRequest = false;
            }
            return ResourceBundle.getBundle(prefix, new Locale("en"));
        }
    }

    private XPutil() {
    }

    public static Logger getLogger() {
        return xpvLogger;
    }

    public static void log(Level l2, String s2, Throwable ex) {
        xpvLogger.log(l2, s2, ex);
    }

    public static Object getClassFor(Properties prop, String className, Class classType) {
        try {
            String name = prop.getProperty(className);
            if (name == null) {
                return null;
            }
            Class<?> c2 = Class.forName(name);
            Object obj = c2.newInstance();
            return obj;
        }
        catch (Exception ex) {
            XPutil.getLogger().log(Level.WARNING, "could not load" + className, ex);
            return null;
        }
    }

    public static DMTag[] parseTags(String tagStr) {
        StringTokenizer st = new StringTokenizer(tagStr, "(), ");
        DMTag[] tagList = new DMTag[st.countTokens() / 2];
        int count = 0;
        while (st.hasMoreTokens()) {
            int g2 = Integer.decode(st.nextToken());
            int e2 = Integer.decode(st.nextToken());
            tagList[count++] = new DMTag(g2, e2);
        }
        return tagList;
    }

    public static String[] parseStrings(String str, String token) {
        StringTokenizer st = new StringTokenizer(str, token);
        String[] strs = new String[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            strs[count++] = st.nextToken();
        }
        return strs;
    }

    public static BufferedImage getScreenImage(JComponent port) {
        Dimension d2 = port.getSize();
        int w2 = (int)d2.getWidth();
        int h2 = (int)d2.getHeight();
        BufferedImage bi = new BufferedImage(w2, h2, 5);
        Graphics g2 = bi.getGraphics();
        port.paint(g2);
        return bi;
    }

    public static void imageSave(BufferedImage image, String imageFormat, String fileName) {
        try {
            File f2 = new File(fileName);
            if (f2.exists()) {
                System.err.println("deleting" + f2.getAbsolutePath());
                f2.delete();
            }
            ImageIO.write((RenderedImage)image, imageFormat, f2);
            System.err.println("in imageSave....fileName to save===" + fileName);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            XPutil.getLogger().log(Level.WARNING, "Could not save image into " + fileName, ex);
        }
    }

    public static boolean compareCallBack(double myValue, double callBackValue) {
        double delta = 0.1;
        return !(myValue >= callBackValue - 0.1) || !(myValue <= callBackValue + 0.1);
    }

    public static void time(String str) {
        if (lasttime == 0L) {
            System.out.print("start ");
        }
        System.out.println(str + ":  " + (float)(System.currentTimeMillis() - lasttime) / 1000.0f);
        lasttime = System.currentTimeMillis();
    }

    public static Properties loadXPVAppProperties(InputStream propertyFile) {
        Properties prop = new Properties();
        try {
            prop.load(propertyFile);
            String config = System.getProperties().getProperty("XPVCONFIG");
            if (config != null && !new File(config).exists()) {
                int len;
                FileOutputStream fos = new FileOutputStream(config);
                byte[] buff = new byte[32768];
                while ((len = propertyFile.read(buff)) >= 0) {
                    fos.write(buff, 0, len);
                }
                fos.close();
            } else if (config != null) {
                prop.load(new FileInputStream(config));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XPutil.getLogger().log(Level.INFO, "loading " + propertyFile, ex);
        }
        return prop;
    }

    public static int[] getColorTable(String name) {
        try {
            int[] rgb = new int[256];
            if (name.endsWith(".txt")) {
                LineNumberReader lr = new LineNumberReader(new FileReader(name));
                for (int i2 = 0; i2 < rgb.length; ++i2) {
                    String line = lr.readLine();
                    StringTokenizer st = new StringTokenizer(line);
                    if (st.countTokens() != 3) continue;
                    rgb[i2] = Integer.parseInt(st.nextToken()) | Integer.parseInt(st.nextToken()) << 8 | Integer.parseInt(st.nextToken()) << 16;
                }
            } else if (name.endsWith(".rgb")) {
                DataInputStream dis = new DataInputStream(new FileInputStream(name));
                for (int i3 = 0; i3 < rgb.length; ++i3) {
                    int b2 = dis.readInt();
                    int g2 = dis.readInt();
                    int r2 = dis.readInt();
                    rgb[i3] = r2 | g2 << 8 | b2 << 16;
                }
            } else {
                return ColorTable.getColorTable((String)name);
            }
            return rgb;
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        String logLevel = System.getProperty("LogLevel");
        if (logLevel != null && logLevel.equalsIgnoreCase("finest")) {
            xpvLogger.setLevel(Level.FINEST);
        }
        lasttime = 0L;
    }

    public static class movFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".mov");
        }

        @Override
        public String getDescription() {
            return "*.mov";
        }
    }

    public static class dcmFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".dcm");
        }

        @Override
        public String getDescription() {
            return "*.dcm";
        }
    }

    public static class aviFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".avi");
        }

        @Override
        public String getDescription() {
            return "*.avi";
        }
    }

    public static class pngFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".png");
        }

        @Override
        public String getDescription() {
            return "*.png";
        }
    }

    public static class jpegFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".jpg");
        }

        @Override
        public String getDescription() {
            return "*.jpg";
        }
    }

    public static class AnnoChooser
    extends JPanel {
        JCheckBox jCheckBox1 = new JCheckBox();
        BorderLayout borderLayout1 = new BorderLayout();
        boolean anno = true;
        static final String annoStatus = "Annot";

        public boolean getAnno() {
            return this.anno;
        }

        public AnnoChooser() {
            try {
                this.jCheckBox1.setRolloverEnabled(false);
                this.jCheckBox1.setSelected(true);
                this.jCheckBox1.setText("Annotation");
                this.jCheckBox1.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e2) {
                        AnnoChooser.this.jCheckBox1_itemStateChanged(e2);
                    }
                });
                this.setLayout(this.borderLayout1);
                this.setRequestFocusEnabled(false);
                this.add((Component)this.jCheckBox1, "Center");
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }

        void jCheckBox1_itemStateChanged(ItemEvent e2) {
            this.anno = e2.getStateChange() != 2;
        }
    }
}

