/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.x3d;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class UndoRedo {
    UndoManager undoManager = new UndoManager();
    UndoableEditSupport undoSupport_ = new UndoableEditSupport();
    Action undoAction = new UndoAction();
    Action redoAction = new RedoAction();

    public UndoRedo() {
        this.undoSupport_.addUndoableEditListener(new UndoAdapter());
        this.refreshUndoRedo();
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public void refreshUndoRedo() {
        if (this.undoManager.canUndo()) {
            this.undoAction.setEnabled(true);
            this.undoAction.putValue("ShortDescription", this.undoManager.getUndoPresentationName());
        } else {
            this.undoAction.setEnabled(false);
            this.undoAction.putValue("ShortDescription", "Cannot Undo");
        }
        if (this.undoManager.canRedo()) {
            this.redoAction.setEnabled(true);
            this.redoAction.putValue("ShortDescription", this.undoManager.getRedoPresentationName());
        } else {
            this.redoAction.setEnabled(false);
            this.redoAction.putValue("ShortDescription", "Cannot Redo");
        }
    }

    public void postEdit(UndoableEdit edit) {
        this.undoSupport_.postEdit(edit);
    }

    public void reset() {
        this.undoManager.discardAllEdits();
        this.refreshUndoRedo();
    }

    class RedoAction
    extends AbstractAction {
        RedoAction() {
            super("Redo");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            UndoRedo.this.undoManager.redo();
            UndoRedo.this.refreshUndoRedo();
        }
    }

    class UndoAction
    extends AbstractAction {
        UndoAction() {
            super("Undo");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            UndoRedo.this.undoManager.undo();
            UndoRedo.this.refreshUndoRedo();
        }
    }

    private class UndoAdapter
    implements UndoableEditListener {
        private UndoAdapter() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e2) {
            UndoRedo.this.undoManager.addEdit(e2.getEdit());
            UndoRedo.this.refreshUndoRedo();
        }
    }
}

