/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.SOPClass;
import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.TagReadListener;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import srjdom.DcmDOM;
import srjdom.SRCommon;

public class EncapsulatedDocument
extends DcmDOM {
    private static int seriesNumber = 5000;
    private static int[] neededTags = new int[]{28, 31, 147, 148, 149, 2439, 150, 152, 2440, 425, 64, 70, 88, 427, 77, 84, 428, 97, 67, 73, 1459, 1310, 2173, 115, 116, 2170, 1322, 91, 92, 93, 1448, 57, 62, 63};
    private static TagReadListener tagReadListener = new TagReadListener(){

        @Override
        public void afterHeader(TagReadEvent e2) {
            int i2;
            int tag2 = e2.getTag();
            for (i2 = 0; i2 < neededTags.length && neededTags[i2] != tag2; ++i2) {
            }
            if (i2 < neededTags.length && neededTags[i2] == tag2) {
                e2.setDataReadStatus(0);
            } else {
                e2.setDataReadStatus(2);
            }
        }
    };

    public EncapsulatedDocument() {
    }

    public EncapsulatedDocument(Type type, String sopIUID, String impCUID) throws DicomException {
        this(type.getSOPClassUID(), sopIUID, SRCommon.TS_EXPLICIT_LITTLE_ENDIAN, impCUID);
    }

    public EncapsulatedDocument(String sopCUID, String sopIUID, String impCUID) throws DicomException {
        this(sopCUID, sopIUID, SRCommon.TS_EXPLICIT_LITTLE_ENDIAN, impCUID);
    }

    public EncapsulatedDocument(String sopCUID, String sopIUID, String trSyntaxUID, String impCUID) throws DicomException {
        super(sopCUID, sopIUID, trSyntaxUID, impCUID);
    }

    public String getDocumentTitle() {
        String documentTitle = null;
        if (this.dcmObj != null) {
            try {
                documentTitle = this.dcmObj.getS(2170);
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        return documentTitle;
    }

    public void setDocumentTitle(String documentTitle) {
        if (this.dcmObj != null) {
            try {
                this.dcmObj.set(2170, documentTitle);
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
    }

    public String getMIMEType() {
        String mimeType = null;
        if (this.dcmObj != null) {
            try {
                mimeType = this.dcmObj.getS(2172);
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        return mimeType;
    }

    public void fill(String dcmFileName, String seriesIUID, String docFileName, String docFileMIMEType, BurnedInAnnotation burnedInAnnotation) {
        this.initDICOMTags(dcmFileName, burnedInAnnotation);
        if (this.dcmObj != null) {
            try {
                this.dcmObj.set(81, "OT");
                this.dcmObj.set(426, seriesIUID);
                this.dcmObj.set(84, "GE MEDICAL SYSTEMS");
                this.dcmObj.set(83, "WSD");
                this.dcmObj.set(430, "1");
                this.dcmObj.set(2172, docFileMIMEType);
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        this.attachDocument(docFileName);
        this.buildDOM(this.metaInfo, this.root);
        this.buildDOM(this.dcmObj, this.root);
    }

    public void initDICOMTags(String fileName, BurnedInAnnotation burnedInAnnotation) {
        SRCommon.logger.info("> initDICOMTags(): " + fileName);
        DicomReader dcmReader = new DicomReader();
        dcmReader.addTagReadListener(tagReadListener);
        DicomObject dcmInitFrom = SRCommon.openDCM(new File(fileName), dcmReader);
        if (this.dcmObj != null && dcmInitFrom != null) {
            try {
                DicomObject item;
                SRCommon.copyType1CTag(dcmInitFrom, this.dcmObj, 57, "ISO_IR 100");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 147, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 148, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 149, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 150, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 152, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 154, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 2440);
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 425, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 64, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 70, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 88, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 427, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 77, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 428, String.valueOf(seriesNumber));
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 97, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 67, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 73, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 1459, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 1310, burnedInAnnotation.toString());
                if (dcmInitFrom.getSize(2173) <= 0) {
                    item = new DicomObject();
                    item.set(115, dcmInitFrom.get(62));
                    item.set(116, dcmInitFrom.get(63));
                    this.dcmObj.set(2173, item);
                } else {
                    SRCommon.copyTag(dcmInitFrom, this.dcmObj, 2173);
                }
                item = (DicomObject)dcmInitFrom.get(1322);
                if (item != null) {
                    SRCommon.copyTag(dcmInitFrom, this.dcmObj, 2170, item.get(93));
                }
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 1322);
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        SRCommon.logger.info("< initDICOMTags()");
    }

    public void attachDocument(String fileName) {
        this.attachDocument(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachDocument(File file) {
        SRCommon.logger.info("> attachDocument(): " + file);
        if (this.dcmObj != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                SRCommon.logger.info("\t# of bytes: " + fis.available());
                byte[] docBytes = new byte[fis.available()];
                fis.read(docBytes);
                this.dcmObj.setBytes(2171, docBytes, 0);
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {
                        SRCommon.logger.log(Level.WARNING, null, ex);
                    }
                }
            }
        }
        SRCommon.logger.info("< attachDocument(): ");
    }

    public void saveDCM(File file) throws IOException, DicomException, UnknownUIDException {
        SRCommon.logger.info("> saveDCM(): " + file);
        FileOutputStream fout = new FileOutputStream(file);
        int transferSyntax = UID.getUIDEntry(SRCommon.getJDTString(this.metaInfo, 31)).getConstant();
        this.dcmObj.write(fout, true, transferSyntax, true, false);
        fout.close();
        SRCommon.logger.info("< saveDCM()");
    }

    public void retrieveDocument() {
        try {
            this.retrieveDocument(this.dcmObj.getS(2170) + ".pdf");
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveDocument(String fileName) {
        SRCommon.logger.info("> retrieveDocument()");
        if (this.dcmObj != null) {
            FileOutputStream fos = null;
            try {
                byte[] docBytes = this.dcmObj.getBytes(2171, 0);
                fos = new FileOutputStream(fileName);
                fos.write(docBytes);
                fos.flush();
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ex) {
                        SRCommon.logger.log(Level.WARNING, null, ex);
                    }
                }
            }
        }
        SRCommon.logger.info("< retrieveDocument(): " + fileName);
    }

    private static void usage() {
        System.out.println("Options:");
        System.out.println("\t-c, --create  <DICOM file to initialize from> <Document to encapsulate>");
        System.out.println("\t-x, --extract <DICOM Encapsulated Document>");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            EncapsulatedDocument.usage();
            System.exit(1);
        }
        String dcmToInitFrom = null;
        String doc = null;
        String dcmEncapDoc = null;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equalsIgnoreCase("-c") || args[i2].equalsIgnoreCase("--create")) {
                if (args.length < 3) {
                    EncapsulatedDocument.usage();
                    System.exit(1);
                }
                dcmToInitFrom = args[i2 + 1];
                doc = args[i2 + 2];
                if (doc.endsWith(".pdf")) continue;
                System.out.println(doc + " is not PDF file!");
                System.exit(2);
                continue;
            }
            if (!args[i2].equalsIgnoreCase("-x") && !args[i2].equalsIgnoreCase("--extract")) continue;
            if (args.length < 2) {
                EncapsulatedDocument.usage();
                System.exit(1);
            }
            dcmEncapDoc = args[i2 + 1];
        }
        EncapsulatedDocument encapDoc = new EncapsulatedDocument();
        if (dcmToInitFrom != null && doc != null) {
            try {
                System.out.println("Encapsulate PDF to DICOM...");
                encapDoc.fill(dcmToInitFrom, "1.2.3", doc, "application/pdf", BurnedInAnnotation.NO);
                encapDoc.saveDCM(new File("huhu.dcm"));
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        if (dcmEncapDoc != null) {
            try {
                System.out.println("Retrieve PDF form DICOM...");
                encapDoc.readDCM(dcmEncapDoc);
                System.out.println("    (0042,0010) DocumentTitle: [" + encapDoc.getDocumentTitle() + "]");
                System.out.println("    (0042,0012) MIMETypeofEncapsulatedDocument: [" + encapDoc.getMIMEType() + "]");
                encapDoc.retrieveDocument();
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        encapDoc.writeXML();
        encapDoc.writeXML(encapDoc.getDocumentTitle() + ".xml");
    }

    public static enum BurnedInAnnotation {
        YES,
        NO;

    }

    public static enum Type {
        PDF(SOPClass.EncapsulatedPDFStorageUID.getValue(), "application/pdf"),
        CDA("1.2.840.10008.5.1.4.1.1.104.2", "text/xml");

        private String sopClassUID;
        private String mimeType;

        private Type(String sopCUID, String mime) {
            this.sopClassUID = sopCUID;
            this.mimeType = mime;
        }

        public String getSOPClassUID() {
            return this.sopClassUID;
        }

        public String getMIMEType() {
            return this.mimeType;
        }
    }
}

