/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictEntry;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Person;
import com.archimed.dicom.UnknownUIDException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import srjdom.IssuerOfPatientIDMacro;
import srjdom.PatientIDsSeq;
import srjdom.RequestAttributesSeq;
import srjdom.SRCode;
import srjdom.SRCodeItem;
import srjdom.SRCodeSeq;
import srjdom.SRCommon;
import srjdom.SRCompositeItem;
import srjdom.SRContainerItem;
import srjdom.SRContentItem;
import srjdom.SRContentSeq;
import srjdom.SRContentTemplateItem;
import srjdom.SRContentTemplateSeq;
import srjdom.SRDOMEncoder;
import srjdom.SRDOMValidator;
import srjdom.SRDate;
import srjdom.SRDateItem;
import srjdom.SRDateTime;
import srjdom.SRDateTimeItem;
import srjdom.SRGraphicType;
import srjdom.SRImageItem;
import srjdom.SRNum;
import srjdom.SRNumItem;
import srjdom.SRPName;
import srjdom.SRPNameItem;
import srjdom.SRReferencedItem;
import srjdom.SRReferencedReqSeq;
import srjdom.SRRelationshipType;
import srjdom.SRSAXHandler;
import srjdom.SRSCoordItem;
import srjdom.SRSOPRefItem;
import srjdom.SRSOPRefSeq;
import srjdom.SRSeriesRefItem;
import srjdom.SRString;
import srjdom.SRStudyRefItem;
import srjdom.SRStudyRefSeq;
import srjdom.SRTCoordItem;
import srjdom.SRTemporalRangeType;
import srjdom.SRTextItem;
import srjdom.SRTime;
import srjdom.SRTimeItem;
import srjdom.SRUID;
import srjdom.SRUIDRefItem;
import srjdom.SRValueType;
import srjdom.SRVerifyingObsItem;
import srjdom.SRVerifyingObsSeq;
import srjdom.SRWaveformItem;
import srjdom.SynchronizationModule;

public class SRDOMDoc {
    static Document srDOM;
    SRString metaElementGroupLength;
    SRString fileMetaInformationVersion;
    SRString mediaStorageSOPClassUID;
    SRString mediaStorageSOPInstanceUID;
    public SRString transferSyntaxUID;
    public SRString implementationClassUID;
    public SRString implementationVersionName;
    public SRString sourceApplicationEntityTitle;
    public SRPName patientName;
    public SRString patientID;
    public IssuerOfPatientIDMacro issuerOfPatientIDMacro;
    public SRDate patientBirthDate;
    public SRTime patientBirthTime;
    public SRString patientSex;
    public SRString otherPatientIDs;
    public PatientIDsSeq otherPatientIDsSeq;
    public SRString ethnicGroup;
    public SRString patientComments;
    public SRString privateCreator;
    public SRString appSpecificData;
    public SRUID studyInstanceUID;
    public SRDate studyDate;
    public SRTime studyTime;
    public SRPName referringPhysicianName;
    public SRString studyID;
    public SRString accessionNumber;
    public SRString studyDescription;
    public SRSOPRefSeq referencedStudySeq;
    public SRString patientAge;
    public SRNum patientSize;
    public SRNum patientWeight;
    public SRString occupation;
    public SRString additionalPatientHistory;
    public SRString seriesDescription;
    public RequestAttributesSeq requestAttributesSeq = null;
    SRString modality;
    public SRUID seriesInstanceUID;
    public SRString seriesNumber;
    public SRSOPRefSeq referencedPPSSeq;
    public SynchronizationModule synchronizationModule;
    public SRString manufacturer;
    public SRString institutionName;
    public SRString institutionAddress;
    public SRString stationName;
    public SRString institutionalDepartmentName;
    public SRString manufacturersModelName;
    public SRString deviceSerialNumber;
    public SRString softwareVersions;
    public SRString instanceNumber;
    public SRString completionFlag;
    public SRString completionFlagDescription;
    public SRString verificationFlag;
    public SRDate contentDate;
    public SRTime contentTime;
    public SRVerifyingObsSeq verifyingObserverSeq;
    public SRStudyRefSeq predecessorDocumentsSeq;
    public SRStudyRefSeq identicalDocumentsSeq;
    public SRReferencedReqSeq referencedReqSeq;
    public SRCodeSeq performedProcCodeSeq;
    public SRStudyRefSeq currentReqProcEvidenceSeq;
    public SRStudyRefSeq pertinentOtherEvidenceSeq;
    public SRDateTime observationDateTime;
    SRString valueType;
    SRCodeSeq conceptNameCodeSequence;
    public SRCode documentTitle;
    public SRString continuityOfContent;
    public SRContentTemplateSeq contentTemplateSeq;
    public SRContentSeq contentSeq;
    SRUID sopClassUID;
    SRUID sopInstanceUID;
    public SRString specificCharacterSet;
    public SRDate instanceCreationDate;
    public SRTime instanceCreationTime;
    public SRUID instanceCreatorUID;
    Element root;
    private String patientIdentificationKey;

    protected void initGroup0002(String sopCUID, String trSyntaxUID) {
        this.metaElementGroupLength = new SRString(27);
        this.root.appendChild(this.metaElementGroupLength.xmlTag);
        this.fileMetaInformationVersion = new SRString(28, "0001");
        this.root.appendChild(this.fileMetaInformationVersion.xmlTag);
        this.mediaStorageSOPClassUID = new SRString(29, sopCUID);
        this.root.appendChild(this.mediaStorageSOPClassUID.xmlTag);
        this.mediaStorageSOPInstanceUID = new SRString(30);
        this.root.appendChild(this.mediaStorageSOPInstanceUID.xmlTag);
        this.transferSyntaxUID = new SRString(31, trSyntaxUID);
        this.root.appendChild(this.transferSyntaxUID.xmlTag);
        this.implementationClassUID = new SRString(32);
        this.root.appendChild(this.implementationClassUID.xmlTag);
        this.implementationVersionName = new SRString(33);
        this.root.appendChild(this.implementationVersionName.xmlTag);
        this.sourceApplicationEntityTitle = new SRString(34);
        this.root.appendChild(this.sourceApplicationEntityTitle.xmlTag);
    }

    protected void initGroup0008(String sopCUID) {
        this.specificCharacterSet = new SRString(57);
        this.root.appendChild(this.specificCharacterSet.xmlTag);
        this.specificCharacterSet.setValue("ISO_IR 100");
        this.instanceCreationDate = new SRDate(59);
        this.root.appendChild(this.instanceCreationDate.xmlTag);
        this.instanceCreationDate.setCurrent();
        this.instanceCreationTime = new SRTime(60);
        this.root.appendChild(this.instanceCreationTime.xmlTag);
        this.instanceCreationTime.setCurrent();
        this.instanceCreatorUID = new SRUID(61);
        this.root.appendChild(this.instanceCreatorUID.xmlTag);
        this.sopClassUID = new SRUID(62, sopCUID);
        this.root.appendChild(this.sopClassUID.xmlTag);
        this.sopInstanceUID = new SRUID(63);
        this.root.appendChild(this.sopInstanceUID.xmlTag);
        this.studyDate = new SRDate(64);
        this.root.appendChild(this.studyDate.xmlTag);
        this.contentDate = new SRDate(67);
        this.root.appendChild(this.contentDate.xmlTag);
        this.contentDate.setCurrent();
        this.studyTime = new SRTime(70);
        this.root.appendChild(this.studyTime.xmlTag);
        this.contentTime = new SRTime(73);
        this.root.appendChild(this.contentTime.xmlTag);
        this.contentTime.setCurrent();
        this.accessionNumber = new SRString(77);
        this.root.appendChild(this.accessionNumber.xmlTag);
        this.modality = new SRString(81, "SR");
        this.root.appendChild(this.modality.xmlTag);
        this.manufacturer = new SRString(84, "GE MEDICAL SYSTEMS");
        this.root.appendChild(this.manufacturer.xmlTag);
        this.institutionName = new SRString(85);
        this.root.appendChild(this.institutionName.xmlTag);
        this.institutionAddress = new SRString(86);
        this.root.appendChild(this.institutionAddress.xmlTag);
        this.referringPhysicianName = new SRPName(88);
        this.root.appendChild(this.referringPhysicianName.xmlTag);
        this.stationName = new SRString(94);
        this.root.appendChild(this.stationName.xmlTag);
        this.studyDescription = new SRString(95);
        this.root.appendChild(this.studyDescription.xmlTag);
        this.referencedStudySeq = new SRSOPRefSeq(107);
        this.root.appendChild(this.referencedStudySeq.xmlTag);
        this.seriesDescription = new SRString(97);
        this.root.appendChild(this.seriesDescription.xmlTag);
        this.institutionalDepartmentName = new SRString(98);
        this.root.appendChild(this.institutionalDepartmentName.xmlTag);
        this.manufacturersModelName = new SRString(105);
        this.root.appendChild(this.manufacturersModelName.xmlTag);
        this.referencedPPSSeq = new SRSOPRefSeq(108, 1);
        this.root.appendChild(this.referencedPPSSeq.xmlTag);
    }

    protected void initGroup0010(String sopCUID) {
        this.patientName = new SRPName(147);
        this.root.appendChild(this.patientName.xmlTag);
        this.patientID = new SRString(148);
        this.root.appendChild(this.patientID.xmlTag);
        this.issuerOfPatientIDMacro = new IssuerOfPatientIDMacro();
        this.root.appendChild(this.issuerOfPatientIDMacro.issuerOfPatientID.xmlTag);
        this.patientBirthDate = new SRDate(150);
        this.root.appendChild(this.patientBirthDate.xmlTag);
        this.patientBirthTime = new SRTime(151);
        this.root.appendChild(this.patientBirthTime.xmlTag);
        this.patientSex = new SRString(152);
        this.root.appendChild(this.patientSex.xmlTag);
        this.otherPatientIDs = new SRString(154);
        this.root.appendChild(this.otherPatientIDs.xmlTag);
        this.otherPatientIDsSeq = new PatientIDsSeq();
        this.root.appendChild(this.otherPatientIDsSeq.xmlTag);
        this.patientAge = new SRString(157);
        this.root.appendChild(this.patientAge.xmlTag);
        this.patientSize = new SRNum(158);
        this.root.appendChild(this.patientSize.xmlTag);
        this.patientWeight = new SRNum(159);
        this.root.appendChild(this.patientWeight.xmlTag);
        this.ethnicGroup = new SRString(170);
        this.root.appendChild(this.ethnicGroup.xmlTag);
        this.occupation = new SRString(171);
        this.root.appendChild(this.occupation.xmlTag);
        this.additionalPatientHistory = new SRString(173);
        this.root.appendChild(this.additionalPatientHistory.xmlTag);
        this.patientComments = new SRString(177);
        this.root.appendChild(this.patientComments.xmlTag);
    }

    protected void initGroup0018(String sopCUID) {
        this.deviceSerialNumber = new SRString(228);
        this.root.appendChild(this.deviceSerialNumber.xmlTag);
        this.softwareVersions = new SRString(236);
        this.root.appendChild(this.softwareVersions.xmlTag);
        if (this.synchronizationModule != null) {
            this.root.appendChild(this.synchronizationModule.triggerSourceOrType.xmlTag);
            this.root.appendChild(this.synchronizationModule.synchronizationTrigger.xmlTag);
            this.root.appendChild(this.synchronizationModule.synchronizationChannel.xmlTag);
            this.root.appendChild(this.synchronizationModule.acquisitionTimeSynchronized.xmlTag);
            this.root.appendChild(this.synchronizationModule.timeSource.xmlTag);
            this.root.appendChild(this.synchronizationModule.timeDistributionProtocol.xmlTag);
            this.root.appendChild(this.synchronizationModule.ntpSourceAddress.xmlTag);
        }
    }

    protected void initGroup0020(String sopCUID) {
        this.studyInstanceUID = new SRUID(425);
        this.root.appendChild(this.studyInstanceUID.xmlTag);
        this.seriesInstanceUID = new SRUID(426);
        this.root.appendChild(this.seriesInstanceUID.xmlTag);
        this.studyID = new SRString(427);
        this.root.appendChild(this.studyID.xmlTag);
        this.seriesNumber = new SRString(428);
        this.root.appendChild(this.seriesNumber.xmlTag);
        this.seriesNumber.setValue("1");
        this.instanceNumber = new SRString(430);
        this.root.appendChild(this.instanceNumber.xmlTag);
        this.instanceNumber.setValue("1");
        if (this.synchronizationModule != null) {
            this.root.appendChild(this.synchronizationModule.synchronizationFrameOfReferenceUID.xmlTag);
        }
    }

    protected void initGroup0040(String sopCUID) {
        this.requestAttributesSeq = new RequestAttributesSeq(1211);
        this.root.appendChild(this.requestAttributesSeq.xmlTag);
        this.observationDateTime = new SRDateTime(1428);
        this.root.appendChild(this.observationDateTime.xmlTag);
        this.observationDateTime.setCurrent();
        this.valueType = new SRString(DDict.getDescription(1429) + "_" + SRValueType.VT_CONTAINER.toString(), 1429);
        this.valueType.setValue(SRValueType.VT_CONTAINER.toString());
        this.root.appendChild(this.valueType.xmlTag);
        this.conceptNameCodeSequence = new SRCodeSeq(1322, 1);
        this.root.appendChild(this.conceptNameCodeSequence.xmlTag);
        this.documentTitle = new SRCode("18748-4", "LN", null, "Diagnostic Imaging Report");
        this.conceptNameCodeSequence.appendChild(this.documentTitle);
        this.continuityOfContent = new SRString(1430, "SEPARATE");
        this.root.appendChild(this.continuityOfContent.xmlTag);
        this.verifyingObserverSeq = new SRVerifyingObsSeq(1431);
        this.root.appendChild(this.verifyingObserverSeq.xmlTag);
        this.predecessorDocumentsSeq = new SRStudyRefSeq(1441);
        this.root.appendChild(this.predecessorDocumentsSeq.xmlTag);
        this.referencedReqSeq = new SRReferencedReqSeq(1442);
        this.root.appendChild(this.referencedReqSeq.xmlTag);
        this.performedProcCodeSeq = new SRCodeSeq(1443);
        this.root.appendChild(this.performedProcCodeSeq.xmlTag);
        this.currentReqProcEvidenceSeq = new SRStudyRefSeq(1444);
        this.root.appendChild(this.currentReqProcEvidenceSeq.xmlTag);
        this.pertinentOtherEvidenceSeq = new SRStudyRefSeq(1445);
        this.root.appendChild(this.pertinentOtherEvidenceSeq.xmlTag);
        this.completionFlag = new SRString(1446, "PARTIAL");
        this.root.appendChild(this.completionFlag.xmlTag);
        this.completionFlagDescription = new SRString(1447);
        this.root.appendChild(this.completionFlagDescription.xmlTag);
        this.verificationFlag = new SRString(1448, "UNVERIFIED");
        this.root.appendChild(this.verificationFlag.xmlTag);
        this.contentTemplateSeq = new SRContentTemplateSeq(1);
        this.root.appendChild(this.contentTemplateSeq.xmlTag);
        this.identicalDocumentsSeq = new SRStudyRefSeq(1450);
        this.root.appendChild(this.identicalDocumentsSeq.xmlTag);
        this.contentSeq = new SRContentSeq(1451);
        this.root.appendChild(this.contentSeq.xmlTag);
    }

    public SRDOMDoc(String sopCUID, boolean withPrivate) {
        if (sopCUID == null) {
            throw new IllegalArgumentException("Illegal SOP Class UID: " + sopCUID);
        }
        this.createSRDOM();
        if (SRCommon.COMPREHENSIVE_SR.equalsIgnoreCase(sopCUID) || SRCommon.XRAY_RADIATION_DOSE_SR.equals(sopCUID)) {
            this.synchronizationModule = new SynchronizationModule();
        }
        try {
            this.initGroup0002(sopCUID, SRCommon.TS_EXPLICIT_LITTLE_ENDIAN);
            this.initGroup0008(sopCUID);
            this.initGroup0010(sopCUID);
            this.initGroup0018(sopCUID);
            this.initGroup0020(sopCUID);
            if (withPrivate) {
                this.privateCreator = new SRString(57, 16);
                this.root.appendChild(this.privateCreator.xmlTag);
                this.appSpecificData = new SRString(57, 4245);
                this.root.appendChild(this.appSpecificData.xmlTag);
            }
            this.initGroup0040(sopCUID);
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
    }

    public SRDOMDoc(boolean withPrivate) {
        this(SRCommon.ENHANCED_SR, withPrivate);
    }

    public SRDOMDoc() {
        this(true);
    }

    public SRDOMDoc(String sopIUID) {
        this();
        this.setSOPInstanceUID(sopIUID);
    }

    public SRDOMDoc(String sopCUID, String sopIUID) {
        this(sopCUID, true);
        this.setSOPInstanceUID(sopIUID);
    }

    public SRDOMDoc(String sopCUID, String sopIUID, String trSyntaxUID) {
        this(sopCUID, sopIUID);
        this.transferSyntaxUID.setValue(trSyntaxUID);
    }

    protected void createSRDOM() {
        SRCommon.logger.info("> createSRDOM()");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            srDOM = builder.newDocument();
            this.root = srDOM.createElement("DICOM");
            srDOM.appendChild(this.root);
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
        SRCommon.logger.info("< createSRDOM()");
    }

    public void readDCM(File dcmFile) {
        SRCommon.logger.info("> readDCM()\tfile: " + dcmFile);
        DicomObject dcm = SRCommon.openDCM(dcmFile);
        this.buildSRDOM(dcm);
        SRCommon.logger.info("< readDCM()");
    }

    public SRDOMDoc appendDCM(File dcmFile) {
        SRCommon.logger.info("> appendDCM()\tfile: " + dcmFile);
        DicomObject dcm = SRCommon.openDCM(dcmFile);
        String patientKey = SRCommon.getPatientIdentificationKey(dcm);
        if (!this.patientIdentificationKey.equals(patientKey)) {
            throw new IllegalArgumentException("Patient identification key does not match! " + this.patientIdentificationKey + " - " + patientKey);
        }
        String privateInfo = SRCommon.getJDTString(dcm, 57, 4245);
        SRCommon.logger.info("\tprivateInfo: " + privateInfo);
        this.processContentSQ(dcm, this.contentSeq, privateInfo);
        SRCommon.logger.info("< appendDCM()");
        return this;
    }

    public void readXML(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        this.readXML(xmlFile, new SRSAXHandler(this));
    }

    public void readXML(File xmlFile, DefaultHandler saxHandler) throws IOException, SAXException, ParserConfigurationException {
        SRCommon.logger.info("> readXML()\tfile: " + xmlFile + "\tsaxHandler: " + saxHandler);
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setValidating(false);
        parserFactory.setNamespaceAware(false);
        SAXParser parser = parserFactory.newSAXParser();
        parser.parse(xmlFile, saxHandler);
        this.createPatientIdentificationKey();
        SRCommon.logger.info("< readXML()");
    }

    private void buildSRDOM(DicomObject dcm) {
        this.buildSRDOM(dcm, true);
    }

    private void buildSRDOM(DicomObject dcm, boolean processSQ) {
        SRCommon.logger.info("> buildSRDOM()\tprocessSQ: " + processSQ);
        try {
            SRSOPRefItem sopRefItem;
            DicomObject metaInfo = dcm.getFileMetaInformation();
            this.metaElementGroupLength.setValue(SRCommon.getJDTString(metaInfo, 27));
            this.fileMetaInformationVersion.setValue(SRCommon.getJDTString(metaInfo, 28));
            this.mediaStorageSOPClassUID.setValue(SRCommon.getJDTString(metaInfo, 29));
            this.mediaStorageSOPInstanceUID.setValue(SRCommon.getJDTString(metaInfo, 30));
            this.transferSyntaxUID.setValue(SRCommon.getJDTString(metaInfo, 31));
            this.implementationClassUID.setValue(SRCommon.getJDTString(metaInfo, 32));
            this.implementationVersionName.setValue(SRCommon.getJDTString(metaInfo, 33));
            this.sourceApplicationEntityTitle.setValue(SRCommon.getJDTString(metaInfo, 34));
            this.specificCharacterSet.setValue(SRCommon.getJDTString(dcm, 57));
            this.instanceCreationDate.setValue(SRCommon.getJDTString(dcm, 59));
            this.instanceCreationTime.setValue(SRCommon.getJDTString(dcm, 60));
            this.instanceCreatorUID.setValue(SRCommon.getJDTString(dcm, 61));
            this.sopClassUID.setValue(SRCommon.getJDTString(dcm, 62));
            this.sopInstanceUID.setValue(SRCommon.getJDTString(dcm, 63));
            this.studyDate.setValue(SRCommon.getJDTString(dcm, 64));
            this.contentDate.setValue(SRCommon.getJDTString(dcm, 67));
            this.studyTime.setValue(SRCommon.getJDTString(dcm, 70));
            this.contentTime.setValue(SRCommon.getJDTString(dcm, 73));
            this.accessionNumber.setValue(SRCommon.getJDTString(dcm, 77));
            this.modality.setValue(SRCommon.getJDTString(dcm, 81));
            this.manufacturer.setValue(SRCommon.getJDTString(dcm, 84));
            this.institutionName.setValue(SRCommon.getJDTString(dcm, 85));
            this.institutionAddress.setValue(SRCommon.getJDTString(dcm, 86));
            this.referringPhysicianName.setValue(SRCommon.getJDTString(dcm, 88));
            this.stationName.setValue(SRCommon.getJDTString(dcm, 94));
            this.studyDescription.setValue(SRCommon.getJDTString(dcm, 95));
            this.seriesDescription.setValue(SRCommon.getJDTString(dcm, 97));
            this.institutionalDepartmentName.setValue(SRCommon.getJDTString(dcm, 98));
            this.manufacturersModelName.setValue(SRCommon.getJDTString(dcm, 105));
            DicomObject refPPSSeq = (DicomObject)dcm.get(108);
            if (refPPSSeq != null && (sopRefItem = this.getSOPRefItem(refPPSSeq)) != null) {
                this.referencedPPSSeq.appendChild(sopRefItem);
            }
            this.patientName.setValue(SRCommon.getJDTString(dcm, 147));
            this.patientID.setValue(SRCommon.getJDTString(dcm, 148));
            this.issuerOfPatientIDMacro.fill(dcm);
            this.patientBirthDate.setValue(SRCommon.getJDTString(dcm, 150));
            this.patientBirthTime.setValue(SRCommon.getJDTString(dcm, 151));
            this.patientSex.setValue(SRCommon.getJDTString(dcm, 152));
            this.createPatientIdentificationKey();
            this.otherPatientIDs.setValue(SRCommon.getJDTString(dcm, 154));
            this.otherPatientIDsSeq.fill(dcm);
            this.patientAge.setValue(SRCommon.getJDTString(dcm, 157));
            this.patientSize.setValue(SRCommon.getJDTString(dcm, 158));
            this.patientWeight.setValue(SRCommon.getJDTString(dcm, 159));
            this.ethnicGroup.setValue(SRCommon.getJDTString(dcm, 170));
            this.occupation.setValue(SRCommon.getJDTString(dcm, 171));
            this.additionalPatientHistory.setValue(SRCommon.getJDTString(dcm, 173));
            this.patientComments.setValue(SRCommon.getJDTString(dcm, 177));
            this.deviceSerialNumber.setValue(SRCommon.getJDTString(dcm, 228));
            this.softwareVersions.setValue(SRCommon.getJDTString(dcm, 236));
            if (this.synchronizationModule != null) {
                this.synchronizationModule.triggerSourceOrType.setValue(SRCommon.getJDTString(dcm, 252));
                this.synchronizationModule.synchronizationTrigger.setValue(SRCommon.getJDTString(dcm, 1463));
                this.synchronizationModule.synchronizationChannel.setValue(SRCommon.getJDTString(dcm, 1464));
                this.synchronizationModule.acquisitionTimeSynchronized.setValue(SRCommon.getJDTString(dcm, 1466));
                this.synchronizationModule.timeSource.setValue(SRCommon.getJDTString(dcm, 1468));
                this.synchronizationModule.timeDistributionProtocol.setValue(SRCommon.getJDTString(dcm, 1467));
                this.synchronizationModule.ntpSourceAddress.setValue(SRCommon.getJDTString(dcm, 1954));
            }
            this.studyInstanceUID.setValue(SRCommon.getJDTString(dcm, 425));
            this.seriesInstanceUID.setValue(SRCommon.getJDTString(dcm, 426));
            this.studyID.setValue(SRCommon.getJDTString(dcm, 427));
            this.seriesNumber.setValue(SRCommon.getJDTString(dcm, 428));
            this.instanceNumber.setValue(SRCommon.getJDTString(dcm, 430));
            if (this.synchronizationModule != null) {
                this.synchronizationModule.synchronizationFrameOfReferenceUID.setValue(SRCommon.getJDTString(dcm, 1469));
            }
            String privCreator = SRCommon.getJDTString(dcm, 57, 16);
            String appSpecData = SRCommon.getJDTString(dcm, 57, 4245);
            SRCommon.logger.info("\tprivateCreator: " + privCreator + "\tappSpecificData: " + appSpecData);
            if (privCreator != null && !privCreator.trim().equalsIgnoreCase("") && appSpecData != null) {
                this.privateCreator.setValue(privCreator);
                this.appSpecificData.setValue(appSpecData);
            } else {
                try {
                    this.root.removeChild(this.privateCreator.xmlTag);
                    this.root.removeChild(this.appSpecificData.xmlTag);
                }
                catch (Exception ex) {
                    SRCommon.logger.log(Level.WARNING, null, ex);
                }
            }
            this.observationDateTime.setValue(SRCommon.getJDTString(dcm, 1428));
            this.valueType.setValue(SRCommon.getJDTString(dcm, 1429));
            DicomObject cncSeq = (DicomObject)dcm.get(1322);
            if (cncSeq != null) {
                this.documentTitle.setValue(SRCommon.getJDTString(cncSeq, 91), SRCommon.getJDTString(cncSeq, 92), null, SRCommon.getJDTString(cncSeq, 93));
            }
            this.continuityOfContent.setValue(SRCommon.getJDTString(dcm, 1430));
            DicomObject verifObsSeq = (DicomObject)dcm.get(1431);
            if (verifObsSeq != null) {
                DicomObject verifObsIdCodeSeq = (DicomObject)dcm.get(1433);
                SRCode verifIdentificationCode = this.getCode(verifObsIdCodeSeq);
                SRVerifyingObsItem verifObsItem = new SRVerifyingObsItem(SRCommon.getJDTString(verifObsSeq, 1432), SRCommon.getJDTString(verifObsSeq, 1426), SRCommon.getJDTString(verifObsSeq, 1427), verifIdentificationCode);
                this.verifyingObserverSeq.appendChild(verifObsItem);
            }
            this.processSOPInstanceRefMacro(dcm, 1441, this.predecessorDocumentsSeq);
            this.processSOPInstanceRefMacro(dcm, 1450, this.identicalDocumentsSeq);
            this.processCodeSequenceMacro(dcm, 1443, this.performedProcCodeSeq);
            this.processSOPInstanceRefMacro(dcm, 1444, this.currentReqProcEvidenceSeq);
            this.processSOPInstanceRefMacro(dcm, 1445, this.pertinentOtherEvidenceSeq);
            this.completionFlag.setValue(SRCommon.getJDTString(dcm, 1446));
            this.completionFlagDescription.setValue(SRCommon.getJDTString(dcm, 1447));
            this.verificationFlag.setValue(SRCommon.getJDTString(dcm, 1448));
            DicomObject contTpSeq = (DicomObject)dcm.get(1449);
            if (contTpSeq != null) {
                this.processTemplateIdentificationMacro(contTpSeq, this.contentTemplateSeq);
            }
            if (processSQ) {
                this.processContentSQ(dcm, this.contentSeq, this.appSpecificData.getValue());
            }
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
        SRCommon.logger.info("< buildSRDOM()");
    }

    private void processCodeSequenceMacro(DicomObject dcm, int dname, SRCodeSeq seq) {
        SRCommon.logger.info("> processCodeSequenceMacro():\t" + seq + " size: " + dcm.getSize(dname));
        for (int i2 = 0; i2 < dcm.getSize(dname); ++i2) {
            try {
                DicomObject code = (DicomObject)dcm.get(dname, i2);
                if (code == null) continue;
                seq.appendChild(this.getCode(code));
                continue;
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        SRCommon.logger.info("< processCodeSequenceMacro()");
    }

    private void processTemplateIdentificationMacro(DicomObject dcm, SRContentTemplateSeq seq) {
        SRCommon.logger.info("> processTemplateIdentificationMacro()");
        try {
            SRContentTemplateItem srContTpI = new SRContentTemplateItem(SRCommon.getJDTString(dcm, 1338), SRCommon.getJDTString(dcm, 1452));
            seq.appendChild(srContTpI);
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
        SRCommon.logger.info("< processTemplateIdentificationMacro()");
    }

    private void processSOPInstanceRefMacro(DicomObject dcm, int dname, SRStudyRefSeq seq) {
        SRCommon.logger.info("> processSOPInstanceRefMacro():\t" + seq + " size: " + dcm.getSize(dname));
        String stdInstanceUID = null;
        SRStudyRefItem studyRefItem = null;
        String serInstanceUID = null;
        SRSeriesRefItem seriesRefItem = null;
        SRSOPRefItem sopRefItem = null;
        for (int i2 = 0; i2 < dcm.getSize(dname); ++i2) {
            try {
                DicomObject stdRefItem = (DicomObject)dcm.get(dname, i2);
                if (stdRefItem == null) continue;
                DicomObject refSeriesSeq = (DicomObject)stdRefItem.get(109);
                stdInstanceUID = SRCommon.getJDTString(stdRefItem, 425);
                if (refSeriesSeq != null) {
                    SRCommon.logger.info("\t\tReferenced Series Sequence: (0008,1115) size: " + stdRefItem.getSize(109) + "\tStudy Instance UID: (0020,000D): " + stdInstanceUID);
                    for (int j2 = 0; j2 < stdRefItem.getSize(109); ++j2) {
                        try {
                            seriesRefItem = null;
                            DicomObject serRefItem = (DicomObject)stdRefItem.get(109, j2);
                            if (serRefItem != null) {
                                DicomObject referencedSOPSeq = (DicomObject)serRefItem.get(121);
                                serInstanceUID = SRCommon.getJDTString(serRefItem, 426);
                                if (referencedSOPSeq != null) {
                                    SRCommon.logger.info("\t\t\tReferenced SOP Sequence: (0008,1199) size: " + serRefItem.getSize(121) + "\tSeries Instance UID: (0020,000E): " + serInstanceUID);
                                    for (int k2 = 0; k2 < serRefItem.getSize(121); ++k2) {
                                        try {
                                            sopRefItem = this.getSOPRefItem((DicomObject)serRefItem.get(121, k2));
                                            if (sopRefItem == null) continue;
                                            if (seriesRefItem == null) {
                                                seriesRefItem = new SRSeriesRefItem(sopRefItem, serInstanceUID);
                                                continue;
                                            }
                                            seriesRefItem.referencedSOPSequence.appendChild(sopRefItem);
                                            continue;
                                        }
                                        catch (Exception ex) {
                                            SRCommon.logger.log(Level.WARNING, null, ex);
                                        }
                                    }
                                }
                            }
                            if (seriesRefItem == null) continue;
                            if (studyRefItem == null) {
                                studyRefItem = new SRStudyRefItem(seriesRefItem, stdInstanceUID);
                                continue;
                            }
                            studyRefItem.referencedSeriesSequence.appendChild(seriesRefItem);
                            continue;
                        }
                        catch (Exception ex) {
                            SRCommon.logger.log(Level.WARNING, null, ex);
                        }
                    }
                }
                if (studyRefItem == null) continue;
                seq.appendChild(studyRefItem);
                continue;
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        SRCommon.logger.info("< processSOPInstanceRefMacro()");
    }

    private void processContentSQ(DicomObject dcmItem, SRContentSeq contSeq) {
        this.processContentSQ(dcmItem, contSeq, null);
    }

    private void processContentSQ(DicomObject dcmItem, SRContentSeq contSeq, String privateInfo) {
        int nrOfContentSQItems = dcmItem.getSize(1451);
        SRCommon.logger.info("> processContentSQ(): " + contSeq + " size: " + nrOfContentSQItems);
        SRContentItem srContItem = null;
        for (int i2 = 0; i2 < nrOfContentSQItems; ++i2) {
            srContItem = null;
            DicomObject item = (DicomObject)dcmItem.get(1451, i2);
            if (item == null) continue;
            try {
                DicomObject refSOPSQ;
                String valType = SRCommon.getJDTString(item, 1429);
                String relType = SRCommon.getJDTString(item, 1425);
                int nr = item.getSize(1451);
                String obsDatetimeS = SRCommon.getJDTString(item, 1428);
                SRDateTime obsDateTime = null;
                if (obsDatetimeS != null) {
                    obsDateTime = new SRDateTime(1428);
                    obsDateTime.setValue(obsDatetimeS);
                }
                DicomObject conceptNameCodeSQ = (DicomObject)item.get(1322);
                SRCode conceptName = this.getCode(conceptNameCodeSQ);
                SRCommon.logger.info("\tvalType: " + valType + "\trelType: " + relType + "\tnr: " + nr + "\tconceptName: " + conceptName);
                if (SRValueType.VT_CONTAINER.toString().equalsIgnoreCase(valType)) {
                    String contOfContent = SRCommon.getJDTString(item, 1430);
                    srContItem = new SRContainerItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, contOfContent, null, nr > 0);
                } else if (SRValueType.VT_TEXT.toString().equalsIgnoreCase(valType)) {
                    String textValue = SRCommon.getJDTString(item, 1327);
                    srContItem = new SRTextItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, textValue, nr > 0);
                } else if (SRValueType.VT_CODE.toString().equalsIgnoreCase(valType)) {
                    DicomObject conceptCodeSQ = (DicomObject)item.get(1328);
                    srContItem = new SRCodeItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, this.getCode(conceptCodeSQ), nr > 0);
                } else if (SRValueType.VT_NUM.toString().equalsIgnoreCase(valType)) {
                    DicomObject measuredValueSQ = (DicomObject)item.get(1440);
                    DicomObject measUnitSQ = (DicomObject)measuredValueSQ.get(1321);
                    String numValue = SRCommon.getJDTString(measuredValueSQ, 1329);
                    SRCommon.logger.info("\tnumValue: " + numValue);
                    srContItem = new SRNumItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, measUnitSQ == null ? null : this.getCode(measUnitSQ), numValue == null ? null : new Double(numValue), nr > 0);
                } else if (SRValueType.VT_DATE.toString().equalsIgnoreCase(valType)) {
                    srContItem = new SRDateItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, nr > 0);
                    ((SRDateItem)srContItem).date.setValue(SRCommon.getJDTString(item, 1323));
                } else if (SRValueType.VT_TIME.toString().equalsIgnoreCase(valType)) {
                    srContItem = new SRTimeItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, nr > 0);
                    ((SRTimeItem)srContItem).time.setValue(SRCommon.getJDTString(item, 1324));
                } else if (SRValueType.VT_DATETIME.toString().equalsIgnoreCase(valType)) {
                    srContItem = new SRDateTimeItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, nr > 0);
                    ((SRDateTimeItem)srContItem).dateTime.setValue(SRCommon.getJDTString(item, 1434));
                } else if (SRValueType.VT_PNAME.toString().equalsIgnoreCase(valType)) {
                    Person pName = (Person)item.get(1325);
                    srContItem = new SRPNameItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, nr > 0);
                    ((SRPNameItem)srContItem).personName.setValue(pName.toDICOMString().trim());
                } else if (SRValueType.VT_UIDREF.toString().equalsIgnoreCase(valType)) {
                    String uid = SRCommon.getJDTString(item, 1435);
                    srContItem = new SRUIDRefItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, uid, nr > 0);
                } else if (SRValueType.VT_COMPOSITE.toString().equalsIgnoreCase(valType)) {
                    refSOPSQ = (DicomObject)item.get(121);
                    srContItem = new SRCompositeItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, this.getSOPRefItem(refSOPSQ), nr > 0);
                } else if (SRValueType.VT_IMAGE.toString().equalsIgnoreCase(valType)) {
                    refSOPSQ = (DicomObject)item.get(121);
                    srContItem = new SRImageItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, this.getSOPRefItem(refSOPSQ), SRCommon.getJDTString(refSOPSQ, 117), null, null, nr > 0);
                } else if (SRValueType.VT_WAVEFORM.toString().equalsIgnoreCase(valType)) {
                    refSOPSQ = (DicomObject)item.get(121);
                    int[] refWaveformChannels = null;
                    int refWaveformChNr = refSOPSQ.getSize(1495);
                    if (refWaveformChNr > 0) {
                        refWaveformChannels = new int[refWaveformChNr];
                        for (int j2 = 0; j2 < refWaveformChNr; ++j2) {
                            refWaveformChannels[j2] = refSOPSQ.getI(1495, j2);
                        }
                    }
                    srContItem = new SRWaveformItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, this.getSOPRefItem(refSOPSQ), refWaveformChannels, nr > 0);
                } else if (SRValueType.VT_SCOORD.toString().equalsIgnoreCase(valType)) {
                    SRGraphicType graphType = SRGraphicType.getGraphicType(SRCommon.getJDTString(item, 1396));
                    double[] graphData = null;
                    Float curGraphData = null;
                    int graphDatalen = item.getSize(1395);
                    if (graphDatalen > 0) {
                        graphData = new double[graphDatalen];
                        while (graphDatalen > 0) {
                            curGraphData = (Float)item.get(1395, graphData.length - graphDatalen);
                            graphData[graphData.length - graphDatalen] = curGraphData.doubleValue();
                            --graphDatalen;
                        }
                    }
                    srContItem = new SRSCoordItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, graphData, graphType, nr > 0);
                } else if (SRValueType.VT_TCOORD.toString().equalsIgnoreCase(valType)) {
                    SRTemporalRangeType tempRangeType = SRTemporalRangeType.getTemporalRangeType(SRCommon.getJDTString(item, 1436));
                    srContItem = new SRTCoordItem(SRRelationshipType.getRelationshipType(relType), obsDateTime, conceptName, tempRangeType, SRCommon.getJDTString(item, 1438), nr > 0);
                }
                if (valType == null && item.get(1458) != null) {
                    long[] refItemIds = null;
                    Object curID = null;
                    Number curIDNum = null;
                    int refItemIdsLen = item.getSize(1458);
                    if (refItemIdsLen > 0) {
                        refItemIds = new long[refItemIdsLen];
                        while (refItemIdsLen > 0) {
                            curID = item.get(1458, refItemIds.length - refItemIdsLen);
                            if (curID instanceof Long) {
                                curIDNum = (Long)curID;
                            } else if (curID instanceof Integer) {
                                curIDNum = (Integer)curID;
                            }
                            refItemIds[refItemIds.length - refItemIdsLen] = curIDNum.longValue();
                            --refItemIdsLen;
                        }
                    }
                    srContItem = new SRReferencedItem(SRRelationshipType.getRelationshipType(relType), refItemIds);
                }
                if (srContItem == null) continue;
                contSeq.appendChild(srContItem);
                if (privateInfo != null && !privateInfo.equalsIgnoreCase("")) {
                    srContItem.xmlTag.setAttribute("app", privateInfo);
                }
                if (nr <= 0) continue;
                this.processContentSQ(item, srContItem.contentSeq);
                continue;
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
    }

    private SRSOPRefItem getSOPRefItem(DicomObject dcmItem) {
        SRSOPRefItem sopRefItem = null;
        try {
            if (dcmItem != null) {
                String refSOPClass = SRCommon.getJDTString(dcmItem, 115);
                String refSOPInstance = SRCommon.getJDTString(dcmItem, 116);
                sopRefItem = new SRSOPRefItem(refSOPClass, refSOPInstance);
            }
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
        return sopRefItem;
    }

    private SRCode getCode(DicomObject dcmItem) {
        SRCode srCode = null;
        try {
            if (dcmItem != null) {
                String codeValue = SRCommon.getJDTString(dcmItem, 91);
                String codeMeaning = SRCommon.getJDTString(dcmItem, 93);
                String schDes = SRCommon.getJDTString(dcmItem, 92);
                String schVer = SRCommon.getJDTString(dcmItem, 1337);
                srCode = new SRCode(codeValue, schDes, schVer, codeMeaning);
            }
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
        return srCode;
    }

    public static Document getDOM() {
        return srDOM;
    }

    public String getSOPClassUID() {
        return this.sopClassUID.getValue();
    }

    public String getModality() {
        return this.modality.getValue();
    }

    public String getValueType() {
        return this.valueType.getValue();
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID.getValue();
    }

    public String getPatientIdentificationKey() {
        return this.patientIdentificationKey;
    }

    public void setSOPInstanceUID(String sopInstUID) {
        this.mediaStorageSOPInstanceUID.setValue(sopInstUID);
        this.sopInstanceUID.setValue(sopInstUID);
    }

    public void writeXML() {
        this.writeDOM(new StreamResult(System.out));
    }

    public void writeXML(String fileName) throws FileNotFoundException {
        this.writeXML(new File(fileName));
    }

    public void writeXML(File file) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(file);
        StreamResult result = new StreamResult(fos);
        this.writeDOM(result);
    }

    public void saveDCM(String fileName) throws IOException, DicomException, UnknownUIDException {
        this.saveDCM(new File(fileName));
    }

    public void saveDCM(File file) throws IOException, DicomException, UnknownUIDException {
        SRCommon.logger.info("> saveDCM(): " + file);
        this.validate();
        SRDOMEncoder.encode(srDOM);
        SRDOMEncoder.saveDCM(file);
        SRCommon.logger.info("< saveDCM()");
    }

    private void writeDOM(Result res) {
        SRCommon.logger.info("> writeDOM(): " + res);
        this.validate();
        DOMSource source = new DOMSource(srDOM);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(source, res);
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
        SRCommon.logger.info("< writeDOM()");
    }

    private void validate() {
        SRDOMValidator validator = new SRDOMValidator(this);
        validator.validate();
    }

    private void createPatientIdentificationKey() {
        String name = this.patientName.isEmpty() ? null : this.patientName.getValue();
        String id = this.patientID.isEmpty() ? null : this.patientID.getValue();
        String birthDate = this.patientBirthDate.isEmpty() ? null : SRDateTime.xsDateToDICOM(this.patientBirthDate.getValue());
        String sex = this.patientSex.isEmpty() ? null : this.patientSex.getValue();
        this.patientIdentificationKey = SRCommon.getPatientIdentificationKey(name, id, birthDate, sex);
        SRCommon.logger.info("< createPatientIdentificationKey(): " + this.patientIdentificationKey);
    }

    static {
        SRCommon.logger.info("Add private entries to JDT's DDict.");
        try {
            DDict.addEntry(new DDictEntry(57, 16, 6, "PrivateCreator", "1"));
            DDict.addEntry(new DDictEntry(57, 4245, 6, "ApplicationSpecificData", "1"));
        }
        catch (DicomException dcmEx) {
            SRCommon.logger.warning("Entry already present in dictionary file");
        }
        int pr = DDict.lookupDDict(57, 4245);
        SRCommon.logger.info("\t (0039,1095): " + pr + "\tTypeCode: " + DDict.getTypeCodeName(pr) + "\tDescription: " + DDict.getDescription(pr));
    }
}

