/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import srjdom.SRCode;
import srjdom.SRCodeSeq;
import srjdom.SRContentItem;
import srjdom.SRContentTemplateItem;
import srjdom.SRDateTime;
import srjdom.SRNode;
import srjdom.SRNum;
import srjdom.SRRelationshipType;
import srjdom.SRSeq;
import srjdom.SRValueType;

public class SRNumItem
extends SRContentItem {
    SRCodeSeq measurementUnitCodeSeq = null;
    public SRCode unitCode = null;
    public SRNum numericValue = null;

    public SRNumItem(SRRelationshipType relType, SRDateTime obsDateTime, SRCode conceptName, SRCode unit, Double numValue, SRContentTemplateItem conTemplItem, boolean hasContentSeq) {
        this(relType, obsDateTime, conceptName, unit, numValue, hasContentSeq);
    }

    public SRNumItem(SRRelationshipType relType, SRDateTime obsDateTime, SRCode conceptName, SRCode unit, Number numValue, boolean hasContentSeq) {
        this.checkParams(conceptName, unit, numValue);
        this.createContentItem(relType, obsDateTime, SRValueType.VT_NUM, conceptName);
        SRSeq measuredValSeq = new SRSeq(1440, 1);
        this.xmlTag.appendChild(measuredValSeq.xmlTag);
        if (unit != null && numValue != null) {
            SRNode item = new SRNode(1186);
            measuredValSeq.appendChild(item);
            this.unitCode = unit;
            this.measurementUnitCodeSeq = new SRCodeSeq(1321, 1);
            item.xmlTag.appendChild(this.measurementUnitCodeSeq.xmlTag);
            this.measurementUnitCodeSeq.appendChild(this.unitCode);
            this.numericValue = new SRNum(1329, numValue);
            item.xmlTag.appendChild(this.numericValue.xmlTag);
        }
        this.createOptional(hasContentSeq);
    }

    private void checkParams(SRCode conceptName, SRCode unit, Number numValue) {
        if (conceptName == null) {
            throw new IllegalArgumentException("Illegal Concept Name for NUM content item: " + conceptName);
        }
        if (unit == null && numValue != null || unit != null && numValue == null) {
            throw new IllegalArgumentException("Illegal Measurement Unit: '" + unit + "' and Numeric Value: " + numValue + " for NUM content item.");
        }
    }
}

