/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import sun.misc.Unsafe;

public class CopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    final transient ReentrantLock lock = new ReentrantLock();
    private volatile transient Object[] array;
    private static final Unsafe UNSAFE;
    private static final long lockOffset;

    final Object[] getArray() {
        return this.array;
    }

    final void setArray(Object[] a) {
        this.array = a;
    }

    public CopyOnWriteArrayList() {
        this.setArray(new Object[0]);
    }

    public CopyOnWriteArrayList(Collection<? extends E> c) {
        Object[] elements;
        if (c.getClass() == CopyOnWriteArrayList.class) {
            elements = ((CopyOnWriteArrayList)c).getArray();
        } else {
            elements = c.toArray();
            if (elements.getClass() != Object[].class) {
                elements = Arrays.copyOf(elements, elements.length, Object[].class);
            }
        }
        this.setArray(elements);
    }

    public CopyOnWriteArrayList(E[] toCopyIn) {
        this.setArray(Arrays.copyOf(toCopyIn, toCopyIn.length, Object[].class));
    }

    @Override
    public int size() {
        return this.getArray().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static int indexOf(Object o, Object[] elements, int index, int fence) {
        if (o == null) {
            for (int i = index; i < fence; ++i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < fence; ++i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static int lastIndexOf(Object o, Object[] elements, int index) {
        if (o == null) {
            for (int i = index; i >= 0; --i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        Object[] elements = this.getArray();
        return CopyOnWriteArrayList.indexOf(o, elements, 0, elements.length) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        Object[] elements = this.getArray();
        return CopyOnWriteArrayList.indexOf(o, elements, 0, elements.length);
    }

    public int indexOf(E e, int index) {
        Object[] elements = this.getArray();
        return CopyOnWriteArrayList.indexOf(e, elements, index, elements.length);
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] elements = this.getArray();
        return CopyOnWriteArrayList.lastIndexOf(o, elements, elements.length - 1);
    }

    public int lastIndexOf(E e, int index) {
        Object[] elements = this.getArray();
        return CopyOnWriteArrayList.lastIndexOf(e, elements, index);
    }

    public Object clone() {
        try {
            CopyOnWriteArrayList clone = (CopyOnWriteArrayList)super.clone();
            clone.resetLock();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] elements = this.getArray();
        return Arrays.copyOf(elements, elements.length);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] elements = this.getArray();
        int len = elements.length;
        if (a.length < len) {
            return Arrays.copyOf(elements, len, a.getClass());
        }
        System.arraycopy(elements, 0, a, 0, len);
        if (a.length > len) {
            a[len] = null;
        }
        return a;
    }

    private E get(Object[] a, int index) {
        return (E)a[index];
    }

    @Override
    public E get(int index) {
        return this.get(this.getArray(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            E oldValue = this.get(elements, index);
            if (oldValue != element) {
                int len = elements.length;
                Object[] newElements = Arrays.copyOf(elements, len);
                newElements[index] = element;
                this.setArray(newElements);
            } else {
                this.setArray(elements);
            }
            E e = oldValue;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            Object[] newElements = Arrays.copyOf(elements, len + 1);
            newElements[len] = e;
            this.setArray(newElements);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] newElements;
            Object[] elements = this.getArray();
            int len = elements.length;
            if (index > len || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
            }
            int numMoved = len - index;
            if (numMoved == 0) {
                newElements = Arrays.copyOf(elements, len + 1);
            } else {
                newElements = new Object[len + 1];
                System.arraycopy(elements, 0, newElements, 0, index);
                System.arraycopy(elements, index, newElements, index + 1, numMoved);
            }
            newElements[index] = element;
            this.setArray(newElements);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            E oldValue = this.get(elements, index);
            int numMoved = len - index - 1;
            if (numMoved == 0) {
                this.setArray(Arrays.copyOf(elements, len - 1));
            } else {
                Object[] newElements = new Object[len - 1];
                System.arraycopy(elements, 0, newElements, 0, index);
                System.arraycopy(elements, index + 1, newElements, index, numMoved);
                this.setArray(newElements);
            }
            E e = oldValue;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        Object[] snapshot = this.getArray();
        int index = CopyOnWriteArrayList.indexOf(o, snapshot, 0, snapshot.length);
        return index < 0 ? false : this.remove(o, snapshot, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Object o, Object[] snapshot, int index) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl;
            int len;
            Object[] current;
            block9: {
                current = this.getArray();
                len = current.length;
                if (snapshot != current) {
                    int prefix = Math.min(index, len);
                    for (int i = 0; i < prefix; ++i) {
                        if (current[i] == snapshot[i] || !CopyOnWriteArrayList.eq(o, current[i])) continue;
                        index = i;
                        break block9;
                    }
                    if (index >= len) {
                        bl = false;
                        return bl;
                    }
                    if (current[index] != o && (index = CopyOnWriteArrayList.indexOf(o, current, index, len)) < 0) {
                        bl = false;
                        return bl;
                    }
                }
            }
            Object[] newElements = new Object[len - 1];
            System.arraycopy(current, 0, newElements, 0, index);
            System.arraycopy(current, index + 1, newElements, index, len - index - 1);
            this.setArray(newElements);
            bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRange(int fromIndex, int toIndex) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (fromIndex < 0 || toIndex > len || toIndex < fromIndex) {
                throw new IndexOutOfBoundsException();
            }
            int newlen = len - (toIndex - fromIndex);
            int numMoved = len - toIndex;
            if (numMoved == 0) {
                this.setArray(Arrays.copyOf(elements, newlen));
            } else {
                Object[] newElements = new Object[newlen];
                System.arraycopy(elements, 0, newElements, 0, fromIndex);
                System.arraycopy(elements, toIndex, newElements, fromIndex, numMoved);
                this.setArray(newElements);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public boolean addIfAbsent(E e) {
        Object[] snapshot = this.getArray();
        return CopyOnWriteArrayList.indexOf(e, snapshot, 0, snapshot.length) >= 0 ? false : this.addIfAbsent(e, snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfAbsent(E e, Object[] snapshot) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl;
            Object[] current = this.getArray();
            int len = current.length;
            if (snapshot != current) {
                int common = Math.min(snapshot.length, len);
                for (int i = 0; i < common; ++i) {
                    if (current[i] == snapshot[i] || !CopyOnWriteArrayList.eq(e, current[i])) continue;
                    boolean bl2 = false;
                    return bl2;
                }
                if (CopyOnWriteArrayList.indexOf(e, current, common, len) >= 0) {
                    bl = false;
                    return bl;
                }
            }
            Object[] newElements = Arrays.copyOf(current, len + 1);
            newElements[len] = e;
            this.setArray(newElements);
            bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Object[] elements = this.getArray();
        int len = elements.length;
        for (Object e : c) {
            if (CopyOnWriteArrayList.indexOf(e, elements, 0, len) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (len != 0) {
                int newlen = 0;
                Object[] temp = new Object[len];
                for (int i = 0; i < len; ++i) {
                    Object element = elements[i];
                    if (c.contains(element)) continue;
                    temp[newlen++] = element;
                }
                if (newlen != len) {
                    this.setArray(Arrays.copyOf(temp, newlen));
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (len != 0) {
                int newlen = 0;
                Object[] temp = new Object[len];
                for (int i = 0; i < len; ++i) {
                    Object element = elements[i];
                    if (!c.contains(element)) continue;
                    temp[newlen++] = element;
                }
                if (newlen != len) {
                    this.setArray(Arrays.copyOf(temp, newlen));
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection<? extends E> c) {
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            int added = 0;
            for (int i = 0; i < cs.length; ++i) {
                Object e = cs[i];
                if (CopyOnWriteArrayList.indexOf(e, elements, 0, len) >= 0 || CopyOnWriteArrayList.indexOf(e, cs, 0, added) >= 0) continue;
                cs[added++] = e;
            }
            if (added > 0) {
                Object[] newElements = Arrays.copyOf(elements, len + added);
                System.arraycopy(cs, 0, newElements, len, added);
                this.setArray(newElements);
            }
            int n = added;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.setArray(new Object[0]);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] cs;
        Object[] objectArray = cs = c.getClass() == CopyOnWriteArrayList.class ? ((CopyOnWriteArrayList)c).getArray() : c.toArray();
        if (cs.length == 0) {
            return false;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (len == 0 && cs.getClass() == Object[].class) {
                this.setArray(cs);
            } else {
                Object[] newElements = Arrays.copyOf(elements, len + cs.length);
                System.arraycopy(cs, 0, newElements, len, cs.length);
                this.setArray(newElements);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Object[] cs = c.toArray();
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] newElements;
            Object[] elements = this.getArray();
            int len = elements.length;
            if (index > len || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
            }
            if (cs.length == 0) {
                boolean bl = false;
                return bl;
            }
            int numMoved = len - index;
            if (numMoved == 0) {
                newElements = Arrays.copyOf(elements, len + cs.length);
            } else {
                newElements = new Object[len + cs.length];
                System.arraycopy(elements, 0, newElements, 0, index);
                System.arraycopy(elements, index, newElements, index + cs.length, numMoved);
            }
            System.arraycopy(cs, 0, newElements, index, cs.length);
            this.setArray(newElements);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        for (Object e : this.getArray()) {
            action.accept(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (len != 0) {
                int newlen = 0;
                Object[] temp = new Object[len];
                for (int i = 0; i < len; ++i) {
                    Object e = elements[i];
                    if (filter.test(e)) continue;
                    temp[newlen++] = e;
                }
                if (newlen != len) {
                    this.setArray(Arrays.copyOf(temp, newlen));
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        if (operator == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            Object[] newElements = Arrays.copyOf(elements, len);
            for (int i = 0; i < len; ++i) {
                Object e = elements[i];
                newElements[i] = operator.apply(e);
            }
            this.setArray(newElements);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(Comparator<? super E> c) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] newElements;
            Object[] elements = this.getArray();
            Object[] es = newElements = Arrays.copyOf(elements, elements.length);
            Arrays.sort(es, c);
            this.setArray(newElements);
        }
        finally {
            lock.unlock();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] elements = this.getArray();
        s.writeInt(elements.length);
        for (Object element : elements) {
            s.writeObject(element);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.resetLock();
        int len = s.readInt();
        Object[] elements = new Object[len];
        for (int i = 0; i < len; ++i) {
            elements[i] = s.readObject();
        }
        this.setArray(elements);
    }

    public String toString() {
        return Arrays.toString(this.getArray());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        Iterator it = list.iterator();
        Object[] elements = this.getArray();
        int len = elements.length;
        for (int i = 0; i < len; ++i) {
            if (it.hasNext() && CopyOnWriteArrayList.eq(elements[i], it.next())) continue;
            return false;
        }
        return !it.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object obj : this.getArray()) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public Iterator<E> iterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Object[] elements = this.getArray();
        int len = elements.length;
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new COWIterator(elements, index);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.getArray(), 1040);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (fromIndex < 0 || toIndex > len || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException();
            }
            COWSubList cOWSubList = new COWSubList(this, fromIndex, toIndex);
            return cOWSubList;
        }
        finally {
            lock.unlock();
        }
    }

    private void resetLock() {
        UNSAFE.putObjectVolatile(this, lockOffset, new ReentrantLock());
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<CopyOnWriteArrayList> k = CopyOnWriteArrayList.class;
            lockOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("lock"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static class COWSubListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> it;
        private final int offset;
        private final int size;

        COWSubListIterator(List<E> l, int index, int offset, int size) {
            this.offset = offset;
            this.size = size;
            this.it = l.listIterator(index + offset);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.it.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.it.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex() - this.offset;
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex() - this.offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int s = this.size;
            ListIterator<E> i = this.it;
            while (this.nextIndex() < s) {
                action.accept(i.next());
            }
        }
    }

    private static class COWSubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final CopyOnWriteArrayList<E> l;
        private final int offset;
        private int size;
        private Object[] expectedArray;

        COWSubList(CopyOnWriteArrayList<E> list, int fromIndex, int toIndex) {
            this.l = list;
            this.expectedArray = this.l.getArray();
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        private void checkForComodification() {
            if (this.l.getArray() != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int index, E element) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.rangeCheck(index);
                this.checkForComodification();
                E x = this.l.set(index + this.offset, element);
                this.expectedArray = this.l.getArray();
                E e = x;
                return e;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int index) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.rangeCheck(index);
                this.checkForComodification();
                E e = this.l.get(index + this.offset);
                return e;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public int size() {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.checkForComodification();
                int n = this.size;
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E element) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.checkForComodification();
                if (index < 0 || index > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(index + this.offset, element);
                this.expectedArray = this.l.getArray();
                ++this.size;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void clear() {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.checkForComodification();
                this.l.removeRange(this.offset, this.offset + this.size);
                this.expectedArray = this.l.getArray();
                this.size = 0;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.rangeCheck(index);
                this.checkForComodification();
                E result = this.l.remove(index + this.offset);
                this.expectedArray = this.l.getArray();
                --this.size;
                E e = result;
                return e;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean remove(Object o) {
            int index = this.indexOf(o);
            if (index == -1) {
                return false;
            }
            this.remove(index);
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.checkForComodification();
                COWSubListIterator<E> cOWSubListIterator = new COWSubListIterator<E>(this.l, 0, this.offset, this.size);
                return cOWSubListIterator;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int index) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.checkForComodification();
                if (index < 0 || index > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
                }
                COWSubListIterator<E> cOWSubListIterator = new COWSubListIterator<E>(this.l, index, this.offset, this.size);
                return cOWSubListIterator;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.checkForComodification();
                if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
                    throw new IndexOutOfBoundsException();
                }
                COWSubList<E> cOWSubList = new COWSubList<E>(this.l, fromIndex + this.offset, toIndex + this.offset);
                return cOWSubList;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int lo = this.offset;
            int hi = this.offset + this.size;
            Object[] a = this.expectedArray;
            if (this.l.getArray() != a) {
                throw new ConcurrentModificationException();
            }
            if (lo < 0 || hi > a.length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = lo; i < hi; ++i) {
                Object e = a[i];
                action.accept(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            if (operator == null) {
                throw new NullPointerException();
            }
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                int lo = this.offset;
                int hi = this.offset + this.size;
                Object[] elements = this.expectedArray;
                if (this.l.getArray() != elements) {
                    throw new ConcurrentModificationException();
                }
                int len = elements.length;
                if (lo < 0 || hi > len) {
                    throw new IndexOutOfBoundsException();
                }
                Object[] newElements = Arrays.copyOf(elements, len);
                for (int i = lo; i < hi; ++i) {
                    Object e = elements[i];
                    newElements[i] = operator.apply(e);
                }
                this.expectedArray = newElements;
                this.l.setArray(newElements);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator<? super E> c) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                Object[] newElements;
                int lo = this.offset;
                int hi = this.offset + this.size;
                Object[] elements = this.expectedArray;
                if (this.l.getArray() != elements) {
                    throw new ConcurrentModificationException();
                }
                int len = elements.length;
                if (lo < 0 || hi > len) {
                    throw new IndexOutOfBoundsException();
                }
                Object[] es = newElements = Arrays.copyOf(elements, len);
                Arrays.sort(es, lo, hi, c);
                this.expectedArray = newElements;
                this.l.setArray(newElements);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            boolean removed = false;
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                int n = this.size;
                if (n > 0) {
                    int lo = this.offset;
                    int hi = this.offset + n;
                    Object[] elements = this.expectedArray;
                    if (this.l.getArray() != elements) {
                        throw new ConcurrentModificationException();
                    }
                    int len = elements.length;
                    if (lo < 0 || hi > len) {
                        throw new IndexOutOfBoundsException();
                    }
                    int newSize = 0;
                    Object[] temp = new Object[n];
                    for (int i = lo; i < hi; ++i) {
                        Object element = elements[i];
                        if (c.contains(element)) continue;
                        temp[newSize++] = element;
                    }
                    if (newSize != n) {
                        Object[] newElements = new Object[len - n + newSize];
                        System.arraycopy(elements, 0, newElements, 0, lo);
                        System.arraycopy(temp, 0, newElements, lo, newSize);
                        System.arraycopy(elements, hi, newElements, lo + newSize, len - hi);
                        this.size = newSize;
                        removed = true;
                        this.expectedArray = newElements;
                        this.l.setArray(newElements);
                    }
                }
            }
            finally {
                lock.unlock();
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            boolean removed = false;
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                int n = this.size;
                if (n > 0) {
                    int lo = this.offset;
                    int hi = this.offset + n;
                    Object[] elements = this.expectedArray;
                    if (this.l.getArray() != elements) {
                        throw new ConcurrentModificationException();
                    }
                    int len = elements.length;
                    if (lo < 0 || hi > len) {
                        throw new IndexOutOfBoundsException();
                    }
                    int newSize = 0;
                    Object[] temp = new Object[n];
                    for (int i = lo; i < hi; ++i) {
                        Object element = elements[i];
                        if (!c.contains(element)) continue;
                        temp[newSize++] = element;
                    }
                    if (newSize != n) {
                        Object[] newElements = new Object[len - n + newSize];
                        System.arraycopy(elements, 0, newElements, 0, lo);
                        System.arraycopy(temp, 0, newElements, lo, newSize);
                        System.arraycopy(elements, hi, newElements, lo + newSize, len - hi);
                        this.size = newSize;
                        removed = true;
                        this.expectedArray = newElements;
                        this.l.setArray(newElements);
                    }
                }
            }
            finally {
                lock.unlock();
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            boolean removed = false;
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                int n = this.size;
                if (n > 0) {
                    int lo = this.offset;
                    int hi = this.offset + n;
                    Object[] elements = this.expectedArray;
                    if (this.l.getArray() != elements) {
                        throw new ConcurrentModificationException();
                    }
                    int len = elements.length;
                    if (lo < 0 || hi > len) {
                        throw new IndexOutOfBoundsException();
                    }
                    int newSize = 0;
                    Object[] temp = new Object[n];
                    for (int i = lo; i < hi; ++i) {
                        Object e = elements[i];
                        if (filter.test(e)) continue;
                        temp[newSize++] = e;
                    }
                    if (newSize != n) {
                        Object[] newElements = new Object[len - n + newSize];
                        System.arraycopy(elements, 0, newElements, 0, lo);
                        System.arraycopy(temp, 0, newElements, lo, newSize);
                        System.arraycopy(elements, hi, newElements, lo + newSize, len - hi);
                        this.size = newSize;
                        removed = true;
                        this.expectedArray = newElements;
                        this.l.setArray(newElements);
                    }
                }
            }
            finally {
                lock.unlock();
            }
            return removed;
        }

        @Override
        public Spliterator<E> spliterator() {
            int lo = this.offset;
            int hi = this.offset + this.size;
            Object[] a = this.expectedArray;
            if (this.l.getArray() != a) {
                throw new ConcurrentModificationException();
            }
            if (lo < 0 || hi > a.length) {
                throw new IndexOutOfBoundsException();
            }
            return Spliterators.spliterator(a, lo, hi, 1040);
        }
    }

    static final class COWIterator<E>
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;

        private COWIterator(Object[] elements, int initialCursor) {
            this.cursor = initialCursor;
            this.snapshot = elements;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[--this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            Object[] elements = this.snapshot;
            int size = elements.length;
            for (int i = this.cursor; i < size; ++i) {
                Object e = elements[i];
                action.accept(e);
            }
            this.cursor = size;
        }
    }
}

