/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.ScrollPaneAdjustable;
import java.awt.peer.ScrollPanePeer;
import sun.awt.AWTAccessor;
import sun.awt.PeerEvent;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WToolkit;
import sun.util.logging.PlatformLogger;

final class WScrollPanePeer
extends WPanelPeer
implements ScrollPanePeer {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.windows.WScrollPanePeer");
    int scrollbarWidth = this._getVScrollbarWidth();
    int scrollbarHeight = this._getHScrollbarHeight();
    int prevx;
    int prevy;

    static native void initIDs();

    @Override
    native void create(WComponentPeer var1);

    native int getOffset(int var1);

    WScrollPanePeer(Component target) {
        super(target);
    }

    @Override
    void initialize() {
        super.initialize();
        this.setInsets();
        Insets i = this.getInsets();
        this.setScrollPosition(-i.left, -i.top);
    }

    @Override
    public void setUnitIncrement(Adjustable adj, int p) {
    }

    @Override
    public Insets insets() {
        return this.getInsets();
    }

    private native void setInsets();

    @Override
    public synchronized native void setScrollPosition(int var1, int var2);

    @Override
    public int getHScrollbarHeight() {
        return this.scrollbarHeight;
    }

    private native int _getHScrollbarHeight();

    @Override
    public int getVScrollbarWidth() {
        return this.scrollbarWidth;
    }

    private native int _getVScrollbarWidth();

    public Point getScrollOffset() {
        int x = this.getOffset(0);
        int y = this.getOffset(1);
        return new Point(x, y);
    }

    @Override
    public void childResized(int width, int height) {
        ScrollPane sp = (ScrollPane)this.target;
        Dimension vs = sp.getSize();
        this.setSpans(vs.width, vs.height, width, height);
        this.setInsets();
    }

    synchronized native void setSpans(int var1, int var2, int var3, int var4);

    @Override
    public void setValue(Adjustable adj, int v) {
        Component c = this.getScrollChild();
        if (c == null) {
            return;
        }
        Point p = c.getLocation();
        switch (adj.getOrientation()) {
            case 1: {
                this.setScrollPosition(-p.x, v);
                break;
            }
            case 0: {
                this.setScrollPosition(v, -p.y);
            }
        }
    }

    private Component getScrollChild() {
        ScrollPane sp = (ScrollPane)this.target;
        Component child = null;
        try {
            child = sp.getComponent(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return child;
    }

    private void postScrollEvent(int orient, int type, int pos, boolean isAdjusting) {
        Adjustor adjustor = new Adjustor(orient, type, pos, isAdjusting);
        WToolkit.executeOnEventHandlerThread(new ScrollEvent(this.target, adjustor));
    }

    static {
        WScrollPanePeer.initIDs();
    }

    class Adjustor
    implements Runnable {
        int orient;
        int type;
        int pos;
        boolean isAdjusting;

        Adjustor(int orient, int type, int pos, boolean isAdjusting) {
            this.orient = orient;
            this.type = type;
            this.pos = pos;
            this.isAdjusting = isAdjusting;
        }

        @Override
        public void run() {
            Component hwAncestor;
            if (WScrollPanePeer.this.getScrollChild() == null) {
                return;
            }
            ScrollPane sp = (ScrollPane)WScrollPanePeer.this.target;
            ScrollPaneAdjustable adj = null;
            if (this.orient == 1) {
                adj = (ScrollPaneAdjustable)sp.getVAdjustable();
            } else if (this.orient == 0) {
                adj = (ScrollPaneAdjustable)sp.getHAdjustable();
            } else if (log.isLoggable(PlatformLogger.Level.FINE)) {
                log.fine("Assertion failed: unknown orient");
            }
            if (adj == null) {
                return;
            }
            int newpos = adj.getValue();
            switch (this.type) {
                case 2: {
                    newpos -= adj.getUnitIncrement();
                    break;
                }
                case 1: {
                    newpos += adj.getUnitIncrement();
                    break;
                }
                case 3: {
                    newpos -= adj.getBlockIncrement();
                    break;
                }
                case 4: {
                    newpos += adj.getBlockIncrement();
                    break;
                }
                case 5: {
                    newpos = this.pos;
                    break;
                }
                default: {
                    if (log.isLoggable(PlatformLogger.Level.FINE)) {
                        log.fine("Assertion failed: unknown type");
                    }
                    return;
                }
            }
            newpos = Math.max(adj.getMinimum(), newpos);
            newpos = Math.min(adj.getMaximum(), newpos);
            adj.setValueIsAdjusting(this.isAdjusting);
            AWTAccessor.getScrollPaneAdjustableAccessor().setTypedValue(adj, newpos, this.type);
            for (hwAncestor = WScrollPanePeer.this.getScrollChild(); hwAncestor != null && !(hwAncestor.getPeer() instanceof WComponentPeer); hwAncestor = hwAncestor.getParent()) {
            }
            if (log.isLoggable(PlatformLogger.Level.FINE) && hwAncestor == null) {
                log.fine("Assertion (hwAncestor != null) failed, couldn't find heavyweight ancestor of scroll pane child");
            }
            WComponentPeer hwPeer = (WComponentPeer)hwAncestor.getPeer();
            hwPeer.paintDamagedAreaImmediately();
        }
    }

    class ScrollEvent
    extends PeerEvent {
        ScrollEvent(Object source, Runnable runnable) {
            super(source, runnable, 0L);
        }

        @Override
        public PeerEvent coalesceEvents(PeerEvent newEvent) {
            if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                log.finest("ScrollEvent coalesced: " + newEvent);
            }
            if (newEvent instanceof ScrollEvent) {
                return newEvent;
            }
            return null;
        }
    }
}

