/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int primeSize = 1024;
    private int exponentSize = 0;
    private SecureRandom random = null;

    private static void checkKeySize(int keysize) throws InvalidParameterException {
        if (keysize != 2048 && keysize != 4096 && (keysize < 512 || keysize > 1024 || keysize % 64 != 0)) {
            throw new InvalidParameterException("DH key size must be multiple of 64 and range from 512 to 1024 (inclusive), or 2048, or 4096. The specific key size " + keysize + " is not supported");
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        DHParameterGenerator.checkKeySize(keysize);
        this.primeSize = keysize;
        this.random = random;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(genParamSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        DHGenParameterSpec dhParamSpec = (DHGenParameterSpec)genParamSpec;
        this.primeSize = dhParamSpec.getPrimeSize();
        try {
            DHParameterGenerator.checkKeySize(this.primeSize);
        }
        catch (InvalidParameterException ipe) {
            throw new InvalidAlgorithmParameterException(ipe.getMessage());
        }
        this.exponentSize = dhParamSpec.getExponentSize();
        if (this.exponentSize <= 0) {
            throw new InvalidAlgorithmParameterException("Exponent size must be greater than zero");
        }
        if (this.exponentSize >= this.primeSize) {
            throw new InvalidAlgorithmParameterException("Exponent size must be less than modulus size");
        }
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters algParams = null;
        if (this.exponentSize == 0) {
            this.exponentSize = this.primeSize - 1;
        }
        if (this.random == null) {
            this.random = SunJCE.getRandom();
        }
        try {
            AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance("DSA");
            paramGen.init(this.primeSize, this.random);
            algParams = paramGen.generateParameters();
            DSAParameterSpec dsaParamSpec = algParams.getParameterSpec(DSAParameterSpec.class);
            DHParameterSpec dhParamSpec = this.exponentSize > 0 ? new DHParameterSpec(dsaParamSpec.getP(), dsaParamSpec.getG(), this.exponentSize) : new DHParameterSpec(dsaParamSpec.getP(), dsaParamSpec.getG());
            algParams = AlgorithmParameters.getInstance("DH", SunJCE.getInstance());
            algParams.init(dhParamSpec);
        }
        catch (InvalidParameterSpecException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        return algParams;
    }
}

