/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ATValue;
import com.archimed.dicom.DDate;
import com.archimed.dicom.DDateRange;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictBase;
import com.archimed.dicom.DDictEntry;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.DicomWriter;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.GroupList;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.Offsets;
import com.archimed.dicom.Person;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.TransferSyntaxUID;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.c;
import com.archimed.dicom.charset.DicomCharset;
import com.archimed.dicom.l;
import com.archimed.dicom.p;
import com.archimed.dicom.u;
import com.archimed.log.JdtLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DicomObject
extends GroupList {
    static final int SEQITEM_NEW = 1;
    static final int SEQITEM_UNDEFLEN = 2;
    static final int SEQITEM_DEFLEN = 3;
    DicomObject filemetainfo = null;
    long offset = 0L;
    int length = 0;
    private DicomObject int = null;
    private int for = 1;
    private byte[] if;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomObject.class);
    private static final DicomCharset[] do = new DicomCharset[]{DicomCharset.DEFAULT};

    public DicomObject() {
        this(null);
    }

    DicomObject(DicomObject dicomObject) {
        this.int = dicomObject;
    }

    public DicomObject getParent() {
        return this.int;
    }

    void setParent(DicomObject dicomObject) {
        this.int = dicomObject;
    }

    public DicomCharset[] dicomCharsets() {
        DicomObject dicomObject = this;
        while (dicomObject.getParent() != null) {
            dicomObject = dicomObject.getParent();
        }
        int n2 = dicomObject.getSize(57);
        if (n2 <= 0) {
            return do;
        }
        try {
            DicomCharset[] dicomCharsetArray = new DicomCharset[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = dicomObject.getString(57, i2, true);
                dicomCharsetArray[i2] = DicomCharset.lookup(string);
                if (dicomCharsetArray[i2] != null) continue;
                this.log.warn("specified character set '" + string + "' unknown,using default.");
                return do;
            }
            return dicomCharsetArray;
        }
        catch (DicomException dicomException) {
            this.log.error("Error while initializing character sets,reverting to default charset ", dicomException);
            return do;
        }
    }

    public void setSeqItemLenState(int n2) {
        this.for = n2;
    }

    public int getSeqItemLenState() {
        return this.for;
    }

    public void setPreamble(byte[] byArray) {
        if (byArray != null && byArray.length != 128) {
            throw new IllegalArgumentException("preamble must be exactly 128 bytes");
        }
        this.if = byArray;
    }

    public byte[] getPreamble() {
        return this.if;
    }

    public DataElement newDataElement(int n2) {
        return this.newDataElement_ge(DDict.getGroup(n2), this.a(n2, true));
    }

    public DataElement newDataElement_ge(int n2, int n3) {
        int n4 = DDict.getTypeCode(n2, n3);
        c c2 = new c(this, n2, n3, n4);
        this.push(c2);
        return c2;
    }

    private DataElement a(int n2, int n3, boolean bl) {
        DataElement dataElement = this.getVR(n2, n3);
        if (dataElement == null && bl) {
            dataElement = this.newDataElement_ge(n2, n3);
        }
        return dataElement;
    }

    private int a(int n2, boolean bl) {
        DDictEntry dDictEntry = DDict.getEntry(n2);
        if (dDictEntry == null) {
            throw new IllegalArgumentException("unknown DDict constant: " + n2);
        }
        int n3 = dDictEntry.getGroup();
        int n4 = dDictEntry.getElement();
        String string = dDictEntry.getPrivateCreatorID();
        if (!DDictBase.isPrivateTag(n3, n4)) {
            return n4;
        }
        if (string == null) {
            this.log.warn("Private Creator ID not set in DicomObject.Element number of private tag " + DumpUtils.tagString(n3, n4) + " will be unadjusted.");
            return n4;
        }
        String string2 = null;
        int n5 = -1;
        for (int i2 = 16; i2 <= 255; ++i2) {
            if (this.getSize_ge(n3, i2) > 0) {
                try {
                    string2 = this.getString_ge(n3, i2, 0);
                }
                catch (DicomException dicomException) {
                    this.log.warn("DicomException while getting private creator: " + dicomException);
                    return n4;
                }
            } else {
                string2 = null;
            }
            if (string2 != null && string.equals(string2)) {
                return i2 << 8 | n4;
            }
            if (string2 != null || n5 != -1) continue;
            n5 = i2;
        }
        if (!bl) {
            this.log.warn("Private Creator ID " + string + " not found in DicomObject.Element number of private tag " + DumpUtils.tagString(n3, n4) + " will be unadjusted.");
            return n4;
        }
        this.log.debug("adding new Private Creator ID " + string + " at " + DumpUtils.tagString(n3, n5));
        try {
            this.setString_ge(n3, n5, string, 0);
        }
        catch (DicomException dicomException) {
            this.log.warn("DicomException when setting private creator '" + string + "', element unadjusted");
            return n4;
        }
        return n5 << 8 | n4;
    }

    private int a(String string, int n2) throws DicomException {
        for (int i2 = 16; i2 <= 255; ++i2) {
            String string2 = this.getString_ge(n2, i2, 0);
            if (string2 == null || !string.equals(string2)) continue;
            return i2 << 8;
        }
        return -1;
    }

    private void a(int n2, int n3, int n4, Object object, int n5) throws DicomException {
        Object var6_6 = null;
        c c2 = (c)this.a(n2, n3, true);
        this.log.debug("DicomObject.addValue " + (c2 == null ? "<new>, index: " : "<old>, index: ") + n5 + ", type: " + (object == null ? "null" : object.getClass().getName()) + " " + DumpUtils.tagDescriptionString(n2, n3));
        if (c2 == null) {
            c2 = new c(this, n2, n3, n4);
            this.push(c2);
        }
        if (n5 > c2.val.size()) {
            throw new DicomException("Index (" + n5 + ") exceeds bounds of Data Element");
        }
        try {
            if (object == null) {
                return;
            }
            if (object instanceof String) {
                switch (n4) {
                    case 1: 
                    case 3: 
                    case 8: 
                    case 19: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 29: {
                        if (!object.equals("") || n5 != 0) break;
                        return;
                    }
                }
                if (n5 == c2.size()) {
                    c2.addString((String)object);
                } else {
                    c2.setString((String)object, n5);
                }
                return;
            }
            if (object instanceof byte[]) {
                if (n5 == c2.size()) {
                    c2.addBytes((byte[])object);
                } else {
                    c2.setBytes((byte[])object, n5);
                }
                return;
            }
            if (object instanceof Integer) {
                if (c2.dcm_type == 21) {
                    c2.dcm_type = 3;
                }
                if (n5 == c2.size()) {
                    c2.addInteger((Integer)object);
                } else {
                    c2.setInteger((Integer)object, n5);
                }
                return;
            }
            if (object instanceof Float) {
                if (n5 == c2.size()) {
                    c2.addFloat((Float)object);
                } else {
                    c2.setFloat((Float)object, n5);
                }
                return;
            }
            if (object instanceof Double) {
                if (n5 == c2.size()) {
                    c2.addDouble((Double)object);
                } else {
                    c2.setDouble((Double)object, n5);
                }
                return;
            }
            if (object instanceof Person) {
                if (n5 == c2.size()) {
                    c2.addPersonName((Person)object);
                } else {
                    c2.setPersonName((Person)object, n5);
                }
                return;
            }
            if (object instanceof DDate) {
                if (n5 == c2.size()) {
                    c2.addString(((DDate)object).toDICOMString());
                } else {
                    c2.setString(((DDate)object).toDICOMString(), n5);
                }
                return;
            }
            if (object instanceof DDateRange) {
                if (n5 == c2.size()) {
                    c2.addString(((DDateRange)object).toDICOMString());
                } else {
                    c2.setString(((DDateRange)object).toDICOMString(), n5);
                }
                return;
            }
            if (object instanceof Short) {
                if (c2.dcm_type == 21) {
                    c2.dcm_type = 23;
                }
                if (n5 == c2.size()) {
                    c2.addShort((Short)object);
                } else {
                    c2.setShort((Short)object, n5);
                }
                return;
            }
            if (object instanceof Long) {
                if (n5 == c2.size()) {
                    c2.addLong((Long)object);
                } else {
                    c2.setLong((Long)object, n5);
                }
                return;
            }
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                if (nArray.length != 2) {
                    throw new DicomException("Only int[] of length 2 can be converted to ATValue");
                }
                if (n5 == c2.size()) {
                    c2.addATValue(new ATValue(nArray[0], nArray[1]));
                } else {
                    c2.setATValue(new ATValue(nArray[0], nArray[1]), n5);
                }
                return;
            }
            if (object instanceof float[]) {
                if (n5 == c2.size()) {
                    c2.addFloats((float[])object);
                } else {
                    c2.setFloats((float[])object, n5);
                }
                return;
            }
            if (object instanceof DicomObject) {
                if (n5 == c2.size()) {
                    c2.addSequenceItem((DicomObject)object);
                } else {
                    c2.setSequenceItem((DicomObject)object, n5);
                }
                return;
            }
            if (object instanceof SOPClassUID) {
                SOPClassUID sOPClassUID = (SOPClassUID)object;
                if (n5 == c2.size()) {
                    c2.addString(sOPClassUID.getValue());
                } else {
                    c2.setString(sOPClassUID.getValue(), n5);
                }
                return;
            }
            if (object instanceof TransferSyntaxUID) {
                TransferSyntaxUID transferSyntaxUID = (TransferSyntaxUID)object;
                if (n5 == c2.size()) {
                    c2.addString(transferSyntaxUID.getValue());
                } else {
                    c2.setString(transferSyntaxUID.getValue(), n5);
                }
                return;
            }
            throw new DicomException("Unsupported type in argument: " + object.getClass().getName());
        }
        catch (DicomException dicomException) {
            throw new DicomException(n2, n3, dicomException.getMessage());
        }
    }

    public void set(int n2, Object object) throws DicomException {
        int n3 = DDict.getGroup(n2);
        int n4 = this.a(n2, true);
        this.set_ge(n3, n4, object);
    }

    public void set_ge(int n2, int n3, Object object) throws DicomException {
        this.deleteItem_ge(n2, n3);
        this.set_ge(n2, n3, object, 0);
    }

    public void append(int n2, Object object) throws DicomException {
        int n3 = DDict.getGroup(n2);
        int n4 = this.a(n2, true);
        this.append_ge(n3, n4, object);
    }

    public void append_ge(int n2, int n3, Object object) throws DicomException {
        if (object != null) {
            int n4 = this.getSize_ge(n2, n3);
            if (n4 == -1) {
                n4 = 0;
            }
            this.set_ge(n2, n3, object, n4);
        }
    }

    public void set(int n2, Object object, int n3) throws DicomException {
        int n4 = DDict.getGroup(n2);
        int n5 = this.a(n2, true);
        this.set_ge(n4, n5, object, n3);
    }

    public void set_ge(int n2, int n3, Object object, int n4) throws DicomException {
        int n5 = DDict.getTypeCode(n2, n3);
        this.a(n2, n3, n5, object, n4);
    }

    public int getType(int n2) throws DicomException {
        int n3 = DDict.getGroup(n2);
        int n4 = this.a(n2, false);
        return this.getType_ge(n3, n4);
    }

    public int getType_ge(int n2, int n3) throws DicomException {
        c c2 = (c)this.a(n2, n3, false);
        if (c2 == null) {
            throw new DicomException("no such tag in DicomObject");
        }
        return c2.dcm_type;
    }

    public void setType(int n2, int n3) throws DicomException {
        int n4 = DDict.getGroup(n2);
        int n5 = this.a(n2, false);
        this.setType_ge(n4, n5, n3);
    }

    public void setType_ge(int n2, int n3, int n4) throws DicomException {
        c c2;
        DDict.getTypeName(n4);
        int n5 = this.getType_ge(n2, n3);
        switch (n5) {
            case 21: {
                if (n4 == 3 || n4 == 23) break;
                throw new DicomException("Illegal new type: new VR type must be tUS or tSS");
            }
            case 22: {
                if (n4 == 24 || n4 == 8) break;
                throw new DicomException("Illegal new type: new VR type must be tOW or tOB");
            }
            case 3: 
            case 23: {
                return;
            }
            default: {
                throw new DicomException("current type must be tUS_US or tOW_OB");
            }
        }
        if ((c2 = (c)this.a(n2, n3, false)) == null) {
            throw new DicomException("no such tag in DicomObject");
        }
        c2.dcm_type = n4;
    }

    public void setSeqLenState_ge(int n2, int n3, int n4) throws DicomException {
        c c2 = (c)this.a(n2, n3, false);
        if (c2 == null) {
            throw new DicomException("no such tag in DicomObject");
        }
        c2.goto = n4;
    }

    public void setSeqLenState(int n2, int n3) throws DicomException {
        int n4 = DDict.getGroup(n2);
        int n5 = this.a(n2, true);
        this.setSeqLenState_ge(n4, n5, n3);
    }

    public int getSeqLenState_ge(int n2, int n3) throws DicomException {
        c c2 = (c)this.a(n2, n3, false);
        if (c2 == null) {
            throw new DicomException("no such tag in DicomObject");
        }
        return c2.goto;
    }

    public int getSeqLenState(int n2) throws DicomException {
        int n3 = DDict.getGroup(n2);
        int n4 = this.a(n2, false);
        return this.getSeqLenState_ge(n3, n4);
    }

    public int getSize(int n2) {
        int n3 = DDict.getGroup(n2);
        int n4 = this.a(n2, false);
        return this.getSize_ge(n3, n4);
    }

    public int getSize_ge(int n2, int n3) {
        c c2 = (c)this.a(n2, n3, false);
        if (c2 == null) {
            return -1;
        }
        return c2.val.size();
    }

    public long calculateOffset(int n2, int n3, int n4, boolean bl, boolean bl2) {
        return new Offsets(this).calculateOffset(n2, n3, n4, bl, bl2, true);
    }

    public long getOffset(int n2, int n3) {
        c c2 = (c)this.a(DDict.getGroup(n2), this.a(n2, false), false);
        if (c2 == (c)null) {
            return 0L;
        }
        if (n3 >= c2.val.size()) {
            return 0L;
        }
        if (c2.dcm_type != 10) {
            return 0L;
        }
        return ((DicomObject)c2.val.elementAt((int)n3)).offset;
    }

    public String getString(int n2, int n3) throws DicomException {
        return this.getString(n2, n3, true);
    }

    public String getString(int n2, int n3, boolean bl) throws DicomException {
        return this.getString_ge(DDict.getGroup(n2), this.a(n2, false), n3, bl);
    }

    public String getString_ge(int n2, int n3, int n4) throws DicomException {
        return this.getString_ge(n2, n3, n4, true);
    }

    public String getString_ge(int n2, int n3, int n4, boolean bl) throws DicomException {
        DataElement dataElement = this.a(n2, n3, false);
        return dataElement == null ? null : dataElement.getString(n4);
    }

    public void setString(int n2, String string, int n3) throws DicomException {
        this.setString_ge(DDict.getGroup(n2), this.a(n2, true), string, n3);
    }

    public void setString_ge(int n2, int n3, String string, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setString(string, n4);
    }

    public void addString(int n2, String string) throws DicomException {
        this.addString_ge(DDict.getGroup(n2), this.a(n2, true), string);
    }

    public void addString_ge(int n2, int n3, String string) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addString(string);
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws DicomException {
        return this.getBigDecimal_ge(DDict.getGroup(n2), this.a(n2, false), n3);
    }

    public BigDecimal getBigDecimal_ge(int n2, int n3, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, false);
        if (dataElement == null) {
            return null;
        }
        return dataElement.getBigDecimal(n4);
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal, int n3) throws DicomException {
        this.setBigDecimal_ge(DDict.getGroup(n2), this.a(n2, true), bigDecimal, n3);
    }

    public void setBigDecimal_ge(int n2, int n3, BigDecimal bigDecimal, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setBigDecimal(bigDecimal, n4);
    }

    public void addBigDecimal(int n2, BigDecimal bigDecimal) throws DicomException {
        this.addBigDecimal_ge(DDict.getGroup(n2), this.a(n2, true), bigDecimal);
    }

    public void addBigDecimal_ge(int n2, int n3, BigDecimal bigDecimal) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addBigDecimal(bigDecimal);
    }

    public Short getShort(int n2, int n3) throws DicomException {
        return this.getShort_ge(DDict.getGroup(n2), this.a(n2, false), n3);
    }

    public Short getShort_ge(int n2, int n3, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, false);
        return dataElement == null ? null : dataElement.getShort(n4);
    }

    public void setShort(int n2, Short s2, int n3) throws DicomException {
        this.setShort_ge(DDict.getGroup(n2), this.a(n2, true), s2, n3);
    }

    public void setShort_ge(int n2, int n3, Short s2, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setShort(s2, n4);
    }

    public void addShort(int n2, Short s2) throws DicomException {
        this.addShort_ge(DDict.getGroup(n2), this.a(n2, true), s2);
    }

    public void addShort_ge(int n2, int n3, Short s2) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addShort(s2);
    }

    public Integer getInteger(int n2, int n3) throws DicomException {
        return this.getInteger_ge(DDict.getGroup(n2), this.a(n2, false), n3);
    }

    public Integer getInteger_ge(int n2, int n3, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, false);
        return dataElement == null ? null : dataElement.getInteger(n4);
    }

    public void setInteger(int n2, Integer n3, int n4) throws DicomException {
        this.setInteger_ge(DDict.getGroup(n2), this.a(n2, true), n3, n4);
    }

    public void setInteger_ge(int n2, int n3, Integer n4, int n5) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setInteger(n4, n5);
    }

    public void addInteger(int n2, Integer n3) throws DicomException {
        this.addInteger_ge(DDict.getGroup(n2), this.a(n2, true), n3);
    }

    public void addInteger_ge(int n2, int n3, Integer n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addInteger(n4);
    }

    public Long getLong(int n2, int n3) throws DicomException {
        return this.getLong_ge(DDict.getGroup(n2), this.a(n2, false), n3);
    }

    public Long getLong_ge(int n2, int n3, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, false);
        return dataElement == null ? null : dataElement.getLong(n4);
    }

    public void setLong(int n2, Long l2, int n3) throws DicomException {
        this.setLong_ge(DDict.getGroup(n2), this.a(n2, true), l2, n3);
    }

    public void setLong_ge(int n2, int n3, Long l2, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setLong(l2, n4);
    }

    public void addLong(int n2, Long l2) throws DicomException {
        this.addLong_ge(DDict.getGroup(n2), this.a(n2, true), l2);
    }

    public void addLong_ge(int n2, int n3, Long l2) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addLong(l2);
    }

    public Float getFloat(int n2, int n3) throws DicomException {
        return this.getFloat_ge(DDict.getGroup(n2), this.a(n2, false), n3);
    }

    public Float getFloat_ge(int n2, int n3, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, false);
        return dataElement == null ? null : dataElement.getFloat(n4);
    }

    public void setFloat(int n2, Float f2, int n3) throws DicomException {
        this.setFloat_ge(DDict.getGroup(n2), this.a(n2, true), f2, n3);
    }

    public void setFloat_ge(int n2, int n3, Float f2, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setFloat(f2, n4);
    }

    public void addFloat(int n2, Float f2) throws DicomException {
        this.addFloat_ge(DDict.getGroup(n2), this.a(n2, true), f2);
    }

    public void addFloat_ge(int n2, int n3, Float f2) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addFloat(f2);
    }

    public Double getDouble(int n2, int n3) throws DicomException {
        return this.getDouble_ge(DDict.getGroup(n2), this.a(n2, false), n3);
    }

    public Double getDouble_ge(int n2, int n3, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, false);
        return dataElement == null ? null : dataElement.getDouble(n4);
    }

    public void setDouble(int n2, Double d2, int n3) throws DicomException {
        this.setDouble_ge(DDict.getGroup(n2), this.a(n2, true), d2, n3);
    }

    public void setDouble_ge(int n2, int n3, Double d2, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setDouble(d2, n4);
    }

    public void addDouble(int n2, Double d2) throws DicomException {
        this.addDouble_ge(DDict.getGroup(n2), this.a(n2, true), d2);
    }

    public void addDouble_ge(int n2, int n3, Double d2) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addDouble(d2);
    }

    public float[] getFloats(int n2, int n3) throws DicomException {
        return this.getFloats_ge(DDict.getGroup(n2), this.a(n2, false), n3);
    }

    public float[] getFloats_ge(int n2, int n3, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, false);
        return dataElement == null ? null : dataElement.getFloats(n4);
    }

    public void setFloats(int n2, float[] fArray, int n3) throws DicomException {
        this.setFloats_ge(DDict.getGroup(n2), this.a(n2, true), fArray, n3);
    }

    public void setFloats_ge(int n2, int n3, float[] fArray, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setFloats(fArray, n4);
    }

    public void addFloats(int n2, float[] fArray) throws DicomException {
        this.addFloats_ge(DDict.getGroup(n2), this.a(n2, true), fArray);
    }

    public void addFloats_ge(int n2, int n3, float[] fArray) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addFloats(fArray);
    }

    public ATValue getATValue(int n2, int n3) throws DicomException {
        return this.getATValue_ge(DDict.getGroup(n2), this.a(n2, false), n3);
    }

    public ATValue getATValue_ge(int n2, int n3, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, false);
        return dataElement == null ? null : dataElement.getATValue(n4);
    }

    public void setATValue(int n2, ATValue aTValue, int n3) throws DicomException {
        this.setATValue_ge(DDict.getGroup(n2), this.a(n2, true), aTValue, n3);
    }

    public void setATValue_ge(int n2, int n3, ATValue aTValue, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setATValue(aTValue, n4);
    }

    public void addATValue(int n2, ATValue aTValue) throws DicomException {
        this.addATValue_ge(DDict.getGroup(n2), this.a(n2, true), aTValue);
    }

    public void addATValue_ge(int n2, int n3, ATValue aTValue) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addATValue(aTValue);
    }

    public DicomObject getSequenceItem(int n2, int n3) throws DicomException {
        return this.getSequenceItem_ge(DDict.getGroup(n2), this.a(n2, false), n3);
    }

    public DicomObject getSequenceItem_ge(int n2, int n3, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, false);
        return dataElement == null ? null : dataElement.getSequenceItem(n4);
    }

    public void setSequenceItem(int n2, DicomObject dicomObject, int n3) throws DicomException {
        this.setSequenceItem_ge(DDict.getGroup(n2), this.a(n2, true), dicomObject, n3);
    }

    public void setSequenceItem_ge(int n2, int n3, DicomObject dicomObject, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setSequenceItem(dicomObject, n4);
    }

    public void addSequenceItem(int n2, DicomObject dicomObject) throws DicomException {
        this.addSequenceItem_ge(DDict.getGroup(n2), this.a(n2, true), dicomObject);
    }

    public void addSequenceItem_ge(int n2, int n3, DicomObject dicomObject) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addSequenceItem(dicomObject);
    }

    public Person getPersonName(int n2, int n3) throws DicomException {
        return this.getPersonName_ge(DDict.getGroup(n2), this.a(n2, false), n3);
    }

    public Person getPersonName_ge(int n2, int n3, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, false);
        return dataElement == null ? null : dataElement.getPersonName(n4);
    }

    public void setPersonName(int n2, Person person, int n3) throws DicomException {
        this.setPersonName_ge(DDict.getGroup(n2), this.a(n2, true), person, n3);
    }

    public void setPersonName(int n2, Person person, int n3, DicomCharset dicomCharset, DicomCharset dicomCharset2, DicomCharset dicomCharset3) throws DicomException {
        this.setPersonName_ge(DDict.getGroup(n2), this.a(n2, true), person, n3, dicomCharset, dicomCharset2, dicomCharset3);
    }

    public void setPersonName_ge(int n2, int n3, Person person, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setPersonName(person, n4);
    }

    public void setPersonName_ge(int n2, int n3, Person person, int n4, DicomCharset dicomCharset, DicomCharset dicomCharset2, DicomCharset dicomCharset3) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setPersonName(person, n4, dicomCharset, dicomCharset2, dicomCharset3);
    }

    public void addPersonName(int n2, Person person) throws DicomException {
        this.addPersonName_ge(DDict.getGroup(n2), this.a(n2, true), person);
    }

    public void addPersonName(int n2, Person person, DicomCharset dicomCharset, DicomCharset dicomCharset2, DicomCharset dicomCharset3) throws DicomException {
        this.addPersonName_ge(DDict.getGroup(n2), this.a(n2, true), person, dicomCharset, dicomCharset2, dicomCharset3);
    }

    public void addPersonName_ge(int n2, int n3, Person person) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addPersonName(person);
    }

    public void addPersonName_ge(int n2, int n3, Person person, DicomCharset dicomCharset, DicomCharset dicomCharset2, DicomCharset dicomCharset3) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addPersonName(person, dicomCharset, dicomCharset2, dicomCharset3);
    }

    public byte[] getBytes(int n2, int n3) throws DicomException {
        return this.getBytes_ge(DDict.getGroup(n2), this.a(n2, false), n3);
    }

    public byte[] getBytes_ge(int n2, int n3, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, false);
        return dataElement == null ? null : dataElement.getBytes(n4);
    }

    public void setBytes(int n2, byte[] byArray, int n3) throws DicomException {
        this.setBytes_ge(DDict.getGroup(n2), this.a(n2, true), byArray, n3);
    }

    public void setBytes_ge(int n2, int n3, byte[] byArray, int n4) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.setBytes(byArray, n4);
    }

    public void addBytes(int n2, byte[] byArray) throws DicomException {
        this.addBytes_ge(DDict.getGroup(n2), this.a(n2, true), byArray);
    }

    public void addBytes_ge(int n2, int n3, byte[] byArray) throws DicomException {
        DataElement dataElement = this.a(n2, n3, true);
        dataElement.addBytes(byArray);
    }

    public DataElement getDataElement(int n2) {
        int n3 = DDict.getGroup(n2);
        int n4 = this.a(n2, false);
        return this.getDataElement(n3, n4);
    }

    public DataElement getDataElement(int n2, int n3) {
        return this.a(n2, n3, false);
    }

    public Object get(int n2) {
        return this.get(n2, 0);
    }

    public Object get_ge(int n2, int n3) {
        return this.get_ge(n2, n3, 0);
    }

    public Object get(int n2, int n3) {
        int n4 = DDict.getGroup(n2);
        int n5 = this.a(n2, false);
        return this.get_ge(n4, n5, n3);
    }

    public Object get_ge(int n2, int n3, int n4) {
        c c2 = (c)this.a(n2, n3, false);
        if (c2 == null || c2.size() == 0) {
            return null;
        }
        if (n4 >= c2.val.size()) {
            return null;
        }
        return l.if(c2.val.elementAt(n4), c2.dcm_type, this.dicomCharsets(), true);
    }

    public String getS(int n2) throws DicomException {
        return this.getS(n2, 0);
    }

    public String getS_ge(int n2, int n3) throws DicomException {
        return this.getS_ge(n2, n3, 0);
    }

    public String getS(int n2, int n3) throws DicomException {
        int n4 = DDict.getGroup(n2);
        int n5 = this.a(n2, false);
        return this.getS_ge(n4, n5, n3);
    }

    public String getS_ge(int n2, int n3, int n4) throws DicomException {
        c c2 = (c)this.a(n2, n3, false);
        if (c2 == null || c2.size() == 0) {
            return null;
        }
        if (n4 >= c2.val.size()) {
            return null;
        }
        return l.a(c2.val.elementAt(n4), c2.dcm_type, this.dicomCharsets(), true);
    }

    public int getI(int n2) throws DicomException {
        return this.getI(n2, 0);
    }

    public int getI_ge(int n2, int n3) throws DicomException {
        return this.getI_ge(n2, n3, 0);
    }

    public int getI(int n2, int n3) throws DicomException {
        int n4 = DDict.getGroup(n2);
        int n5 = this.a(n2, false);
        return this.getI_ge(n4, n5, n3);
    }

    public int getI_ge(int n2, int n3, int n4) throws DicomException {
        Object object = this.get_ge(n2, n3, n4);
        if (object != null) {
            int n5 = this.a((int)n2, (int)n3, (boolean)false).dcm_type;
            return l.a(object, n5);
        }
        return Integer.MAX_VALUE;
    }

    public void remove(int n2) {
        this.remove_ge(DDict.getGroup(n2), this.a(n2, false));
    }

    public void remove_ge(int n2, int n3) {
        this.removeVR(n2, n3);
    }

    public Vector deleteItem(int n2) {
        int n3 = DDict.getGroup(n2);
        int n4 = this.a(n2, false);
        return this.deleteItem_ge(n3, n4);
    }

    public Vector deleteItem_ge(int n2, int n3) {
        c c2 = this.removeVR(n2, n3);
        if (c2 == (c)null) {
            return null;
        }
        return c2.val;
    }

    public Object deleteItem(int n2, int n3) {
        int n4 = DDict.getGroup(n2);
        int n5 = this.a(n2, false);
        return this.deleteItem_ge(n4, n5, n3);
    }

    public Object deleteItem_ge(int n2, int n3, int n4) {
        c c2 = (c)this.a(n2, n3, false);
        if (n4 >= c2.val.size()) {
            return null;
        }
        Object e2 = c2.val.elementAt(n4);
        c2.val.removeElementAt(n4);
        return e2;
    }

    public void read(InputStream inputStream) throws IOException, DicomException {
        this.read(inputStream, true);
    }

    public void read(InputStream inputStream, boolean bl) throws IOException, DicomException {
        DicomReader dicomReader = new DicomReader();
        dicomReader.read(this, inputStream, bl);
    }

    public void read(InputStream inputStream, int n2, boolean bl) throws IOException, DicomException {
        DicomReader dicomReader = new DicomReader();
        dicomReader.readDICOMStream(this, new u(inputStream), n2, bl);
    }

    public void write(OutputStream outputStream, boolean bl) throws DicomException, IOException {
        DicomWriter dicomWriter = new DicomWriter();
        dicomWriter.write(this, outputStream, bl);
    }

    public void write(OutputStream outputStream, boolean bl, int n2, boolean bl2) throws DicomException, IOException {
        DicomWriter dicomWriter = new DicomWriter();
        dicomWriter.write(this, outputStream, bl, n2, bl2);
    }

    public void write(OutputStream outputStream, boolean bl, int n2, boolean bl2, boolean bl3) throws DicomException, IOException {
        DicomWriter dicomWriter = new DicomWriter();
        dicomWriter.write(this, outputStream, bl, n2, bl2, bl3);
    }

    void changeDICOMFileMetaInformation(int n2) throws DicomException {
        this.filemetainfo = this.getFileMetaInformation();
        if (this.filemetainfo == null) {
            this.a(n2);
        } else {
            try {
                this.filemetainfo.set(31, UID.getUIDEntry(n2).getValue(), 0);
            }
            catch (IllegalValueException illegalValueException) {
                this.log.error("IllegalValueException when setting transfer syntax in file meta information", illegalValueException);
            }
        }
    }

    private void a(int n2) throws DicomException {
        this.filemetainfo = this.getFileMetaInformation();
        this.log.debug("DicomObject.makeDICOMFileMetaInformation. transfer syntax: " + n2);
        if (this.filemetainfo == null) {
            this.filemetainfo = new DicomObject();
        }
        if (this.getSize(62) != 1 || this.getSize(63) != 1) {
            throw new DicomException("This DicomObject can't be written to a Dicom File: Unable to find SOP Common Info");
        }
        byte[] byArray = new byte[]{0, 1};
        this.filemetainfo.set(28, byArray, 0);
        this.filemetainfo.set(29, this.get(62), 0);
        this.filemetainfo.set(30, this.get(63), 0);
        String string = this.filemetainfo.getS(31);
        if (string != null) {
            int n3 = 0;
            try {
                n3 = UID.getUIDEntry(string).getConstant();
            }
            catch (UnknownUIDException unknownUIDException) {
                throw new DicomException("Cannot change unknown transfersyntax into new one");
            }
            if (n3 != 8193 && n3 != 8194 && n3 != 8195) {
                throw new DicomException("Cannot change encapsulated transfersyntax, use Compression.decompress().");
            }
        }
        try {
            this.filemetainfo.set(31, UID.getUIDEntry(n2).getValue(), 0);
        }
        catch (IllegalValueException illegalValueException) {
            this.log.error("IllegalValueException while setting transfer syntax in file meta information: + e", illegalValueException);
        }
        if (this.filemetainfo.getSize(32) == 0) {
            this.filemetainfo.set(32, "1.2.826.0.1.3680043.2.60.0.1");
        }
        if (this.filemetainfo.getSize(33) == 0) {
            this.filemetainfo.set(33, Jdt.DEFAULT_IMPLEMENTATION_VERSION_NAME);
        }
    }

    public DicomObject getFileMetaInformation() {
        return this.filemetainfo;
    }

    public DicomObject setFileMetaInformation(DicomObject dicomObject) {
        DicomObject dicomObject2 = this.filemetainfo;
        this.filemetainfo = dicomObject;
        return dicomObject2;
    }

    public void dumpVRs(OutputStream outputStream) throws IOException {
        this.dumpVRs(outputStream, false);
    }

    public void dumpVRs(OutputStream outputStream, boolean bl) throws IOException {
        DumpUtils dumpUtils = new DumpUtils(bl, false);
        dumpUtils.dump(this, outputStream);
    }

    static {
        new p().if();
    }
}

