/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictEntry;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.c;
import com.archimed.dicom.charset.DicomCharset;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DumpUtils {
    private int do;
    private int for;
    private int int;
    private boolean new;
    private boolean if;
    private String a;

    public DumpUtils(boolean bl, boolean bl2) {
        this(35, 60, 6, bl, bl2);
    }

    public DumpUtils(int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.do = n2;
        this.for = n3;
        this.new = bl;
        this.int = n4;
        this.if = bl2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPropertyAccess("line.separator");
                this.a = System.getProperty("line.separator", "\n");
            }
            catch (SecurityException securityException) {
                System.err.println("SecurityException when reading system property line.separator ." + securityException);
                this.a = "\n";
            }
        } else {
            this.a = System.getProperty("line.separator", "\n");
        }
    }

    public DumpUtils(int n2, int n3, int n4, boolean bl) {
        this(n2, n3, n4, bl, false);
    }

    private static String a(String string, int n2) {
        if (string.length() > n2) {
            return string.substring(0, n2);
        }
        int n3 = n2 - string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            string = string + " ";
        }
        return string;
    }

    private static String do(String string, int n2) {
        if (string.length() < 4) {
            return "...";
        }
        return string.substring(0, n2 - 3) + "...";
    }

    private static String if(String string, int n2) {
        if (string.length() > n2) {
            return DumpUtils.do(string, n2);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = n2 - string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte by) {
        return DumpUtils.toHexString(by & 0xFF, 2);
    }

    public static String toHexString(int n2, int n3) {
        String string = "";
        String string2 = Integer.toHexString(n2);
        if (n3 < string2.length()) {
            string2 = string2.substring(0, n3);
        }
        for (int i2 = 0; i2 < n3 - string2.length(); ++i2) {
            string = string + "0";
        }
        return string + string2;
    }

    public static String tagString(int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(DumpUtils.toHexString(n2, 4));
        stringBuffer.append(",");
        stringBuffer.append(DumpUtils.toHexString(n3, 4));
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }

    public static String tagDescriptionString(int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(DumpUtils.toHexString(n2, 4));
        stringBuffer.append(",");
        stringBuffer.append(DumpUtils.toHexString(n3, 4));
        stringBuffer.append(") ");
        stringBuffer.append(DDict.getDescription(DDict.lookupDDict(n2, n3)));
        return stringBuffer.toString();
    }

    public void dump(DicomObject dicomObject, StringBuffer stringBuffer) throws IOException {
        DicomObject dicomObject2;
        if (this.new && (dicomObject2 = dicomObject.getFileMetaInformation()) != null) {
            this.a(dicomObject2, 0, stringBuffer);
        }
        this.a(dicomObject, 0, stringBuffer);
    }

    public void dump(DicomObject dicomObject, OutputStream outputStream) throws IOException {
        DicomObject dicomObject2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.new && (dicomObject2 = dicomObject.getFileMetaInformation()) != null) {
            this.a(dicomObject2, 0, stringBuffer);
        }
        this.a(dicomObject, 0, stringBuffer);
        outputStream.write(stringBuffer.toString().getBytes());
        outputStream.flush();
    }

    private void a(DicomObject dicomObject, int n2, StringBuffer stringBuffer) throws IOException {
        Enumeration enumeration = dicomObject.enumerateVRs(this.if, 8193, true);
        while (enumeration.hasMoreElements()) {
            boolean bl;
            c c2 = (c)enumeration.nextElement();
            boolean bl2 = bl = c2.dcm_type == 10;
            if (bl) {
                this.a(dicomObject, c2, n2, stringBuffer);
                for (int i2 = 0; i2 < c2.val.size(); ++i2) {
                    DicomObject dicomObject2 = (DicomObject)c2.val.elementAt(i2);
                    if (dicomObject2 != null) {
                        this.a(dicomObject2, n2 + 1, stringBuffer);
                    }
                    if (i2 == c2.val.size() - 1) continue;
                    this.if(n2 + 1, stringBuffer);
                }
                this.a(n2, stringBuffer);
                continue;
            }
            this.a(dicomObject, c2, n2, dicomObject.dicomCharsets(), stringBuffer);
        }
    }

    private void if(int n2, StringBuffer stringBuffer) {
        this.a(stringBuffer, n2);
        stringBuffer.append("\\");
        stringBuffer.append(this.a);
    }

    private void a(DicomObject dicomObject, c c2, int n2, StringBuffer stringBuffer) {
        this.a(stringBuffer, n2);
        this.a(dicomObject, stringBuffer, c2, n2);
        stringBuffer.append(this.a);
        stringBuffer = new StringBuffer("");
        this.a(stringBuffer, n2);
        stringBuffer.append("[");
        stringBuffer.append(this.a);
    }

    private void a(int n2, StringBuffer stringBuffer) {
        this.a(stringBuffer, n2);
        stringBuffer.append("]");
        stringBuffer.append(this.a);
    }

    private void a(DicomObject dicomObject, c c2, int n2, DicomCharset[] dicomCharsetArray, StringBuffer stringBuffer) throws IOException {
        this.a(stringBuffer, n2);
        this.a(dicomObject, stringBuffer, c2, n2);
        stringBuffer.append("[");
        StringBuffer stringBuffer2 = new StringBuffer("");
        String string = null;
        for (int i2 = 0; i2 < c2.val.size(); ++i2) {
            string = c2.getString(i2, false);
            if (string != null) {
                stringBuffer2.append(string);
            }
            if (i2 == c2.val.size() - 1) continue;
            stringBuffer2.append("\\");
        }
        if (stringBuffer2 != null) {
            if (stringBuffer2.length() > this.for) {
                stringBuffer.append(DumpUtils.do(stringBuffer2.toString(), this.for));
            } else {
                stringBuffer.append(stringBuffer2);
            }
        }
        stringBuffer.append("]");
        stringBuffer.append(this.a);
    }

    private void a(StringBuffer stringBuffer, int n2) {
        int n3 = n2 * this.int;
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuffer.append(" ");
        }
    }

    private void a(DicomObject dicomObject, StringBuffer stringBuffer, c c2, int n2) {
        stringBuffer.append("(");
        stringBuffer.append(DumpUtils.toHexString(c2.group, 4));
        stringBuffer.append(",");
        stringBuffer.append(DumpUtils.toHexString(c2.element, 4));
        stringBuffer.append(")");
        stringBuffer.append(" ");
        DDictEntry dDictEntry = DDict.getEntry(DDict.lookupDDict(c2.group, c2.element));
        String string = "";
        if (dDictEntry == null) {
            string = "Undefined";
        } else if (c2.group % 2 == 1) {
            if (c2.element >= 16 && c2.element <= 255) {
                string = "Private Creator";
            } else {
                String string2;
                try {
                    string2 = dicomObject.getString_ge(c2.getGroup(), c2.getElement() >> 8, 0);
                }
                catch (Throwable throwable) {
                    string2 = null;
                }
                string = dDictEntry.getPrivateCreatorID() != null && string2 != null && string2.equals(dDictEntry.getPrivateCreatorID()) ? dDictEntry.getDescription() : "Private Tag";
            }
        } else {
            string = dDictEntry.getDescription();
        }
        int n3 = this.do - this.int * n2;
        n3 = Math.max(n3, 3);
        stringBuffer.append(DumpUtils.if(string, n3));
        stringBuffer.append(" ");
        stringBuffer.append(DumpUtils.a(DDict.getTypeName(c2.dcm_type), 5));
        stringBuffer.append(" ");
        stringBuffer.append("# ");
        stringBuffer.append(DumpUtils.a(Integer.toString(c2.dataLen), 10));
        stringBuffer.append(" ");
        stringBuffer.append(DumpUtils.a(Integer.toString(c2.val.size()), 8));
        stringBuffer.append(" ");
    }
}

