/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.charset;

import com.archimed.dicom.Jdt;
import com.archimed.log.JdtLogger;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DicomCharset {
    protected static JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomCharset.class);
    private static final HashMap do = new HashMap();
    public static final DicomCharset DEFAULT = DicomCharset.a("", "Default repertoire", null, null, "US-ASCII");
    public static final DicomCharset ISO_IR_100 = DicomCharset.a("ISO_IR 100", "Latin alphabet No. 1", null, null, "ISO-8859-1");
    public static final DicomCharset ISO_IR_101 = DicomCharset.a("ISO_IR 101", "Latin alphabet No. 2", null, null, "ISO-8859-2");
    public static final DicomCharset ISO_IR_109 = DicomCharset.a("ISO_IR 109", "Latin alphabet No. 3", null, null, "ISO-8859-3");
    public static final DicomCharset ISO_IR_110 = DicomCharset.a("ISO_IR 110", "Latin alphabet No. 4", null, null, "ISO-8859-4");
    public static final DicomCharset ISO_IR_144 = DicomCharset.a("ISO_IR 144", "Cyrillic", null, null, "ISO-8859-5");
    public static final DicomCharset ISO_IR_127 = DicomCharset.a("ISO_IR 127", "Arabic", null, null, "ISO-8859-6");
    public static final DicomCharset ISO_IR_126 = DicomCharset.a("ISO_IR 126", "Greek", null, null, "ISO-8859-7");
    public static final DicomCharset ISO_IR_138 = DicomCharset.a("ISO_IR 138", "Hebrew", null, null, "ISO-8859-8");
    public static final DicomCharset ISO_IR_148 = DicomCharset.a("ISO_IR 148", "Latin alphabet No. 5", null, null, "ISO-8859-9");
    public static final DicomCharset ISO_IR_13 = DicomCharset.a("ISO_IR 13", "Japanese", null, null, "JIS_X0201");
    public static final DicomCharset ISO_IR_166 = DicomCharset.a("ISO_IR 166", "Thai", null, null, "TIS-620");
    public static final DicomCharset ISO_2022_IR_6 = DicomCharset.a("ISO 2022 IR 6", "Default repertoire (Code Extensions)", null, new byte[]{40, 66}, "US-ASCII");
    public static final DicomCharset ISO_2022_IR_100 = DicomCharset.a("ISO 2022 IR 100", "Latin alphabet No. 1 (Code Extensions)", new byte[]{45, 65}, new byte[]{40, 66}, "ISO-8859-1");
    public static final DicomCharset ISO_2022_IR_101 = DicomCharset.a("ISO 2022 IR 101", "Latin alphabet No. 2 (Code Extensions)", new byte[]{45, 66}, new byte[]{40, 66}, "ISO-8859-2");
    public static final DicomCharset ISO_2022_IR_109 = DicomCharset.a("ISO 2022 IR 109", "Latin alphabet No. 3 (Code Extensions)", new byte[]{45, 67}, new byte[]{40, 66}, "ISO-8859-3");
    public static final DicomCharset ISO_2022_IR_110 = DicomCharset.a("ISO 2022 IR 110", "Latin alphabet No. 4 (Code Extensions)", new byte[]{45, 68}, new byte[]{40, 66}, "ISO-8859-4");
    public static final DicomCharset ISO_2022_IR_144 = DicomCharset.a("ISO 2022 IR 144", "Cyrillic (Code Extensions)", new byte[]{45, 76}, new byte[]{40, 66}, "ISO-8859-5");
    public static final DicomCharset ISO_2022_IR_127 = DicomCharset.a("ISO 2022 IR 127", "Arabic (Code Extensions)", new byte[]{45, 71}, new byte[]{40, 66}, "ISO-8859-6");
    public static final DicomCharset ISO_2022_IR_126 = DicomCharset.a("ISO 2022 IR 126", "Greek (Code Extensions)", new byte[]{45, 70}, new byte[]{40, 66}, "ISO-8859-7");
    public static final DicomCharset ISO_2022_IR_138 = DicomCharset.a("ISO 2022 IR 138", "Hebrew (Code Extensions)", new byte[]{45, 72}, new byte[]{40, 66}, "ISO-8859-8");
    public static final DicomCharset ISO_2022_IR_148 = DicomCharset.a("ISO 2022 IR 148", "Latin alphabet No. 5 (Code Extensions)", new byte[]{45, 77}, new byte[]{40, 66}, "ISO-8859-9");
    public static final DicomCharset ISO_2022_IR_13 = DicomCharset.a("ISO 2022 IR 13", "Japanese (Code Extensions)", new byte[]{41, 73}, new byte[]{40, 74}, "JIS_X0201");
    public static final DicomCharset ISO_2022_IR_166 = DicomCharset.a("ISO 2022 IR 166", "Thai (Code Extensions)", new byte[]{45, 84}, new byte[]{40, 66}, "TIS-620");
    public static final DicomCharset ISO_2022_IR_87 = DicomCharset.a("ISO 2022 IR 87", "Japanese (JIS X 0208)", null, new byte[]{36, 66}, "x-JIS0208");
    public static final DicomCharset ISO_2022_IR_159 = DicomCharset.a("ISO 2022 IR 159", "Japanese (JIS X 0212)", null, new byte[]{36, 40, 68}, "JIS_X0212-1990");
    public static final DicomCharset ISO_2022_IR_149 = DicomCharset.a("ISO 2022 IR 149", "Korean (KS X 1001)", new byte[]{36, 41, 67}, null, "EUC-KR");
    public static final DicomCharset ISO_IR_192 = DicomCharset.a("ISO_IR 192", "Unicode in UTF-8", null, null, "UTF-8");
    public static final DicomCharset GB18030 = DicomCharset.a("GB18030", "GB18030", null, null, "GB18030");
    private String if;
    private String new;
    private byte[] int;
    private byte[] for;
    private String a;

    public DicomCharset(String string, String string2, byte[] byArray, byte[] byArray2, String string3) {
        this.if = string2;
        this.new = string;
        this.int = byArray;
        this.for = byArray2;
        this.a = string3;
    }

    private static DicomCharset a(String string, String string2, byte[] byArray, byte[] byArray2, String string3) {
        DicomCharset dicomCharset = new DicomCharset(string, string2, byArray, byArray2, string3);
        do.put(string, dicomCharset);
        try {
            Charset.forName(string3);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            log.warn("charset " + string + " (" + string3 + ") not available, no decoding/encoding in this charset possible. " + illegalCharsetNameException);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            log.warn("charset " + string + " (" + string3 + ") not available, no decoding/encoding in this charset possible. " + unsupportedCharsetException);
        }
        return dicomCharset;
    }

    public static DicomCharset lookup(String string) {
        return (DicomCharset)do.get(string);
    }

    public static DicomCharset lookup(byte[] byArray) {
        Iterator iterator = do.keySet().iterator();
        while (iterator.hasNext()) {
            DicomCharset dicomCharset = (DicomCharset)do.get(iterator.next());
            if (Arrays.equals(byArray, dicomCharset.int)) {
                return dicomCharset;
            }
            if (!Arrays.equals(byArray, dicomCharset.for)) continue;
            return dicomCharset;
        }
        return null;
    }

    public Charset getJavaCharset() throws UnsupportedCharsetException, IllegalCharsetNameException {
        return Charset.forName(this.a);
    }

    public String getDefinedTerm() {
        return this.new;
    }

    public byte[] getEscapeSequenceG1() {
        return this.int;
    }

    public byte[] getEscapeSequenceG0() {
        return this.for;
    }
}

