/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.image;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Jdt;
import com.archimed.log.JdtLogger;

public class DicomImage
extends DicomObject {
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomImage.class);

    public void patientData(String string, String string2, String string3, String string4) throws DicomException {
        try {
            this.set(147, string);
            this.set(148, string2);
            this.set(152, string4);
        }
        catch (DicomException dicomException) {
            this.log.error("", dicomException);
        }
        try {
            this.set(150, string3);
        }
        catch (DicomException dicomException) {
            throw new DicomException("Invalid Date format");
        }
    }

    public void generalStudyData(String string, String string2, String string3, String string4, String string5, String string6) throws DicomException {
        this.set(425, string);
        this.set(64, string2);
        this.set(70, string3);
        this.set(88, string4);
        this.set(427, string5);
        this.set(77, string6);
    }

    public void generalSeriesData(String string, String string2, String string3) throws DicomException {
        this.set(81, string);
        this.set(426, string2);
        this.set(428, string3);
    }

    public void generalEquipmentData(String string) {
        try {
            this.set(84, string);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
    }

    public void generalImageData(String string) throws DicomException {
        try {
            this.set(430, string);
        }
        catch (DicomException dicomException) {
            throw new DicomException("Invalid Integer format");
        }
    }

    public void imagePixelData(int n2, int n3, int n4, int n5, int n6, byte[] byArray) throws DicomException {
        this.set(461, new Integer(1));
        this.set(462, "MONOCHROME2");
        this.set(466, new Integer(n2));
        this.set(467, new Integer(n3));
        if (n4 != 8 && n4 != 16 && n4 != 32) {
            throw new DicomException("BitsAllocated " + n4 + ": other than 8, 16 or 32");
        }
        if (n5 > n4) {
            throw new DicomException("BitsStored > BitsAllocated");
        }
        if (n6 >= n5) {
            throw new DicomException("HighBit >= BitsStored");
        }
        if (byArray == null) {
            throw new DicomException("PixelData empty");
        }
        this.set(475, new Integer(n4));
        this.set(476, new Integer(n5));
        this.set(477, new Integer(n6));
        this.set(478, new Integer(0));
        this.set(1184, byArray);
    }

    public void imagePixelData(int n2, int n3, int n4, int n5, int n6, int[] nArray) throws DicomException {
        this.set(461, new Integer(1));
        this.set(462, "MONOCHROME2");
        this.set(466, new Integer(n2));
        this.set(467, new Integer(n3));
        if (n4 != 8 && n4 != 16 && n4 != 24 && n4 != 32) {
            throw new DicomException("BitsAllocated " + n4 + ": other than 8, 16 or 32");
        }
        if (n5 > n4) {
            throw new DicomException("BitsStored > BitsAllocated");
        }
        if (n6 >= n5) {
            throw new DicomException("HighBit >= BitsStored");
        }
        if (nArray == null) {
            throw new DicomException("PixelData empty");
        }
        this.set(475, new Integer(n4));
        this.set(476, new Integer(n5));
        this.set(477, new Integer(n6));
        this.set(478, new Integer(0));
        int n7 = n4 / 8;
        byte[] byArray = new byte[nArray.length * n7];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < n7; ++i3) {
                byArray[n7 * i2 + i3] = (byte)((nArray[i2] & 255 << 8 * i3) >> 8 * i3);
            }
        }
        this.set(1184, byArray);
    }

    public void imagePixelData(int n2, int n3, int n4, byte[] byArray) throws DicomException {
        if (n4 != 0 && n4 != 1) {
            throw new DicomException("Planar Configuration has to be 0 or 1");
        }
        if (byArray == null) {
            throw new DicomException("PixelData empty");
        }
        this.set(461, new Integer(3));
        this.set(462, "RGB");
        this.set(466, new Integer(n2));
        this.set(467, new Integer(n3));
        this.set(475, new Integer(8));
        this.set(476, new Integer(8));
        this.set(477, new Integer(7));
        this.set(478, new Integer(0));
        this.set(463, new Integer(n4));
        this.set(1184, byArray);
    }

    public void imagePixelData(int n2, int n3, int n4, int[] nArray) throws DicomException {
        if (n4 != 0 && n4 != 1) {
            throw new DicomException("Planar Configuration has to be 0 or 1");
        }
        if (nArray == null) {
            throw new DicomException("PixelData empty");
        }
        this.set(461, new Integer(3));
        this.set(462, "RGB");
        this.set(466, new Integer(n2));
        this.set(467, new Integer(n3));
        this.set(475, new Integer(8));
        this.set(476, new Integer(8));
        this.set(477, new Integer(7));
        this.set(478, new Integer(0));
        this.set(463, new Integer(n4));
        byte[] byArray = new byte[nArray.length * 3];
        if (n4 == 0) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                byArray[3 * i2] = (byte)((nArray[i2] & 0xFF0000) >> 16);
                byArray[3 * i2 + 1] = (byte)((nArray[i2] & 0xFF00) >> 8);
                byArray[3 * i2 + 2] = (byte)(nArray[i2] & 0xFF);
            }
        } else {
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                byArray[i3] = (byte)((nArray[i3] & 0xFF0000) >> 16);
                byArray[nArray.length + i3] = (byte)((nArray[i3] & 0xFF00) >> 8);
                byArray[2 * nArray.length + i3] = (byte)(nArray[i3] & 0xFF);
            }
        }
        this.set(1184, byArray);
    }

    public void imagePixelData(int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws DicomException {
        int n4;
        if (byArray == null) {
            throw new DicomException("PixelData empty");
        }
        if (byArray2 == null) {
            throw new DicomException("Red Palette empty");
        }
        if (byArray3 == null) {
            throw new DicomException("Green Palette empty");
        }
        if (byArray4 == null) {
            throw new DicomException("Blue Palette empty");
        }
        this.set(466, new Integer(n2));
        this.set(467, new Integer(n3));
        this.set(475, new Integer(8));
        this.set(476, new Integer(8));
        this.set(477, new Integer(7));
        this.set(494, new Integer(256), 0);
        this.set(494, new Integer(0), 1);
        this.set(494, new Integer(16), 2);
        this.set(495, new Integer(256), 0);
        this.set(495, new Integer(0), 1);
        this.set(495, new Integer(16), 2);
        this.set(496, new Integer(256), 0);
        this.set(496, new Integer(0), 1);
        this.set(496, new Integer(16), 2);
        this.set(461, new Integer(1));
        this.set(462, "PALETTE COLOR");
        this.set(478, new Integer(0));
        byte[] byArray5 = new byte[512];
        byte[] byArray6 = new byte[512];
        byte[] byArray7 = new byte[512];
        for (n4 = 0; n4 < byArray2.length; ++n4) {
            byArray5[2 * n4 + 1] = byArray2[n4];
        }
        for (n4 = 0; n4 < byArray3.length; ++n4) {
            byArray6[2 * n4 + 1] = byArray3[n4];
        }
        for (n4 = 0; n4 < byArray4.length; ++n4) {
            byArray7[2 * n4 + 1] = byArray4[n4];
        }
        this.set(498, byArray5);
        this.set(499, byArray6);
        this.set(500, byArray7);
        this.set(1184, byArray);
    }

    public void sopCommonData(String string, String string2) {
        try {
            if (string == null) {
                this.set(62, "1.2.840.10008.5.1.4.1.1.7");
            } else {
                this.set(62, string);
            }
            this.set(63, string2);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
    }
}

