/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.SOPClass;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Command
extends DicomObject {
    public static final int N_EVENT_REPORT_REQUEST = 256;
    public static final int N_EVENT_REPORT_RESPONSE = 33024;
    public static final int N_GET_REQUEST = 272;
    public static final int N_GET_RESPONSE = 33040;
    public static final int N_SET_REQUEST = 288;
    public static final int N_SET_RESPONSE = 33056;
    public static final int N_ACTION_REQUEST = 304;
    public static final int N_ACTION_RESPONSE = 33072;
    public static final int N_CREATE_REQUEST = 320;
    public static final int N_CREATE_RESPONSE = 33088;
    public static final int N_DELETE_REQUEST = 336;
    public static final int N_DELETE_RESPONSE = 33104;
    public static final int C_STORE_REQUEST = 1;
    public static final int C_STORE_RESPONSE = 32769;
    public static final int C_GET_REQUEST = 16;
    public static final int C_GET_RESPONSE = 32784;
    public static final int C_FIND_REQUEST = 32;
    public static final int C_FIND_RESPONSE = 32800;
    public static final int C_MOVE_REQUEST = 33;
    public static final int C_MOVE_RESPONSE = 32801;
    public static final int C_ECHO_REQUEST = 48;
    public static final int C_ECHO_RESPONSE = 32816;
    public static final int C_CANCEL_REQUEST = 4095;
    public static final int MEDIUM_PRIORITY = 0;
    public static final int HIGH_PRIORITY = 1;
    public static final int LOW_PRIORITY = 2;

    Command() {
    }

    public int getCommandType() throws DicomException {
        return this.if(3);
    }

    public void setCommandType(int n2) throws DicomException {
        this.set(3, new Integer(n2));
    }

    public int getMessageID() throws DicomException {
        return this.if(4);
    }

    public void setMessageID(int n2) throws DicomException {
        this.set(4, new Integer(n2));
    }

    public int getResponseMessageID() throws DicomException {
        return this.if(5);
    }

    public void setResponseMessageID(int n2) throws DicomException {
        this.set(5, new Integer(n2));
    }

    public int getStatus() throws DicomException {
        return this.if(9);
    }

    public void setStatus(int n2) throws DicomException {
        this.set(9, new Integer(n2));
    }

    public int getAffectedSOPClass() throws DicomException {
        return this.do(1);
    }

    public void setAffectedSOPClass(int n2) throws DicomException {
        try {
            this.set(1, UID.getUIDEntry(n2).getValue());
        }
        catch (IllegalValueException illegalValueException) {
            DicomException dicomException = new DicomException(illegalValueException + "");
            dicomException.initCause(illegalValueException);
            throw dicomException;
        }
    }

    public int getRequestedSOPClass() throws DicomException {
        return this.do(2);
    }

    public void setRequestedSOPClass(int n2) throws DicomException {
        try {
            this.set(2, UID.getUIDEntry(n2).getValue());
        }
        catch (IllegalValueException illegalValueException) {
            DicomException dicomException = new DicomException(illegalValueException + "");
            dicomException.initCause(illegalValueException);
            throw dicomException;
        }
    }

    public String getAffectedSOPInstance() throws DicomException {
        return this.for(13);
    }

    public void setRequestedSOPInstance(String string) throws DicomException {
        this.set(14, string);
    }

    public String getRequestedSOPInstance() throws DicomException {
        return this.for(14);
    }

    public void setAffectedSOPInstance(String string) throws DicomException {
        this.set(13, string);
    }

    public void hasData(boolean bl) throws DicomException {
        if (!bl) {
            this.set(8, new Integer(257));
        } else {
            this.set(8, new Integer(0));
        }
    }

    public boolean hasData() throws DicomException {
        Object object = this.get(8);
        if (object == null) {
            throw new DicomException(this.a(8, "tag value missing"));
        }
        return (Integer)object != 257;
    }

    public int getPriority() throws DicomException {
        return this.if(7);
    }

    public void setPriority(int n2) throws DicomException {
        this.set(7, new Integer(n2));
    }

    public String getMoveOriginatorAE() throws DicomException {
        return this.for(23);
    }

    public void setMoveOriginatorAE(String string) throws DicomException {
        this.set(23, string);
    }

    public int getRemainingSuboperations() throws DicomException {
        return this.if(19, false);
    }

    public void setRemainingSuboperations(int n2) throws DicomException {
        this.set(19, new Integer(n2));
    }

    public int getCompletedSuboperations() throws DicomException {
        return this.if(20, false);
    }

    public void setCompletedSuboperations(int n2) throws DicomException {
        this.set(20, new Integer(n2));
    }

    public int getFailedSuboperations() throws DicomException {
        return this.if(21, false);
    }

    public void setFailedSuboperations(int n2) throws DicomException {
        this.set(21, new Integer(n2));
    }

    public int getWarningSuboperations() throws DicomException {
        return this.if(22, false);
    }

    public void setWarningSuboperations(int n2) throws DicomException {
        this.set(22, new Integer(n2));
    }

    public int getMoveOriginatorID() throws DicomException {
        return this.if(24);
    }

    public void setMoveOriginatorMessageID(int n2) throws DicomException {
        this.set(24, new Integer(n2));
    }

    public void setMoveDestination(String string) throws DicomException {
        this.set(6, string);
    }

    public int getEventTypeID() throws DicomException {
        return this.if(15, false);
    }

    public void setEventTypeID(int n2) throws DicomException {
        this.set(15, new Integer(n2));
    }

    public int getActionTypeID() throws DicomException {
        return this.if(18, false);
    }

    public void setActionTypeID(int n2) throws DicomException {
        this.set(18, new Integer(n2));
    }

    public String getCommandName() throws DicomException {
        int n2 = this.getCommandType();
        switch (n2) {
            case 256: {
                return "N-EVENT-REPORT-REQUEST";
            }
            case 33024: {
                return "N-EVENT-REPORT-RESPONSE";
            }
            case 272: {
                return "N-GET-REQUEST";
            }
            case 33040: {
                return "N-GET-RESPONSE";
            }
            case 288: {
                return "N-SET-REQUEST";
            }
            case 33056: {
                return "N-SET-RESPONSE";
            }
            case 304: {
                return "N-ACTION-REQUEST";
            }
            case 33072: {
                return "N-ACTION-RESPONSE";
            }
            case 320: {
                return "N-CREATE-REQUEST";
            }
            case 33088: {
                return "N-CREATE-RESPONSE";
            }
            case 336: {
                return "N-DELETE-REQUEST";
            }
            case 33104: {
                return "N-DELETE-RESPONSE";
            }
            case 1: {
                return "C-STORE-REQUEST";
            }
            case 32769: {
                return "C-STORE-RESPONSE";
            }
            case 16: {
                return "C-GET-REQUEST";
            }
            case 32784: {
                return "C-GET-RESPONSE";
            }
            case 32: {
                return "C-FIND-REQUEST";
            }
            case 32800: {
                return "C-FIND-RESPONSE";
            }
            case 33: {
                return "C-MOVE-REQUEST";
            }
            case 32801: {
                return "C-MOVE-RESPONSE";
            }
            case 48: {
                return "C-ECHO-REQUEST";
            }
            case 32816: {
                return "C-ECHO-RESPONSE";
            }
            case 4095: {
                return "C-CANCEL-REQUEST";
            }
        }
        throw new DicomException("Unknown command field: " + n2);
    }

    private static Command if(int n2, int n3, boolean bl, int n4) throws DicomException {
        Command command2 = new Command();
        command2.setCommandType(n2);
        command2.hasData(bl);
        command2.setMessageID(n3);
        switch (n2) {
            case 272: 
            case 288: 
            case 304: 
            case 336: {
                command2.setRequestedSOPClass(n4);
                break;
            }
            default: {
                command2.setAffectedSOPClass(n4);
            }
        }
        return command2;
    }

    private static Command a(int n2, int n3, boolean bl, int n4) throws DicomException {
        Command command2 = new Command();
        command2.setCommandType(n2);
        command2.hasData(bl);
        command2.setResponseMessageID(n3);
        command2.setAffectedSOPClass(n4);
        return command2;
    }

    public static Command createCEchoReq(int n2, int n3) throws DicomException {
        Command command2 = Command.if(48, n2, false, n3);
        return command2;
    }

    public static Command createCEchoRes(Command command2, int n2) throws DicomException {
        Command command3 = Command.a(32816, command2.getMessageID(), false, command2.getAffectedSOPClass());
        command3.setStatus(n2);
        return command3;
    }

    public static Command createCStoreReq(int n2, int n3, int n4, String string) throws DicomException {
        Command command2 = Command.if(1, n2, true, n3);
        command2.setAffectedSOPInstance(string);
        command2.setPriority(n4);
        return command2;
    }

    public static Command createCStoreRes(Command command2, int n2) throws DicomException {
        Command command3 = Command.a(32769, command2.getMessageID(), false, command2.getAffectedSOPClass());
        command3.setAffectedSOPInstance(command2.getAffectedSOPInstance());
        command3.setStatus(n2);
        return command3;
    }

    public static Command createCFindReq(int n2, int n3, int n4) throws DicomException {
        Command command2 = Command.if(32, n2, true, n3);
        command2.setPriority(n4);
        return command2;
    }

    public static Command createCFindRes(Command command2, int n2, boolean bl) throws DicomException {
        Command command3 = Command.a(32800, command2.getMessageID(), bl, command2.getAffectedSOPClass());
        command3.setStatus(n2);
        return command3;
    }

    public static Command createCCancel(Command command2) throws DicomException {
        Command command3 = new Command();
        command3.setCommandType(4095);
        command3.hasData(false);
        command3.setResponseMessageID(command2.getMessageID());
        return command3;
    }

    public static Command createCGetReq(int n2, int n3, int n4) throws DicomException {
        Command command2 = Command.if(16, n2, true, n3);
        command2.setPriority(n4);
        return command2;
    }

    public static Command createCGetRes(Command command2, int n2, boolean bl) throws DicomException {
        Command command3 = Command.a(32784, command2.getMessageID(), bl, command2.getAffectedSOPClass());
        command3.setStatus(n2);
        return command3;
    }

    public static Command createCMoveReq(int n2, int n3, int n4, String string) throws DicomException {
        Command command2 = Command.if(33, n2, true, n3);
        command2.setPriority(n4);
        command2.setMoveDestination(string);
        return command2;
    }

    public static Command createCMoveRes(Command command2, int n2, boolean bl) throws DicomException {
        Command command3 = Command.a(32801, command2.getMessageID(), bl, command2.getAffectedSOPClass());
        command3.setStatus(n2);
        return command3;
    }

    public static Command createNEventReportReq(int n2, int n3, String string, int n4, boolean bl) throws DicomException {
        Command command2 = Command.if(256, n2, bl, n3);
        command2.setAffectedSOPInstance(string);
        command2.setEventTypeID(n4);
        return command2;
    }

    public static Command createNEventReportRes(Command command2, int n2, boolean bl) throws DicomException {
        Command command3 = Command.a(33024, command2.getMessageID(), bl, command2.getAffectedSOPClass());
        command3.setStatus(n2);
        command3.hasData(bl);
        return command3;
    }

    public static Command createNGetReq(int n2, int n3, String string) throws DicomException {
        Command command2 = Command.if(272, n2, false, n3);
        command2.setRequestedSOPInstance(string);
        return command2;
    }

    public static Command createNGetRes(Command command2, int n2, boolean bl) throws DicomException {
        Command command3 = Command.a(33040, command2.getMessageID(), bl, command2.getRequestedSOPClass());
        command3.setRequestedSOPInstance(command2.getRequestedSOPInstance());
        command3.setStatus(n2);
        return command3;
    }

    public static Command createNSetReq(int n2, int n3, String string) throws DicomException {
        Command command2 = Command.if(288, n2, true, n3);
        command2.setRequestedSOPInstance(string);
        return command2;
    }

    public static Command createNSetRes(Command command2, int n2, boolean bl) throws DicomException {
        Command command3 = Command.a(33056, command2.getMessageID(), bl, command2.getRequestedSOPClass());
        command3.setAffectedSOPInstance(command2.getRequestedSOPInstance());
        command3.setStatus(n2);
        return command3;
    }

    public static Command createNActionReq(int n2, int n3, String string, int n4, boolean bl) throws DicomException {
        Command command2 = Command.if(304, n2, bl, n3);
        command2.setRequestedSOPInstance(string);
        command2.setActionTypeID(n4);
        return command2;
    }

    public static Command createNActionRes(Command command2, int n2, boolean bl) throws DicomException {
        Command command3 = Command.a(33072, command2.getMessageID(), bl, command2.getRequestedSOPClass());
        command3.setAffectedSOPInstance(command2.getRequestedSOPInstance());
        command3.setStatus(n2);
        return command3;
    }

    public static Command createNCreateReq(int n2, int n3, String string, boolean bl) throws DicomException {
        Command command2 = Command.if(320, n2, bl, n3);
        command2.setAffectedSOPInstance(string);
        return command2;
    }

    public static Command createNCreateRes(Command command2, int n2, boolean bl) throws DicomException {
        Command command3 = Command.a(33088, command2.getMessageID(), bl, command2.getAffectedSOPClass());
        command3.setAffectedSOPInstance(command2.getAffectedSOPInstance());
        command3.setStatus(n2);
        return command3;
    }

    public static Command createNDeleteReq(int n2, int n3, String string) throws DicomException {
        Command command2 = Command.if(336, n2, false, n3);
        command2.setRequestedSOPInstance(string);
        return command2;
    }

    public static Command createNDeleteRes(Command command2, int n2) throws DicomException {
        Command command3 = Command.a(33104, command2.getMessageID(), false, command2.getRequestedSOPClass());
        command3.setAffectedSOPInstance(command2.getRequestedSOPInstance());
        command3.setStatus(n2);
        return command3;
    }

    private int if(int n2) throws DicomException {
        return this.if(n2, true);
    }

    private int if(int n2, boolean bl) throws DicomException {
        Object object = this.get(n2);
        if (object == null) {
            if (bl) {
                throw new DicomException(this.a(n2, "tag value missing"));
            }
            return -1;
        }
        return (Integer)object;
    }

    private String for(int n2) throws DicomException {
        Object object = this.get(n2);
        if (object == null) {
            throw new DicomException(this.a(n2, "tag value missing"));
        }
        return (String)object;
    }

    private int do(int n2) throws DicomException {
        Object object = this.get(n2);
        if (object == null) {
            throw new DicomException(this.a(n2, "tag value missing"));
        }
        try {
            return SOPClass.getUIDEntry((String)object).getConstant();
        }
        catch (UnknownUIDException unknownUIDException) {
            throw new DicomException("SOP Class/Meta SOP Class '" + object + "' not found in dictionary");
        }
    }

    private String a(int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("unable to extract ");
        stringBuffer.append(DDict.getDescription(n2));
        stringBuffer.append(" tag value from command");
        if (string != null) {
            stringBuffer.append(": ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

