/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.TransferSyntaxUID;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;

public class ResponsePolicy {
    public static Response prepareResponse(Request request, String string, String[] stringArray, int[] nArray, int n2, boolean bl) throws IllegalValueException {
        return ResponsePolicy.prepareResponse(request, string, stringArray, nArray, new int[]{n2}, bl);
    }

    public static Response prepareResponse(Request request, String string, String[] stringArray, int[] nArray, int[] nArray2, boolean bl) throws IllegalValueException {
        int n2;
        if (string != null && !request.getCalledTitle().equals(string)) {
            return new Reject(Reject.REJECTED_PERMANENT, Reject.DICOM_UL_SERVICE_USER, Reject.USER_CALLED_AETITLE_NOT_RECOGNIZED);
        }
        boolean bl2 = true;
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!request.getCallingTitle().equals(stringArray[i2])) continue;
                bl2 = false;
            }
            if (bl2) {
                return new Reject(Reject.REJECTED_PERMANENT, Reject.DICOM_UL_SERVICE_USER, Reject.USER_CALLING_AETITLE_NOT_RECOGNIZED);
            }
        }
        Acknowledge acknowledge = new Acknowledge();
        acknowledge.setCalledTitle(request.getCalledTitle());
        acknowledge.setCallingTitle(request.getCallingTitle());
        block1: for (n2 = 0; n2 < request.getPresentationContexts(); ++n2) {
            UIDEntry uIDEntry = request.getAbstractSyntax(n2);
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                if (!uIDEntry.equals(UID.getUIDEntry(nArray[i3]))) continue;
                for (int i4 = 0; i4 < request.getTransferSyntaxes(n2); ++i4) {
                    UIDEntry uIDEntry2 = request.getTransferSyntax(n2, i4);
                    for (int i5 = 0; i5 < nArray2.length; ++i5) {
                        if (uIDEntry2.getConstant() != nArray2[i5]) continue;
                        acknowledge.addPresentationContext(request.getID(n2), 0, nArray2[i5]);
                        continue block1;
                    }
                }
                acknowledge.addPresentationContext(request.getID(n2), 4, 8193);
                continue block1;
            }
            acknowledge.addPresentationContext(request.getID(n2), 3, 8193);
        }
        if (bl) {
            bl2 = true;
            for (n2 = 0; n2 < acknowledge.getPresentationContexts(); ++n2) {
                if (acknowledge.getResult(n2) != 0) continue;
                bl2 = false;
            }
            if (bl2) {
                return new Reject(Reject.REJECTED_PERMANENT, Reject.DICOM_UL_SERVICE_USER, Reject.USER_NO_REASON_GIVEN);
            }
        }
        return acknowledge;
    }

    public static Response prepareResponse(Request request, String string, String[] stringArray, SupportedContext[] supportedContextArray, boolean bl) throws IllegalValueException {
        int n2;
        if (string != null && !request.getCalledTitle().equals(string)) {
            return new Reject(Reject.REJECTED_PERMANENT, Reject.DICOM_UL_SERVICE_USER, Reject.USER_CALLED_AETITLE_NOT_RECOGNIZED);
        }
        boolean bl2 = true;
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!request.getCallingTitle().equals(stringArray[i2])) continue;
                bl2 = false;
            }
            if (bl2) {
                return new Reject(Reject.REJECTED_PERMANENT, Reject.DICOM_UL_SERVICE_USER, Reject.USER_CALLING_AETITLE_NOT_RECOGNIZED);
            }
        }
        Acknowledge acknowledge = new Acknowledge();
        acknowledge.setCalledTitle(request.getCalledTitle());
        acknowledge.setCallingTitle(request.getCallingTitle());
        block1: for (n2 = 0; n2 < request.getPresentationContexts(); ++n2) {
            UIDEntry uIDEntry = request.getAbstractSyntax(n2);
            for (int i3 = 0; i3 < supportedContextArray.length; ++i3) {
                if (!uIDEntry.equals(supportedContextArray[i3].sopClassUID)) continue;
                for (int i4 = 0; i4 < request.getTransferSyntaxes(n2); ++i4) {
                    UIDEntry uIDEntry2 = request.getTransferSyntax(n2, i4);
                    for (int i5 = 0; i5 < supportedContextArray[i3].tsUIDs.length; ++i5) {
                        if (!uIDEntry2.equals(supportedContextArray[i3].tsUIDs[i5])) continue;
                        acknowledge.addPresentationContext(request.getID(n2), 0, supportedContextArray[i3].tsUIDs[i5].getConstant());
                        continue block1;
                    }
                }
                acknowledge.addPresentationContext(request.getID(n2), 4, 8193);
                continue block1;
            }
            acknowledge.addPresentationContext(request.getID(n2), 3, 8193);
        }
        if (bl) {
            bl2 = true;
            for (n2 = 0; n2 < acknowledge.getPresentationContexts(); ++n2) {
                if (acknowledge.getResult(n2) != 0) continue;
                bl2 = false;
            }
            if (bl2) {
                return new Reject(Reject.REJECTED_PERMANENT, Reject.DICOM_UL_SERVICE_USER, Reject.USER_NO_REASON_GIVEN);
            }
        }
        return acknowledge;
    }

    public static int getResultForAbstractSyntax(Request request, Acknowledge acknowledge, int n2) throws IllegalValueException {
        int n3 = request.getPresentationContexts();
        for (int i2 = 0; i2 < n3; ++i2) {
            UIDEntry uIDEntry = request.getAbstractSyntax(i2);
            if (uIDEntry.getConstant() != n2) continue;
            int n4 = request.getID(i2);
            for (int i3 = 0; i3 < acknowledge.getPresentationContexts(); ++i3) {
                int n5 = acknowledge.getID(i3);
                if (n4 != n5) continue;
                return acknowledge.getResult(i3);
            }
            throw new IllegalValueException("no matching presentation context id in request and acknowledge for specified abstract syntax");
        }
        throw new IllegalValueException("abstract syntax not in request");
    }

    public static class SupportedContext {
        SOPClassUID sopClassUID;
        TransferSyntaxUID[] tsUIDs;

        public SupportedContext(SOPClassUID sOPClassUID, TransferSyntaxUID[] transferSyntaxUIDArray) {
            this.sopClassUID = sOPClassUID;
            this.tsUIDs = transferSyntaxUIDArray;
        }
    }
}

