/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.AssociationIO;
import com.archimed.dicom.network.Command;
import com.archimed.dicom.network.Dimse;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.ResponsePolicy;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.scu.CEchoSCU;
import com.archimed.dicom.scu.SCUException;
import com.archimed.dicom.scu.SCUFactory;
import com.archimed.dicom.scu.a.l;
import com.archimed.log.JdtLogger;
import java.io.IOException;
import java.net.Socket;

public class CEchoSCUFactory
extends SCUFactory {
    protected static JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(CEchoSCUFactory.class);

    private CEchoSCUFactory() {
    }

    public static CEchoSCU createCEchoSCU(String string, int n2, String string2, String string3) {
        return new l(string, n2, string2, string3);
    }

    public static void executeCEcho(String string, int n2, String string2, String string3) throws SCUException, DicomException, IOException {
        CEchoSCUFactory.executeCEcho(string, n2, string2, string3, 0);
    }

    public static void executeCEcho(String string, int n2, String string2, String string3, int n3) throws SCUException, DicomException, IOException {
        Socket socket = new Socket(string, n2);
        socket.setSoTimeout(n3);
        AssociationIO associationIO = new AssociationIO(socket.getInputStream(), socket.getOutputStream());
        Request request = new Request();
        request.setCalledTitle(string2);
        request.setCallingTitle(string3);
        try {
            request.addPresentationContext(1, 4097, new int[]{8193});
        }
        catch (IllegalValueException illegalValueException) {
            log.error("IllegalValueException while adding presentation context: " + illegalValueException, illegalValueException);
            throw new SCUException("IllegalValueException while adding presentation context: " + illegalValueException, illegalValueException);
        }
        request.setMaxPduSize(32768);
        log.debug(request);
        try {
            associationIO.write(request);
        }
        catch (DicomException dicomException) {
            log.error("DicomException while writing Association Request: " + dicomException, dicomException);
            throw new SCUException("DicomException while writing Association Request: " + dicomException, dicomException);
        }
        ULServiceMessage uLServiceMessage = null;
        try {
            uLServiceMessage = associationIO.read();
        }
        catch (DicomException dicomException) {
            log.error("DicomException while reading Association Response: " + dicomException, dicomException);
            throw new SCUException("DicomException while writing Association Response: " + dicomException, dicomException);
        }
        log.debug(uLServiceMessage);
        switch (uLServiceMessage.getMessageType()) {
            case 1002: {
                int n4;
                Acknowledge acknowledge = (Acknowledge)uLServiceMessage;
                try {
                    n4 = ResponsePolicy.getResultForAbstractSyntax(request, acknowledge, 4097);
                }
                catch (IllegalValueException illegalValueException) {
                    log.error("IllegalValueException while calling getResultForAbstractSyntax: " + illegalValueException, illegalValueException);
                    throw new SCUException("IllegalValueException while calling getResultForAbstractSyntax: " + illegalValueException);
                }
                if (n4 == 0) {
                    Command command2 = Command.createCEchoReq(1, 4097);
                    Dimse dimse = new Dimse(1, command2, null);
                    associationIO.write(dimse);
                    uLServiceMessage = associationIO.read();
                    Command command3 = null;
                    if (!(uLServiceMessage instanceof Dimse)) {
                        log.error("unexpected pdu received: " + uLServiceMessage);
                        throw new SCUException("unexpected pdu received: " + uLServiceMessage);
                    }
                    command3 = ((Dimse)uLServiceMessage).getCommand();
                    if (command3.getStatus() != 0) {
                        String string4 = "non-success status received in C-ECHO resposnse: " + command3.getStatus();
                        log.error(string4);
                        throw new SCUException(string4);
                    }
                    CEchoSCUFactory.release(associationIO);
                    break;
                }
                throw new SCUException("association acknowledge received but presentation context not accepted");
            }
            case 1003: {
                log.error("association reject received: " + uLServiceMessage);
                throw new SCUException("association reject received: " + uLServiceMessage);
            }
            case 1007: {
                log.error("abort received: " + uLServiceMessage);
                throw new SCUException("abort received: " + uLServiceMessage);
            }
            default: {
                log.error("unexpected pdu received: " + uLServiceMessage);
                throw new SCUException("unexpected pdu received: " + uLServiceMessage);
            }
        }
    }
}

