/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.TransferSyntaxUID;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.AssociationIO;
import com.archimed.dicom.network.Command;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.ResponsePolicy;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.scu.CStoreItemRequest;
import com.archimed.dicom.scu.CStoreSCU;
import com.archimed.dicom.scu.MultiCStoreSCU;
import com.archimed.dicom.scu.SCUException;
import com.archimed.dicom.scu.SCUFactory;
import com.archimed.dicom.scu.a.o;
import com.archimed.log.JdtLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;

public class CStoreSCUFactory
extends SCUFactory {
    protected static JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(CStoreSCUFactory.class);

    public static void main(String[] stringArray) {
        try {
            log.debug("Trispark JDT Version: " + Jdt.getVersion() + "(" + Jdt.getBuild() + ")");
            Command command2 = CStoreSCUFactory.executeCStore(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3], stringArray[4]);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            log.error("Exception while executing C-STORE: " + throwable, throwable);
        }
    }

    public static Command executeCStore(String string, int n2, String string2, String string3, String string4) throws SCUException, DicomException, IOException {
        CharSequence charSequence;
        Object object;
        FileInputStream fileInputStream = new FileInputStream(string4);
        DicomReader dicomReader = new DicomReader();
        DicomObject dicomObject = dicomReader.read(fileInputStream, true);
        fileInputStream.close();
        if (log.isDebugEnabled()) {
            object = new DumpUtils(true, false);
            charSequence = new StringBuffer();
            ((DumpUtils)object).dump(dicomObject, (StringBuffer)charSequence);
            log.debug("DUMP DICOMFILE:");
            log.debug("\r\n" + ((StringBuffer)charSequence).toString());
        }
        if ((object = dicomObject.getFileMetaInformation()) == null) {
            throw new SCUException("No file meta information");
        }
        charSequence = ((DicomObject)object).getString(31, 0);
        if (charSequence == null) {
            throw new SCUException("No specified transfer syntax in file meta information");
        }
        TransferSyntaxUID transferSyntaxUID = null;
        try {
            transferSyntaxUID = (TransferSyntaxUID)UID.getUIDEntry((String)charSequence);
        }
        catch (UnknownUIDException unknownUIDException) {
            throw new SCUException("Unknown transfer syntax in file meta information: '" + (String)charSequence + "'");
        }
        return CStoreSCUFactory.executeCStore(string, n2, string2, string3, dicomObject, transferSyntaxUID);
    }

    public static Command executeCStore(String string, int n2, String string2, String string3, DicomObject dicomObject, TransferSyntaxUID transferSyntaxUID) throws SCUException, IOException {
        try {
            String string4 = dicomObject.getString(62, 0);
            String string5 = dicomObject.getString(63, 0);
            SOPClassUID sOPClassUID = null;
            try {
                sOPClassUID = (SOPClassUID)UID.getUIDEntry(string4);
            }
            catch (UnknownUIDException unknownUIDException) {
                log.error("UnknownUIDException while executing C-STORE", unknownUIDException);
                throw new SCUException("UnknownUIDException while executing C-STORE: + ex", unknownUIDException);
            }
            CStoreSCU cStoreSCU = CStoreSCUFactory.createCStoreSCU(string, n2, string2, string3, sOPClassUID, transferSyntaxUID);
            Command command2 = cStoreSCU.cstore(dicomObject, 0);
            CStoreSCUFactory.release(cStoreSCU.getAssociationIO());
            return command2;
        }
        catch (DicomException dicomException) {
            log.error("DicomException while executing C-STORE: " + dicomException, dicomException);
            throw new SCUException("DicomException while executing C-STORE: + ex", dicomException);
        }
    }

    public static CStoreSCU createCStoreSCU(String string, int n2, String string2, String string3, SOPClassUID sOPClassUID, TransferSyntaxUID transferSyntaxUID) throws SCUException, IOException {
        Socket socket = new Socket(string, n2);
        return CStoreSCUFactory.createCStoreSCU(socket, string2, string3, sOPClassUID, transferSyntaxUID);
    }

    public static CStoreSCU createCStoreSCU(Socket socket, String string, String string2, SOPClassUID sOPClassUID, TransferSyntaxUID transferSyntaxUID) throws SCUException, IOException {
        AssociationIO associationIO = new AssociationIO(socket.getInputStream(), socket.getOutputStream());
        Request request = new Request();
        request.setCalledTitle(string2);
        request.setCallingTitle(string);
        try {
            request.addPresentationContext(1, sOPClassUID.getConstant(), new int[]{transferSyntaxUID.getConstant()});
        }
        catch (IllegalValueException illegalValueException) {
            log.error("IllegalValueException while adding presentation context: " + illegalValueException, illegalValueException);
            throw new SCUException("IllegalValueException while adding presentation context: " + illegalValueException, illegalValueException);
        }
        request.setMaxPduSize(32768);
        log.debug(request);
        try {
            associationIO.write(request);
        }
        catch (DicomException dicomException) {
            log.error("DicomException while writing Association Request: " + dicomException, dicomException);
            throw new SCUException("DicomException while writing Association Request: " + dicomException, dicomException);
        }
        ULServiceMessage uLServiceMessage = null;
        try {
            uLServiceMessage = associationIO.read();
        }
        catch (DicomException dicomException) {
            log.error("DicomException while reading Association Response: " + dicomException, dicomException);
            throw new SCUException("DicomException while writing Association Response: " + dicomException, dicomException);
        }
        log.debug(uLServiceMessage);
        switch (uLServiceMessage.getMessageType()) {
            case 1002: {
                int n2;
                Acknowledge acknowledge = (Acknowledge)uLServiceMessage;
                try {
                    n2 = ResponsePolicy.getResultForAbstractSyntax(request, acknowledge, sOPClassUID.getConstant());
                }
                catch (IllegalValueException illegalValueException) {
                    log.error("IllegalValueException while calling getResultForAbstractSyntax: " + illegalValueException, illegalValueException);
                    throw new SCUException("IllegalValueException while calling getResultForAbstractSyntax: " + illegalValueException);
                }
                if (n2 == 0) {
                    return new CStoreSCU(associationIO, 1, sOPClassUID);
                }
                throw new SCUException("association acknowledge received but presentation context not accepted");
            }
            case 1003: {
                log.error("association reject received: " + uLServiceMessage);
                throw new SCUException("association reject received: " + uLServiceMessage);
            }
            case 1007: {
                log.error("abort received: " + uLServiceMessage);
                throw new SCUException("abort received: " + uLServiceMessage);
            }
        }
        log.error("unexpected pdu received: " + uLServiceMessage);
        throw new SCUException("unexpected pdu received: " + uLServiceMessage);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String string, int n2, String string2, String string3, File file, boolean bl) {
        return CStoreSCUFactory.createMultiCStoreSCU(string, n2, string2, string3, new File[]{file}, bl);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String string, int n2, String string2, String string3, File[] fileArray, boolean bl) {
        return new o(string, n2, string2, string3, fileArray, bl);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String string, int n2, String string2, String string3, DicomObject dicomObject) {
        return CStoreSCUFactory.createMultiCStoreSCU(string, n2, string2, string3, new DicomObject[]{dicomObject});
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String string, int n2, String string2, String string3, DicomObject[] dicomObjectArray) {
        return new o(string, n2, string2, string3, dicomObjectArray);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String string, int n2, String string2, String string3, CStoreItemRequest[] cStoreItemRequestArray) {
        return new o(string, n2, string2, string3, cStoreItemRequestArray);
    }
}

