/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.xml;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.xml.Dicom2XmlException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Dicom2XmlConverter {
    public void write(DicomObject dicomObject, OutputStream outputStream) throws Dicom2XmlException, DicomException {
        DicomObject dicomObject2 = dicomObject.getFileMetaInformation();
        if (dicomObject2 == null) {
            throw new Dicom2XmlException("No file meta information");
        }
        this.write(dicomObject, outputStream, true);
    }

    public void write(DicomObject dicomObject, OutputStream outputStream, boolean bl) throws Dicom2XmlException, DicomException {
        Element element;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Dicom2XmlException("ParserConfigurationException: " + parserConfigurationException, parserConfigurationException);
        }
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        Document document = dOMImplementation.createDocument("http://www.trispark.com/jdt/dicom2xml", "dicomfile", null);
        document.getDocumentElement().setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        document.getDocumentElement().setAttribute("xsi:schemaLocation", "http://www.trispark.com/jdt/dicom2xml dicom2xml.xsd");
        DicomObject dicomObject2 = dicomObject.getFileMetaInformation();
        if (dicomObject2 != null && bl) {
            element = document.createElement("filemeta");
            document.getDocumentElement().appendChild(element);
            this.a(dicomObject2, document, element);
        }
        element = document.createElement("dataset");
        document.getDocumentElement().appendChild(element);
        this.a(dicomObject, document, element);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new Dicom2XmlException("TransformerConfigurationException: " + transformerConfigurationException, transformerConfigurationException);
        }
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new Dicom2XmlException("TransformerException: " + transformerException, transformerException);
        }
    }

    private void a(DataElement dataElement) {
    }

    private void a(DicomObject dicomObject, Document document, Element element) throws DicomException {
        Enumeration enumeration = dicomObject.enumerateVRs(false);
        String string = null;
        Element element2 = null;
        while (enumeration.hasMoreElements()) {
            DataElement dataElement = (DataElement)enumeration.nextElement();
            String string2 = DumpUtils.toHexString(dataElement.getGroup(), 4);
            if (string == null || !string.equals(string2)) {
                element2 = document.createElement("dicom-group");
                element2.setAttribute("group", string2);
                element.appendChild(element2);
            }
            this.a(dataElement, document, element2);
            string = string2;
        }
    }

    private void a(DataElement dataElement, Document document, Element element) throws DicomException {
        String string = DumpUtils.toHexString(dataElement.getElement(), 4);
        if (dataElement.getVR() == 10) {
            Element element2 = document.createElement("dicom-sequence");
            element2.setAttribute("element", string);
            element2.setAttribute("vr", DDict.getTypeName(dataElement.getVR()));
            element2.setAttribute("name", DDict.getDescription(dataElement.getTag()));
            element2.setAttribute("vm", dataElement.size() + "");
            element.appendChild(element2);
            for (int i2 = 0; i2 < dataElement.size(); ++i2) {
                int n2 = i2 + 1;
                DicomObject dicomObject = dataElement.getSequenceItem(i2);
                Element element3 = document.createElement("dicom-sequence-item");
                element3.setAttribute("card", "" + n2);
                element2.appendChild(element3);
                this.a(dicomObject, document, element3);
            }
        } else {
            Element element4 = document.createElement("dicom-element");
            element4.setAttribute("element", string);
            element4.setAttribute("vr", DDict.getTypeName(dataElement.getVR()));
            element4.setAttribute("name", DDict.getDescription(dataElement.getTag()));
            element4.setAttribute("vm", dataElement.size() + "");
            element.appendChild(element4);
            this.if(dataElement, document, element4);
        }
    }

    private void if(DataElement dataElement, Document document, Element element) throws DicomException {
        for (int i2 = 0; i2 < dataElement.size(); ++i2) {
            int n2 = i2 + 1;
            Element element2 = document.createElement("dicom-element-value");
            element2.setAttribute("card", "" + n2);
            Text text = document.createTextNode(dataElement.getString(i2));
            element2.appendChild(text);
            element.appendChild(element2);
        }
    }
}

