/*
 * Decompiled with CFR 0.152.
 */
package com.ge.hc.cse.commons.selection;

import com.ge.hc.cse.commons.selection.InvalidSelectionFileException;
import com.ge.hc.cse.commons.selection.Selection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelectionReader {
    public static final String EMPTY_STRING = "";
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    public static final int MINIMUM_PRIMARY_SELECTION_TOKEN_COUNT = 7;
    public static final String SDC_SELECTION_FILE = "SDC_SELECTION_FILE";
    public static final int NUMBER_OF_RETRIES = 5;
    public static final String SDC_SELECTION_TOKEN_SEPERATOR = " ";
    public static final String UTF8 = "utf-8";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    public static final String UNIX_FILE_SEPARATOR = "/";
    public static final int LINE_SEPARATOR_CHAR_COUNT = LINE_SEPARATOR.length();
    public static final String FIRST_LINE_TOKENS_SEPARATOR = " ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static ByteBuffer readSelectionData(String selfile) {
        ByteBuffer buffer;
        block18: {
            FileLock fileLock;
            FileInputStream fis;
            block17: {
                long size;
                FileChannel fileChannel;
                block16: {
                    fis = null;
                    fileChannel = null;
                    fileLock = null;
                    buffer = EMPTY_BYTE_BUFFER;
                    try {
                        fis = new FileInputStream(selfile);
                        fileChannel = fis.getChannel();
                        fileLock = SelectionReader.waitForFileLock(fileChannel);
                    }
                    catch (FileNotFoundException fe) {
                        Logger.getLogger(SelectionReader.class.getName()).log(Level.SEVERE, "file not found", fe);
                        throw new Exception("Unable to get  selection " + fe.getMessage());
                    }
                    catch (Exception e2) {
                        Logger.getLogger(SelectionReader.class.getName()).log(Level.SEVERE, "Exception.", e2);
                    }
                    size = fileChannel.size();
                    if (size != 0L) break block16;
                    ByteBuffer byteBuffer = buffer;
                    try {
                        SelectionReader.releaseFileLock(fileLock);
                        SelectionReader.closeStream(fis);
                    }
                    catch (RuntimeException e3) {
                        Logger.getLogger(SelectionReader.class.getName()).log(Level.SEVERE, "Excep...", e3);
                    }
                    return byteBuffer;
                }
                buffer = ByteBuffer.allocate((int)size);
                int bytesRead = fileChannel.read(buffer);
                if (bytesRead != 0) break block17;
                buffer = EMPTY_BYTE_BUFFER;
            }
            try {
                SelectionReader.releaseFileLock(fileLock);
                SelectionReader.closeStream(fis);
            }
            catch (RuntimeException e4) {
                Logger.getLogger(SelectionReader.class.getName()).log(Level.SEVERE, "Excep...", e4);
            }
            break block18;
            catch (Exception e5) {
                try {
                    Logger.getLogger(SelectionReader.class.getName()).log(Level.SEVERE, "Exception", e5);
                }
                catch (Throwable throwable) {
                    try {
                        SelectionReader.releaseFileLock(fileLock);
                        SelectionReader.closeStream(fis);
                    }
                    catch (RuntimeException e6) {
                        Logger.getLogger(SelectionReader.class.getName()).log(Level.SEVERE, "Excep...", e6);
                    }
                    throw throwable;
                }
                try {
                    SelectionReader.releaseFileLock(fileLock);
                    SelectionReader.closeStream(fis);
                }
                catch (RuntimeException e7) {
                    Logger.getLogger(SelectionReader.class.getName()).log(Level.SEVERE, "Excep...", e7);
                }
            }
        }
        return buffer;
    }

    public static Selection readSelection(String selfile) throws InvalidSelectionFileException, TimeoutException {
        ByteBuffer buffer = SelectionReader.readSelectionData(selfile);
        if (buffer == EMPTY_BYTE_BUFFER) {
            throw new InvalidSelectionFileException("invalid selection file");
        }
        buffer.rewind();
        String s2 = null;
        try {
            s2 = new String(buffer.array(), UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidSelectionFileException("Invalid selection file: Selection file has invalid characterss", ex);
        }
        int secondarySelStart = s2.indexOf(LINE_SEPARATOR);
        if (secondarySelStart < 0) {
            throw new InvalidSelectionFileException("Invalid selection file");
        }
        String firstLine = s2.substring(0, secondarySelStart + 1);
        String[] firstLineComponents = firstLine.split(" ");
        String firstImagePath = firstLineComponents[0];
        String rankOfFirstImageStr = firstLineComponents[1];
        int rankOfSelectedImage = Integer.parseInt(rankOfFirstImageStr);
        String numberOfImagesStr = firstLineComponents[2];
        int numberOfImages = Integer.parseInt(numberOfImagesStr);
        String secondarySelection = s2.substring(secondarySelStart + LINE_SEPARATOR_CHAR_COUNT, s2.length());
        String normalizedPathForSecondarySelection = SelectionReader.normalizePath(secondarySelection);
        String[] secondarySelectionTokens = normalizedPathForSecondarySelection.split(" ");
        String level = null;
        if (secondarySelectionTokens == null) {
            throw new InvalidSelectionFileException("invalid selection file");
        }
        String strToken = secondarySelectionTokens[0].substring(secondarySelectionTokens[0].lastIndexOf(File.separator) + 1);
        if (strToken.startsWith("e")) {
            level = "exam";
        } else if (strToken.startsWith("s")) {
            level = "series";
        } else if (strToken.startsWith("i")) {
            level = "image";
        }
        Selection currentSelection = new Selection(level, secondarySelectionTokens, rankOfSelectedImage - 1, numberOfImages);
        return currentSelection;
    }

    private static void closeStream(FileInputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SelectionReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void releaseFileLock(FileLock fileLock) {
        if (fileLock != null) {
            try {
                fileLock.release();
            }
            catch (IOException ex) {
                Logger.getLogger(SelectionReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static String normalizePath(String imagePath) {
        String normalizedPath = EMPTY_STRING;
        try {
            normalizedPath = UNIX_FILE_SEPARATOR.equals(File.separator) ? imagePath.replaceAll("[/]{2,}", UNIX_FILE_SEPARATOR) : imagePath.replaceAll("[\\\\]{2,}", "\\\\");
            normalizedPath = normalizedPath.trim();
        }
        catch (Exception e2) {
            Logger.getLogger(SelectionReader.class.getName()).log(Level.SEVERE, "Failed to get PESI path from the image path", e2);
        }
        return normalizedPath;
    }

    private static FileLock waitForFileLock(FileChannel fileChannel) throws IOException, TimeoutException {
        FileLock fileLock = null;
        for (int i2 = 0; i2 < 5 && (fileLock = fileChannel.tryLock(0L, Long.MAX_VALUE, true)) == null; ++i2) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SelectionReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (fileLock == null) {
            throw new TimeoutException("Acquiring lock failed");
        }
        return fileLock;
    }

    public static void main(String[] s2) {
        try {
            Selection selec = SelectionReader.readSelection("D:\\sdc_selection");
            System.out.println("Obtained the following selection ");
            System.out.println("Level = " + selec.getLevel());
            System.out.println("Rank = " + selec.getIndexOfFirstImage());
            System.out.println("Number of images selected = " + selec.getNumberOfImages());
            System.out.println("Selected Paths");
            for (String path : selec.getSelectionFilePaths()) {
                System.out.println(path);
            }
        }
        catch (InvalidSelectionFileException e2) {
            e2.printStackTrace();
        }
        catch (TimeoutException e3) {
            e3.printStackTrace();
        }
    }
}

