/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer;

import com.ge.med.cse.cvf.util.CvUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class MediaRemovalDetector
extends JPanel
implements ActionListener {
    JFrame parent;
    Timer timer;
    File dicomDirFile;
    ResourceBundle bundle = CvUtils.getResourceBundle();

    public MediaRemovalDetector() {
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                e2.consume();
            }
        });
        this.timer = new Timer(1000, this);
        this.timer.setRepeats(true);
        if (System.getProperty("REPOSITORY_PATH") == null) {
            this.dicomDirFile = new File(System.getProperty("REPOSITORY_PATH", System.getProperty("user.dir", ".")) + File.separatorChar + "DICOMDIR");
            if (!this.dicomDirFile.exists()) {
                new File(System.getProperty("REPOSITORY_PATH", System.getProperty("user.dir", ".")) + File.separatorChar + "DICOMDIR".toLowerCase());
            }
        } else {
            this.dicomDirFile = new File(System.getProperty("REPOSITORY_PATH") + File.separator + "DICOMDIR");
            if (!this.dicomDirFile.exists()) {
                new File(System.getProperty("REPOSITORY_PATH") + File.separatorChar + "DICOMDIR".toLowerCase());
            }
        }
        System.err.println("File to monitor :: " + this.dicomDirFile.getAbsolutePath());
        this.setVisible(false);
    }

    @Override
    public void addNotify() {
        if (System.getProperty("REPOSITORY_TYPE", "archive").equalsIgnoreCase("archive")) {
            super.addNotify();
            this.parent = (JFrame)SwingUtilities.getWindowAncestor(this);
            this.setBounds(this.parent.getBounds());
            if (this.dicomDirFile.exists()) {
                this.timer.start();
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Color ppColor = new Color(30, 0, 100, 70);
        g2.setColor(ppColor);
        g2.fill3DRect(0, 0, this.getWidth(), this.getHeight(), true);
    }

    @Override
    public void actionPerformed(ActionEvent ve) {
        if (!this.dicomDirFile.exists()) {
            this.setVisible(true);
            if (this.parent.getExtendedState() == 1) {
                this.parent.setExtendedState(6);
            }
            JOptionPane.showMessageDialog(this.parent, this.bundle.getString("ERROR_MEDIA_REMOVAL"), "", 0);
            System.err.println("User removed CD, hence aborting the process");
            this.timer.stop();
            System.exit(0);
        }
    }
}

