/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.datasetloader;

import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.appframework.DataContext;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.cse.cvf.dataloader.adv.XpCompareModeLoader;
import com.ge.med.cse.cvf.dataloader.adv.XpFusionImageDataLoader;
import com.ge.med.cse.cvf.dataloader.adv.XpFusionVolumeLoadRunner;
import com.ge.med.cse.cvf.dataloader.adv.XpSingleSeriesLoadRunner;
import com.ge.med.cse.cvf.dataloader.adv.XpVolumeLoader;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.xpv.base.XPscreen;
import java.util.ArrayList;
import java.util.Observable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;

public class MVImageLoader
extends Observable {
    private TaskMonitor taskMonitor = null;
    private ExecutorService service = Executors.newCachedThreadPool();
    private XPscreen screen = null;

    public void loadImages(DMObject[] series, String mode) {
        this.stopLoader();
        if (mode.equals("MODE3D")) {
            ArrayList<J3DViewport> ports = new ArrayList<J3DViewport>();
            for (int i2 = 0; i2 < this.screen.getScreenLayout().getNoOfPorts(); ++i2) {
                JComponent comp = this.screen.getPort(i2);
                if (!(comp instanceof J3DViewport)) continue;
                ports.add((J3DViewport)comp);
            }
            J3DViewport[] j3dPorts = ports.toArray(new J3DViewport[ports.size()]);
            if (j3dPorts == null || j3dPorts.length == 0) {
                return;
            }
            DMObject[] toLoad = null;
            if (series.length > 2 || series.length == 1) {
                toLoad = new DMObject[]{series[0]};
                XpVolumeLoader volLoader = new XpVolumeLoader(toLoad, j3dPorts, this.taskMonitor);
                this.addObserver(volLoader);
                this.service.submit(volLoader);
            }
            if (series.length == 2) {
                toLoad = series;
                XpFusionVolumeLoadRunner fusionloader = new XpFusionVolumeLoadRunner(toLoad, j3dPorts, this.taskMonitor);
                this.service.submit(fusionloader);
                this.addObserver(fusionloader);
            }
        } else if (mode.equals("MODE2D")) {
            DataContext dataContext = ContextProvider.getDataContext("MediaViewer");
            if (series.length == 1) {
                if (!(this.screen.getPort(0) instanceof XpViewport)) {
                    return;
                }
                XpViewport vp = (XpViewport)this.screen.getPort(0);
                XpSingleSeriesLoadRunner singleLoader = new XpSingleSeriesLoadRunner(series, vp, this.taskMonitor);
                this.addObserver(singleLoader);
                this.service.submit(singleLoader);
            } else if (series.length == 2) {
                if (this.screen.getScreenLayout().getNoOfPorts() < 3) {
                    return;
                }
                JComponent[] ports = new JComponent[]{this.screen.getPort(0), this.screen.getPort(1), this.screen.getPort(2)};
                XpFusionImageDataLoader fusionLoader = new XpFusionImageDataLoader();
                DatasetModel model1 = dataContext.getDatasetModel("DATASET_2D_1");
                DatasetModel model2 = dataContext.getDatasetModel("DATASET_2D_2");
                model1.getDataset().setData(series[0]);
                model2.getDataset().setData(series[1]);
                DatasetModel[] models = new DatasetModel[]{model1, model2};
                fusionLoader.load(ports, models, CvPropertiesManager.getProperties(), this.taskMonitor);
                this.addObserver(fusionLoader);
                this.service.submit(fusionLoader);
            }
        } else if (mode.equalsIgnoreCase("MODE_2D_COMPARE")) {
            if (this.screen.getScreenLayout().getNoOfPorts() < 2) {
                return;
            }
            JComponent[] ports = new JComponent[]{this.screen.getPort(0), this.screen.getPort(1)};
            DataContext dataContext = ContextProvider.getDataContext("MediaViewer");
            XpCompareModeLoader compareLoader = new XpCompareModeLoader();
            DatasetModel model1 = dataContext.getDatasetModel("DATASET_2D_1");
            DatasetModel model2 = dataContext.getDatasetModel("DATASET_2D_2");
            model1.getDataset().setData(series[0]);
            model2.getDataset().setData(series[1]);
            DatasetModel[] models = new DatasetModel[]{model1, model2};
            compareLoader.load(ports, models, CvPropertiesManager.getProperties(), this.taskMonitor);
            this.addObserver(compareLoader);
            this.service.submit(compareLoader);
        } else if (mode.equals("MODE_3D_FUSION_LAYOUT")) {
            // empty if block
        }
    }

    public void stopLoader() {
        if (this.countObservers() > 0) {
            this.setChanged();
            this.notifyObservers();
            this.deleteObservers();
        }
    }

    public void setTaskMoitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    public void setScreen(XPscreen screen) {
        this.screen = screen;
    }
}

