/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.datasetloader;

import com.ge.med.idc.XjVolume;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import java.io.File;
import java.util.HashMap;

public class MVImageMemoryManger {
    static HashMap<DMObject, DMImage[]> quickMap;
    HashMap<DMObject, XjVolume> volumeMap = new HashMap();
    private static MVImageMemoryManger instance;
    final int applicatiomemory = 60;

    private MVImageMemoryManger() {
    }

    public static MVImageMemoryManger getInstance() {
        return instance;
    }

    public DMImage[] getImages(DMObject dmo) {
        if (quickMap.containsKey(dmo)) {
            return quickMap.get(dmo);
        }
        return null;
    }

    public void putImages(DMObject series, DMImage[] images) {
        int size;
        if (series == null || images == null) {
            return;
        }
        if (quickMap.containsKey(series)) {
            return;
        }
        long freeavailable = Runtime.getRuntime().freeMemory();
        long diff = freeavailable - (long)(size = MVImageMemoryManger.computeSize(images));
        if (Math.abs(diff) > 5000000L) {
            quickMap.put(series, images);
        } else {
            for (DMObject nextDMo : quickMap.keySet()) {
                DMImage[] imgs = quickMap.get(nextDMo);
                int storedSize = MVImageMemoryManger.computeSize(imgs);
                if (storedSize <= size) continue;
                quickMap.remove(nextDMo);
                quickMap.put(series, images);
                break;
            }
        }
    }

    private static int computeSize(DMImage[] images) {
        int size = 0;
        for (DMImage img : images) {
            String filePath = img.getComposite().getFilePath();
            size = (int)((long)size + new File(filePath).length());
        }
        return size;
    }

    static {
        Tap.setProperty("tap.dm.ImageMemory", "20");
        quickMap = new HashMap();
        instance = new MVImageMemoryManger();
    }
}

